/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.Builder;
import com.tridium.sys.registry.NAdapterInfo;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NAgentList;
import com.tridium.sys.registry.NDependencyInfo;
import com.tridium.sys.registry.NLexiconInfo;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.util.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RegistryDatabase {
    static String[] noDefs = new String[0];
    public static final long magic = 7958534985112118370L;
    public static final int version = 3;
    NModuleInfo[] modules;
    HashMap modulesByName;
    NTypeInfo[] types;
    HashMap typesBySpec;
    HashMap defs;
    String[] fileExts;
    HashMap typesByFileExt;
    String[] ordSchemes;
    HashMap lexicons;
    HashMap typesByOrdScheme;
    NAdapterInfo[] adapters;
    static /* synthetic */ Class class$com$tridium$sys$registry$NAgentInfo;

    public ModuleInfo[] getModules() {
        return (ModuleInfo[])this.modules.clone();
    }

    public ModuleInfo getModule(String string) {
        ModuleInfo moduleInfo = (ModuleInfo)this.modulesByName.get(string);
        if (moduleInfo == null) {
            throw new ModuleNotFoundException(string);
        }
        return moduleInfo;
    }

    public TypeInfo[] getTypes() {
        return (TypeInfo[])this.types.clone();
    }

    public TypeInfo[] getTypes(TypeInfo typeInfo, boolean bl) {
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        ModuleInfo[] moduleInfoArray = this.getModules();
        int n = 0;
        while (n < moduleInfoArray.length) {
            TypeInfo[] typeInfoArray = moduleInfoArray[n].getTypes();
            int n2 = 0;
            while (n2 < typeInfoArray.length) {
                TypeInfo typeInfo2 = typeInfoArray[n2];
                if (!(bl && typeInfo2.isAbstract() || !typeInfo2.is(typeInfo))) {
                    arrayList.add(typeInfo2);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new TypeInfo[arrayList.size()]);
    }

    public TypeInfo getType(String string) {
        NTypeInfo nTypeInfo = (NTypeInfo)this.typesBySpec.get(string);
        if (nTypeInfo == null) {
            throw new TypeNotFoundException(string);
        }
        return nTypeInfo;
    }

    public String[] getDefs() {
        return this.defs.keySet().toArray(new String[this.defs.size()]);
    }

    public String[] getDefs(String string) {
        String[] stringArray = (String[])this.defs.get(string);
        if (stringArray == null) {
            return noDefs;
        }
        return (String[])stringArray.clone();
    }

    public String getDef(String string, String string2) {
        String[] stringArray = (String[])this.defs.get(string);
        if (stringArray == null) {
            return string2;
        }
        return stringArray[0];
    }

    public AgentList getAgents(TypeInfo typeInfo) {
        return typeInfo.getAgents();
    }

    public AgentList getSpecificAgents(TypeInfo typeInfo) {
        NAgentList nAgentList = new NAgentList();
        NTypeInfo[] nTypeInfoArray = ((NTypeInfo)typeInfo).agents;
        int n = 0;
        while (n < nTypeInfoArray.length) {
            nAgentList.add(nTypeInfoArray[n].getAgentInfo());
            ++n;
        }
        return nAgentList;
    }

    public boolean isAgent(TypeInfo typeInfo, TypeInfo typeInfo2) {
        NTypeInfo[] nTypeInfoArray = ((NTypeInfo)typeInfo2).is;
        int n = nTypeInfoArray.length - 1;
        while (n >= 0) {
            NTypeInfo[] nTypeInfoArray2 = nTypeInfoArray[n].agents;
            int n2 = 0;
            while (n2 < nTypeInfoArray2.length) {
                if (nTypeInfoArray2[n2].getAgentInfo().getAgentType() == typeInfo) {
                    return true;
                }
                ++n2;
            }
            --n;
        }
        return false;
    }

    public boolean isSpecificAgent(TypeInfo typeInfo, TypeInfo typeInfo2) {
        NTypeInfo[] nTypeInfoArray = ((NTypeInfo)typeInfo2).agents;
        int n = 0;
        while (n < nTypeInfoArray.length) {
            if (nTypeInfoArray[n] == typeInfo) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public TypeInfo[] getAdapters(TypeInfo typeInfo, TypeInfo typeInfo2) {
        ArrayList<NTypeInfo> arrayList = new ArrayList<NTypeInfo>();
        NAdapterInfo[] nAdapterInfoArray = this.adapters;
        int n = nAdapterInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nAdapterInfoArray[n2].isMatch(typeInfo, typeInfo2)) {
                arrayList.add(nAdapterInfoArray[n2].type);
            }
            ++n2;
        }
        return arrayList.toArray(new TypeInfo[arrayList.size()]);
    }

    public String[] getFileExtensions() {
        return (String[])this.fileExts.clone();
    }

    public String[] getFileExtensions(TypeInfo typeInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.fileExts.length) {
            TypeInfo typeInfo2 = (TypeInfo)this.typesByFileExt.get(this.fileExts[n]);
            if (typeInfo2.is(typeInfo)) {
                arrayList.add(this.fileExts[n]);
            }
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public TypeInfo getFileTypeForExtension(String string) {
        NTypeInfo nTypeInfo = (NTypeInfo)this.typesByFileExt.get(TextUtil.toLowerCase((String)string));
        if (nTypeInfo == null) {
            return this.getType("baja:DataFile");
        }
        return nTypeInfo;
    }

    public String[] getOrdSchemes() {
        return (String[])this.ordSchemes.clone();
    }

    public TypeInfo getOrdScheme(String string) {
        NTypeInfo nTypeInfo = (NTypeInfo)this.typesByOrdScheme.get(TextUtil.toLowerCase((String)string));
        if (nTypeInfo == null) {
            throw new UnknownSchemeException(string);
        }
        return nTypeInfo;
    }

    public boolean isOrdScheme(String string) {
        NTypeInfo nTypeInfo = (NTypeInfo)this.typesByOrdScheme.get(TextUtil.toLowerCase((String)string));
        boolean bl = false;
        if (nTypeInfo != null) {
            bl = true;
        }
        return bl;
    }

    public LexiconInfo[] getLexicons() {
        return this.lexicons.values().toArray(new LexiconInfo[this.lexicons.size()]);
    }

    public LexiconInfo[] getLexicons(String string) {
        return this.getLexicons(string, null);
    }

    public LexiconInfo[] getLexicons(String string, String string2) {
        ArrayList<LexiconInfo> arrayList = new ArrayList<LexiconInfo>();
        Iterator iterator = this.lexicons.values().iterator();
        String string3 = string2;
        if (string2 == null) {
            string3 = "";
        }
        while (iterator.hasNext()) {
            LexiconInfo lexiconInfo = (LexiconInfo)iterator.next();
            if (!lexiconInfo.getModuleName().equalsIgnoreCase(string) || !lexiconInfo.getLanguage().equalsIgnoreCase(string3)) continue;
            arrayList.add(lexiconInfo);
        }
        return arrayList.toArray(new LexiconInfo[arrayList.size()]);
    }

    public LexiconInfo getLexicon(String string, String string2, String string3) {
        LexiconInfo lexiconInfo;
        String string4 = string;
        if (string2 != null && string2.length() > 0) {
            string4 = string + '-' + string2;
        }
        if ((lexiconInfo = (LexiconInfo)this.lexicons.get(string4 = string4 + '-' + string3)) == null) {
            throw new RegistryException("Unknown lexicon" + string4);
        }
        return lexiconInfo;
    }

    void read(InputStream inputStream) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.readHeader(dataInputStream);
        this.readModules(dataInputStream);
        this.readTypes(dataInputStream);
        this.readDefs(dataInputStream);
        this.readFileExts(dataInputStream);
        this.readOrdSchemes(dataInputStream);
        this.readLexicons(dataInputStream);
        this.readAdapters(dataInputStream);
        dataInputStream.close();
    }

    void readHeader(DataInputStream dataInputStream) throws Exception {
        if (dataInputStream.readLong() != 7958534985112118370L) {
            throw new IOException("Invalid magic");
        }
        if (dataInputStream.readInt() != 3) {
            throw new IOException("Invalid version");
        }
        int n = dataInputStream.readInt();
        this.modules = new NModuleInfo[n];
        this.modulesByName = new HashMap(n * 3);
        int n2 = 0;
        while (n2 < n) {
            this.modules[n2] = new NModuleInfo(n2);
            ++n2;
        }
        n2 = dataInputStream.readInt();
        this.types = new NTypeInfo[n2];
        this.typesBySpec = new HashMap(n2 * 3);
        int n3 = 0;
        while (n3 < n2) {
            this.types[n3] = new NTypeInfo(n3, null);
            ++n3;
        }
    }

    void readModules(DataInputStream dataInputStream) throws Exception {
        int n = 0;
        while (n < this.modules.length) {
            NModuleInfo nModuleInfo = this.modules[n];
            nModuleInfo.read(this, dataInputStream);
            this.modulesByName.put(nModuleInfo.moduleName, nModuleInfo);
            ++n;
        }
    }

    void readTypes(DataInputStream dataInputStream) throws Exception {
        Array array;
        NTypeInfo[] nTypeInfoArray;
        NTypeInfo nTypeInfo;
        int n = 0;
        while (n < this.types.length) {
            NTypeInfo nTypeInfo2 = this.types[n];
            nTypeInfo2.read(this, dataInputStream);
            this.typesBySpec.put(nTypeInfo2.toString(), nTypeInfo2);
            ++n;
        }
        HashMap<NTypeInfo[], Array> hashMap = new HashMap<NTypeInfo[], Array>();
        int n2 = 0;
        while (n2 < this.types.length) {
            nTypeInfo = this.types[n2];
            int n3 = 0;
            while (n3 < nTypeInfo.agents.length) {
                nTypeInfoArray = nTypeInfo.agents[n3];
                array = (Array)hashMap.get(nTypeInfoArray);
                if (array == null) {
                    Class clazz = class$com$tridium$sys$registry$NAgentInfo;
                    if (clazz == null) {
                        clazz = RegistryDatabase.class("[Lcom.tridium.sys.registry.NAgentInfo;", false);
                    }
                    array = new Array(clazz);
                    hashMap.put(nTypeInfoArray, array);
                }
                array.add((Object)new NAgentInfo(nTypeInfo));
                ++n3;
            }
            ++n2;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            nTypeInfo = (NTypeInfo)iterator.next();
            Array array2 = (Array)hashMap.get(nTypeInfo);
            nTypeInfoArray = new NTypeInfo[array2.size()];
            array = (Array)array2.trim();
            int n4 = 0;
            while (n4 < ((NAgentInfo[])array).length) {
                nTypeInfoArray[n4] = (NTypeInfo)array[n4].getTypeInfo();
                ++n4;
            }
            nTypeInfo.agentOn = nTypeInfoArray;
        }
    }

    void readDefs(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        this.defs = new HashMap(n * 3);
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            int n3 = dataInputStream.readUnsignedByte();
            String[] stringArray = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                stringArray[n4] = dataInputStream.readUTF();
                ++n4;
            }
            this.defs.put(string, stringArray);
            ++n2;
        }
    }

    void readFileExts(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readUnsignedShort();
        this.fileExts = new String[n];
        this.typesByFileExt = new HashMap(n * 3);
        int n2 = 0;
        while (n2 < n) {
            String string;
            this.fileExts[n2] = string = dataInputStream.readUTF();
            this.typesByFileExt.put(string, this.types[dataInputStream.readUnsignedShort()]);
            ++n2;
        }
    }

    void readOrdSchemes(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readUnsignedShort();
        this.ordSchemes = new String[n];
        this.typesByOrdScheme = new HashMap(n * 3);
        int n2 = 0;
        while (n2 < n) {
            String string;
            this.ordSchemes[n2] = string = dataInputStream.readUTF();
            this.typesByOrdScheme.put(string, this.types[dataInputStream.readUnsignedShort()]);
            ++n2;
        }
    }

    void readLexicons(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        this.lexicons = new HashMap(n * 3);
        int n2 = 0;
        while (n2 < n) {
            NLexiconInfo nLexiconInfo = new NLexiconInfo();
            nLexiconInfo.read(dataInputStream);
            String string = nLexiconInfo.getModuleName();
            String string2 = nLexiconInfo.getLanguage();
            String string3 = nLexiconInfo.getContainerModuleName();
            if (string2 != null && string2.length() > 0) {
                string = string + '-' + string2;
            }
            string = string + '-' + string3;
            this.lexicons.put(string, nLexiconInfo);
            ++n2;
        }
    }

    void readAdapters(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readUnsignedShort();
        this.adapters = new NAdapterInfo[n];
        int n2 = 0;
        while (n2 < n) {
            this.adapters[n2] = new NAdapterInfo();
            this.adapters[n2].read(this, dataInputStream);
            ++n2;
        }
    }

    public BModule synthesizeModule(String string, Version version, String string2, Version version2, String string3) {
        if (this.modulesByName.containsKey(string)) {
            throw new RegistryException("Duplicate module name: " + string);
        }
        NModuleInfo nModuleInfo = new NModuleInfo(-1);
        nModuleInfo.moduleName = string;
        nModuleInfo.bajaVersion = version;
        nModuleInfo.vendor = string2;
        nModuleInfo.vendorVersion = version2;
        nModuleInfo.description = string3;
        nModuleInfo.hasPalette = false;
        nModuleInfo.buildTime = BAbsTime.now().getMillis();
        nModuleInfo.types = NTypeInfo.noTypes;
        nModuleInfo.moduleContent = "doc";
        nModuleInfo.depends = new NDependencyInfo[0];
        nModuleInfo.isTransientModule = true;
        this.modulesByName.put(nModuleInfo.moduleName, nModuleInfo);
        this.modules = (NModuleInfo[])ArrayUtil.addOne(this.modules, nModuleInfo);
        SortUtil.sort((Object[])this.modules);
        return Nre.moduleManager.synthesizeModule(nModuleInfo).bmodule();
    }

    public Type synthesizeType(BTypeSpec bTypeSpec, String string, TypeInfo typeInfo, TypeInfo[] typeInfoArray, AgentInfo[] agentInfoArray, boolean bl, boolean bl2) {
        if (this.typesBySpec.get(bTypeSpec.toString()) != null) {
            throw new RegistryException("Type already exists: " + bTypeSpec);
        }
        if (!this.modulesByName.containsKey(bTypeSpec.getModuleName())) {
            throw new RegistryException("Module does not exist: " + bTypeSpec.getModuleName());
        }
        if (!string.startsWith("auto.")) {
            throw new IllegalArgumentException("Class package must start with 'auto.'.");
        }
        if (!string.endsWith(".B" + bTypeSpec.getTypeName())) {
            throw new IllegalArgumentException("TypeSpec does not match class name.");
        }
        if (typeInfo.is(BFrozenEnum.TYPE) && !bl2) {
            throw new IllegalArgumentException("Frozen enumerations must be declared final.");
        }
        NTypeInfo nTypeInfo = new NTypeInfo(-1, bTypeSpec);
        nTypeInfo.superType = (NTypeInfo)typeInfo;
        nTypeInfo.lexicon = Lexicon.make("baja");
        nTypeInfo.className = string;
        nTypeInfo.isTransientType = true;
        boolean bl3 = false;
        NTypeInfo[] nTypeInfoArray = new NTypeInfo[typeInfoArray.length];
        int n = 0;
        while (n < typeInfoArray.length) {
            nTypeInfoArray[n] = (NTypeInfo)typeInfoArray[n];
            if (typeInfoArray[n].is(BIAgent.TYPE)) {
                bl3 = true;
            }
            ++n;
        }
        nTypeInfo.interfaces = nTypeInfoArray;
        if (agentInfoArray.length > 0 && !bl3) {
            throw new RegistryException("Type is an agent on other types, but does not implement BIAgent.");
        }
        NTypeInfo[] nTypeInfoArray2 = new NTypeInfo[agentInfoArray.length];
        int n2 = 0;
        while (n2 < agentInfoArray.length) {
            nTypeInfoArray2[n2] = (NTypeInfo)agentInfoArray[n2].getAgentType();
            ++n2;
        }
        nTypeInfo.agentOn = nTypeInfoArray2;
        n2 = 0;
        while (n2 < nTypeInfo.agentOn.length) {
            ArrayUtil.addOne(nTypeInfo.agentOn[n2].agents, nTypeInfo);
            ++n2;
        }
        n2 = 1;
        if (bl) {
            n2 |= 0x400;
        }
        if (bl2) {
            n2 |= 0x10;
        }
        nTypeInfo.modifiers = n2;
        Object object = new Builder.IsMap();
        NTypeInfo nTypeInfo2 = nTypeInfo;
        while (nTypeInfo2 != null) {
            ((Builder.IsMap)object).add(nTypeInfo2);
            nTypeInfo2 = nTypeInfo2.superType;
        }
        nTypeInfo2 = nTypeInfo;
        while (nTypeInfo2 != null) {
            this.mapInterfaces((Builder.IsMap)object, nTypeInfo2);
            nTypeInfo2 = nTypeInfo2.superType;
        }
        nTypeInfo.is = ((Builder.IsMap)object).toArray();
        this.types = (NTypeInfo[])ArrayUtil.addOne(this.types, nTypeInfo);
        this.typesBySpec.put(nTypeInfo.toString(), nTypeInfo);
        object = (NModuleInfo)this.modulesByName.get(bTypeSpec.getModuleName());
        ((NModuleInfo)object).types = (NTypeInfo[])ArrayUtil.addOne(((NModuleInfo)object).types, nTypeInfo);
        Nre.moduleManager.synthesizeType(bTypeSpec, string, typeInfo, typeInfoArray, bl, bl2);
        return bTypeSpec.getResolvedType();
    }

    private final void mapInterfaces(Builder.IsMap isMap, NTypeInfo nTypeInfo) {
        if (nTypeInfo.isInterface()) {
            isMap.add(nTypeInfo);
        }
        int n = 0;
        while (n < nTypeInfo.interfaces.length) {
            this.mapInterfaces(isMap, nTypeInfo.interfaces[n]);
            ++n;
        }
    }

    void write(File file) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.writeHeader(dataOutputStream);
        this.writeModules(dataOutputStream);
        this.writeTypes(dataOutputStream);
        this.writeDefs(dataOutputStream);
        this.writeFileExts(dataOutputStream);
        this.writeOrdSchemes(dataOutputStream);
        this.writeLexicons(dataOutputStream);
        this.writeAdapters(dataOutputStream);
        dataOutputStream.close();
    }

    void writeHeader(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeLong(7958534985112118370L);
        dataOutputStream.writeInt(3);
        dataOutputStream.writeInt(this.modules.length);
        dataOutputStream.writeInt(this.types.length);
    }

    void writeModules(DataOutputStream dataOutputStream) throws Exception {
        int n = 0;
        while (n < this.modules.length) {
            this.modules[n].write(this, dataOutputStream);
            ++n;
        }
    }

    void writeTypes(DataOutputStream dataOutputStream) throws Exception {
        int n = 0;
        while (n < this.types.length) {
            this.types[n].write(this, dataOutputStream);
            ++n;
        }
    }

    void writeDefs(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeInt(this.defs.size());
        Iterator iterator = this.defs.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = (String[])this.defs.get(string);
            dataOutputStream.writeUTF(string);
            dataOutputStream.write(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                dataOutputStream.writeUTF(stringArray[n]);
                ++n;
            }
        }
    }

    void writeFileExts(DataOutputStream dataOutputStream) throws Exception {
        int n = this.fileExts.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            String string = this.fileExts[n2];
            NTypeInfo nTypeInfo = (NTypeInfo)this.typesByFileExt.get(string);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeShort(nTypeInfo.id);
            ++n2;
        }
    }

    void writeOrdSchemes(DataOutputStream dataOutputStream) throws Exception {
        int n = this.ordSchemes.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            String string = this.ordSchemes[n2];
            NTypeInfo nTypeInfo = (NTypeInfo)this.typesByOrdScheme.get(string);
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeShort(nTypeInfo.id);
            ++n2;
        }
    }

    void writeLexicons(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeInt(this.lexicons.size());
        Iterator iterator = this.lexicons.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NLexiconInfo nLexiconInfo = (NLexiconInfo)this.lexicons.get(string);
            nLexiconInfo.write(dataOutputStream);
        }
    }

    void writeAdapters(DataOutputStream dataOutputStream) throws Exception {
        int n = this.adapters.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            this.adapters[n2].write(this, dataOutputStream);
            ++n2;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

