/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.Builder;
import com.tridium.sys.registry.Debug;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryChecksum;
import com.tridium.sys.registry.RegistryDatabase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.io.ValueDocDecoder;
import javax.baja.log.Log;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.Registry;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NRegistry
implements Registry {
    public static final Log log = Log.getLog("sys.registry");
    public static boolean forceRebuild = false;
    RegistryDatabase db;
    public final ValueDocDecoder.ITypeResolver typeResolver;
    private String[] invalidModules;

    public final BAbsTime getLastBuildTime() {
        return BAbsTime.make(this.dbFile().lastModified());
    }

    public final ModuleInfo[] getModules() {
        return this.db().getModules();
    }

    public final ModuleInfo getModule(String string) {
        return this.db().getModule(string);
    }

    public final TypeInfo[] getTypes() {
        return this.db().getTypes();
    }

    public final TypeInfo[] getTypes(TypeInfo typeInfo) {
        return this.db().getTypes(typeInfo, false);
    }

    public final TypeInfo[] getConcreteTypes(TypeInfo typeInfo) {
        return this.db().getTypes(typeInfo, true);
    }

    public final TypeInfo getType(String string) {
        return this.db().getType(string);
    }

    public final String[] getDefs() {
        return this.db().getDefs();
    }

    public final String[] getDefs(String string) {
        return this.db().getDefs(string);
    }

    public final String getDef(String string) {
        return this.db().getDef(string, null);
    }

    public final String getDef(String string, String string2) {
        return this.db().getDef(string, string2);
    }

    public final AgentList getAgents(TypeInfo typeInfo) {
        return this.db().getAgents(typeInfo);
    }

    public final AgentList getSpecificAgents(TypeInfo typeInfo) {
        return this.db().getSpecificAgents(typeInfo);
    }

    public final boolean isAgent(TypeInfo typeInfo, TypeInfo typeInfo2) {
        return this.db().isAgent(typeInfo, typeInfo2);
    }

    public final boolean isSpecificAgent(TypeInfo typeInfo, TypeInfo typeInfo2) {
        return this.db().isSpecificAgent(typeInfo, typeInfo2);
    }

    public final TypeInfo[] getAdapters(TypeInfo typeInfo, TypeInfo typeInfo2) {
        return this.db().getAdapters(typeInfo, typeInfo2);
    }

    public final String[] getFileExtensions() {
        return this.db().getFileExtensions();
    }

    public final String[] getFileExtensions(TypeInfo typeInfo) {
        return this.db().getFileExtensions(typeInfo);
    }

    public final TypeInfo getFileTypeForExtension(String string) {
        return this.db().getFileTypeForExtension(string);
    }

    public final String[] getOrdSchemes() {
        return this.db().getOrdSchemes();
    }

    public final TypeInfo getOrdScheme(String string) {
        return this.db().getOrdScheme(string);
    }

    public final boolean isOrdScheme(String string) {
        return this.db().isOrdScheme(string);
    }

    public final LexiconInfo[] getLexicons() {
        return this.db().getLexicons();
    }

    public final LexiconInfo[] getLexicons(String string) {
        return this.db().getLexicons(string);
    }

    public final LexiconInfo[] getLexicons(String string, String string2) {
        return this.db().getLexicons(string, string2);
    }

    public final LexiconInfo getLexicon(String string, String string2, String string3) {
        return this.db().getLexicon(string, string2, string3);
    }

    public final Type synthesizeType(BTypeSpec bTypeSpec, String string, TypeInfo typeInfo, TypeInfo[] typeInfoArray, AgentInfo[] agentInfoArray, boolean bl, boolean bl2) {
        return this.db().synthesizeType(bTypeSpec, string, typeInfo, typeInfoArray, agentInfoArray, bl, bl2);
    }

    public final BModule synthesizeModule(String string, Version version, String string2, Version version2, String string3) {
        return this.db().synthesizeModule(string, version, string2, version2, string3);
    }

    final RegistryDatabase db() {
        if (this.db == null) {
            try {
                long l = System.currentTimeMillis();
                this.db = new RegistryDatabase();
                InputStream inputStream = Nre.bootEnv.isRemote() ? Nre.bootEnv.read(this.dbRemote()) : new BufferedInputStream(new FileInputStream(this.dbFile()));
                this.db.read(inputStream);
                long l2 = System.currentTimeMillis();
                log.message("Loaded [" + (l2 - l) + "ms]");
            }
            catch (Throwable throwable) {
                throw new RegistryException("Cannot load registry", throwable);
            }
        }
        return this.db;
    }

    public final boolean isRegistryUpToDate() {
        if (Nre.bootEnv.isRemote()) {
            return true;
        }
        if (forceRebuild) {
            log.message("Force rebuild");
            return false;
        }
        if (this.dummyFile().exists()) {
            log.message("*** No Rebuild ***");
            return true;
        }
        long l = System.currentTimeMillis();
        try {
            File file = this.chkFile();
            if (!file.exists()) {
                throw new RegistryException("Missing \"" + file + '\"');
            }
            RegistryChecksum registryChecksum = new RegistryChecksum();
            registryChecksum.read(file);
            File file2 = new File(Nre.bajaHome, "modules");
            File[] fileArray = file2.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                registryChecksum.checkUpToDate(fileArray[n]);
                ++n;
            }
            if (registryChecksum.modules.size() > 0) {
                String string = ((RegistryChecksum.ModuleSnapshot)registryChecksum.modules.values().toArray()[0]).name;
                throw new RegistryException("Module removed \"" + string + '\"');
            }
        }
        catch (RegistryException registryException) {
            log.message("Out-of-date: " + registryException.getMessage());
            return false;
        }
        catch (Throwable throwable) {
            log.message("Out-of-date", throwable);
            return false;
        }
        long l2 = System.currentTimeMillis();
        log.message("Up-to-date [" + (l2 - l) + "ms]");
        return true;
    }

    public final void rebuild() {
        try {
            log.message("Rebuilding registry...");
            long l = System.currentTimeMillis();
            File file = this.dummyFile();
            boolean bl = file.exists();
            int n = Builder.rebuild(this);
            TypeInfo[] typeInfoArray = this.getConcreteTypes(BObject.TYPE.getTypeInfo());
            int n2 = 0;
            while (n2 < typeInfoArray.length) {
                NTypeInfo nTypeInfo = (NTypeInfo)typeInfoArray[n2];
                if (nTypeInfo.agentOn.length > 0 && !nTypeInfo.is(BIAgent.TYPE)) {
                    log.warning(nTypeInfo.getTypeSpec() + " declares itself as an agent, but does not implement BIAgent.");
                }
                ++n2;
            }
            if (bl) {
                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                printWriter.write("no-rebuild.dummy " + new Date());
                printWriter.close();
            }
            long l2 = System.currentTimeMillis();
            log.message("Rebuilt: " + n + " types [" + (l2 - l) + "ms]");
        }
        catch (Throwable throwable) {
            log.error("Cannot rebuild", throwable);
        }
    }

    public final void syncModules() {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException("Can't syncModules() on uninitialized registry");
        }
        Builder.syncFiles(this);
    }

    public final void loadModule(String string) throws Exception {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException("Can't loadModule(" + string + ") on uninitialized registry");
        }
        Builder.loadModule(this, string);
    }

    public final void unloadModule(String string) throws Exception {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException("Can't unloadModule(" + string + ") on uninitialized registry");
        }
        Builder.unloadModule(this, string);
    }

    public final void reloadModule(String string) throws Exception {
        if (Nre.bootEnv.isRemote()) {
            return;
        }
        if (this.db == null) {
            throw new IllegalStateException("Can't reloadModule(" + string + ") on uninitialized registry");
        }
        Builder.reloadModule(this, string);
    }

    public final void postInit() {
        if (!this.isRegistryUpToDate()) {
            this.rebuild();
        }
        try {
            this.checkNSedona();
        }
        catch (RegistryException registryException) {
            ((NRegistryTypeResolver)this.typeResolver).registryException = new RegistryException(registryException.getMessage());
            this.invalidModules = new String[]{((NRegistryTypeResolver)this.typeResolver).invalidModuleName};
        }
        Nre.spySysManagers.add("registryManager", new Debug.SummaryPage());
    }

    public final String[] getInvalidModules() {
        return this.invalidModules;
    }

    private final void checkNSedona() throws RegistryException {
        Object object;
        try {
            ((NRegistryTypeResolver)this.typeResolver).invalidModuleName = "nsedona";
            object = this.getModule("nsedona");
            String string = "nsedona " + object.getVendorVersion() + " not supported: ";
            if (object.getVendorVersion().compareTo(new Version("1.1")) < 0) {
                throw new RegistryException(string + "baja " + this.getModule("baja").getVendorVersion());
            }
            try {
                this.getType("nsedona:DaspTunnel");
            }
            catch (TypeNotFoundException typeNotFoundException) {
                throw new RegistryException(string + "[0]");
            }
            try {
                this.getType("nsedona:SedonaNetwork");
                throw new RegistryException(string + "[1]");
            }
            catch (TypeNotFoundException typeNotFoundException) {
            }
        }
        catch (ModuleNotFoundException moduleNotFoundException) {}
        object = this.getTypes();
        int n = 0;
        while (n < ((TypeInfo[])object).length) {
            String string = object[n].getTypeClassName();
            if (string.startsWith("javax.baja.sedona.driver.") || string.startsWith("com.tridium.sedona.")) {
                ((NRegistryTypeResolver)this.typeResolver).invalidModuleName = object[n].getModuleName();
                throw new RegistryException(object[n] + ": [2]");
            }
            ++n;
        }
    }

    public final File dir() {
        return new File(Nre.bajaHome, "registry");
    }

    public final File dbFile() {
        return new File(this.dir(), "registry.db");
    }

    public final String dbRemote() {
        return "/registry/registry.db";
    }

    public final File chkFile() {
        return new File(this.dir(), "registry.chk");
    }

    public final File dummyFile() {
        return new File(this.dir(), "no-rebuild.dummy");
    }

    private final /* synthetic */ void this() {
        this.typeResolver = new NRegistryTypeResolver();
        this.invalidModules = null;
    }

    public NRegistry() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class NRegistryTypeResolver
    extends ValueDocDecoder.BogTypeResolver {
        String invalidModuleName;
        RegistryException registryException;

        public final BModule loadModule(ValueDocDecoder valueDocDecoder, BComplex bComplex, String string, String string2, String string3) {
            if (this.registryException != null && this.invalidModuleName != null) {
                String string4 = null;
                try {
                    int n = string2.indexOf(61);
                    string4 = string2.substring(n + 1).trim();
                }
                catch (Exception exception) {
                    super.loadModule(valueDocDecoder, bComplex, string, string2, string3);
                    throw new XException("Invalid module attribute '" + string2 + '\'', ((ValueDocDecoder.BogDecoderPlugin)valueDocDecoder.getPlugin()).getXmlParser());
                }
                if (string4.equals(this.invalidModuleName)) {
                    throw this.registryException;
                }
            }
            return super.loadModule(valueDocDecoder, bComplex, string, string2, string3);
        }

        private final /* synthetic */ void this() {
            this.invalidModuleName = null;
            this.registryException = null;
        }

        private NRegistryTypeResolver() {
            this.this();
        }
    }
}

