/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.baja.log.Log;
import javax.baja.registry.LexiconInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NLexiconInfo
implements LexiconInfo {
    private static final Log log = Log.getLog("sys.registry");
    private static final NLexiconInfo[] none = new NLexiconInfo[0];
    private String brandPattern;
    private String moduleName;
    private String resourcePath;
    private String language;
    private String containerModuleName;
    private BAbsTime lastModified;
    private boolean defaultLexicon;

    public String getBrandPattern() {
        return this.brandPattern;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getContainerModuleName() {
        return this.containerModuleName;
    }

    public BAbsTime getLastModified() {
        return this.lastModified;
    }

    public boolean isDefault() {
        return this.defaultLexicon;
    }

    public void setLastModified(long l) {
        this.lastModified = BAbsTime.make(l);
    }

    public void setLastModified(BAbsTime bAbsTime) {
        this.lastModified = bAbsTime;
    }

    public void read(DataInputStream dataInputStream) throws Exception {
        this.moduleName = dataInputStream.readUTF();
        this.brandPattern = dataInputStream.readUTF();
        this.resourcePath = dataInputStream.readUTF();
        this.language = dataInputStream.readUTF();
        this.containerModuleName = dataInputStream.readUTF();
        this.defaultLexicon = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeUTF(this.moduleName);
        dataOutputStream.writeUTF(this.brandPattern);
        dataOutputStream.writeUTF(this.resourcePath);
        dataOutputStream.writeUTF(this.language);
        dataOutputStream.writeUTF(this.containerModuleName);
        dataOutputStream.writeBoolean(this.defaultLexicon);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.moduleName);
        if (this.language != null) {
            stringBuffer.append('-').append(this.language);
        }
        if (this.brandPattern != null) {
            stringBuffer.append('-').append(this.brandPattern);
        }
        if (this.containerModuleName != null) {
            stringBuffer.append('-').append(this.containerModuleName);
        }
        if (this.resourcePath != null) {
            stringBuffer.append('-').append(this.resourcePath);
        }
        if (this.defaultLexicon) {
            stringBuffer.append('-').append("true");
        } else {
            stringBuffer.append('-').append("false");
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.defaultLexicon = false;
    }

    public NLexiconInfo() {
        this.this();
    }

    public NLexiconInfo(XElem xElem, String string, String string2) {
        this.this();
        this.moduleName = xElem.get("module");
        this.brandPattern = string;
        this.resourcePath = xElem.get("resource");
        this.language = xElem.get("language", "");
        this.containerModuleName = string2;
        this.defaultLexicon = xElem.getb("default", false);
        this.lastModified = BAbsTime.NULL;
    }
}

