/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.NAdapterInfo;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NTypeInfo;
import java.io.File;
import java.io.StringWriter;
import javax.baja.agent.AgentInfo;
import javax.baja.io.HtmlWriter;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;

public class Debug {
    public static final Log log = Log.getLog("sys.registry");
    private File root;

    public File modulesFile() {
        return new File(this.root, "modules.xml");
    }

    public File moduleDir(String string) {
        return new File(this.root, string);
    }

    public static class AdaptersPage
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            String string = "../";
            NAdapterInfo[] nAdapterInfoArray = Nre.registryManager.db().adapters;
            spyWriter.startTable(true);
            spyWriter.trTitle("Installed Adapters", 3);
            spyWriter.w("<tr>").th("Type").th("From").th("To").w("</tr>\n");
            int n = 0;
            while (n < nAdapterInfoArray.length) {
                NAdapterInfo nAdapterInfo = nAdapterInfoArray[n];
                spyWriter.w("<tr>").td("<a href='" + string + "types/" + nAdapterInfo.type.toString() + "'>" + nAdapterInfo.type + "</a>").td("<a href='" + string + "types/" + nAdapterInfo.from.toString() + "'>" + nAdapterInfo.from + "</a>").td("<a href='" + string + "types/" + nAdapterInfo.to.toString() + "'>" + nAdapterInfo.to + "</a>").w("</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }
    }

    public static class OrdSchemesPage
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            String string = "../";
            String[] stringArray = Sys.getRegistry().getOrdSchemes();
            spyWriter.startTable(true);
            spyWriter.trTitle("Installed Ord Schemes", 2);
            int n = 0;
            while (n < stringArray.length) {
                TypeInfo typeInfo = Sys.getRegistry().getOrdScheme(stringArray[n]);
                spyWriter.w("<tr>").td(stringArray[n]).td("<a href='" + string + "types/" + typeInfo.toString() + "'>" + typeInfo + "</a>").w("</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }
    }

    public static class FileExtsPage
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            String string = "../";
            String[] stringArray = Sys.getRegistry().getFileExtensions();
            spyWriter.startTable(true);
            spyWriter.trTitle("Installed File Extensions", 2);
            int n = 0;
            while (n < stringArray.length) {
                TypeInfo typeInfo = Sys.getRegistry().getFileTypeForExtension(stringArray[n]);
                spyWriter.w("<tr>").td(stringArray[n]).td("<a href='" + string + "types/" + typeInfo.toString() + "'>" + typeInfo + "</a>").w("</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }
    }

    public static class DefsPage
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = Sys.getRegistry().getDefs();
            SortUtil.sort((Object[])objectArray, (Object[])objectArray);
            spyWriter.startTable(true);
            spyWriter.trTitle("Defs [" + objectArray.length + ']', 2);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = Sys.getRegistry().getDef((String)object);
                spyWriter.tr(object, string);
                ++n;
            }
            spyWriter.endTable();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TypePage
    extends Spy {
        String typeSpec;
        static /* synthetic */ Class class$javax$baja$registry$TypeInfo;

        public void write(SpyWriter spyWriter) throws Exception {
            NTypeInfo[] nTypeInfoArray;
            NTypeInfo[] nTypeInfoArray2;
            NTypeInfo nTypeInfo = (NTypeInfo)Sys.getRegistry().getType(this.typeSpec);
            String string = "../";
            spyWriter.startTable(true);
            StringWriter stringWriter = new StringWriter();
            new HtmlWriter(stringWriter).w("Type ").a("../../modules/" + nTypeInfo.getModuleName(), nTypeInfo.getModuleName()).w(":").w(nTypeInfo.getTypeName());
            spyWriter.trTitle(stringWriter, 2);
            spyWriter.w("<tr>").td("isAbstract").td("" + nTypeInfo.isAbstract()).w("</tr>\n");
            spyWriter.w("<tr>").td("isInterface").td("" + nTypeInfo.isInterface()).w("</tr>\n");
            spyWriter.w("<tr>").td("superType").td(this.typeref(string, nTypeInfo.getSuperType())).w("</tr>\n");
            TypeInfo[] typeInfoArray = nTypeInfo.getInterfaces();
            if (typeInfoArray.length > 0) {
                spyWriter.trTitle("Interfaces", 2);
                int n = 0;
                while (n < typeInfoArray.length) {
                    spyWriter.w("<tr><td colspan='2'>").w(this.typeref(string, typeInfoArray[n])).w("</td></tr>\n");
                    ++n;
                }
            }
            if ((nTypeInfoArray2 = nTypeInfo.agents).length > 0) {
                spyWriter.trTitle("Agents", 2);
                int n = 0;
                while (n < nTypeInfoArray2.length) {
                    spyWriter.w("<tr><td colspan='2'>").w(this.typeref(string, nTypeInfoArray2[n])).w("</td></tr>\n");
                    ++n;
                }
            }
            if ((nTypeInfoArray = nTypeInfo.agentOn).length > 0) {
                spyWriter.trTitle("Agent On", 2);
                int n = 0;
                while (n < nTypeInfoArray.length) {
                    spyWriter.w("<tr><td colspan='2'>").w(this.typeref(string, nTypeInfoArray[n])).w("</td></tr>\n");
                    ++n;
                }
            }
            NTypeInfo[] nTypeInfoArray3 = nTypeInfo.is;
            spyWriter.trTitle("Is Types", 2);
            int n = 0;
            while (n < nTypeInfoArray3.length) {
                spyWriter.w("<tr><td colspan='2'>").w(this.typeref(string, nTypeInfoArray3[n])).w("</td></tr>\n");
                ++n;
            }
            TypeInfo[] typeInfoArray2 = Sys.getRegistry().getTypes(nTypeInfo);
            Class clazz = class$javax$baja$registry$TypeInfo;
            if (clazz == null) {
                clazz = class$javax$baja$registry$TypeInfo = TypePage.class("[Ljavax.baja.registry.TypeInfo;", false);
            }
            Array array = new Array(clazz);
            int n2 = 0;
            while (n2 < typeInfoArray2.length) {
                if (nTypeInfo.isInterface()) {
                    if (new Array((Object[])typeInfoArray2[n2].getInterfaces()).indexOf((Object)nTypeInfo) != -1) {
                        array.add((Object)typeInfoArray2[n2]);
                    }
                } else {
                    TypeInfo typeInfo = typeInfoArray2[n2].getSuperType();
                    if (typeInfo != null && typeInfo.equals(nTypeInfo)) {
                        array.add((Object)typeInfoArray2[n2]);
                    }
                }
                ++n2;
            }
            if (array.size() > 0) {
                typeInfoArray2 = (TypeInfo[])array.trim();
                spyWriter.trTitle("Sub Types", 2);
                n2 = 0;
                while (n2 < typeInfoArray2.length) {
                    spyWriter.w("<tr><td colspan='2'>").w(this.typeref(string, typeInfoArray2[n2])).w("</td></tr>\n");
                    ++n2;
                }
            }
            try {
                AgentInfo agentInfo = nTypeInfo.getAgentInfo();
                spyWriter.trTitle("AgentInfo", 2);
                spyWriter.w("<tr>").td("requiredPermissions").td(agentInfo.getRequiredPermissions()).w("</tr>\n");
                spyWriter.w("<tr>").td("appName").td(agentInfo.getAppName()).w("</tr>\n");
            }
            catch (RegistryException registryException) {}
            spyWriter.endTable();
        }

        private final String typeref(String string, TypeInfo typeInfo) {
            if (typeInfo == null) {
                return "null";
            }
            return "<a href='" + string + typeInfo.toString() + "'>" + typeInfo.toString() + "</a>";
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        TypePage(String string) {
            this.typeSpec = string;
        }
    }

    public static class TypesPage
    extends SpyDir {
        public Spy find(String string) {
            return new TypePage(string);
        }

        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = Sys.getRegistry().getTypes();
            SortUtil.sort((Object[])objectArray);
            spyWriter.startTable(true);
            spyWriter.trTitle("Installed Types", 1);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                spyWriter.w("<tr>").td("<a href='../types/" + spyWriter.href(object.toString()) + "'>" + object + "</a>").w("</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }
    }

    public static class ModulePage
    extends Spy {
        String name;

        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = Sys.getRegistry().getModule(this.name).getTypes();
            SortUtil.sort((Object[])objectArray);
            spyWriter.startTable(true);
            spyWriter.trTitle("Module \"" + this.name + '\"', 1);
            int n = 0;
            while (n < objectArray.length) {
                NTypeInfo nTypeInfo = (NTypeInfo)objectArray[n];
                spyWriter.w("<tr>").td("<a href='" + spyWriter.href("../../types/" + nTypeInfo.toString()) + "'>" + nTypeInfo + "</a>").w("</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }

        ModulePage(String string) {
            this.name = string;
        }
    }

    public static class ModulesPage
    extends SpyDir {
        public Spy find(String string) {
            return new ModulePage(string);
        }

        public void write(SpyWriter spyWriter) throws Exception {
            ModuleInfo[] moduleInfoArray = Sys.getRegistry().getModules();
            spyWriter.startTable(true);
            spyWriter.trTitle("Installed Modules", 8);
            int n = 0;
            while (n < moduleInfoArray.length) {
                NModuleInfo nModuleInfo = (NModuleInfo)moduleInfoArray[n];
                spyWriter.w("<tr>").td("<a href='" + spyWriter.href(nModuleInfo.getModuleName()) + "'>" + nModuleInfo.getModuleName() + "</a>").td(nModuleInfo.getBajaVersion()).td(nModuleInfo.getVendor()).td(nModuleInfo.getVendorVersion()).td(nModuleInfo.getDescription()).td(BAbsTime.make(nModuleInfo.getBuildTime())).td(nModuleInfo.hasPalette() ? "palette" : "no palette").td(nModuleInfo.isAutoload() ? "autoload" : "non-autoload").td(nModuleInfo.isReloadable() ? "reloadable" : "non-reloadable").w("</tr>\n");
                ++n;
            }
            spyWriter.endTable();
        }
    }

    public static class SummaryPage
    extends SpyDir {
        public void write(SpyWriter spyWriter) throws Exception {
            spyWriter.startTable(true);
            spyWriter.trTitle("Registry", 1);
            spyWriter.w("<tr>").td("<a href='" + spyWriter.href("modules") + "'>Installed Modules</a>").w("</tr>");
            spyWriter.w("<tr>").td("<a href='" + spyWriter.href("types") + "'>Installed Types</a>").w("</tr>");
            spyWriter.w("<tr>").td("<a href='" + spyWriter.href("defs") + "'>Registry Definitions</a>").w("</tr>");
            spyWriter.w("<tr>").td("<a href='" + spyWriter.href("fileExts") + "'>Installed File Extensions</a>").w("</tr>");
            spyWriter.w("<tr>").td("<a href='" + spyWriter.href("ordSchemes") + "'>Installed Ord Schemes</a>").w("</tr>");
            spyWriter.w("<tr>").td("<a href='" + spyWriter.href("adapters") + "'>Installed Adapters</a>").w("</tr>");
            spyWriter.endTable();
        }

        SummaryPage() {
            this.add("modules", new ModulesPage());
            this.add("types", new TypesPage());
            this.add("defs", new DefsPage());
            this.add("fileExts", new FileExtsPage());
            this.add("ordSchemes", new OrdSchemesPage());
            this.add("adapters", new AdaptersPage());
        }
    }
}

