/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.ClassScanner;
import com.tridium.sys.registry.NAdapterInfo;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NDependencyInfo;
import com.tridium.sys.registry.NLexiconInfo;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryChecksum;
import com.tridium.sys.registry.RegistryDatabase;
import com.tridium.util.ArrayUtil;
import com.tridium.util.jar.JarEntry;
import com.tridium.util.jar.JarFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.LexiconInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Builder {
    static final Log log = Log.getLog("sys.registry");
    static HashSet skipFiles = new HashSet();
    ModuleBuild[] moduleBuilds;
    ArrayList typeBuilds;
    ArrayList adapterBuilds;
    HashMap typeBuildsBySpecString;
    HashMap typesByFileExt;
    HashMap typesByOrdScheme;
    HashMap typesBySpecString;
    HashMap typesByClass;
    HashMap defs;
    HashMap lexicons;
    static /* synthetic */ Class class$com$tridium$sys$registry$NModuleInfo;
    static /* synthetic */ Class class$com$tridium$sys$registry$NTypeInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$sys$registry$NAdapterInfo;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    static int rebuild(NRegistry nRegistry) throws Exception {
        Builder.clean(nRegistry);
        ModuleBuild[] moduleBuildArray = Builder.load();
        Builder builder = new Builder();
        builder.init(moduleBuildArray, 0, 0);
        builder.resolveSuperAndInterfaces();
        builder.resolveIsTypes();
        builder.resolveAdapters();
        builder.agentize();
        builder.write(nRegistry);
        return builder.typeBuilds.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void syncFiles(NRegistry nRegistry) {
        NRegistry nRegistry2 = nRegistry;
        synchronized (nRegistry2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object object;
            File file = new File(Nre.bajaHome, "modules");
            File[] fileArray = file.listFiles();
            HashMap<Object[], ModuleBuild> hashMap = new HashMap<Object[], ModuleBuild>();
            HashMap<String, ArrayList<ModuleBuild>> hashMap2 = new HashMap<String, ArrayList<ModuleBuild>>();
            HashMap<Object[], ModuleBuild> hashMap3 = new HashMap<Object[], ModuleBuild>();
            int n = 0;
            while (true) {
                if (n >= fileArray.length) {
                    if (hashMap.size() != 0 || hashMap3.size() != 0) break;
                    return;
                }
                object = fileArray[n];
                if (!skipFiles.contains(object.getName()) && (object.getName().endsWith(".jar") || object.getName().endsWith(".sjar"))) {
                    ModuleBuild moduleBuild;
                    objectArray2 = object.getName().substring(0, object.getName().length() - 4);
                    objectArray = (Object[])nRegistry.db.modulesByName.get(objectArray2);
                    if (objectArray == null) {
                        try {
                            moduleBuild = Builder.readModule((File)object, true);
                            if (moduleBuild == null) {
                                skipFiles.add(object.getName());
                            } else {
                                hashMap.put(objectArray2, moduleBuild);
                                DependencyInfo[] dependencyInfoArray = moduleBuild.info.depends;
                                int n2 = 0;
                                while (n2 < dependencyInfoArray.length) {
                                    ArrayList<ModuleBuild> arrayList = (ArrayList<ModuleBuild>)hashMap2.get(dependencyInfoArray[n2].getModuleName());
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<ModuleBuild>();
                                        hashMap2.put(dependencyInfoArray[n2].getModuleName(), arrayList);
                                    }
                                    arrayList.add(moduleBuild);
                                    ++n2;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            log.error("Cannot read module " + object.getName(), throwable);
                        }
                    } else if (objectArray.isReloadableModule) {
                        try {
                            moduleBuild = Builder.readModule((File)object, true);
                            if (moduleBuild.info.getBuildTime() != objectArray.getBuildTime()) {
                                hashMap3.put(objectArray2, moduleBuild);
                            }
                        }
                        catch (Throwable throwable) {
                            log.error("Cannot read module " + object.getName(), throwable);
                        }
                    }
                }
                ++n;
            }
            Object object2 = hashMap3.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                try {
                    log.trace("Reload module " + (String)object);
                    Builder.reloadModule(nRegistry, (String)object);
                }
                catch (Throwable throwable) {
                    log.error("Cannot reload module " + (String)object, throwable);
                }
            }
            object2 = hashMap2.keySet().iterator();
            while (object2.hasNext()) {
                Builder.checkDependencies((String)object2.next(), nRegistry, hashMap2, hashMap);
            }
            object2 = new Builder();
            super.init(hashMap.values().toArray(new ModuleBuild[hashMap.size()]), nRegistry);
            super.resolveSuperAndInterfaces();
            super.resolveIsTypes();
            super.resolveAdapters();
            super.agentize();
            object = super.sortModules();
            objectArray2 = (NModuleInfo[])ArrayUtil.add(nRegistry.db.modules, object);
            objectArray = new String[objectArray2.length];
            int n3 = 0;
            while (n3 < objectArray2.length) {
                objectArray[n3] = ((NModuleInfo)objectArray2[n3]).getModuleName();
                ++n3;
            }
            SortUtil.sort((Object[])objectArray, (Object[])objectArray2);
            NTypeInfo[] nTypeInfoArray = ((Builder)object2).typesByClass.values().toArray(new NTypeInfo[((Builder)object2).typesByClass.size()]);
            HashMap<String, NTypeInfo> hashMap4 = new HashMap<String, NTypeInfo>();
            int n4 = 0;
            while (n4 < nTypeInfoArray.length) {
                hashMap4.put(nTypeInfoArray[n4].typeSpec.toString(), nTypeInfoArray[n4]);
                ++n4;
            }
            NAdapterInfo[] nAdapterInfoArray = new NAdapterInfo[nRegistry.db.adapters.length + ((Builder)object2).adapterBuilds.size()];
            System.arraycopy(nRegistry.db.adapters, 0, nAdapterInfoArray, 0, nRegistry.db.adapters.length);
            int n5 = 0;
            while (n5 < ((Builder)object2).adapterBuilds.size()) {
                nAdapterInfoArray[n5 + nRegistry.db.adapters.length] = ((AdapterBuild)((Builder)object2).adapterBuilds.get((int)n5)).info;
                ++n5;
            }
            String[] stringArray = super.sortOrdSchemes();
            String[] stringArray2 = super.sortFileExts();
            HashMap<String, Object> hashMap5 = new HashMap<String, Object>();
            hashMap5.putAll(nRegistry.db.modulesByName);
            int n6 = 0;
            while (n6 < ((Object[])object).length) {
                hashMap5.put(((NModuleInfo)object[n6]).getModuleName(), object[n6]);
                ++n6;
            }
            n6 = 0;
            while (n6 < ((Builder)object2).moduleBuilds.length) {
                Iterator iterator = ((Builder)object2).moduleBuilds[n6].agentTypesByTargetSpec.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    NTypeInfo nTypeInfo = (NTypeInfo)hashMap4.get(string);
                    Object[] objectArray3 = (NTypeInfo[])((Builder)object2).moduleBuilds[n6].agentTypesByTargetSpec.get(string);
                    nTypeInfo.agents = (NTypeInfo[])ArrayUtil.add(nTypeInfo.agents, objectArray3);
                }
                ++n6;
            }
            nRegistry.db.modules = objectArray2;
            nRegistry.db.modulesByName = hashMap5;
            nRegistry.db.types = nTypeInfoArray;
            nRegistry.db.typesBySpec = hashMap4;
            nRegistry.db.defs = ((Builder)object2).defs;
            nRegistry.db.fileExts = stringArray2;
            nRegistry.db.typesByFileExt = ((Builder)object2).typesByFileExt;
            nRegistry.db.ordSchemes = stringArray;
            nRegistry.db.lexicons = ((Builder)object2).lexicons;
            nRegistry.db.typesByOrdScheme = ((Builder)object2).typesByOrdScheme;
            nRegistry.db.adapters = nAdapterInfoArray;
            return;
        }
    }

    private static final void checkDependencies(String string, NRegistry nRegistry, Map map, Map map2) {
        ArrayList arrayList = (ArrayList)map.get(string);
        if (arrayList == null) {
            return;
        }
        ModuleBuild moduleBuild = (ModuleBuild)map2.get(string);
        NModuleInfo nModuleInfo = moduleBuild == null ? (NModuleInfo)nRegistry.db.modulesByName.get(string) : moduleBuild.info;
        int n = 0;
        while (n < arrayList.size()) {
            ModuleBuild moduleBuild2 = (ModuleBuild)arrayList.get(n);
            String string2 = moduleBuild2.info.getModuleName();
            if (map2.containsKey(string2)) {
                DependencyInfo[] dependencyInfoArray = moduleBuild2.info.depends;
                int n2 = 0;
                while (n2 < dependencyInfoArray.length) {
                    if (dependencyInfoArray[n2].getModuleName().equals(string)) {
                        if (nModuleInfo != null && (dependencyInfoArray[n2].getVendorVersion() == null || nModuleInfo.getVendorVersion().compareTo(dependencyInfoArray[n2].getVendorVersion()) >= 0) || map2.remove(string2) == null) break;
                        log.error("Cannot load module " + string2 + ".jar, dependency failed: " + dependencyInfoArray[n2]);
                        Builder.checkDependencies(string2, nRegistry, map, map2);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void loadModule(NRegistry nRegistry, String string) throws ModuleNotFoundException {
        NRegistry nRegistry2 = nRegistry;
        synchronized (nRegistry2) {
            Object[] objectArray;
            Object object;
            File file = new File(Nre.bajaHome, "modules");
            HashMap<String, ModuleBuild> hashMap = new HashMap<String, ModuleBuild>();
            HashMap<String, Object[]> hashMap2 = new HashMap<String, Object[]>();
            File file2 = new File(file, string + ".jar");
            if (!file2.exists()) {
                throw new ModuleNotFoundException(string);
            }
            NModuleInfo nModuleInfo = (NModuleInfo)nRegistry.db.modulesByName.get(string);
            if (nModuleInfo == null || !nModuleInfo.isAutoloadModule || nModuleInfo.isReloadableModule) {
                try {
                    ModuleBuild moduleBuild = Builder.readModule(file2, true, true);
                    hashMap.put(string, moduleBuild);
                    object = moduleBuild.info.depends;
                    int n = 0;
                    while (n < ((DependencyInfo[])object).length) {
                        objectArray = (Object[])hashMap2.get(object[n].getModuleName());
                        if (objectArray == null) {
                            objectArray = new ArrayList();
                            hashMap2.put(object[n].getModuleName(), objectArray);
                        }
                        objectArray.add(moduleBuild);
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    log.error("Cannot read module " + file2.getName(), throwable);
                }
            }
            object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                Builder.checkDependencies((String)object.next(), nRegistry, hashMap2, hashMap);
            }
            object = new Builder();
            super.init(hashMap.values().toArray(new ModuleBuild[hashMap.size()]), nRegistry);
            super.resolveSuperAndInterfaces();
            super.resolveIsTypes();
            super.resolveAdapters();
            super.agentize();
            Object[] objectArray2 = super.sortModules();
            objectArray = nRegistry.db.modules;
            Class clazz = class$com$tridium$sys$registry$NModuleInfo;
            if (clazz == null) {
                clazz = class$com$tridium$sys$registry$NModuleInfo = Builder.class("[Lcom.tridium.sys.registry.NModuleInfo;", false);
            }
            Array array = new Array(clazz);
            if (nModuleInfo != null) {
                int n = 0;
                while (n < objectArray.length) {
                    if (!((NModuleInfo)objectArray[n]).getModuleName().equals(nModuleInfo.getModuleName())) {
                        array.add(objectArray[n]);
                    }
                    ++n;
                }
                objectArray = (NModuleInfo[])array.trim();
            }
            objectArray = (NModuleInfo[])ArrayUtil.add(objectArray, objectArray2);
            Object[] objectArray3 = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray3[n] = ((NModuleInfo)objectArray[n]).getModuleName();
                ++n;
            }
            SortUtil.sort((Object[])objectArray3, (Object[])objectArray);
            NTypeInfo[] nTypeInfoArray = ((Builder)object).typesByClass.values().toArray(new NTypeInfo[((Builder)object).typesByClass.size()]);
            HashMap<String, NTypeInfo> hashMap3 = new HashMap<String, NTypeInfo>();
            int n2 = 0;
            while (n2 < nTypeInfoArray.length) {
                hashMap3.put(nTypeInfoArray[n2].typeSpec.toString(), nTypeInfoArray[n2]);
                ++n2;
            }
            NAdapterInfo[] nAdapterInfoArray = new NAdapterInfo[nRegistry.db.adapters.length + ((Builder)object).adapterBuilds.size()];
            System.arraycopy(nRegistry.db.adapters, 0, nAdapterInfoArray, 0, nRegistry.db.adapters.length);
            int n3 = 0;
            while (n3 < ((Builder)object).adapterBuilds.size()) {
                nAdapterInfoArray[n3 + nRegistry.db.adapters.length] = ((AdapterBuild)((Builder)object).adapterBuilds.get((int)n3)).info;
                ++n3;
            }
            String[] stringArray = super.sortOrdSchemes();
            String[] stringArray2 = super.sortFileExts();
            HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
            hashMap4.putAll(nRegistry.db.modulesByName);
            int n4 = 0;
            while (n4 < objectArray2.length) {
                hashMap4.put(((NModuleInfo)objectArray2[n4]).getModuleName(), objectArray2[n4]);
                ++n4;
            }
            n4 = 0;
            while (n4 < ((Builder)object).moduleBuilds.length) {
                Iterator iterator = ((Builder)object).moduleBuilds[n4].agentTypesByTargetSpec.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    NTypeInfo nTypeInfo = (NTypeInfo)hashMap3.get(string2);
                    Object[] objectArray4 = (NTypeInfo[])((Builder)object).moduleBuilds[n4].agentTypesByTargetSpec.get(string2);
                    nTypeInfo.agents = (NTypeInfo[])ArrayUtil.add(nTypeInfo.agents, objectArray4);
                }
                ++n4;
            }
            nRegistry.db.modules = objectArray;
            nRegistry.db.modulesByName = hashMap4;
            nRegistry.db.types = nTypeInfoArray;
            nRegistry.db.typesBySpec = hashMap3;
            nRegistry.db.defs = ((Builder)object).defs;
            nRegistry.db.fileExts = stringArray2;
            nRegistry.db.typesByFileExt = ((Builder)object).typesByFileExt;
            nRegistry.db.ordSchemes = stringArray;
            nRegistry.db.lexicons = ((Builder)object).lexicons;
            nRegistry.db.typesByOrdScheme = ((Builder)object).typesByOrdScheme;
            nRegistry.db.adapters = nAdapterInfoArray;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void unloadModule(NRegistry var0, String var1_1) throws Exception {
        var2_2 = (NModuleInfo)var0.db.modulesByName.get(var1_1);
        if (var2_2 == null) {
            throw new Exception("Module not loaded.");
        }
        if (var2_2.isAutoloadModule && !var2_2.isReloadableModule) {
            throw new Exception("Module must not be autoload or must be reloadable");
        }
        var3_3 = new File(Nre.bajaHome, "modules");
        var4_4 = new File(var3_3, var1_1 + ".jar");
        if (!var4_4.exists()) {
            throw new ModuleNotFoundException(var1_1);
        }
        var5_5 = Builder.readModule(var4_4, true, true);
        var6_6 = var0;
        synchronized (var6_6) {
            var8_7 = var2_2.getTypes();
            var9_8 = var0.db.types;
            var10_9 = var0.db.typesBySpec;
            v0 = Builder.class$com$tridium$sys$registry$NTypeInfo;
            if (v0 == null) {
                v0 = Builder.class$com$tridium$sys$registry$NTypeInfo = Builder.class("[Lcom.tridium.sys.registry.NTypeInfo;", false);
            }
            var11_10 = new Array(v0);
            var12_11 = 0;
            while (true) {
                block30: {
                    if (var12_11 < var9_8.length) break block30;
                    var9_8 = (NTypeInfo[])var11_10.trim();
                    var12_12 = var0.db.defs;
                    var13_14 = var5_5.defs;
                    var14_16 = var13_14.keySet().iterator();
                    if (true) ** GOTO lbl52
                }
                var13_13 = false;
                var14_15 = 0;
                while (var14_15 < var8_7.length) {
                    if (var9_8[var12_11].equals(var8_7[var14_15])) {
                        var13_13 = true;
                        var10_9.remove(var9_8[var12_11].getTypeSpec().toString());
                        break;
                    }
                    ++var14_15;
                }
                if (!var13_13) {
                    var11_10.add((Object)var9_8[var12_11]);
                }
                ++var12_11;
            }
            do {
                var15_17 /* !! */  = var14_16.next();
                var12_12.remove(var15_17 /* !! */ );
lbl52:
                // 2 sources

            } while (var14_16.hasNext());
            var15_17 /* !! */  = var0.db.fileExts;
            var16_18 = var0.db.typesByFileExt;
            var17_19 = var5_5.typesByFileExt;
            v2 = Builder.class$java$lang$String;
            if (v2 == null) {
                v2 = Builder.class$java$lang$String = Builder.class("[Ljava.lang.String;", false);
            }
            var11_10 = new Array(v2);
            var18_20 = 0;
            while (var18_20 < ((K)var15_17 /* !! */ ).length) {
                var19_22 = false;
                var20_24 = var17_19.keySet().iterator();
                while (var20_24.hasNext()) {
                    if (var15_17 /* !! */ [var18_20].equals(var20_24.next())) {
                        var16_18.remove(var15_17 /* !! */ [var18_20]);
                    }
                    var19_22 = true;
                }
                if (!var19_22) {
                    var11_10.add(var15_17 /* !! */ [var18_20]);
                }
                ++var18_20;
            }
            var15_17 /* !! */  = (String[])var11_10.trim();
            var18_21 = var0.db.ordSchemes;
            var19_23 = var0.db.typesByOrdScheme;
            var20_24 = var5_5.typesByOrdScheme;
            v3 = Builder.class$java$lang$String;
            if (v3 == null) {
                v3 = Builder.class$java$lang$String = Builder.class("[Ljava.lang.String;", false);
            }
            var11_10 = new Array(v3);
            var21_25 = 0;
            while (var21_25 < var18_21.length) {
                var22_27 = false;
                var23_29 = var20_24.keySet().iterator();
                while (var23_29.hasNext()) {
                    if (var18_21[var21_25].equals(var23_29.next())) {
                        var19_23.remove(var18_21[var21_25]);
                    }
                    var22_27 = true;
                }
                if (!var22_27) {
                    var11_10.add((Object)var18_21[var21_25]);
                }
                ++var21_25;
            }
            var18_21 = (String[])var11_10.trim();
            var21_26 = var0.db.lexicons;
            var22_28 = var5_5.lexicons;
            var23_29 = var22_28.keySet().iterator();
            while (var23_29.hasNext()) {
                var21_26.remove(var23_29.next());
            }
            var24_30 = var0.db.adapters;
            var25_31 = var5_5.adapterBuilds;
            v4 = Builder.class$com$tridium$sys$registry$NAdapterInfo;
            if (v4 == null) {
                v4 = Builder.class$com$tridium$sys$registry$NAdapterInfo = Builder.class("[Lcom.tridium.sys.registry.NAdapterInfo;", false);
            }
            var11_10 = new Array(v4);
            var26_32 = 0;
            while (var26_32 < var24_30.length) {
                var27_34 = 0;
                var28_35 = 0;
                while (var26_32 < var25_31.size()) {
                    if (var24_30[var26_32].equals(((AdapterBuild)var25_31.get((int)var28_35)).info)) {
                        var27_34 = 1;
                    }
                    ++var28_35;
                }
                if (var27_34 == 0) {
                    var11_10.add((Object)var24_30[var26_32]);
                }
                ++var26_32;
            }
            var24_30 = (NAdapterInfo[])var11_10.trim();
            var26_33 = var0.db.modules;
            var27_34 = 0;
            while (var27_34 < var26_33.length) {
                if (var26_33[var27_34].getModuleName().equals(var2_2.getModuleName())) {
                    var26_33[var27_34] = var5_5.info;
                }
                ++var27_34;
            }
            var0.db.modules = var26_33;
            var0.db.types = var9_8;
            var0.db.typesBySpec = var10_9;
            var0.db.defs = var12_12;
            var0.db.fileExts = var15_17 /* !! */ ;
            var0.db.typesByFileExt = var16_18;
            var0.db.ordSchemes = var18_21;
            var0.db.typesByOrdScheme = var19_23;
            var0.db.lexicons = var21_26;
            var0.db.adapters = var24_30;
            var2_2.types = NTypeInfo.noTypes;
            Nre.moduleManager.unloadModule(var1_1);
            return;
        }
    }

    static void reloadModule(NRegistry nRegistry, String string) throws Exception {
        NModuleInfo nModuleInfo = (NModuleInfo)nRegistry.db.modulesByName.get(string);
        if (nModuleInfo == null) {
            throw new BajaRuntimeException("Module not loaded");
        }
        if (!nModuleInfo.isReloadableModule) {
            throw new BajaRuntimeException("Cannot reload this module");
        }
        Builder.unloadModule(nRegistry, string);
        Builder.loadModule(nRegistry, string);
    }

    private static final void clean(NRegistry nRegistry) throws Exception {
        FileUtil.delete(nRegistry.dir());
    }

    private static final ModuleBuild[] load() throws Exception {
        if (log.isTraceOn()) {
            log.trace("Builder.read");
        }
        File file = new File(Nre.bajaHome, "modules");
        Object[] objectArray = file.listFiles();
        SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)new Comparator(){

            public final int compare(Object object, Object object2) {
                return ((File)object).getName().compareTo(((File)object2).getName());
            }
        });
        ArrayList<ModuleBuild> arrayList = new ArrayList<ModuleBuild>();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            skipFiles.clear();
            if (((File)object).getName().endsWith(".jar") || ((File)object).getName().endsWith(".sjar")) {
                try {
                    ModuleBuild moduleBuild = Builder.readModule((File)object, false);
                    if (moduleBuild == null) {
                        skipFiles.add(((File)object).getName());
                    } else {
                        arrayList.add(moduleBuild);
                    }
                }
                catch (Throwable throwable) {
                    log.error("Cannot read module " + ((File)object).getName(), throwable);
                }
            }
            ++n;
        }
        return arrayList.toArray(new ModuleBuild[arrayList.size()]);
    }

    private static final ModuleBuild readModule(File file, boolean bl) throws Exception {
        return Builder.readModule(file, bl, false);
    }

    private static final ModuleBuild readModule(File file, boolean bl, boolean bl2) throws Exception {
        JarFile jarFile;
        JarEntry jarEntry;
        if (log.isTraceOn()) {
            log.trace("Builder.read \"" + file.getName() + "\"...");
        }
        if ((jarEntry = (jarFile = new JarFile(file)).getJarEntry("META-INF/module.xml")) == null) {
            jarEntry = jarFile.getJarEntry("meta-inf/module.xml");
        }
        if (jarEntry == null) {
            throw new ModuleException("Module missing META-INF/module.xml: " + file);
        }
        XElem xElem = XParser.make((InputStream)new BufferedInputStream(jarEntry.getInputStream())).parse();
        ModuleBuild moduleBuild = Builder.readManifest(xElem, jarFile, bl, bl2);
        if (moduleBuild == null) {
            jarFile.close();
            return null;
        }
        String string = file.getName();
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - ".jar".length());
        } else if (string.endsWith(".sjar")) {
            string = string.substring(0, string.length() - ".sjar".length());
        }
        if (!string.equals(moduleBuild.info.moduleName)) {
            throw new ModuleException("File name does not match manifest: " + string);
        }
        NModuleInfo nModuleInfo = moduleBuild.info;
        boolean bl3 = false;
        if (jarFile.getJarEntry("module.palette") != null) {
            bl3 = true;
        }
        nModuleInfo.hasPalette = bl3;
        jarFile.close();
        moduleBuild.snapshot.size = file.length();
        moduleBuild.snapshot.timestamp = file.lastModified();
        return moduleBuild;
    }

    private static final ModuleBuild readManifest(XElem xElem, JarFile jarFile, boolean bl, boolean bl2) {
        XElem[] xElemArray;
        XElem xElem2;
        if (!xElem.getb("nre", true) || !xElem.getb("installable", true)) {
            return null;
        }
        ModuleBuild moduleBuild = new ModuleBuild();
        moduleBuild.info.moduleName = xElem.get("name");
        moduleBuild.info.bajaVersion = new Version(xElem.get("bajaVersion"));
        moduleBuild.info.vendor = xElem.get("vendor");
        moduleBuild.info.vendorVersion = new Version(xElem.get("vendorVersion"));
        moduleBuild.info.description = xElem.get("description");
        moduleBuild.info.buildTime = Long.parseLong(xElem.get("buildMillis", "0"));
        moduleBuild.info.moduleContent = xElem.get("archiveInstall", "doc");
        moduleBuild.info.isAutoloadModule = xElem.getb("autoload", true);
        moduleBuild.info.isReloadableModule = xElem.getb("reloadable", false);
        moduleBuild.snapshot.name = moduleBuild.info.moduleName;
        if (moduleBuild.info.isAutoloadModule || bl2 || moduleBuild.info.isReloadableModule) {
            XElem xElem3;
            Object[] objectArray;
            Object object;
            XElem[] xElemArray2;
            xElem2 = xElem.elem("defs");
            if (xElem2 != null) {
                int n = xElem2.contentSize();
                int n2 = 0;
                while (n2 < n) {
                    try {
                        xElemArray2 = xElem2.elem(n2);
                        if (xElemArray2.name().equals("def")) {
                            String string = xElemArray2.get("name");
                            object = xElemArray2.get("value");
                            objectArray = (String[])moduleBuild.defs.get(string);
                            objectArray = objectArray != null ? (String[])ArrayUtil.addOne(objectArray, object) : new String[]{object};
                            moduleBuild.defs.put(string, objectArray);
                        }
                    }
                    catch (Exception exception) {
                        log.error("Error on def in \"" + moduleBuild.info.moduleName + '\"', exception);
                    }
                    ++n2;
                }
            }
            if ((xElemArray = xElem.elem("lexicons")) != null) {
                String string = xElemArray.get("brand", "");
                xElemArray2 = xElemArray.elems("lexicon");
                int n = xElemArray2.length;
                int n3 = 0;
                while (n3 < n) {
                    try {
                        objectArray = xElemArray2[n3];
                        NLexiconInfo nLexiconInfo = new NLexiconInfo((XElem)objectArray, string, moduleBuild.info.moduleName);
                        String string2 = nLexiconInfo.getModuleName();
                        String string3 = nLexiconInfo.getLanguage();
                        String string4 = nLexiconInfo.getContainerModuleName();
                        nLexiconInfo.setLastModified(jarFile.getFile().lastModified());
                        if (string3 != null && string3.length() > 0) {
                            string2 = string2 + '-' + string3;
                        }
                        string2 = string2 + '-' + string4;
                        moduleBuild.lexicons.put(string2, nLexiconInfo);
                    }
                    catch (Exception exception) {
                        log.error("Error on lexicon in \"" + moduleBuild.info.moduleName + '\"', exception);
                    }
                    ++n3;
                }
            }
            if ((xElem3 = xElem.elem("types")) != null) {
                xElemArray2 = xElem3.elems("type");
                moduleBuild.info.types = new NTypeInfo[xElemArray2.length];
                int n = 0;
                while (n < xElemArray2.length) {
                    try {
                        object = Builder.readType(jarFile, moduleBuild, xElemArray2[n]);
                        moduleBuild.typeBuilds.add(object);
                        moduleBuild.info.types[n] = ((TypeBuild)object).info;
                    }
                    catch (Throwable throwable) {
                        log.error("Error on type \"" + moduleBuild.info.moduleName + ':' + xElemArray2[n].get("name", "???") + '\"', throwable);
                    }
                    ++n;
                }
            }
        }
        if (bl) {
            xElem2 = xElem.elem("dependencies");
            if (xElem2 == null) {
                moduleBuild.info.depends = new NDependencyInfo[0];
            } else {
                xElemArray = xElem2.elems("dependency");
                moduleBuild.info.depends = new NDependencyInfo[xElemArray.length];
                int n = 0;
                while (n < xElemArray.length) {
                    moduleBuild.info.depends[n] = new NDependencyInfo(xElemArray[n]);
                    ((NDependencyInfo)moduleBuild.info.depends[n]).module = moduleBuild.info;
                    ++n;
                }
            }
        }
        return moduleBuild;
    }

    private static final TypeBuild readType(JarFile jarFile, ModuleBuild moduleBuild, XElem xElem) throws Exception {
        Object object;
        XElem xElem2;
        XElem xElem3;
        XElem xElem4;
        String string = xElem.get("name");
        TypeBuild typeBuild = new TypeBuild(moduleBuild, BTypeSpec.make(moduleBuild.info.moduleName, string));
        String string2 = xElem.get("ordScheme", null);
        if (string2 != null) {
            typeBuild.ordScheme = string2 = TextUtil.toLowerCase((String)string2);
            if (moduleBuild.typesByOrdScheme.get(string2) != null) {
                log.warning("Multiple types registered for ordScheme \"" + string2 + '\"');
            } else {
                moduleBuild.typesByOrdScheme.put(string2, typeBuild.info);
            }
        }
        if ((xElem4 = xElem.elem("file")) != null) {
            Builder.readFile(typeBuild, xElem4);
        }
        if ((xElem3 = xElem.elem("agent")) != null) {
            Builder.readAgent(typeBuild, xElem3);
        }
        if ((xElem2 = xElem.elem("adapter")) != null) {
            Builder.readAdapter(typeBuild, xElem2);
        }
        typeBuild.info.className = xElem.get("class");
        if (jarFile.getFile().getName().endsWith(".jar")) {
            object = jarFile.getJarEntry(typeBuild.info.className.replace('.', '/') + ".class");
            if (object == null) {
                log.error("Missing class for \"" + typeBuild + '\"');
                return typeBuild;
            }
            ClassScanner classScanner = new ClassScanner();
            classScanner.scan(((JarEntry)object).getInputStream());
            typeBuild.info.modifiers = classScanner.modifiers;
            typeBuild.superClass = classScanner.superClass;
            typeBuild.interfaceClasses = classScanner.interfaces;
            if (!classScanner.hasLoadType) {
                log.error("Missing Sys.loadType() " + typeBuild);
            }
        } else if (jarFile.getFile().getName().endsWith(".sjar")) {
            Class clazz = class$javax$baja$sys$BComponent;
            if (clazz == null) {
                clazz = class$javax$baja$sys$BComponent = Builder.class("[Ljavax.baja.sys.BComponent;", false);
            }
            typeBuild.superClass = xElem.get("extends", clazz.getName());
            Builder.readInterfaces(typeBuild, xElem);
            typeBuild.info.modifiers = 1;
            if (xElem.get("abstract", "false").equalsIgnoreCase("true")) {
                typeBuild.info.modifiers |= 0x400;
            }
            if (xElem.get("final", "false").equalsIgnoreCase("true")) {
                typeBuild.info.modifiers |= 0x10;
            }
        } else {
            throw new IllegalStateException();
        }
        object = (NTypeInfo)moduleBuild.typesBySpec.get(typeBuild.toString());
        if (object != null) {
            log.error("Duplicate typespec " + object + " & " + typeBuild);
        } else {
            moduleBuild.typesBySpec.put(typeBuild.toString(), typeBuild.info);
        }
        object = (NTypeInfo)moduleBuild.typesByClass.get(typeBuild.info.className);
        if (object != null) {
            log.error("Duplicate classes " + object + " & " + typeBuild);
        } else {
            moduleBuild.typesByClass.put(typeBuild.info.className, typeBuild.info);
        }
        return typeBuild;
    }

    private static final void readFile(TypeBuild typeBuild, XElem xElem) {
        try {
            int n = 0;
            while (n < xElem.contentSize()) {
                XElem xElem2 = xElem.elem(n);
                if (xElem2.name().equals("ext")) {
                    String string = TextUtil.toLowerCase((String)xElem2.get("name"));
                    NTypeInfo nTypeInfo = (NTypeInfo)typeBuild.moduleBuild.typesByFileExt.get(string);
                    if (nTypeInfo != null) {
                        log.warning("Duplicate files for ext \"" + string + "\": " + nTypeInfo + " & " + typeBuild);
                    } else {
                        typeBuild.moduleBuild.typesByFileExt.put(string, typeBuild.info);
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            log.error("Cannot map type as file \"" + typeBuild + '\"', throwable);
        }
    }

    private static final void readAgent(TypeBuild typeBuild, XElem xElem) {
        try {
            typeBuild.info.agentInfo = new NAgentInfo(typeBuild.info);
            String string = xElem.get("requiredPermissions", null);
            typeBuild.info.agentInfo.permissions = string != null ? BPermissions.make(string) : BPermissions.adminWrite;
            typeBuild.info.agentInfo.appName = xElem.get("app", null);
            String string2 = xElem.get("default", null);
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                typeBuild.info.agentInfo.defaultPreferrence = 1;
            } else if (string2 != null && string2.equalsIgnoreCase("false")) {
                typeBuild.info.agentInfo.defaultPreferrence = 2;
            }
            int n = 0;
            while (n < xElem.contentSize()) {
                XElem xElem2 = xElem.elem(n);
                if (xElem2.name().equals("on")) {
                    typeBuild.addAgentOn(xElem2.get("type"));
                }
                ++n;
            }
        }
        catch (XException xException) {
            log.error("Cannot map type as agent \"" + typeBuild + "\": " + (Object)((Object)xException));
            typeBuild.info.agentInfo = null;
            typeBuild.agentsOn = null;
        }
        catch (Throwable throwable) {
            log.error("Cannot map type as agent \"" + typeBuild + '\"', throwable);
            typeBuild.info.agentInfo = null;
            typeBuild.agentsOn = null;
        }
    }

    private static final void readAdapter(TypeBuild typeBuild, XElem xElem) {
        try {
            AdapterBuild adapterBuild = new AdapterBuild(typeBuild);
            adapterBuild.fromSpec = xElem.get("from");
            adapterBuild.toSpec = xElem.get("to");
            typeBuild.moduleBuild.adapterBuilds.add(adapterBuild);
        }
        catch (XException xException) {
            log.error("Cannot map type as adapter \"" + typeBuild + "\": " + (Object)((Object)xException));
        }
        catch (Throwable throwable) {
            log.error("Cannot map type as adapter \"" + typeBuild + '\"', throwable);
        }
    }

    private static final void readInterfaces(TypeBuild typeBuild, XElem xElem) {
        XElem xElem2 = xElem.elem("interfaces");
        if (xElem2 != null) {
            XElem[] xElemArray = xElem2.elems("interface");
            String[] stringArray = new String[xElemArray.length];
            int n = 0;
            while (n < xElemArray.length) {
                stringArray[n] = xElemArray[n].get("class");
                ++n;
            }
            typeBuild.interfaceClasses = stringArray;
        } else {
            typeBuild.interfaceClasses = new String[0];
        }
    }

    private final void init(ModuleBuild[] moduleBuildArray, NRegistry nRegistry) {
        this.typesByFileExt.putAll(nRegistry.db.typesByFileExt);
        this.typesByOrdScheme.putAll(nRegistry.db.typesByOrdScheme);
        this.typesBySpecString.putAll(nRegistry.db.typesBySpec);
        this.defs.putAll(nRegistry.db.defs);
        this.lexicons.putAll(nRegistry.db.lexicons);
        int n = 0;
        while (n < nRegistry.db.types.length) {
            this.typesByClass.put(nRegistry.db.types[n].className, nRegistry.db.types[n]);
            ++n;
        }
        this.init(moduleBuildArray, nRegistry.db.modules.length, nRegistry.db.types.length);
    }

    private final void init(ModuleBuild[] moduleBuildArray, int n, int n2) {
        this.moduleBuilds = moduleBuildArray;
        int n3 = 0;
        while (n3 < moduleBuildArray.length) {
            Object object;
            Object object2;
            Object object3;
            ModuleBuild moduleBuild = moduleBuildArray[n3];
            moduleBuild.info.id = n3 + n;
            int n4 = 0;
            while (n4 < moduleBuild.info.types.length) {
                object3 = moduleBuild.info.types[n4];
                object2 = (TypeBuild)moduleBuild.typeBuilds.get(n4);
                ((NTypeInfo)object3).id = this.typeBuilds.size();
                this.typeBuilds.add(object2);
                this.typesBySpecString.put(((NTypeInfo)object3).typeSpec.toString(), object2.info);
                this.typeBuildsBySpecString.put(((NTypeInfo)object3).typeSpec.toString(), object2);
                ++n4;
            }
            Iterator iterator = moduleBuild.typesByOrdScheme.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                if (this.typesByOrdScheme.containsKey(object3)) {
                    log.warning("Multiple types registered for ordScheme \"" + (String)object3 + '\"');
                    continue;
                }
                this.typesByOrdScheme.put(object3, moduleBuild.typesByOrdScheme.get(object3));
            }
            iterator = moduleBuild.typesByFileExt.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = (NTypeInfo)this.typesByFileExt.get(object3);
                object = (Object[])moduleBuild.typesByFileExt.get(object3);
                if (object2 != null) {
                    log.warning("Duplicate files for ext \"" + (String)object3 + "\": " + object2 + " & " + object);
                    continue;
                }
                this.typesByFileExt.put(object3, object);
            }
            iterator = moduleBuild.typesByClass.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = (NTypeInfo)moduleBuild.typesByClass.get(object3);
                object = (NTypeInfo)this.typesByClass.get(object3);
                if (object != null) {
                    log.error("Duplicate classes " + object + " & " + object2);
                    continue;
                }
                this.typesByClass.put(object3, object2);
            }
            iterator = moduleBuild.defs.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = (String[])moduleBuild.defs.get(object3);
                object = (String[])this.defs.get(object3);
                if (object == null) {
                    this.defs.put(object3, object2);
                    continue;
                }
                this.defs.put(object3, (String[])ArrayUtil.add(object, object2));
            }
            iterator = moduleBuild.lexicons.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = (LexiconInfo)moduleBuild.lexicons.get(object3);
                if (object2 == null) continue;
                this.lexicons.put(object3, object2);
            }
            this.adapterBuilds.addAll(moduleBuild.adapterBuilds);
            ++n3;
        }
    }

    private final void resolveSuperAndInterfaces() {
        int n = this.typeBuilds.size();
        int n2 = 0;
        while (n2 < n) {
            TypeBuild typeBuild = (TypeBuild)this.typeBuilds.get(n2);
            try {
                this.resolveSuperAndInterfaces(typeBuild);
            }
            catch (Throwable throwable) {
                log.error("Cannot resolve type \"" + typeBuild + '\"', throwable);
            }
            ++n2;
        }
    }

    private final void resolveSuperAndInterfaces(TypeBuild typeBuild) throws Exception {
        boolean bl = typeBuild.info.isInterface();
        if (!bl && typeBuild.superClass != null) {
            typeBuild.info.superType = (NTypeInfo)this.typesByClass.get(typeBuild.superClass);
            if (typeBuild.info.superType == null && !typeBuild.info.className.equals("javax.baja.sys.BObject")) {
                log.error("Missing super type \"" + typeBuild.superClass + "\" for \"" + typeBuild + '\"');
            }
        }
        ArrayList<NTypeInfo> arrayList = null;
        if (typeBuild.interfaceClasses != null) {
            int n = 0;
            while (n < typeBuild.interfaceClasses.length) {
                String string = typeBuild.interfaceClasses[n];
                NTypeInfo nTypeInfo = (NTypeInfo)this.typesByClass.get(string);
                if (nTypeInfo == null) {
                    int n2 = string.lastIndexOf(36);
                    if (n2 < 0) {
                        n2 = string.lastIndexOf(46);
                    }
                    if (n2 > 0 && n2 < string.length() - 3 && string.charAt(n2 + 1) == 'B' && string.charAt(n2 + 2) == 'I') {
                        log.error("Missing interface type \"" + string + "\" for \"" + typeBuild + '\"');
                    }
                } else {
                    if (arrayList == null) {
                        arrayList = new ArrayList<NTypeInfo>();
                    }
                    arrayList.add(nTypeInfo);
                }
                ++n;
            }
        }
        if (arrayList != null) {
            typeBuild.info.interfaces = arrayList.toArray(new NTypeInfo[arrayList.size()]);
        }
    }

    private final void resolveIsTypes() {
        int n = this.typeBuilds.size();
        int n2 = 0;
        while (n2 < n) {
            TypeBuild typeBuild = (TypeBuild)this.typeBuilds.get(n2);
            try {
                this.resolveIsTypes(typeBuild);
            }
            catch (Throwable throwable) {
                log.error("Cannot resolve type \"" + typeBuild + '\"', throwable);
            }
            ++n2;
        }
    }

    private final void resolveIsTypes(TypeBuild typeBuild) throws Exception {
        IsMap isMap = new IsMap();
        NTypeInfo nTypeInfo = typeBuild.info;
        while (nTypeInfo != null) {
            isMap.add(nTypeInfo);
            nTypeInfo = nTypeInfo.superType;
        }
        nTypeInfo = typeBuild.info;
        while (nTypeInfo != null) {
            this.mapInterfaces(isMap, nTypeInfo);
            nTypeInfo = nTypeInfo.superType;
        }
        typeBuild.info.is = isMap.toArray();
    }

    private final void mapInterfaces(IsMap isMap, NTypeInfo nTypeInfo) {
        if (nTypeInfo.isInterface()) {
            isMap.add(nTypeInfo);
        }
        int n = 0;
        while (n < nTypeInfo.interfaces.length) {
            this.mapInterfaces(isMap, nTypeInfo.interfaces[n]);
            ++n;
        }
    }

    private final void resolveAdapters() {
        int n = this.adapterBuilds.size();
        ArrayList<AdapterBuild> arrayList = new ArrayList<AdapterBuild>(n);
        int n2 = 0;
        while (n2 < n) {
            AdapterBuild adapterBuild = (AdapterBuild)this.adapterBuilds.get(n2);
            try {
                if (this.resolveAdapter(adapterBuild)) {
                    arrayList.add(adapterBuild);
                }
            }
            catch (Throwable throwable) {
                log.error("Cannot resolver adapter \"" + adapterBuild.info.type + '\"', throwable);
            }
            ++n2;
        }
        this.adapterBuilds = arrayList;
    }

    private final boolean resolveAdapter(AdapterBuild adapterBuild) {
        NTypeInfo nTypeInfo = (NTypeInfo)this.typesBySpecString.get(adapterBuild.fromSpec);
        if (nTypeInfo == null) {
            log.error("Cannot find from type \"" + adapterBuild.fromSpec + "\" for \"" + adapterBuild.info.type + '\"');
            return false;
        }
        adapterBuild.info.from = nTypeInfo;
        nTypeInfo = (NTypeInfo)this.typesBySpecString.get(adapterBuild.toSpec);
        if (nTypeInfo == null) {
            log.error("Cannot find to type \"" + adapterBuild.toSpec + "\" for \"" + adapterBuild.info.type + '\"');
            return false;
        }
        adapterBuild.info.to = nTypeInfo;
        return true;
    }

    private final void agentize() {
        this.agentsToTarget();
        this.agentsToArray();
    }

    private final void agentsToTarget() {
        int n = this.typeBuilds.size();
        int n2 = 0;
        while (n2 < n) {
            TypeBuild typeBuild = (TypeBuild)this.typeBuilds.get(n2);
            try {
                this.agentToTarget(typeBuild);
            }
            catch (Throwable throwable) {
                log.error("Cannot agentize \"" + typeBuild + '\"', throwable);
            }
            ++n2;
        }
    }

    private final void agentToTarget(TypeBuild typeBuild) throws Exception {
        ArrayList arrayList = typeBuild.agentsOn;
        if (arrayList == null) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            String string = (String)arrayList.get(n);
            NTypeInfo nTypeInfo = (NTypeInfo)this.typesBySpecString.get(string);
            if (nTypeInfo == null) {
                log.error("Cannot find agent target type \"" + string + "\" for \"" + typeBuild + '\"');
            } else {
                TypeBuild typeBuild2 = (TypeBuild)this.typeBuildsBySpecString.get(string);
                if (typeBuild2 == null) {
                    typeBuild.moduleBuild.addAgent(typeBuild.info, nTypeInfo);
                } else {
                    typeBuild2.addAgent(typeBuild.info);
                }
            }
            ++n;
        }
    }

    private final void agentsToArray() {
        int n = this.typeBuilds.size();
        int n2 = 0;
        while (n2 < n) {
            TypeBuild typeBuild = (TypeBuild)this.typeBuilds.get(n2);
            try {
                if (typeBuild.agentsList != null && typeBuild.agentsList.size() > 0) {
                    typeBuild.info.agents = typeBuild.agentsList.toArray(new NTypeInfo[typeBuild.agentsList.size()]);
                }
            }
            catch (Throwable throwable) {
                log.error("Cannot map agent to array \"" + typeBuild + '\"', throwable);
            }
            ++n2;
        }
    }

    private final void write(NRegistry nRegistry) throws Exception {
        nRegistry.dir().mkdirs();
        this.writeChecksum(nRegistry);
        this.writeDatabase(nRegistry);
    }

    private final void writeChecksum(NRegistry nRegistry) throws Exception {
        int n = this.moduleBuilds.length;
        HashMap<String, RegistryChecksum.ModuleSnapshot> hashMap = new HashMap<String, RegistryChecksum.ModuleSnapshot>(n * 3);
        int n2 = 0;
        while (n2 < n) {
            hashMap.put(this.moduleBuilds[n2].snapshot.name, this.moduleBuilds[n2].snapshot);
            ++n2;
        }
        RegistryChecksum registryChecksum = new RegistryChecksum();
        registryChecksum.modules = hashMap;
        registryChecksum.write(nRegistry.chkFile());
    }

    private final void writeDatabase(NRegistry nRegistry) throws Exception {
        RegistryDatabase registryDatabase = new RegistryDatabase();
        registryDatabase.modules = this.sortModules();
        registryDatabase.modulesByName = new HashMap(registryDatabase.modules.length * 2);
        int n = 0;
        while (n < registryDatabase.modules.length) {
            registryDatabase.modulesByName.put(registryDatabase.modules[n].moduleName, registryDatabase.modules[n]);
            ++n;
        }
        registryDatabase.types = new NTypeInfo[this.typeBuilds.size()];
        n = 0;
        while (n < this.typeBuilds.size()) {
            registryDatabase.types[n] = ((TypeBuild)this.typeBuilds.get((int)n)).info;
            ++n;
        }
        registryDatabase.typesBySpec = this.typesBySpecString;
        registryDatabase.defs = this.defs;
        registryDatabase.fileExts = this.sortFileExts();
        registryDatabase.typesByFileExt = this.typesByFileExt;
        registryDatabase.ordSchemes = this.sortOrdSchemes();
        registryDatabase.typesByOrdScheme = this.typesByOrdScheme;
        registryDatabase.lexicons = this.lexicons;
        registryDatabase.adapters = new NAdapterInfo[this.adapterBuilds.size()];
        n = 0;
        while (n < this.adapterBuilds.size()) {
            registryDatabase.adapters[n] = ((AdapterBuild)this.adapterBuilds.get((int)n)).info;
            ++n;
        }
        registryDatabase.write(nRegistry.dbFile());
    }

    private final NModuleInfo[] sortModules() {
        Object[] objectArray = new String[this.moduleBuilds.length];
        Object[] objectArray2 = new NModuleInfo[this.moduleBuilds.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.moduleBuilds[n].info.moduleName;
            objectArray2[n] = this.moduleBuilds[n].info;
            ++n;
        }
        SortUtil.sort((Object[])objectArray, (Object[])objectArray2);
        return objectArray2;
    }

    private final String[] sortFileExts() {
        Object[] objectArray = this.typesByFileExt.keySet().toArray(new String[this.typesByFileExt.size()]);
        SortUtil.sort((Object[])objectArray);
        return objectArray;
    }

    private final String[] sortOrdSchemes() {
        Object[] objectArray = this.typesByOrdScheme.keySet().toArray(new String[this.typesByOrdScheme.size()]);
        SortUtil.sort((Object[])objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.typeBuilds = new ArrayList();
        this.adapterBuilds = new ArrayList();
        this.typeBuildsBySpecString = new HashMap();
        this.typesByFileExt = new HashMap();
        this.typesByOrdScheme = new HashMap();
        this.typesBySpecString = new HashMap();
        this.typesByClass = new HashMap();
        this.defs = new HashMap();
        this.lexicons = new HashMap();
    }

    private Builder() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class ModuleBuild {
        NModuleInfo info;
        RegistryChecksum.ModuleSnapshot snapshot;
        HashMap defs;
        HashMap lexicons;
        ArrayList typeBuilds;
        HashMap typesByOrdScheme;
        HashMap typesBySpec;
        HashMap typesByClass;
        HashMap typesByFileExt;
        ArrayList adapterBuilds;
        HashMap agentTypesByTargetSpec;

        public void addAgent(NTypeInfo nTypeInfo, NTypeInfo nTypeInfo2) {
            Object[] objectArray = (NTypeInfo[])this.agentTypesByTargetSpec.get(nTypeInfo2.typeSpec.toString());
            objectArray = objectArray == null ? new NTypeInfo[]{nTypeInfo} : (NTypeInfo[])ArrayUtil.addOne(objectArray, nTypeInfo);
            this.agentTypesByTargetSpec.put(nTypeInfo2.typeSpec.toString(), objectArray);
        }

        public String toString() {
            return this.info.toString();
        }

        private final /* synthetic */ void this() {
            this.defs = new HashMap();
            this.lexicons = new HashMap();
            this.typeBuilds = new ArrayList();
            this.typesByOrdScheme = new HashMap();
            this.typesBySpec = new HashMap();
            this.typesByClass = new HashMap();
            this.typesByFileExt = new HashMap();
            this.adapterBuilds = new ArrayList();
            this.agentTypesByTargetSpec = new HashMap();
        }

        ModuleBuild() {
            this.this();
            this.info = new NModuleInfo(-1);
            this.snapshot = new RegistryChecksum.ModuleSnapshot();
        }
    }

    static class AdapterBuild {
        TypeBuild typeBuild;
        NAdapterInfo info;
        String fromSpec;
        String toSpec;

        public String toString() {
            return this.info.toString();
        }

        AdapterBuild(TypeBuild typeBuild) {
            this.typeBuild = typeBuild;
            this.info = new NAdapterInfo();
            this.info.type = typeBuild.info;
        }
    }

    static class TypeBuild {
        ModuleBuild moduleBuild;
        NTypeInfo info;
        String superClass;
        String[] interfaceClasses;
        String ordScheme;
        ArrayList agentsOn;
        ArrayList agentsList;

        public void addAgentOn(String string) {
            if (this.agentsOn == null) {
                this.agentsOn = new ArrayList();
            }
            this.agentsOn.add(string);
        }

        public void addAgent(NTypeInfo nTypeInfo) {
            if (this.agentsList == null) {
                this.agentsList = new ArrayList();
            }
            this.agentsList.add(nTypeInfo);
        }

        public String toString() {
            return this.info.toString();
        }

        TypeBuild(ModuleBuild moduleBuild, BTypeSpec bTypeSpec) {
            this.moduleBuild = moduleBuild;
            this.info = new NTypeInfo(-1, bTypeSpec);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class IsMap {
        private ArrayList list;
        private IntHashMap byId;

        void add(NTypeInfo nTypeInfo) {
            if (this.byId.get(nTypeInfo.id) != null) {
                return;
            }
            this.list.add(nTypeInfo);
            this.byId.put(nTypeInfo.id, (Object)nTypeInfo);
        }

        NTypeInfo[] toArray() {
            return this.list.toArray(new NTypeInfo[this.list.size()]);
        }

        private final /* synthetic */ void this() {
            this.list = new ArrayList();
            this.byId = new IntHashMap();
        }

        IsMap() {
            this.this();
        }
    }
}

