/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.asm.Buffer;
import com.tridium.sys.Nre;
import com.tridium.sys.module.Dependency;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.NModule;
import com.tridium.sys.module.SyntheticModuleClassLoader;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.schema.SyntheticCompiler;
import com.tridium.util.ArrayUtil;
import com.tridium.util.jar.JarEntry;
import com.tridium.util.jar.JarFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import javax.baja.log.Log;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ModuleManager {
    public static ModuleManager instance;
    public static final Log log;
    private NModule baja;
    private NModule[] moduleArray;
    private Hashtable moduleTable;
    private ArrayList resolving;
    private boolean postInit;

    public synchronized NModule[] getModules() {
        NModule[] nModuleArray = new NModule[this.moduleArray.length];
        System.arraycopy(this.moduleArray, 0, nModuleArray, 0, nModuleArray.length);
        return nModuleArray;
    }

    public NModule getModuleForClass(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)classLoader).module;
        }
        if (clazz.isPrimitive()) {
            return null;
        }
        String string = clazz.getName();
        if (clazz.isArray()) {
            int n = string.indexOf(76);
            string = string.substring(n + 1);
        }
        if (string.startsWith("javax.baja.") || string.startsWith("com.tridium.asm.") || string.startsWith("com.tridium.collection.") || string.startsWith("com.tridium.data.") || string.startsWith("com.tridium.sys.") || string.startsWith("com.tridium.timezone.") || string.startsWith("com.tridium.util.")) {
            return this.baja;
        }
        return null;
    }

    public synchronized NModule loadModule(String string) throws ModuleNotFoundException, ModuleException {
        NModule nModule = (NModule)this.moduleTable.get(string);
        if (nModule != null) {
            return nModule;
        }
        try {
            if (Nre.bootEnv.isRemote()) {
                Nre.bootEnv.findModule(string);
            }
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Missing module: " + string, exception);
        }
        return new PrivilegedLoader().load(string);
    }

    public synchronized void unloadModule(String string) throws ModuleException {
        NModule nModule = (NModule)this.moduleTable.get(string);
        if (nModule == null) {
            return;
        }
        try {
            nModule.jarFile.close();
        }
        catch (IOException iOException) {
            throw new ModuleException("Cannot close " + nModule.jarFile, iOException);
        }
        this.moduleArray = (NModule[])ArrayUtil.removeOne((Object[])this.moduleArray, nModule);
        this.moduleTable.remove(nModule.name);
    }

    NModule doLoad(String string) throws ModuleException {
        NModule nModule = this.find(string);
        if (!nModule.name.equals(string)) {
            throw new ModuleException("Invalid case \"" + string + "\" != \"" + nModule.name + '\"');
        }
        this.resolve(nModule);
        if (!nModule.isSystemJar) {
            nModule.classLoader = !nModule.isSynthetic() ? new ModuleClassLoader(nModule) : new SyntheticModuleClassLoader(nModule);
        }
        this.add(nModule);
        return nModule;
    }

    private final NModule loadSystemModule(String string) {
        Object object;
        File file = null;
        try {
            file = Nre.bootEnv.findModule(string);
        }
        catch (Exception exception) {
            throw new BajaRuntimeException("Missing system module: " + string, exception);
        }
        if (file == null || !file.exists()) {
            object = File.separator;
            String string2 = Nre.bajaHome + (String)object + "lib" + (String)object + string + ".jar";
            file = new File(string2);
        }
        if (!file.exists()) {
            throw new IllegalStateException("Missing system module: " + file);
        }
        try {
            object = this.makeModule(file);
            ((NModule)object).isSystemJar = true;
            this.add((NModule)object);
            return object;
        }
        catch (Exception exception) {
            log.error("Cannot load system jar file: " + file, exception);
            return null;
        }
    }

    private final NModule find(String string) throws ModuleException {
        File file;
        String[] stringArray = Nre.registryManager.getInvalidModules();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (string.equals(stringArray[n2])) {
                    throw new ModuleException("Unsupported " + string + " module");
                }
                ++n2;
            }
        }
        try {
            file = Nre.bootEnv.findModule(string);
        }
        catch (Exception exception) {
            throw new ModuleNotFoundException(string, exception);
        }
        if (file == null || !file.exists()) {
            throw new ModuleNotFoundException(string);
        }
        return this.makeModule(file);
    }

    public NModule makeModule(File file) throws ModuleException {
        NModule nModule;
        try {
            nModule = new NModule();
            nModule.jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            throw new ModuleException("Cannot open jar: " + file, iOException);
        }
        JarFile jarFile = nModule.jarFile;
        JarEntry jarEntry = jarFile.getJarEntry("META-INF/module.xml");
        if (jarEntry == null) {
            jarEntry = jarFile.getJarEntry("meta-inf/module.xml");
        }
        if (jarEntry == null) {
            throw new ModuleException("Module missing META-INF/module.xml: " + file);
        }
        try {
            nModule.readXml(XParser.make((InputStream)new BufferedInputStream(jarEntry.getInputStream())).parse());
        }
        catch (Exception exception) {
            log.error("Cannot parse XML: " + file, exception);
            throw new ModuleException("Cannot parse XML: " + file, exception);
        }
        if (this.postInit) {
            nModule.init();
        }
        return nModule;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void resolve(NModule nModule) throws ModuleException {
        NModule nModule2;
        if (nModule.depends == null) {
            return;
        }
        int n = 0;
        while (n < this.resolving.size()) {
            nModule2 = (NModule)this.resolving.get(n);
            if (nModule2.name.equals(nModule.name)) {
                throw new ModuleException("Circular dependency: " + nModule);
            }
            ++n;
        }
        this.resolving.add(nModule);
        try {
            int n2 = 0;
            while (n2 < nModule.depends.length) {
                Dependency dependency = nModule.depends[n2];
                if (dependency != null) {
                    log.trace("Resolve: " + nModule + " -> " + dependency);
                    try {
                        dependency.resolution = this.loadModule(dependency.name);
                        dependency.resolution.checkBajaVersion(dependency.bajaVersion);
                        dependency.resolution.checkVendor(dependency.vendor, dependency.vendorVersion);
                    }
                    catch (Exception exception) {
                        throw new ModuleException("Cannot resolve dependency " + dependency + " for " + nModule, exception);
                    }
                }
                ++n2;
            }
            nModule2 = null;
            this.resolving.remove(nModule);
            return;
        }
        catch (Throwable throwable) {
            nModule2 = null;
            this.resolving.remove(nModule);
            throw throwable;
        }
    }

    public NModule synthesizeModule(NModuleInfo nModuleInfo) {
        NModule nModule = new NModule();
        nModule.name = nModuleInfo.getModuleName();
        nModule.bajaVersion = nModuleInfo.getBajaVersion();
        nModule.vendorVersion = nModuleInfo.getVendorVersion();
        nModule.description = nModuleInfo.getDescription();
        nModule.vendor = nModuleInfo.getVendor();
        nModule.preferredSymbol = nModuleInfo.getModuleName();
        nModule.isSystemJar = false;
        nModule.depends = new Dependency[0];
        nModule.typeList = new String[0];
        nModule.types = new HashMap();
        nModule.jarFile = null;
        nModule.classLoader = new ModuleClassLoader(nModule);
        if (this.postInit) {
            nModule.init();
        }
        this.add(nModule);
        return nModule;
    }

    public void synthesizeType(BTypeSpec bTypeSpec, String string, TypeInfo typeInfo, TypeInfo[] typeInfoArray, boolean bl, boolean bl2) {
        NModule nModule = Nre.moduleManager.loadModule(bTypeSpec.getModuleName());
        Buffer buffer = SyntheticCompiler.compile(bTypeSpec, typeInfo, typeInfoArray, bl, bl2, true);
        nModule.typeList = (String[])ArrayUtil.addOne(nModule.typeList, bTypeSpec.getTypeName());
        nModule.types.put(bTypeSpec.getTypeName(), string);
        try {
            nModule.getClassLoader().loadAutoClass(string, buffer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BajaRuntimeException(classNotFoundException);
        }
    }

    private final synchronized void add(NModule nModule) {
        log.trace("Loaded: " + nModule);
        NModule[] nModuleArray = new NModule[this.moduleArray.length + 1];
        System.arraycopy(this.moduleArray, 0, nModuleArray, 0, this.moduleArray.length);
        nModuleArray[this.moduleArray.length] = nModule;
        this.moduleArray = nModuleArray;
        this.moduleTable.put(nModule.name, nModule);
    }

    public void postInit() {
        Nre.spySysManagers.add("moduleManager", new Page());
        this.postInit = true;
        NModule[] nModuleArray = this.getModules();
        int n = 0;
        while (n < nModuleArray.length) {
            nModuleArray[n].init();
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.moduleArray = new NModule[0];
        this.moduleTable = new Hashtable();
        this.resolving = new ArrayList();
        this.postInit = false;
    }

    public ModuleManager() {
        this.this();
        instance = this;
        this.baja = this.loadSystemModule("baja");
    }

    static {
        log = Log.getLog("sys.module");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PrivilegedLoader
    implements PrivilegedExceptionAction {
        String name;

        NModule load(String string) throws ModuleException {
            this.name = string;
            try {
                return (NModule)AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ModuleException) {
                    throw (ModuleException)exception;
                }
                throw new BajaRuntimeException(exception);
            }
        }

        public Object run() throws Exception {
            return ModuleManager.this.doLoad(this.name);
        }

        PrivilegedLoader() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Page
    extends SpyDir {
        public Spy find(String string) {
            return new ModulePage(ModuleManager.this.loadModule(string));
        }

        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = ModuleManager.this.getModules();
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)new Comparator(){

                public final int compare(Object object, Object object2) {
                    if (!(object instanceof NModule) || !(object2 instanceof NModule)) {
                        return 0;
                    }
                    return ((NModule)object).getModuleName().compareTo(((NModule)object2).getModuleName());
                }
            });
            spyWriter.startTable(true);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String string = ((NModule)object).getModuleName();
                spyWriter.tr("<a href='" + string + "'>" + string + "</a>", ((NModule)object).getBajaVersion(), ((NModule)object).getVendor(), ((NModule)object).getVendorVersion(), ((NModule)object).getDescription());
                ++n;
            }
            spyWriter.endTable();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ModulePage
    extends Spy {
        NModule m;

        public void write(SpyWriter spyWriter) throws Exception {
            this.m.bmodule().spy(spyWriter);
        }

        ModulePage(NModule nModule) {
            this.m = nModule;
        }
    }
}

