/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.metrics;

import com.tridium.sys.metrics.Group;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.sys.BajaRuntimeException;

class SubGroup
extends Group {
    static final String PREFIX = "driverCapacity";
    String[] modules;

    private static final String[] extractModules(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    boolean isGlobal() {
        return false;
    }

    SubGroup(Feature feature) {
        super(feature.getFeatureName());
        try {
            feature.check();
            this.networks.limit = SubGroup.parseLimit(feature, "network.limit");
            this.devices.limit = SubGroup.parseLimit(feature, "device.limit");
            this.points.limit = SubGroup.parseLimit(feature, "point.limit");
            String string = feature.get("modules");
            if (string == null) {
                throw new BajaRuntimeException("Feature '" + feature.getFeatureName() + "' does not define the key 'modules'.");
            }
            this.modules = SubGroup.extractModules(string);
        }
        catch (FeatureNotLicensedException featureNotLicensedException) {
            featureNotLicensedException.printStackTrace();
        }
    }
}

