/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VendorLicense {
    private String source;
    private XElem xml;
    private Array features;
    private String signature;
    private boolean modified;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$Feature;

    public static VendorLicense make(BIFile bIFile) throws Exception {
        VendorLicense vendorLicense = new VendorLicense();
        vendorLicense.load(bIFile);
        return vendorLicense;
    }

    public static VendorLicense make(String string, InputStream inputStream) throws Exception {
        VendorLicense vendorLicense = new VendorLicense();
        vendorLicense.load(string, inputStream);
        return vendorLicense;
    }

    public static VendorLicense make(String string, InputStream inputStream, boolean bl) throws Exception {
        VendorLicense vendorLicense = new VendorLicense();
        vendorLicense.load(string, inputStream, bl);
        return vendorLicense;
    }

    public static VendorLicense make(String string, XElem xElem) throws Exception {
        VendorLicense vendorLicense = new VendorLicense();
        vendorLicense.load(string, xElem);
        return vendorLicense;
    }

    public String getSource() {
        return this.source;
    }

    public String getHostId() {
        return this.xml.get("hostId");
    }

    public void setHostId(String string) {
        this.modify();
        this.xml.setAttr("hostId", string);
    }

    public String getVendor() {
        return this.xml.get("vendor");
    }

    public void setVendor(String string) {
        this.modify();
        this.xml.setAttr("vendor", string);
    }

    public boolean isExpired() {
        boolean bl = false;
        if (Clock.millis() > this.getExpiration()) {
            bl = true;
        }
        return bl;
    }

    public long getExpiration() {
        return LicenseUtil.parseDate(this.xml.get("expiration"));
    }

    public void setExpiration(long l) {
        this.modify();
        this.xml.setAttr("expiration", LicenseUtil.formatDate(l));
    }

    public long getGenerated() {
        return LicenseUtil.parseDate(this.xml.get("generated"));
    }

    public Version getVersion() {
        return new Version(this.xml.get("version"));
    }

    public void setVersion(Version version) {
        this.modify();
        this.xml.setAttr("version", version.toString());
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String string) {
        this.modify();
        this.signature = string;
    }

    public Feature getFeature(String string) {
        int n = 0;
        while (n < this.features.size()) {
            Feature feature = (Feature)this.features.get(n);
            if (feature.getKey().equals(Feature.toKey(string))) {
                return feature;
            }
            ++n;
        }
        return null;
    }

    public Feature.Brand getBrandFeature() {
        return (Feature.Brand)this.getFeature("brand");
    }

    public String getBrandId() {
        if ("tridium".equalsIgnoreCase(this.getVendor())) {
            Feature.Brand brand = this.getBrandFeature();
            return brand == null ? null : brand.getBrandId();
        }
        return null;
    }

    public String getLicenseName() {
        if ("tridium".equalsIgnoreCase(this.getVendor())) {
            Feature.Brand brand = this.getBrandFeature();
            return brand == null ? "Tridium" : TextUtil.capitalize((String)brand.getBrandId());
        }
        return TextUtil.capitalize((String)this.getVendor());
    }

    public Feature[] getFeatures() {
        return (Feature[])this.features.trim();
    }

    public String[] getFeatureNames() {
        Feature[] featureArray = this.getFeatures();
        String[] stringArray = new String[featureArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = featureArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public Feature addFeature(String string) {
        if (this.getFeature(string) != null) {
            throw new RuntimeException("Feature already exists");
        }
        Feature feature = Feature.make(this, string);
        this.features.add((Object)feature);
        return feature;
    }

    public Feature removeFeature(String string) {
        int n = 0;
        while (n < this.features.size()) {
            Feature feature = (Feature)this.features.get(n);
            if (feature.getKey().equals(Feature.toKey(string))) {
                this.features.remove(n);
                return feature;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(BIFile bIFile) throws Exception {
        InputStream inputStream = bIFile.getInputStream();
        try {
            this.load(bIFile.toString(), XParser.make((InputStream)inputStream).parse());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        inputStream.close();
    }

    public void load(String string, InputStream inputStream) throws Exception {
        this.load(string, inputStream, true);
    }

    public void load(String string, InputStream inputStream, boolean bl) throws Exception {
        this.load(string, XParser.make((InputStream)inputStream).parse(bl));
    }

    public void load(String string, XElem xElem) throws Exception {
        this.source = string != null ? string : "Unknown";
        this.parse(xElem);
    }

    private final void parse(XElem xElem) throws Exception {
        if (!xElem.qname().equals("license")) {
            throw new XException("Root element must be <license> element", xElem);
        }
        this.modified = false;
        this.xml = new XElem("license");
        int n = 0;
        while (n < xElem.attrSize()) {
            this.xml.addAttr(xElem.attrName(n), xElem.attrValue(n));
            ++n;
        }
        if (xElem.get("generated", null) == null) {
            this.xml.addAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        }
        XElem[] xElemArray = xElem.elems("feature");
        Class clazz = class$com$tridium$sys$license$dom$Feature;
        if (clazz == null) {
            clazz = class$com$tridium$sys$license$dom$Feature = VendorLicense.class("[Lcom.tridium.sys.license.dom.Feature;", false);
        }
        this.features = new Array(clazz);
        int n2 = 0;
        while (n2 < xElemArray.length) {
            XElem xElem2 = xElemArray[n2];
            Feature feature = Feature.make(this, xElem2.get("name"));
            feature.load(xElemArray[n2]);
            this.features.add((Object)feature);
            ++n2;
        }
        XElem xElem3 = xElem.elem("signature");
        if (xElem3 != null) {
            this.signature = xElem3.string();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(BIFile bIFile) throws IOException {
        OutputStream outputStream = bIFile.getOutputStream();
        try {
            VendorLicense.format(this.save(), new XWriter(outputStream));
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        outputStream.close();
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, true);
    }

    public void save(OutputStream outputStream, boolean bl) throws IOException {
        XWriter xWriter = new XWriter(outputStream);
        this.save(xWriter);
        xWriter.flush();
        if (bl) {
            xWriter.close();
        }
    }

    public void save(XWriter xWriter) throws IOException {
        VendorLicense.format(this.save(), xWriter);
    }

    public XElem save() {
        if (this.modified) {
            this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
            this.modified = false;
        }
        XElem xElem = this.xml.copy();
        int n = 0;
        while (n < this.features.size()) {
            xElem.addContent((XContent)((Feature)this.features.get(n)).save());
            ++n;
        }
        if (this.signature != null) {
            XElem xElem2 = new XElem("signature");
            xElem2.addContent((XContent)new XText(this.signature));
            xElem.addContent((XContent)xElem2);
        }
        return xElem;
    }

    public static void format(XElem xElem, XWriter xWriter) {
        VendorLicense.formatr(xElem, xWriter, "");
        xWriter.flush();
    }

    private static final void formatr(XElem xElem, XWriter xWriter, String string) {
        xWriter.w((Object)string).w('<').w((Object)xElem.name());
        int n = xElem.attrSize();
        int n2 = 0;
        while (n2 < n) {
            xWriter.w((Object)" ").attr(xElem.attrName(n2), xElem.attrValue(n2));
            ++n2;
        }
        if (xElem.contentSize() == 0) {
            xWriter.w((Object)"/>").nl();
            return;
        }
        xWriter.w('>');
        XElem[] xElemArray = xElem.elems();
        if (xElemArray.length > 0) {
            xWriter.nl();
        }
        int n3 = 0;
        while (n3 < xElemArray.length) {
            VendorLicense.formatr(xElemArray[n3], xWriter, string + ' ');
            ++n3;
        }
        if (xElem.text() != null) {
            xElem.text().write(xWriter);
        }
        if (xElemArray.length > 0) {
            xWriter.w((Object)string);
        }
        xWriter.w((Object)"</").w((Object)xElem.name()).w('>').nl();
    }

    protected void modify() {
        this.signature = null;
        this.modified = true;
    }

    public void dump() {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("  VendorLicense");
        printWriter.println("    source:     " + this.source);
        printWriter.println("    hostId:     " + this.getHostId());
        printWriter.println("    vendor:     " + this.getVendor());
        printWriter.println("    version:    " + this.getVersion());
        printWriter.println("    expiration: " + LicenseUtil.formatDate(this.getExpiration()));
        printWriter.println("    generated:  " + LicenseUtil.formatDate(this.getGenerated()));
        Feature[] featureArray = this.getFeatures();
        int n = 0;
        while (n < featureArray.length) {
            featureArray[n].dump(printWriter);
            ++n;
        }
        printWriter.flush();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.source = "Unknown";
        Class clazz = class$com$tridium$sys$license$dom$Feature;
        if (clazz == null) {
            clazz = class$com$tridium$sys$license$dom$Feature = VendorLicense.class("[Lcom.tridium.sys.license.dom.Feature;", false);
        }
        this.features = new Array(clazz);
        this.signature = null;
        this.modified = false;
    }

    public VendorLicense() {
        this.this();
        this.xml = new XElem("license");
        this.xml.setAttr("generated", LicenseUtil.formatDate(Clock.millis()));
        this.xml.setAttr("expiration", "never");
        this.modified = true;
    }
}

