/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.PrintWriter;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Feature
implements Comparable {
    private final VendorLicense parent;
    private final String name;
    private final String key;
    private XElem xml;
    static /* synthetic */ Class class$java$lang$String;

    static Feature make(VendorLicense vendorLicense, String string) {
        if (string.equalsIgnoreCase("brand")) {
            return new Brand(vendorLicense);
        }
        return new Feature(vendorLicense, string);
    }

    static String toKey(String string) {
        return TextUtil.toLowerCase((String)string);
    }

    public VendorLicense getParent() {
        return this.parent;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExpired() {
        boolean bl = false;
        if (Clock.millis() > this.getExpiration() || this.parent.isExpired()) {
            bl = true;
        }
        return bl;
    }

    public long getExpiration() {
        String string = this.xml.get("expiration", null);
        return string == null ? Long.MAX_VALUE : LicenseUtil.parseDate(string);
    }

    public void setExpiration(long l) {
        this.modify();
        this.xml.setAttr("expiration", LicenseUtil.formatDate(l));
    }

    public int compareTo(Object object) {
        String string = ((Feature)object).name;
        if (this.name.equals("about")) {
            return -1;
        }
        if (this.name.equals("brand")) {
            return string.equals("about") ? 1 : -1;
        }
        return this.name.compareTo(string);
    }

    public String toString() {
        return this.parent.getVendor() + ':' + this.getName();
    }

    public String get(String string) {
        return this.xml.get(string, null);
    }

    public String get(String string, String string2) {
        return this.xml.get(string, string2);
    }

    public boolean getb(String string, boolean bl) {
        return this.xml.getb(string, bl);
    }

    public int geti(String string, int n) {
        return this.xml.geti(string, n);
    }

    public String[] list() {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = Feature.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz, this.xml.attrSize());
        int n = 0;
        while (n < this.xml.attrSize()) {
            String string = this.xml.attrName(n);
            if (!string.equals("name") && !string.equals("expiration")) {
                array.add((Object)string);
            }
            ++n;
        }
        return (String[])array.trim();
    }

    public void set(String string, String string2) {
        this.xml.setAttr(string, string2);
    }

    public final void set(String string, boolean bl) {
        this.set(string, String.valueOf(bl));
    }

    public final void set(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    public final void remove(String string) {
        this.xml.removeAttr(string);
    }

    void load(XElem xElem) throws Exception {
        if (!xElem.qname().equals("feature")) {
            throw new XException("Root element must be <feature> element", xElem);
        }
        this.xml = xElem.copy();
    }

    XElem save() {
        return this.xml.copy();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("    " + this.name);
        printWriter.println("      expiration:         " + LicenseUtil.formatDate(this.getExpiration()));
        String[] stringArray = this.list();
        int n = 0;
        while (n < stringArray.length) {
            printWriter.println("      " + TextUtil.pad((String)(stringArray[n] + ": "), (int)20) + this.get(stringArray[n]));
            ++n;
        }
        printWriter.flush();
    }

    public void modify() {
        this.getParent().modify();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Feature(VendorLicense vendorLicense, String string) {
        if (vendorLicense == null) {
            throw new NullPointerException();
        }
        this.parent = vendorLicense;
        this.name = string;
        this.key = Feature.toKey(string);
        this.xml = new XElem("feature");
        this.xml.setAttr("name", string);
    }

    public static class Brand
    extends Feature {
        public String getBrandId() {
            return this.get("brandId");
        }

        public String getStationIn() {
            return this.get("accept.station.in");
        }

        public String getStationOut() {
            return this.get("accept.station.out");
        }

        public String getWbIn() {
            return this.get("accept.wb.in");
        }

        public String getWbOut() {
            return this.get("accept.wb.out");
        }

        Brand(VendorLicense vendorLicense) {
            super(vendorLicense, "brand");
        }
    }
}

