/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.CertificateFile;
import com.tridium.sys.license.FloatingLicenseManager;
import com.tridium.sys.license.FlrConfig;
import com.tridium.sys.license.LicenseFile;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NFeature;
import com.tridium.sys.license.NodeLockedLicenseManager;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.license.LicenseManager;
import javax.baja.log.Log;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class NLicenseManager
implements LicenseManager {
    protected static final Log log = Log.getLog("sys.license");
    final String TRIDIUM_BRAND_KEY;
    protected Lexicon lex;
    private HashMap features;
    private CertificateFile[] certificates;
    private LicenseFile[] licenses;
    private String fatalLicenseFault;

    public static NLicenseManager make() {
        NLicenseManager nLicenseManager = new NodeLockedLicenseManager();
        if (Nre.args == null || Nre.args.parameters.length == 0) {
            return nLicenseManager;
        }
        FlrConfig flrConfig = new FlrConfig();
        if (flrConfig.exists()) {
            if (flrConfig.isValid()) {
                String string = Nre.args.getOption("pack");
                if (string == null && (string = flrConfig.getPackName(Nre.args.parameters[0])) == null) {
                    log.warning("No license pack is mapped for app '" + FlrConfig.aliasApp(Nre.args.parameters[0]) + "'. Looking for a node-locked license.");
                } else {
                    nLicenseManager = new FloatingLicenseManager(flrConfig, string);
                }
            } else {
                log.error("flrclient.xml file exists, but is not valid: { " + flrConfig + " }. Looking for a node-locked license.");
            }
        }
        return nLicenseManager;
    }

    public Feature getFeature(String string, String string2) throws FeatureNotLicensedException, LicenseDatabaseException {
        if (this.fatalLicenseFault != null) {
            throw new LicenseDatabaseException(this.fatalLicenseFault);
        }
        String string3 = LicenseUtil.toKey(string, string2);
        Feature feature = (Feature)this.features.get(string3);
        if (feature == null) {
            throw new FeatureNotLicensedException(string3);
        }
        return feature;
    }

    public Feature checkFeature(String string, String string2) throws FeatureNotLicensedException, LicenseDatabaseException {
        if (this.fatalLicenseFault != null) {
            throw new LicenseDatabaseException(this.fatalLicenseFault);
        }
        String string3 = LicenseUtil.toKey(string, string2);
        Feature feature = (Feature)this.features.get(string3);
        if (feature == null) {
            throw new FeatureNotLicensedException(string3);
        }
        feature.check();
        return feature;
    }

    public Feature[] getFeatures() throws LicenseDatabaseException {
        if (this.fatalLicenseFault != null) {
            throw new LicenseDatabaseException(this.fatalLicenseFault);
        }
        Object[] objectArray = this.features.values().toArray(new NFeature[this.features.size()]);
        Object[] objectArray2 = new String[objectArray.length];
        int n = 0;
        while (n < objectArray2.length) {
            objectArray2[n] = ((NFeature)objectArray[n]).key;
            ++n;
        }
        SortUtil.sort((Object[])objectArray2, (Object[])objectArray, (boolean)true);
        return objectArray;
    }

    public final CertificateFile getCertificate(String string) throws LicenseDatabaseException {
        int n = 0;
        while (n < this.certificates.length) {
            CertificateFile certificateFile = this.certificates[n];
            if (string.equals(certificateFile.vendor)) {
                if (!certificateFile.isValid()) {
                    throw new LicenseDatabaseException("Invalid certificate for vendor: " + string);
                }
                return certificateFile;
            }
            ++n;
        }
        throw new LicenseDatabaseException("No certificate for vendor: " + string);
    }

    protected final void setFatalLicenseFault(String string) {
        this.fatalLicenseFault = string;
    }

    protected final boolean isFatalLicenseFault() {
        boolean bl = false;
        if (this.fatalLicenseFault != null) {
            bl = true;
        }
        return bl;
    }

    protected final CertificateFile[] getCertificates() {
        return this.certificates;
    }

    protected final void setCertificates(CertificateFile[] certificateFileArray) {
        this.certificates = certificateFileArray;
    }

    protected final LicenseFile[] getLicenses() {
        return this.licenses;
    }

    protected final void setLicenses(LicenseFile[] licenseFileArray) {
        this.licenses = licenseFileArray;
    }

    public void reload() {
        this.load();
    }

    protected final void load() {
        this.features = new HashMap();
        this.setCertificates(this.loadCertificates());
        this.setLicenses(this.loadLicenses());
    }

    protected CertificateFile[] loadCertificates() {
        ArrayList<CertificateFile> arrayList = new ArrayList<CertificateFile>();
        File file = new File(Sys.getBajaHome(), "certificates");
        File[] fileArray = file.listFiles();
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            if (fileArray[n].getName().toLowerCase().endsWith(".certificate")) {
                CertificateFile certificateFile = new CertificateFile(fileArray[n]);
                certificateFile.load(this);
                arrayList.add(certificateFile);
            }
            ++n;
        }
        return arrayList.toArray(new CertificateFile[arrayList.size()]);
    }

    protected abstract LicenseFile[] loadLicenses();

    protected void addFeature(NFeature nFeature) throws LicenseDatabaseException {
        String string = nFeature.key;
        NFeature nFeature2 = (NFeature)this.features.get(string);
        if (nFeature2 != null) {
            if (this.TRIDIUM_BRAND_KEY.equals(string)) {
                this.fatalLicenseFault = "Cannot have multiple branded licenses";
                throw new LicenseDatabaseException(this.fatalLicenseFault);
            }
            nFeature2.merge(nFeature);
        } else {
            this.features.put(nFeature.key, nFeature);
        }
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        printWriter.println("");
        printWriter.println("Niagara Licensing");
        printWriter.println("HostId=" + Nre.getHostId());
        printWriter.println("");
        printWriter.println("Certificates");
        if (this.certificates.length == 0) {
            printWriter.println("  none");
        }
        int n = 0;
        while (n < this.certificates.length) {
            printWriter.println("  " + this.certificates[n]);
            ++n;
        }
        printWriter.println("");
        printWriter.print("Licenses ");
        printWriter.println(this instanceof NodeLockedLicenseManager ? "(node-locked)" : "(floating)");
        if (this.licenses.length == 0) {
            printWriter.println("  none");
        }
        n = 0;
        while (n < this.licenses.length) {
            printWriter.println("  " + this.licenses[n]);
            ++n;
        }
        if (this.fatalLicenseFault != null) {
            return;
        }
        printWriter.println("");
        printWriter.println("Features");
        Feature[] featureArray = this.getFeatures();
        if (featureArray.length == 0) {
            printWriter.println("  none");
        }
        int n2 = 0;
        while (n2 < featureArray.length) {
            NFeature nFeature = (NFeature)featureArray[n2];
            printWriter.println("  " + nFeature);
            String[] stringArray = nFeature.list();
            int n3 = 0;
            while (n3 < stringArray.length) {
                printWriter.println("    " + stringArray[n3] + '=' + nFeature.get(stringArray[n3]));
                ++n3;
            }
            ++n2;
        }
        try {
            printWriter.println("");
            printWriter.println("Brand");
            printWriter.println("  brandId            = " + Brand.getBrandId());
            printWriter.println("  accept.station.in  = " + Brand.getAcceptStationInString());
            printWriter.println("  accept.station.out = " + Brand.getAcceptStationOutString());
            printWriter.println("  accept.wb.in       = " + Brand.getAcceptWbInString());
            printWriter.println("  accept.wb.out      = " + Brand.getAcceptWbOutString());
        }
        catch (Exception exception) {}
    }

    public void postInit() {
        this.lex = Lexicon.make("baja");
        this.load();
        if (Nre.spySysManagers.find("licenseManager") != null) {
            Nre.spySysManagers.remove("licenseManager");
        }
        Nre.spySysManagers.add("licenseManager", new Page());
    }

    private final /* synthetic */ void this() {
        this.TRIDIUM_BRAND_KEY = LicenseUtil.toKey("tridium", "brand");
        this.fatalLicenseFault = null;
    }

    protected NLicenseManager() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Page
    extends Spy {
        public void write(SpyWriter spyWriter) throws Exception {
            spyWriter.print("<pre>");
            NLicenseManager.this.dump(spyWriter);
            spyWriter.print("</pre>");
        }
    }
}

