/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.Nre;
import com.tridium.sys.license.CertificateFile;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NFeature;
import com.tridium.sys.license.NLicenseManager;
import java.security.PublicKey;
import java.util.Properties;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.util.Base64;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public abstract class LicenseFile {
    protected String error;
    protected String hostId;
    protected String vendor;
    protected long generated;
    protected long expiration;

    protected abstract XElem getRoot() throws Exception;

    protected abstract boolean isLicenseHostIdValid();

    public void load(NLicenseManager nLicenseManager) {
        try {
            XElem[] xElemArray;
            if (Nre.getHostId() == null) {
                this.error = "HostId not supported";
                return;
            }
            XElem xElem = this.getRoot();
            if (xElem.qname().equals("license")) {
                this.load(nLicenseManager, xElem);
                return;
            }
            if (xElem.qname().equals("licenses") && (xElemArray = xElem.elems("license")).length > 0) {
                int n = 0;
                while (n < xElemArray.length) {
                    this.load(nLicenseManager, xElemArray[n]);
                    ++n;
                }
                return;
            }
            throw new XException("Missing <license> element", xElem);
        }
        catch (XException xException) {
            this.error = "Invalid XML: " + xException.getMessage();
        }
        catch (Throwable throwable) {
            this.error = throwable.toString();
        }
    }

    private final void load(NLicenseManager nLicenseManager, XElem xElem) throws Exception {
        Object object;
        Object object2;
        this.vendor = xElem.get("vendor");
        CertificateFile certificateFile = nLicenseManager.getCertificate(this.vendor);
        PublicKey publicKey = certificateFile.publicKey;
        XElem xElem2 = xElem.elem("signature");
        if (xElem2 == null) {
            throw new XException("Missing signature element", xElem);
        }
        byte[] byArray = Base64.decode((String)xElem2.string());
        this.hostId = xElem.get("hostId");
        if (!this.isLicenseHostIdValid()) {
            if (this.error == null) {
                this.error = "HostId does not match";
            }
            return;
        }
        long l = System.currentTimeMillis();
        this.generated = LicenseUtil.parseDate(xElem.get("generated"));
        if (l < this.generated - 86400000L) {
            this.error = "Current date is earlier than license generated date";
            return;
        }
        this.expiration = LicenseUtil.parseDate(xElem.get("expiration"));
        if (l > this.expiration) {
            this.error = "License file is expired";
            return;
        }
        String string = xElem.get("vendor");
        if (string != null && string.equalsIgnoreCase("Tridium")) {
            object2 = new Version(xElem.get("version"));
            object = new Version("3.8");
            if (((Version)object2).major() != ((Version)object).major() || ((Version)object2).minor() < ((Version)object).minor()) {
                this.error = "License for older version: " + object2 + " < " + object;
                return;
            }
        }
        xElem.removeContent((XContent)xElem2);
        object2 = LicenseUtil.encode(xElem);
        if (!LicenseUtil.verify((byte[])object2, byArray, publicKey)) {
            this.error = "Invalid signature";
            return;
        }
        object = xElem.elems("feature");
        int n = 0;
        while (n < ((Object)object).length) {
            try {
                this.loadFeature(nLicenseManager, (XElem)object[n]);
            }
            catch (LicenseDatabaseException licenseDatabaseException) {
                this.error = licenseDatabaseException.getMessage();
                throw licenseDatabaseException;
            }
            catch (Throwable throwable) {
                System.out.println("Invalid feature in " + this.getLicenseName() + " [line " + object[n].line() + ']');
                System.out.println("  " + throwable);
            }
            ++n;
        }
    }

    private final void loadFeature(NLicenseManager nLicenseManager, XElem xElem) throws Exception {
        String string = xElem.get("name");
        long l = Long.MAX_VALUE;
        String string2 = xElem.get("expiration", null);
        if (string2 != null) {
            l = LicenseUtil.parseDate(string2);
        }
        if (this.expiration < l) {
            l = this.expiration;
        }
        NFeature nFeature = new NFeature(this.vendor, string, l);
        int n = 0;
        while (n < xElem.attrSize()) {
            String string3 = xElem.attrName(n);
            String string4 = xElem.attrValue(n);
            if (!string3.equals("name") && !string3.equals("expiration")) {
                if (nFeature.props == NFeature.noProps) {
                    nFeature.props = new Properties();
                }
                nFeature.props.put(string3, string4);
            }
            ++n;
        }
        nLicenseManager.addFeature(nFeature);
    }

    protected abstract String getLicenseName();

    public boolean isValid() {
        boolean bl = false;
        if (this.error == null) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        if (this.isValid()) {
            return this.getLicenseName() + " <" + this.vendor + "> [expires: " + LicenseUtil.formatDate(this.expiration) + "] {valid}";
        }
        return this.getLicenseName() + " {invalid: " + this.error + '}';
    }

    LicenseFile() {
    }
}

