/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.baja.sys.Sys;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class FlrConfig {
    public static final String filename = "flrclient.xml";
    private File configFile;
    private String err;
    private FlrDef[] flrs;
    private HashMap appToPack;

    public static String aliasApp(String string) {
        if (string.equals("workbench:com.tridium.workbench.shell.WbMain")) {
            return "wb";
        }
        if (string.equals("com.tridium.sys.station.Station")) {
            return "station";
        }
        return string;
    }

    public static String unaliasApp(String string) {
        if (string.equals("station")) {
            return "com.tridium.sys.station.Station";
        }
        if (string.equals("wb")) {
            return "workbench:com.tridium.workbench.shell.WbMain";
        }
        return string;
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public boolean isValid() {
        boolean bl = false;
        if (this.err == null) {
            bl = true;
        }
        return bl;
    }

    public FlrDef[] flrs() {
        return this.flrs;
    }

    public void addFlrDef(FlrDef flrDef) {
        ArrayList<FlrDef> arrayList = new ArrayList<FlrDef>(Arrays.asList(this.flrs));
        if (arrayList.contains(flrDef)) {
            return;
        }
        arrayList.add(flrDef);
        this.flrs = arrayList.toArray(new FlrDef[arrayList.size()]);
    }

    public void removeFlr(FlrDef flrDef) {
        ArrayList<FlrDef> arrayList = new ArrayList<FlrDef>(Arrays.asList(this.flrs));
        if (arrayList.remove(flrDef)) {
            this.flrs = arrayList.toArray(new FlrDef[arrayList.size()]);
        }
    }

    public String[] apps() {
        return this.appToPack.keySet().toArray(new String[this.appToPack.size()]);
    }

    public void addPackmap(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        this.appToPack.put(FlrConfig.unaliasApp(string), string2);
    }

    public void removePackmap(String string) {
        this.appToPack.remove(FlrConfig.unaliasApp(string));
    }

    public String getPackName(String string) {
        return (String)this.appToPack.get(FlrConfig.unaliasApp(string));
    }

    public String toString() {
        return this.err == null ? filename : this.err;
    }

    private final void load() {
        this.configFile = new File(new File(Sys.getBajaHome(), "licenses"), filename);
        if (!this.exists()) {
            return;
        }
        try {
            XElem xElem = XParser.make((File)this.configFile).parse();
            if (!xElem.name().equals("flrclient")) {
                throw new XException("root element must be <flrclient>");
            }
            this.flrs = this.parseFlrs(xElem.elems("flr"));
            if (this.flrs.length == 0) {
                throw new XException("No FLRs are defined");
            }
            this.appToPack = this.parsePacks(xElem);
        }
        catch (XException xException) {
            this.err = "Invalid flrclient.xml XML: " + xException.getMessage();
        }
        catch (Exception exception) {
            this.err = exception.toString();
        }
    }

    private final FlrDef[] parseFlrs(XElem[] xElemArray) {
        FlrDef[] flrDefArray = new FlrDef[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            flrDefArray[n] = new FlrDef(xElemArray[n].get("host"), xElemArray[n].geti("port"));
            ++n;
        }
        return flrDefArray;
    }

    private final HashMap parsePacks(XElem xElem) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        XElem[] xElemArray = xElem.elems("packmap");
        int n = 0;
        while (n < xElemArray.length) {
            String string = FlrConfig.unaliasApp(xElemArray[n].get("app"));
            String string2 = xElemArray[n].get("pack");
            if (hashMap.containsKey(string)) {
                throw new XException("Duplicate app defined '" + FlrConfig.aliasApp(string) + '\'', xElemArray[n]);
            }
            hashMap.put(FlrConfig.unaliasApp(xElemArray[n].get("app")), xElemArray[n].get("pack"));
            ++n;
        }
        return hashMap;
    }

    public void write() throws Exception {
        XElem xElem = new XElem("flrclient");
        int n = 0;
        while (n < this.flrs.length) {
            xElem.addContent((XContent)new XElem("flr").addAttr("host", this.flrs[n].ip).addAttr("port", Integer.toString(this.flrs[n].port)));
            ++n;
        }
        String[] stringArray = this.apps();
        int n2 = 0;
        while (n2 < stringArray.length) {
            xElem.addContent((XContent)new XElem("packmap").addAttr("app", FlrConfig.aliasApp(stringArray[n2])).addAttr("pack", this.getPackName(stringArray[n2])));
            ++n2;
        }
        xElem.write(this.configFile);
    }

    public FlrConfig(FlrDef[] flrDefArray, HashMap hashMap) {
        this.flrs = flrDefArray;
        this.appToPack = hashMap;
    }

    public FlrConfig() {
        this.flrs = new FlrDef[0];
        this.appToPack = new HashMap();
        this.load();
    }

    public static class FlrDef {
        public final String ip;
        public final int port;

        public URL getURL() {
            try {
                return new URL("http", this.ip, this.port, "/flr/");
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }

        public int hashCode() {
            int n = 1;
            int n2 = 0;
            if (this.ip != null) {
                n2 = this.ip.hashCode();
            }
            n = 31 * n + n2;
            n = 31 * n + this.port;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FlrDef flrDef = (FlrDef)object;
            if (this.ip == null ? flrDef.ip != null : !this.ip.equals(flrDef.ip)) {
                return false;
            }
            return this.port == flrDef.port;
        }

        public FlrDef(String string, int n) {
            this.ip = string;
            this.port = n;
        }
    }
}

