/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NLicenseManager;
import java.io.File;
import java.security.PublicKey;
import javax.baja.nre.util.Base64;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class CertificateFile {
    File file;
    String error;
    String vendor;
    long expiration;
    PublicKey publicKey;

    public void load(NLicenseManager nLicenseManager) {
        try {
            XElem xElem = XParser.make((File)this.file).parse();
            if (!xElem.qname().equals("certificate")) {
                throw new XException("Root name must be certificate", xElem);
            }
            this.vendor = xElem.get("vendor");
            XElem xElem2 = xElem.elem("publicKey");
            byte[] byArray = Base64.decode((String)xElem2.string());
            this.publicKey = LicenseUtil.toPublicKey(byArray);
            long l = System.currentTimeMillis();
            this.expiration = LicenseUtil.parseDate(xElem.get("expiration"));
            if (l > this.expiration) {
                this.error = "Expired";
                return;
            }
            XElem xElem3 = xElem.elem("signature");
            byte[] byArray2 = Base64.decode((String)xElem3.string());
            xElem.removeContent((XContent)xElem3);
            byte[] byArray3 = LicenseUtil.encode(xElem);
            if (!LicenseUtil.verify(byArray3, byArray2, LicenseUtil.getMasterPublicKey())) {
                this.error = "Invalid signature";
                return;
            }
        }
        catch (XException xException) {
            this.error = "Invalid XML: " + xException.getMessage();
        }
        catch (Throwable throwable) {
            this.error = throwable.toString();
        }
    }

    public boolean isValid() {
        boolean bl = false;
        if (this.error == null) {
            bl = true;
        }
        return bl;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String toString() {
        if (this.isValid()) {
            return this.file.getName() + " <" + this.vendor + "> [expires: " + LicenseUtil.formatDate(this.expiration) + "] {valid}";
        }
        return this.file.getName() + " {invalid: " + this.error + '}';
    }

    CertificateFile(File file) {
        this.file = file;
    }
}

