/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.schema.NSlot;
import java.util.ArrayList;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;

public final class SlotKnobs {
    private static final NKnob[] noKnobs = new NKnob[0];
    public final BComponent sourceComponent;
    public final NSlot sourceSlot;
    public NKnob[] knobs;
    public int size;

    public final void propagate(BValue bValue) {
        int n = 0;
        while (n < this.size) {
            BLink bLink = null;
            try {
                bLink = this.knobs[n].getLink();
                if (bLink != null && bLink.isEnabled()) {
                    bLink.propagate(bValue);
                }
            }
            catch (ActionInvokeException actionInvokeException) {
                EngineManager.log.error("Link propogate: " + bLink, actionInvokeException.getCause());
            }
            catch (Throwable throwable) {
                EngineManager.log.error("Link propogate: " + bLink, throwable);
            }
            ++n;
        }
    }

    public final NKnob get(int n) {
        int n2 = 0;
        while (n2 < this.size) {
            if (this.knobs[n2].id == n) {
                return this.knobs[n2];
            }
            ++n2;
        }
        return null;
    }

    public final NKnob[] list() {
        NKnob[] nKnobArray = new NKnob[this.size];
        System.arraycopy(this.knobs, 0, nKnobArray, 0, this.size);
        return nKnobArray;
    }

    public final void appendTo(ArrayList arrayList) {
        int n = 0;
        while (n < this.size) {
            arrayList.add(this.knobs[n]);
            ++n;
        }
    }

    public final void add(NKnob nKnob) {
        if (this.size >= this.knobs.length) {
            NKnob[] nKnobArray = new NKnob[Math.max(this.size * 2, 4)];
            System.arraycopy(this.knobs, 0, nKnobArray, 0, this.knobs.length);
            this.knobs = nKnobArray;
        }
        this.knobs[this.size++] = nKnob;
    }

    public final void remove(NKnob nKnob) {
        int n = 0;
        while (n < this.size) {
            if (this.knobs[n] == nKnob) {
                if (n < this.knobs.length) {
                    System.arraycopy(this.knobs, n + 1, this.knobs, n, this.knobs.length - n - 1);
                }
                this.knobs[this.size - 1] = null;
                --this.size;
                return;
            }
            ++n;
        }
    }

    public SlotKnobs(BComponent bComponent, NSlot nSlot, NKnob nKnob) {
        this(bComponent, nSlot);
        this.knobs = new NKnob[]{nKnob};
        this.size = 1;
    }

    public SlotKnobs(BComponent bComponent, NSlot nSlot) {
        this.sourceComponent = bComponent;
        this.sourceSlot = nSlot;
        this.knobs = noKnobs;
    }
}

