/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.EngineUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.ExpiredTicketException;

public final class NClockTicket
implements Clock.Ticket {
    long nextUpdate;
    long period;
    BComponent component;
    Action action;
    BValue arg;
    NClockTicket next;

    public final void cancel() {
        this.nextUpdate = 0L;
        this.period = -1;
        this.component = null;
        this.action = null;
        this.arg = null;
    }

    public final boolean isExpired() {
        boolean bl = false;
        if (this.component == null) {
            bl = true;
        }
        return bl;
    }

    public final BComponent getComponent() {
        if (this.isExpired()) {
            throw new ExpiredTicketException();
        }
        return this.component;
    }

    public final Action getAction() {
        if (this.isExpired()) {
            throw new ExpiredTicketException();
        }
        return this.action;
    }

    public final BValue getActionArgument() {
        if (this.isExpired()) {
            throw new ExpiredTicketException();
        }
        return this.arg;
    }

    public final String toString() {
        if (this.isExpired()) {
            return "Ticket: expired";
        }
        BFacets bFacets = BFacets.make("showMilliseconds", BBoolean.TRUE);
        return "Ticket nextUpdate=" + BAbsTime.make(Clock.millis() + this.millisLeft()).toString(bFacets) + " period=" + this.period;
    }

    public final long millisLeft() {
        if (this.nextUpdate < 0L) {
            return -this.nextUpdate - Clock.ticks();
        }
        return this.nextUpdate - Clock.millis();
    }

    final long process(long l, long l2) {
        BComponent bComponent = this.component;
        Action action = this.action;
        BValue bValue = this.arg;
        if (bComponent == null) {
            return Long.MIN_VALUE;
        }
        if (!bComponent.isRunning()) {
            return Long.MIN_VALUE;
        }
        if (this.nextUpdate < 0L) {
            if (l >= -this.nextUpdate) {
                if (this.period == 0L) {
                    this.cancel();
                } else {
                    this.nextUpdate = -(l + this.period);
                }
                EngineUtil.invoke(bComponent, action, bValue, null);
            }
        } else if (l2 >= this.nextUpdate) {
            if (this.period == 0L) {
                this.cancel();
            } else {
                this.nextUpdate += this.period;
            }
            EngineUtil.invoke(bComponent, action, bValue, null);
        }
        if (this.component == null || this.nextUpdate == 0L) {
            return Long.MIN_VALUE;
        }
        if (this.nextUpdate < 0L) {
            return -this.nextUpdate - l;
        }
        return this.nextUpdate - l2;
    }

    public NClockTicket(BComponent bComponent, Action action, BValue bValue) {
        this.component = bComponent;
        this.action = action;
        this.arg = bValue;
    }
}

