/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.Nre;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.log.Log;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LeaseManager {
    static final Log log = Log.getLog("sys.lease");
    HashMap map;
    public final Subscriber subscriber;

    public long getLeaseExpiration(BComponent bComponent) {
        Entry entry = (Entry)this.map.get(bComponent);
        if (entry == null) {
            return -1;
        }
        return entry.expiration;
    }

    public void lease(BComponent bComponent, int n, long l) {
        this.subscriber.subscribe(bComponent, n, (Context)new LeaseContext(l));
    }

    public void lease(BComponent[] bComponentArray, int n, long l) {
        this.subscriber.subscribe(bComponentArray, n, (Context)new LeaseContext(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkLease(BComponent bComponent, LeaseContext leaseContext) {
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            block6: {
                Entry entry;
                block5: {
                    entry = (Entry)this.map.get(bComponent);
                    if (entry != null) break block5;
                    entry = new Entry();
                    entry.component = bComponent;
                    entry.expiration = leaseContext.expiration;
                    this.map.put(bComponent, entry);
                    if (log.isTraceOn()) {
                        log.trace("Lease new: " + bComponent.toPathString() + ' ' + leaseContext.millis + "ms");
                    }
                    break block6;
                }
                entry.expiration = Math.max(entry.expiration, leaseContext.expiration);
                if (log.isTraceOn()) {
                    log.trace("Lease renew: " + bComponent.toPathString() + ' ' + leaseContext.millis + "ms");
                }
            }
            return;
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("leaseManager", new SummaryPage());
    }

    private final /* synthetic */ void this() {
        this.map = new HashMap();
        this.subscriber = new LeaseSubscriber();
    }

    public LeaseManager() {
        this.this();
        new LeaseThread().start();
    }

    static class Entry {
        BComponent component;
        long expiration;

        Entry() {
        }
    }

    static class LeaseContext
    extends BasicContext {
        long millis;
        long expiration;

        LeaseContext(long l) {
            this.millis = l;
            this.expiration = Clock.ticks() + l;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SummaryPage
    extends SpyDir {
        public void write(SpyWriter spyWriter) throws Exception {
            Object[] objectArray = LeaseManager.this.map.values().toArray(new Entry[LeaseManager.this.map.size()]);
            Object[] objectArray2 = new String[objectArray.length];
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = "" + ((Entry)objectArray[n]).component.getNavOrd();
                ++n;
            }
            SortUtil.sort((Object[])objectArray2, (Object[])objectArray);
            spyWriter.startTable(true);
            spyWriter.trTitle("Lease Manager", 3);
            spyWriter.w("<tr>").th("Component").th("Type").th("Time Left").w("</tr>");
            n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                BComponent bComponent = ((Entry)object).component;
                String string = ((Entry)object).expiration - Clock.ticks() + "ms";
                spyWriter.tr(objectArray2[n], bComponent.getType(), string);
                ++n;
            }
            spyWriter.endTable();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LeaseSubscriber
    extends Subscriber {
        public void event(BComponentEvent bComponentEvent) {
        }

        public boolean doesHandleEvent(int n) {
            return false;
        }

        public void subscribed(BComponent bComponent, Context context) {
            LeaseManager.this.checkLease(bComponent, (LeaseContext)context);
        }

        LeaseSubscriber() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LeaseThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = new ArrayList<BComponent>();
            while (true) {
                try {
                    Thread.sleep(5000L);
                    var1_1.clear();
                    var2_2 = Clock.ticks();
                    var4_4 = LeaseManager.this.map;
                    synchronized (var4_4) {
                        var6_6 = LeaseManager.this.map.values().toArray(new Entry[LeaseManager.this.map.size()]);
                        var7_7 = 0;
                        while (true) {
                            block12: {
                                if (var7_7 < var6_6.length) break block12;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 7, 8] lbl18 : MonitorExitStatement: MONITOREXIT : var4_4
                                var6_5 = 0;
                                if (true) ** GOTO lbl42
                            }
                            var8_9 = var6_6[var7_7];
                            if (var8_9.expiration < var2_2) {
                                var1_1.add(var8_9.component);
                                LeaseManager.this.map.remove(var8_9.component);
                                if (LeaseManager.log.isTraceOn()) {
                                    LeaseManager.log.trace("Expired: " + var8_9.component.toPathString());
                                }
                            }
                            ++var7_7;
                        }
                    }
                }
                catch (Throwable var2_3) {
                    LeaseManager.log.error("Error in run", var2_3);
                    continue;
                }
                do {
                    var7_8 = (BComponent)var1_1.get(var6_5);
                    try {
                        LeaseManager.this.subscriber.unsubscribe(var7_8);
                    }
                    catch (Throwable var8_10) {
                        LeaseManager.log.error("Cannot unsubscribe: " + var7_8);
                    }
                    ++var6_5;
lbl42:
                    // 2 sources

                } while (var6_5 < var1_1.size());
            }
        }

        public LeaseThread() {
            super(Nre.mainThreadGroup, "Nre:Lease");
            this.setDaemon(true);
        }
    }
}

