/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.nre.util.PlatformUtil;
import com.tridium.sys.BootEnv;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.baja.log.Log;
import javax.baja.sys.BajaRuntimeException;

public class NreLib {
    private static InetAddress localHost = null;
    private static InetAddress localHost6 = null;
    public static boolean nativesLoaded = false;
    static boolean niagaraIpv6Enabled = Boolean.getBoolean("niagara.ipv6Enabled");

    public static void dumpThreads() {
        if (nativesLoaded) {
            NreLib.dumpThreads0();
        }
    }

    static native void dumpThreads0();

    public static String getHostId() {
        return PlatformUtil.getHostId();
    }

    public static String getHostModel() {
        try {
            String string = NreLib.getHostModel0();
            if (string == null || string.length() == 0) {
                return "Workstation";
            }
            return string;
        }
        catch (Throwable throwable) {
            return "unknown";
        }
    }

    static native String getHostModel0();

    public static String getenv(String string) {
        try {
            return NreLib.getenv0(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static native String getenv0(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean setSystemProperty(String string, String string2) {
        if (string == null) return false;
        if (string2 == null) {
            return false;
        }
        System.getProperties().setProperty(string, string2);
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        String string3 = Nre.bajaHome + File.separator + "lib" + File.separator + "system.properties";
        File file = new File(string3);
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(string3));
                ArrayList<String> arrayList = new ArrayList<String>();
                String string4 = null;
                boolean bl = false;
                while (true) {
                    if ((string4 = bufferedReader.readLine()) == null) {
                        if (!bl) {
                            arrayList.add(string + '=' + string2);
                        }
                        break;
                    }
                    if (string4.startsWith(string + '=')) {
                        bl = true;
                        string4 = string + '=' + string2;
                    }
                    arrayList.add(string4);
                }
                bufferedReader.close();
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = 0;
                while (true) {
                    block23: {
                        if (n < arrayList.size()) break block23;
                        bufferedWriter.write("\r\n");
                        bufferedWriter.flush();
                        break;
                    }
                    bufferedWriter.write("" + arrayList.get(n) + '\n');
                    ++n;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("WARNING: Cannot save " + file + ": File not found");
                boolean bl = false;
                Object var7_14 = null;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                try {
                    bufferedWriter.close();
                    return bl;
                }
                catch (Exception exception) {}
                return bl;
            }
            catch (Throwable throwable) {
                System.out.println("ERROR: Cannot save " + file + ": " + throwable);
                boolean bl = false;
                Object var7_15 = null;
                try {}
                catch (Exception exception) {}
                bufferedReader.close();
                try {}
                catch (Exception exception) {}
                bufferedWriter.close();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            try {}
            catch (Exception exception) {}
            bufferedReader.close();
            try {}
            catch (Exception exception) {}
            bufferedWriter.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var7_17 = null;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        try {}
        catch (Exception exception) {
            return true;
        }
        bufferedWriter.close();
        return true;
    }

    public static InetAddress getLocalHost() {
        return NreLib.getLocalHost(niagaraIpv6Enabled);
    }

    public static InetAddress getLocalHost(boolean bl) {
        try {
            if (!bl) {
                if (localHost == null) {
                    if (nativesLoaded) {
                        localHost = NreLib.getLocalHost0();
                    }
                    if (localHost == null && (localHost = NreLib.getBestLocalAddress(bl)) == null) {
                        Log.getLog("sys").warning("No valid IPv4 addresses found, using IPv4 loopback as localhost");
                        localHost = InetAddress.getByName("127.0.0.1");
                    }
                }
                return localHost;
            }
            if (localHost6 == null) {
                if (nativesLoaded) {
                    localHost6 = NreLib.getLocalHost60();
                }
                if (localHost6 == null && (localHost6 = NreLib.getBestLocalAddress(bl)) == null) {
                    Log.getLog("sys").warning("No valid IPv6 addresses found, using IPv6 loopback as localhost");
                    localHost6 = InetAddress.getByName("::1");
                }
            }
            return localHost6;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new BajaRuntimeException("getLocalHost", throwable);
        }
    }

    static native InetAddress getLocalHost0();

    static native InetAddress getLocalHost60();

    private static final InetAddress getBestLocalAddress(boolean bl) throws Exception {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        InetAddress inetAddress3 = null;
        InetAddress inetAddress4 = null;
        int n = 0;
        while (n < inetAddressArray.length) {
            block16: {
                block15: {
                    block14: {
                        if (!bl || !(inetAddressArray[n] instanceof Inet6Address)) break block14;
                        inetAddress = inetAddressArray[n];
                        break block15;
                    }
                    if (bl || !(inetAddressArray[n] instanceof Inet4Address)) break block16;
                    inetAddress = inetAddressArray[n];
                }
                if (inetAddress2 == null && inetAddress.isLinkLocalAddress()) {
                    inetAddress2 = inetAddress;
                } else if (inetAddress3 == null && inetAddress.isSiteLocalAddress()) {
                    inetAddress3 = inetAddress;
                } else if (!(inetAddress4 != null || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isMulticastAddress() || inetAddress.isSiteLocalAddress() || inetAddress.isAnyLocalAddress())) {
                    inetAddress4 = inetAddress;
                    break;
                }
            }
            ++n;
        }
        inetAddress = null;
        if (inetAddress4 != null) {
            inetAddress = inetAddress4;
        } else if (inetAddress3 != null) {
            inetAddress = inetAddress3;
        } else if (inetAddress2 != null) {
            inetAddress = inetAddress2;
        }
        return inetAddress;
    }

    public static void traceEvent(int n) {
        if (nativesLoaded) {
            NreLib.traceEvent0(n);
        }
    }

    static native void traceEvent0(int var0);

    static {
        try {
            BootEnv bootEnv = Nre.bootEnv;
            if (bootEnv == null || !bootEnv.isRemote()) {
                System.loadLibrary("nre");
                nativesLoaded = true;
            } else {
                System.out.println("WARNING: Not loading nre native library");
            }
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot load nre native library");
            System.out.println("  " + throwable);
        }
    }
}

