/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.KeyRingFactory;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.fips.EntrustProviderManager;
import com.tridium.sys.BIPlatform;
import com.tridium.sys.BNullPlatform;
import com.tridium.sys.BootEnv;
import com.tridium.sys.DefaultBootEnv;
import com.tridium.sys.NreLib;
import com.tridium.sys.engine.EngineManager;
import com.tridium.sys.engine.LeaseManager;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.ModuleManager;
import com.tridium.sys.module.NModule;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.resource.ResourceManager;
import com.tridium.sys.schema.SchemaManager;
import com.tridium.sys.service.ServiceManager;
import com.tridium.sys.session.NSessionManager;
import com.tridium.sys.session.SessionManager;
import com.tridium.sys.spy.LogSetupSpy;
import com.tridium.sys.spy.SysInfoSpy;
import com.tridium.sys.spy.SystemPropertiesSpy;
import com.tridium.sys.spy.UtilSpy;
import com.tridium.sys.station.StationManager;
import com.tridium.sys.stdout.StdoutManager;
import com.tridium.util.CommandLineArguments;
import com.tridium.util.ThrowableUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.baja.file.BFileSystem;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.Auditor;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.spy.BSpySpace;
import javax.baja.spy.ObjectSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.BUuid;
import javax.baja.util.PatternFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Nre {
    private static final String J9_PROVIDER = "com.tridium.j9.provider.J9BasicProvider";
    private static final String NIAGARA_PROVIDER = "com.tridium.niagara.provider.NiagaraBasicProvider";
    private static final String BC_PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    public static final long bootTime = System.currentTimeMillis();
    public static BootEnv bootEnv;
    public static CommandLineArguments args;
    public static String commandLine;
    public static File bajaHome;
    public static File userHome;
    public static File credentialsHome;
    public static File stationHome;
    public static StdoutManager stdoutManager;
    public static ModuleManager moduleManager;
    public static NRegistry registryManager;
    public static SchemaManager schemaManager;
    public static EngineManager engineManager;
    public static LeaseManager leaseManager;
    public static ServiceManager serviceManager;
    public static NLicenseManager licenseManager;
    public static StationManager stationManager;
    public static ResourceManager resourceManager;
    public static Metrics.Recount metricsRecount;
    public static NSessionManager sessionManager;
    public static ThreadGroup mainThreadGroup;
    public static SpyDir spySysManagers;
    public static String language;
    public static Auditor auditor;
    public static int unitConversion;
    public static String vmUuid;
    public static Class launchedClass;
    private static ISecurityInfoProvider secInfProvider;
    static boolean isBooted;
    static BIPlatform platform;
    static boolean isStation;
    static boolean isRemote;
    static boolean hasBootClass;
    private static final String NRE_PROP = "cmdline::";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$sys$Nre;
    static /* synthetic */ Class class$javax$baja$registry$ModuleInfo;

    static void usage() {
        Nre.println("");
        Nre.println("usage:");
        Nre.println("  nre [options] <class> [args]*");
        Nre.println("parameters:");
        Nre.println("  class        classname or module:classname to execute");
        Nre.println("  args         arguments to pass through to main");
        Nre.println("options:");
        Nre.println("  -version     print nre version");
        Nre.println("  -modules:<x> print modules which match specified pattern");
        Nre.println("  -hostid      print system host id");
        Nre.println("  -licenses    print licensing summary");
        Nre.println("  -props       dump system properties");
        Nre.println("  -locale:<x>  set the default locale (en_US)");
        Nre.println("  -@<option>   pass option to Java VM");
        Nre.println("  -testheap    test max heap size");
        Nre.println("  -buildreg    force rebuild of the registry");
        Nre.println("");
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2;
            StringBuffer stringBuffer = new StringBuffer("nre");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(' ').append(stringArray[n]);
                ++n;
            }
            commandLine = stringBuffer.toString();
            args = new CommandLineArguments(stringArray);
            if (args.hasOption("version")) {
                Nre.version();
                return;
            }
            if (args.hasOption("modules")) {
                Nre.modules(args.getOption("modules"));
                return;
            }
            if (args.hasOption("hostid")) {
                Nre.hostId();
                return;
            }
            if (args.hasOption("km")) {
                Nre.initKm();
                return;
            }
            if (args.hasOption("licenses")) {
                Nre.licenses();
                return;
            }
            if (args.hasOption("props")) {
                Nre.dumpProps();
                return;
            }
            if (args.hasOption("testheap")) {
                Nre.testheap();
                return;
            }
            if (args.hasOption("buildreg")) {
                Nre.buildreg();
                return;
            }
            if (Nre.args.parameters.length < 1) {
                Nre.usage();
                return;
            }
            Nre.boot();
            Log.getLog("sys").message("Baja runtime booted (\"" + bajaHome + "\") on " + NreLib.getHostId());
            String string = args.getOption("locale");
            if (string != null) {
                Nre.setDefaultLocale(string);
            } else {
                Nre.setDefaultLocale(Locale.getDefault());
            }
            NModule nModule = null;
            String string2 = Nre.args.parameters[0];
            int n2 = string2.indexOf(58);
            if (n2 > 0) {
                stringArray2 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
                try {
                    nModule = moduleManager.loadModule((String)stringArray2);
                }
                catch (ModuleNotFoundException moduleNotFoundException) {
                    Nre.fatal("FATAL: Module not found: " + (String)stringArray2);
                }
            }
            stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            Nre.runClass(nModule, string2, stringArray2);
        }
        catch (FatalException fatalException) {
        }
        catch (Throwable throwable) {
            Log.getLog("sys").error("Cannot boot", throwable);
        }
    }

    static void runClass(NModule nModule, String string, String[] stringArray) {
        Object[] objectArray;
        if (nModule != null && (!nModule.getModuleName().equals("workbench") || !string.equals("com.tridium.workbench.shell.WbMain")) || nModule == null) {
            licenseManager.checkFeature("Tridium", "nre");
        }
        Class clazz = null;
        try {
            clazz = nModule != null ? nModule.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Nre.fatal("FATAL: Cannot find class: " + string);
        }
        launchedClass = clazz;
        Method method = null;
        try {
            Class[] classArray = new Class[1];
            Class clazz2 = array$Ljava$lang$String;
            if (clazz2 == null) {
                clazz2 = classArray[0] = (array$Ljava$lang$String = Nre.class("[Ljava.lang.String;", true));
            }
            if (!(method = clazz.getMethod("main", (Class<?>[])(objectArray = classArray))).getReturnType().equals(Void.TYPE)) {
                Nre.fatal("FATAL: Main must return void: " + string);
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                Nre.fatal("FATAL: Main must be public: " + string);
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                Nre.fatal("FATAL: Main must be static: " + string);
            }
        }
        catch (Exception exception) {
            Nre.fatal("FATAL: No main: " + string);
        }
        try {
            objectArray = new Object[]{stringArray};
            method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.getLog("sys").error("Cannot boot", invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            Log.getLog("sys").error("Cannot boot", throwable);
        }
    }

    public static void setDefaultLocale(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            String string4 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken(" \t\n\r\f").substring(1);
            }
            Nre.setDefaultLocale(new Locale(string2, string3, string4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setDefaultLocale(Locale locale) {
        Locale.setDefault(locale);
        language = Locale.getDefault().getLanguage();
    }

    public static void setDefaultTimeZone(String string) {
        try {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            if (timeZone != null && timeZone.getID().equalsIgnoreCase(string)) {
                TimeZone.setDefault(timeZone);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void dumpProps() {
        Nre.boot();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = Nre.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        Enumeration<Object> enumeration = System.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = System.getProperty(string);
            array.add((Object)(string + " = " + string2));
        }
        array = array.sort();
        int n = 0;
        while (n < array.size()) {
            System.out.println(array.get(n));
            ++n;
        }
    }

    public static boolean boot() {
        return Nre.boot(null);
    }

    public static synchronized boolean boot(BootEnv bootEnv) {
        String string;
        String string2;
        String[] stringArray;
        if (isBooted) {
            return false;
        }
        isBooted = true;
        if (bootEnv == null) {
            bootEnv = new DefaultBootEnv();
        }
        Nre.bootEnv = bootEnv;
        isRemote = bootEnv.isRemote();
        bajaHome = bootEnv.getBajaHome();
        String[] stringArray2 = stringArray = args != null ? Nre.args.parameters : new String[]{};
        if (stringArray.length >= 2 && stringArray[0].equals("com.tridium.sys.station.Station")) {
            string2 = stringArray[1];
            stationHome = userHome = new File(bajaHome, "stations" + File.separator + string2);
            isStation = true;
            hasBootClass = true;
        } else if (stringArray.length >= 1) {
            hasBootClass = true;
            string2 = System.getProperty("user.name");
            if (string2 == null) {
                string2 = "user";
            }
            if (!(userHome = new File(bajaHome, "users" + File.separator + string2)).exists()) {
                userHome.mkdirs();
            }
            Nre.buildCredentialsHome();
        }
        Nre.loadSystemProperties();
        Nre.checkSystemTimeWorkaround();
        string2 = System.getProperty("niagara.lang", null);
        if (string2 != null) {
            Nre.setDefaultLocale(string2);
        }
        if ((string = System.getProperty("niagara.timezone", null)) != null) {
            Nre.setDefaultTimeZone(string);
        }
        mainThreadGroup = Nre.findMainThreadGroup(Thread.currentThread().getThreadGroup());
        stdoutManager = new StdoutManager();
        registryManager = new NRegistry();
        schemaManager = new SchemaManager();
        moduleManager = new ModuleManager();
        engineManager = new EngineManager();
        leaseManager = new LeaseManager();
        serviceManager = new ServiceManager();
        licenseManager = NLicenseManager.make();
        stationManager = new StationManager();
        resourceManager = new ResourceManager();
        sessionManager = new NSessionManager();
        metricsRecount = new Metrics.Recount();
        Spy.ROOT.add("sysInfo", new SysInfoSpy());
        Spy.ROOT.add("stdout", new StdoutManager.SpyPage(stdoutManager));
        Spy.ROOT.add("systemProperties", new SystemPropertiesSpy());
        Spy.ROOT.add("logSetup", new LogSetupSpy());
        spySysManagers = new SpyDir();
        Spy.ROOT.add("sysManagers", spySysManagers);
        Spy.ROOT.add("util", new UtilSpy());
        Spy.ROOT.add("classLoaders", new ModuleClassLoader.LoaderSpy());
        Spy.ROOT.add("metrics", new Metrics.MetricSpy());
        stdoutManager.postInit();
        registryManager.postInit();
        schemaManager.postInit();
        moduleManager.postInit();
        engineManager.postInit();
        leaseManager.postInit();
        serviceManager.postInit();
        licenseManager.postInit();
        stationManager.postInit();
        resourceManager.postInit();
        sessionManager.postInit();
        Spy.ROOT.add("nav", new ObjectSpy(BNavRoot.INSTANCE));
        BModuleSpace.INSTANCE.getNavName();
        BFileSystem.INSTANCE.getNavName();
        BSpySpace.INSTANCE.getNavName();
        vmUuid = BUuid.make().toString();
        if (hasBootClass || isRemote) {
            Nre.loadSecurityProviders();
            String string3 = null;
            String string4 = null;
            if (isStation) {
                string3 = System.getProperty("baja.home");
                string4 = ".km";
            } else {
                string3 = isRemote ? bootEnv.getBajaHome().getPath() : System.getProperty("baja.home");
                string3 = string3 + "/workbench";
                string4 = ".wbkm";
            }
            string3 = string3 + "/security";
            Nre.loadKeyRings(string3, string4, false);
            try {
                Class clazz = Sys.loadClass("platCrypto", "com.tridium.platcrypto.spy.CryptoPlatformPage");
                if (clazz != null) {
                    Spy.ROOT.add("cryptography info", (Spy)clazz.getConstructor(null).newInstance(null));
                }
                if (stationHome == null) {
                    CertManagerFactory.getInstance();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static ThreadGroup findMainThreadGroup(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = null;
        ThreadGroup threadGroup3 = threadGroup;
        while (threadGroup3.getParent() != null) {
            if (threadGroup3.getName().equals("main")) {
                threadGroup2 = threadGroup3;
                break;
            }
            threadGroup3 = threadGroup3.getParent();
        }
        if (threadGroup2 == null) {
            threadGroup3 = threadGroup2 = threadGroup;
            while (threadGroup3.getParent() != null) {
                threadGroup2 = threadGroup3;
                threadGroup3 = threadGroup3.getParent();
            }
        }
        return threadGroup2;
    }

    static void buildCredentialsHome() {
        if (credentialsHome == null) {
            Object object;
            Object object2;
            String string = "tridium";
            try {
                object2 = MessageDigest.getInstance("SHA-1");
                object = ((MessageDigest)object2).digest(bajaHome.getCanonicalPath().getBytes());
                string = ByteArrayUtil.toHexString((byte[])object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            credentialsHome = new File(System.getProperty("user.home"), "niagara" + File.separator + "credentials" + File.separator + string);
            if (!credentialsHome.exists()) {
                File file;
                Log.getLog("sys").trace("creating user credentials directory");
                credentialsHome.mkdirs();
                object2 = System.getProperty("user.name");
                if (object2 == null) {
                    object2 = "user";
                }
                if (((File)(object = (Object)new File(bajaHome, "users" + File.separator + (String)object2))).exists() && (file = new File((File)object, "credentials.xml")).exists()) {
                    file.delete();
                }
            }
        }
    }

    static void loadSystemProperties() {
        File file = new File(bajaHome, "lib" + File.separator + "system.properties");
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (System.getProperty(string) != null && System.getProperty(NRE_PROP + string) != null) continue;
                System.getProperties().setProperty(string, properties.getProperty(string).trim());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("WARNING: Cannot load " + file + ": File not found");
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot load " + file + ": " + throwable);
        }
    }

    static void loadSecurityProviders() {
        block15: {
            EntrustProviderManager entrustProviderManager = new EntrustProviderManager();
            boolean bl = false;
            try {
                Sys.getLicenseManager().checkFeature("tridium", "fips140-2");
                if (!entrustProviderManager.verifyProviders()) {
                    throw new Exception();
                }
                bl = true;
            }
            catch (FeatureNotLicensedException featureNotLicensedException) {
                if (entrustProviderManager.verifyProviders()) {
                    Log.getLog("sys").warning("FIPS module is present but FIPS is not licensed.");
                }
            }
            catch (Exception exception) {
                Log.getLog("sys").warning("FIPS is licensed but FIPS module is not present.");
            }
            try {
                Provider[] providerArray;
                if (System.getProperty("java.vm.name").equalsIgnoreCase("J9")) {
                    providerArray = new Provider[1];
                    Class clazz = class$com$tridium$sys$Nre;
                    if (clazz == null) {
                        clazz = class$com$tridium$sys$Nre = Nre.class("[Lcom.tridium.sys.Nre;", false);
                    }
                    providerArray[0] = (Provider)Class.forName(J9_PROVIDER, false, clazz.getClassLoader()).newInstance();
                    SecurityInitializer.initialize((Provider[])providerArray, (boolean)false);
                    break block15;
                }
                if (bl) {
                    try {
                        SecurityInitializer.initialize((Provider[])entrustProviderManager.getProcessedProviders(), (boolean)true);
                        Log.getLog("sys").message("FIPS providers successfully loaded.");
                    }
                    catch (Exception exception) {
                        Log.getLog("sys").error("Error loading FIPS modules. Falling back to BouncyCastle. Cause is:");
                        exception.printStackTrace();
                        Provider[] providerArray2 = Nre.getStandardProviders();
                        SecurityInitializer.initialize((Provider[])providerArray2, (boolean)false);
                    }
                    break block15;
                }
                try {
                    providerArray = Nre.getStandardProviders();
                    SecurityInitializer.initialize((Provider[])providerArray, (boolean)false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!bootEnv.isRemote()) {
                        throw classNotFoundException;
                    }
                }
            }
            catch (Exception exception) {
                throw new SecurityException("Could not load security providers: " + exception);
            }
        }
    }

    private static final Provider[] getStandardProviders() throws Exception {
        Class clazz;
        Provider provider;
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        try {
            Class clazz2 = class$com$tridium$sys$Nre;
            if (clazz2 == null) {
                clazz2 = class$com$tridium$sys$Nre = Nre.class("[Lcom.tridium.sys.Nre;", false);
            }
            provider = (Provider)Class.forName(NIAGARA_PROVIDER, false, clazz2.getClassLoader()).newInstance();
            arrayList.add(provider);
        }
        catch (Exception exception) {
            Log.getLog("sys").warning("Could not load NiagaraBasicProvider. Cause is: " + exception);
        }
        if ((clazz = class$com$tridium$sys$Nre) == null) {
            clazz = class$com$tridium$sys$Nre = Nre.class("[Lcom.tridium.sys.Nre;", false);
        }
        provider = (Provider)Class.forName(BC_PROVIDER, false, clazz.getClassLoader()).newInstance();
        arrayList.add(provider);
        return arrayList.toArray(new Provider[arrayList.size()]);
    }

    static void loadKeyRings(String string, String string2, boolean bl) {
        try {
            if (secInfProvider == null) {
                KeyRing keyRing;
                final File file = new File(string);
                final String string3 = string2;
                if (bl) {
                    keyRing = new File(string).listFiles();
                    int n = 0;
                    while (n < ((KeyRing)keyRing).length) {
                        keyRing[n].delete();
                        ++n;
                    }
                }
                keyRing = KeyRingFactory.getInstance((File)file, (String)".kr", (String)string2).getKeyRing();
                secInfProvider = new ISecurityInfoProvider(){

                    public final KeyRing getKeyRing() {
                        return keyRing;
                    }

                    public final File getSecurityDir() {
                        return file;
                    }

                    public final String getKeyMaterialName() {
                        return string3;
                    }

                    public final String getKeyRingName() {
                        return ".kr";
                    }
                };
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to initialize key ring", exception);
        }
    }

    public static void checkSystemTimeWorkaround() {
        if ("true".equals(System.getProperty("niagara.forceTimeHighResolution", "false"))) {
            Log.getLog("sys").message("Forcing time to use 1ms resolution");
            new Thread(){

                public final void run() {
                    while (true) {
                        try {
                            Thread.sleep(Integer.MAX_VALUE);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }

                private final /* synthetic */ void this() {
                    this.setDaemon(true);
                }
                {
                    this.this();
                }
            }.start();
        }
    }

    public static ISecurityInfoProvider getSecurityInfoProvider() {
        return secInfProvider;
    }

    public static BIPlatform getPlatform() {
        if (platform == null) {
            platform = new BNullPlatform();
        }
        return platform;
    }

    public static void loadPlatform() {
        if (platform != null && !(platform instanceof BNullPlatform)) {
            return;
        }
        try {
            TypeInfo[] typeInfoArray = registryManager.getConcreteTypes(BIPlatform.TYPE.getTypeInfo());
            if (typeInfoArray.length == 1 || typeInfoArray.length > 1 && !typeInfoArray[0].equals(BNullPlatform.TYPE.getTypeInfo())) {
                platform = (BIPlatform)((Object)typeInfoArray[0].getInstance());
            } else if (typeInfoArray.length > 1 && typeInfoArray[0].equals(BNullPlatform.TYPE.getTypeInfo())) {
                platform = (BIPlatform)((Object)typeInfoArray[1].getInstance());
            }
            platform.initPlatform();
        }
        catch (Throwable throwable) {
            Log.getLog("sys").error("Cannot load platform", throwable);
            platform = new BNullPlatform();
        }
    }

    public static void clearPlatform() {
        platform = null;
    }

    public static SessionManager getSessionManager() {
        return sessionManager;
    }

    public static void version() {
        Nre.println("");
        Nre.println("Niagara Runtime Environment");
        Nre.println("  java.version:      " + System.getProperty("java.version"));
        Nre.println("  java.vendor:       " + System.getProperty("java.vendor"));
        Nre.println("  java.vm.name:      " + System.getProperty("java.vm.name"));
        Nre.println("  java.vm.version:   " + System.getProperty("java.vm.version"));
        Nre.println("  java.home:         " + System.getProperty("java.home"));
        Nre.println("  baja.home:         " + System.getProperty("baja.home"));
        Nre.println("  nre.hostId:        " + Nre.getHostId());
        Nre.println("  nre.hostModel:     " + Nre.getHostModel());
        Log.getLog("sys.registry").setSeverity(3);
        Nre.boot();
        NModule nModule = moduleManager.loadModule("baja");
        Nre.println("  nre.bajaVersion:   " + nModule.getBajaVersion());
        Nre.println("  nre.vendor:        " + nModule.getVendor());
        Nre.println("  nre.vendorVersion: " + nModule.getVendorVersion());
    }

    public static void modules(String string) {
        ModuleInfo moduleInfo;
        Nre.boot();
        if (string == null || string.length() == 0) {
            string = "*";
        }
        string = string.toLowerCase();
        PatternFilter patternFilter = new PatternFilter(string);
        ModuleInfo[] moduleInfoArray = Sys.getRegistry().getModules();
        Class clazz = class$javax$baja$registry$ModuleInfo;
        if (clazz == null) {
            clazz = class$javax$baja$registry$ModuleInfo = Nre.class("[Ljavax.baja.registry.ModuleInfo;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < moduleInfoArray.length) {
            if (patternFilter.accept(moduleInfoArray[n].getModuleName().toLowerCase())) {
                array.add((Object)moduleInfoArray[n]);
            }
            ++n;
        }
        ModuleInfo[] moduleInfoArray2 = (ModuleInfo[])array.trim();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < moduleInfoArray2.length) {
            moduleInfo = moduleInfoArray2[n4];
            n2 = Math.max(moduleInfo.getModuleName().length(), n2);
            n3 = Math.max(moduleInfo.getVendor().length(), n3);
            ++n4;
        }
        n4 = 0;
        while (n4 < moduleInfoArray2.length) {
            moduleInfo = moduleInfoArray2[n4];
            Nre.println(TextUtil.pad((String)moduleInfo.getModuleName(), (int)n2) + "  " + TextUtil.pad((String)moduleInfo.getVendor(), (int)n3) + "  " + moduleInfo.getVendorVersion());
            ++n4;
        }
    }

    public static void hostId() {
        Nre.println("HostId: " + Nre.getHostId());
    }

    public static void licenses() {
        String string = System.getProperty("baja.home");
        if (string == null) {
            System.out.println("ERROR:  baja.home not defined");
            return;
        }
        bajaHome = new File(string);
        bootEnv = new DefaultBootEnv();
        registryManager = new NRegistry();
        schemaManager = new SchemaManager();
        moduleManager = new ModuleManager();
        licenseManager = NLicenseManager.make();
        licenseManager.reload();
        licenseManager.dump();
    }

    public static void rebootLicenseManager() {
        if (!isBooted) {
            return;
        }
        licenseManager = NLicenseManager.make();
        licenseManager.postInit();
    }

    public static void buildreg() {
        NRegistry.forceRebuild = true;
        Nre.boot();
    }

    public static void initKm() throws Exception {
        if (Nre.args.parameters.length < 2) {
            throw new Exception("invalid parameters for km");
        }
        Nre.loadSecurityProviders();
        try {
            Nre.loadKeyRings(Nre.args.parameters[0], Nre.args.parameters[1], false);
        }
        catch (SecurityException securityException) {
            Nre.loadKeyRings(Nre.args.parameters[0], Nre.args.parameters[1], true);
        }
    }

    public static void testheap() {
        Nre.println("Test Heap");
        Nre.dumpheap("Start");
        byte[][] byArrayArray = new byte[1000][];
        int n = 0;
        while (n < byArrayArray.length) {
            byArrayArray[n] = new byte[0x100000];
            Nre.dumpheap("Alloc " + n + "MB");
            ++n;
        }
    }

    public static void dumpheap(String string) {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        System.out.println(string + " [Total=" + Nre.mem(l) + " Used=" + Nre.mem(l3) + ']');
    }

    public static String mem(long l) {
        if (l < 0x100000L) {
            return l / 1024L + "KB";
        }
        return l / 0x100000L + "MB";
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void print(Throwable throwable) {
        Nre.println("  " + throwable);
    }

    static void fatal(String string) {
        System.out.println(string);
        throw new FatalException();
    }

    static void fatal(String string, Throwable throwable) {
        Nre.println(string);
        if (throwable != null) {
            ThrowableUtil.dump(System.out, throwable);
        }
        throw new FatalException();
    }

    public static void dumpThreads() {
        NreLib.dumpThreads();
    }

    public static String getHostId() {
        return NreLib.getHostId();
    }

    public static String getHostModel() {
        return NreLib.getHostModel();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        credentialsHome = null;
        stationHome = null;
        language = "en";
        unitConversion = 0;
        isStation = false;
        isRemote = false;
        hasBootClass = false;
    }

    static class FatalException
    extends RuntimeException {
        FatalException() {
        }
    }
}

