/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.station.Station;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.sys.Sys;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Console
extends Thread {
    private Log log;
    private PrintWriter out;
    private BufferedReader in;
    private boolean isAlive;
    private boolean noBlock;
    private boolean ready;

    public void usage() {
        this.out.println();
        this.out.println("Niagara Runtime Environment Console");
        this.out.println("  help      Display this list of commands");
        this.out.println("  version   Display version");
        this.out.println("  save      Save the station database");
        this.out.println("  quit      Quit with orderly shutdown");
        this.out.println("  kill      Exit VM without an orderly shutdown");
        this.out.println("  threads   Produce a VM thread dump");
        this.out.println("  gc        Force a garbage collection cycle");
        this.out.println("  heap      Display heap usage");
        this.out.println();
    }

    public void save() {
        try {
            Station.saveAsync(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void quit() {
        this.log.message("Quit");
        try {
            Station.shutdown(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void kill() {
        this.log.message("Killed");
        this.out.flush();
        System.exit(0);
    }

    public void dumpThreads() {
        NreLib.dumpThreads();
    }

    public void dumpHeap() {
        long l = Runtime.getRuntime().totalMemory() / 1024L;
        long l2 = Runtime.getRuntime().freeMemory() / 1024L;
        this.out.println("totalMemory: " + l + "kb");
        this.out.println("freeMemory:  " + l2 + "kb");
        this.out.println("usedMemory:  " + (l - l2) + "kb");
    }

    public void command(String[] stringArray) throws Exception {
        String string = stringArray[0].trim().toLowerCase();
        if (string.equals("")) {
            return;
        }
        if (string.equals("version")) {
            Nre.version();
            return;
        }
        if (string.equals("save")) {
            this.save();
            return;
        }
        if (string.equals("quit")) {
            this.quit();
            return;
        }
        if (string.equals("kill")) {
            this.kill();
            return;
        }
        if (string.equals("threads")) {
            this.dumpThreads();
            return;
        }
        if (string.equals("gc")) {
            System.out.println("Running gc");
            System.gc();
            return;
        }
        if (string.equals("heap")) {
            this.dumpHeap();
            return;
        }
        if (string.equals("resetdaemon")) {
            Nre.getPlatform().resetLocalDaemonSession();
            return;
        }
        if (string.equals("syncmodules")) {
            ((NRegistry)Sys.getRegistry()).syncModules();
            return;
        }
        this.out.print("Invalid command: ");
        this.out.print(string);
        this.out.println();
        this.usage();
    }

    String[] read() {
        String string = this.readLine();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            vector.addElement("");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String readLine() {
        String string = null;
        try {
            if (this.noBlock) {
                while (this.isAlive && !this.in.ready()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.isAlive) {
                string = this.in.readLine();
            }
        }
        catch (Exception exception) {}
        if (string == null) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
            return "";
        }
        return string;
    }

    public void ready() {
        this.ready = true;
        this.prompt();
    }

    public void run() {
        while (this.isAlive) {
            try {
                if (this.ready) {
                    this.prompt();
                }
                this.command(this.read());
            }
            catch (Throwable throwable) {
                this.log.error("Command failed", throwable);
            }
        }
    }

    private final void prompt() {
        this.out.print("niagara>");
        this.out.flush();
    }

    private final /* synthetic */ void this() {
        this.log = Log.getLog("console");
        this.isAlive = true;
        this.ready = false;
    }

    public Console() {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.out));
    }

    public Console(BufferedReader bufferedReader, PrintWriter printWriter) {
        super("Nre:Console");
        this.this();
        this.in = bufferedReader;
        this.out = printWriter;
        this.noBlock = Nre.args.hasOption("daemonspawn");
    }
}

