/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dataRecovery;

import com.tridium.dataRecovery.BDataRecoveryComponentEvent;
import com.tridium.sys.Nre;
import com.tridium.util.ValueByteBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import javax.baja.agent.BIAgent;
import javax.baja.category.BCategoryMask;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.io.ByteBuffer;
import javax.baja.log.Log;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDataRecoveryComponentRecorder
extends BObject
implements BIAgent {
    public static final Type TYPE;
    public static final Context SKIP_CRITICAL_CX;
    protected static final byte[] EMPTY_DATA;
    public static final Log LOG;
    protected static final Log[] RECORD_LOGS;
    protected static final Log[] RESTORE_LOGS;
    public static final int SPY_EVENT_LIMIT;
    public static final boolean PROG_OBJ_STATS;
    protected static final Log PROG_OBJ_LOG;
    private static TypeInfo PROG_OBJ_TYPE_INFO;
    private BIDataRecoveryService service;
    public long totalProgObjEvents;
    public long progObjChangedEvents;
    public long totalProgObjDataSize;
    public long progObjChangedEventDataSize;
    static /* synthetic */ Class class$com$tridium$dataRecovery$BDataRecoveryComponentRecorder;

    public Type getType() {
        return TYPE;
    }

    public final void setDataRecoveryService(BIDataRecoveryService bIDataRecoveryService) {
        this.service = bIDataRecoveryService;
    }

    public final BIDataRecoveryService getDataRecoveryService() {
        return this.service;
    }

    public boolean isEventCritical(int n, BComplex bComplex, Slot slot, int n2, Context context) {
        int n3;
        if (this.service == null) {
            return false;
        }
        if (!this.service.isEnabled()) {
            return false;
        }
        if (context == SKIP_CRITICAL_CX) {
            return false;
        }
        if (n == 5 || n == 8 || n == 9) {
            return false;
        }
        BComponent bComponent = bComplex.getParentComponent();
        if (bComponent == null) {
            return false;
        }
        BComponentSpace bComponentSpace = bComponent.getComponentSpace();
        if (bComponentSpace == null) {
            return false;
        }
        if (slot != null && ((n2 & 2) != 0 || (n2 & 0x10000) != 0 || (n2 & 0x8000) != 0 && n == 0)) {
            return false;
        }
        BComplex bComplex2 = bComplex.getParent();
        Property property = bComplex.getPropertyInParent();
        return bComplex2 == null || property == null || ((n3 = bComplex2.getFlags(property)) & 2) == 0 && (n3 & 0x10000) == 0;
    }

    public void record(BDataRecoveryComponentEvent bDataRecoveryComponentEvent, Context context) {
        Log log = LOG;
        try {
            int n = bDataRecoveryComponentEvent.getId();
            BComplex bComplex = bDataRecoveryComponentEvent.getComplex((BObject)((Object)this.service));
            BComponent bComponent = bComplex.getParentComponent();
            BComponentSpace bComponentSpace = bComponent.getComponentSpace();
            log = RECORD_LOGS[n];
            boolean bl = log.isTraceOn();
            boolean bl2 = false;
            if (PROG_OBJ_STATS || PROG_OBJ_LOG.isTraceOn()) {
                try {
                    if (PROG_OBJ_TYPE_INFO == null) {
                        PROG_OBJ_TYPE_INFO = BTypeSpec.make("program", "Program").getTypeInfo();
                    }
                    if (bComplex.getType().is(PROG_OBJ_TYPE_INFO)) {
                        bl2 = PROG_OBJ_STATS;
                        if (PROG_OBJ_LOG.isTraceOn()) {
                            log = PROG_OBJ_LOG;
                            bl = true;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            switch (n) {
                case 0: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    ByteBuffer byteBuffer = BDataRecoveryComponentRecorder.encodeValue(bDataRecoveryComponentEvent.getValue());
                    int n2 = byteBuffer.getLength();
                    this.service.update(bComponentSpace, bDataRecoveryComponentEvent, byteBuffer.getBytes(), 0, n2);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        ++this.progObjChangedEvents;
                        int n3 = n2 + bDataRecoveryComponentEvent.getEncodingLen();
                        this.totalProgObjDataSize += (long)n3;
                        this.progObjChangedEventDataSize += (long)n3;
                    }
                    break;
                }
                case 1: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    ValueByteBuffer valueByteBuffer = ValueByteBuffer.make();
                    valueByteBuffer.writeInt(bDataRecoveryComponentEvent.getFlags());
                    valueByteBuffer.encode(bDataRecoveryComponentEvent.getFacets());
                    valueByteBuffer.encode(bDataRecoveryComponentEvent.getValue());
                    int n4 = valueByteBuffer.getLength();
                    this.service.append(bComponentSpace, bDataRecoveryComponentEvent, valueByteBuffer.getBytes(), 0, n4);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)(n4 + bDataRecoveryComponentEvent.getEncodingLen());
                    }
                    break;
                }
                case 2: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    this.service.append(bComponentSpace, bDataRecoveryComponentEvent, EMPTY_DATA);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)bDataRecoveryComponentEvent.getEncodingLen();
                    }
                    break;
                }
                case 3: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    ByteBuffer byteBuffer = BDataRecoveryComponentRecorder.encodeValue(BString.make(bDataRecoveryComponentEvent.getOldSlotName()));
                    int n5 = byteBuffer.getLength();
                    this.service.append(bComponentSpace, bDataRecoveryComponentEvent, byteBuffer.getBytes(), 0, n5);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)(n5 + bDataRecoveryComponentEvent.getEncodingLen());
                    }
                    break;
                }
                case 4: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    Property[] propertyArray = bDataRecoveryComponentEvent.getDynamicProperties();
                    int n6 = propertyArray.length;
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < n6) {
                        if (!Flags.isTransient(bComplex, propertyArray[n8])) {
                            ++n7;
                        }
                        ++n8;
                    }
                    if (n7 == 0) {
                        return;
                    }
                    ByteBuffer byteBuffer = new ByteBuffer();
                    byteBuffer.writeInt(n7);
                    n8 = 0;
                    while (n8 < n6) {
                        if (!Flags.isTransient(bComplex, propertyArray[n8])) {
                            byteBuffer.writeUTF(propertyArray[n8].getName());
                        }
                        ++n8;
                    }
                    int n9 = byteBuffer.getLength();
                    this.service.update(bComponentSpace, bDataRecoveryComponentEvent, byteBuffer.getBytes(), 0, n9);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)(n9 + bDataRecoveryComponentEvent.getEncodingLen());
                    }
                    break;
                }
                case 6: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    ByteBuffer byteBuffer = new ByteBuffer();
                    byteBuffer.writeInt(bDataRecoveryComponentEvent.getFlags());
                    int n10 = byteBuffer.getLength();
                    this.service.update(bComponentSpace, bDataRecoveryComponentEvent, byteBuffer.getBytes(), 0, n10);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)(n10 + bDataRecoveryComponentEvent.getEncodingLen());
                    }
                    break;
                }
                case 7: {
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    ByteBuffer byteBuffer = BDataRecoveryComponentRecorder.encodeValue(bDataRecoveryComponentEvent.getFacets());
                    int n11 = byteBuffer.getLength();
                    this.service.update(bComponentSpace, bDataRecoveryComponentEvent, byteBuffer.getBytes(), 0, n11);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)(n11 + bDataRecoveryComponentEvent.getEncodingLen());
                    }
                    break;
                }
                case 10: {
                    BCategoryMask bCategoryMask = bDataRecoveryComponentEvent.getCategoryMask();
                    if (bl) {
                        log.trace("Recording component event '" + bDataRecoveryComponentEvent + '\'');
                    }
                    ByteBuffer byteBuffer = BDataRecoveryComponentRecorder.encodeValue(bCategoryMask);
                    int n12 = byteBuffer.getLength();
                    this.service.update(bComponentSpace, bDataRecoveryComponentEvent, byteBuffer.getBytes(), 0, n12);
                    if (bl2) {
                        ++this.totalProgObjEvents;
                        this.totalProgObjDataSize += (long)(n12 + bDataRecoveryComponentEvent.getEncodingLen());
                    }
                    break;
                }
            }
        }
        catch (DataRecoveryServiceInFaultException dataRecoveryServiceInFaultException) {
            try {
                Nre.serviceManager.addDataRecoveryComponentRecorder(this.service, null);
            }
            catch (Throwable throwable) {}
            log.warning("DataRecoveryService in fault, could not append component event " + bDataRecoveryComponentEvent + ". Stopped data recovery component recording.", dataRecoveryServiceInFaultException);
        }
        catch (Throwable throwable) {
            log.error("DataRecoveryService could not record component event '" + bDataRecoveryComponentEvent + '\'', throwable);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean restore(BComponentSpace var1_1, IDataRecoveryRecord var2_2) throws Exception {
        var3_3 = null;
        var4_4 = BDataRecoveryComponentRecorder.LOG;
        try {
            var5_5 = var2_2.getKey();
            var6_9 = new ByteBuffer(var5_5);
            var3_3 = (BDataRecoveryComponentEvent)BDataRecoveryComponentEvent.DEFAULT.decode(var6_9);
            var7_10 = var2_2.getData();
            var8_11 = var3_3.getComplex(var1_1);
            var9_12 = var3_3.getId();
            var4_4 = BDataRecoveryComponentRecorder.RESTORE_LOGS[var9_12];
            if (BDataRecoveryComponentRecorder.PROG_OBJ_LOG.isTraceOn()) {
                try {
                    if (BDataRecoveryComponentRecorder.PROG_OBJ_TYPE_INFO == null) {
                        BDataRecoveryComponentRecorder.PROG_OBJ_TYPE_INFO = BTypeSpec.make("program", "Program").getTypeInfo();
                    }
                    if (var8_11.getType().is(BDataRecoveryComponentRecorder.PROG_OBJ_TYPE_INFO)) {
                        var4_4 = BDataRecoveryComponentRecorder.PROG_OBJ_LOG;
                    }
                }
                catch (Exception v0) {}
            }
            switch (var3_3.getId()) {
                case 0: {
                    var10_13 = BDataRecoveryComponentRecorder.decodeValue(var7_10);
                    if (var4_4.isTraceOn()) {
                        var11_15 = new StringBuffer();
                        var11_15.append("Restoring component event '");
                        var11_15.append(var3_3.toString(null));
                        var11_15.append(" val=").append(var10_13.toString(null)).append("'");
                        var4_4.trace(var11_15.toString());
                    }
                    var8_11.set(var3_3.getSlotName(), var10_13);
                    break;
                }
                case 1: {
                    var11_16 = ValueByteBuffer.make(var7_10);
                    var12_17 = var11_16.readInt();
                    var13_19 = (BFacets)var11_16.decode();
                    var10_14 = (BValue)var11_16.decode();
                    if (var4_4.isTraceOn()) {
                        var14_21 = new StringBuffer();
                        var14_21.append("Restoring component event '");
                        var14_21.append(var3_3.toString(null));
                        var14_21.append(" val=").append(var10_14.toString(null));
                        var14_21.append(" flags=").append(Flags.toDisplayString(var12_17, null));
                        var14_21.append(" facets=").append(var13_19.toString(null)).append("'");
                        var4_4.trace(var14_21.toString());
                    }
                    var8_11.asComponent().add(var3_3.getSlotName(), var10_14, var12_17, var13_19, null);
                    break;
                }
                case 2: {
                    if (var4_4.isTraceOn()) {
                        var14_22 = new StringBuffer();
                        var14_22.append("Restoring component event '");
                        var14_22.append(var3_3.toString(null)).append("'");
                        var4_4.trace(var14_22.toString());
                    }
                    var8_11.asComponent().remove(var3_3.getSlotName());
                    break;
                }
                case 3: {
                    var14_23 = ((BString)BDataRecoveryComponentRecorder.decodeValue(var7_10)).getString();
                    if (var4_4.isTraceOn()) {
                        var15_24 = new StringBuffer();
                        var15_24.append("Restoring component event '");
                        var15_24.append(var3_3.toString(null));
                        var15_24.append(" oldSlotName=").append(var14_23).append("'");
                        var4_4.trace(var15_24.toString());
                    }
                    var8_11.asComponent().rename(var8_11.getProperty(var14_23), var3_3.getSlotName());
                    break;
                }
                case 4: {
                    var15_25 = new ByteBuffer(var7_10);
                    var16_27 = var15_25.readInt();
                    var17_28 = new Property[var16_27];
                    var18_29 = 0;
                    while (var18_29 < var16_27) {
                        var17_28[var18_29] = var8_11.getProperty(var15_25.readUTF());
                        ++var18_29;
                    }
                    if (var4_4.isTraceOn()) {
                        var18_30 = new StringBuffer();
                        var18_30.append("Restoring component event '");
                        var18_30.append(var3_3.toString(null));
                        var18_30.append(" props=").append(new Array(var17_28).toString()).append("'");
                        var4_4.trace(var18_30.toString());
                    }
                    var8_11.asComponent().reorder((Property[])var17_28);
                    break;
                }
                case 6: {
                    var15_26 = new ByteBuffer(var7_10);
                    var12_18 = var15_26.readInt();
                    var18_31 = var8_11.getSlot(var3_3.getSlotName());
                    if ((var12_18 & 32768) == 0) ** GOTO lbl120
                    var19_32 = false;
                    try {
                        var20_36 = var8_11.asComponent().getLinks(var18_31);
                        v1 = 0;
                        if (var20_36 != null) {
                            v1 = var20_36.length;
                        }
                        var21_38 = v1;
                        var22_39 = 0;
                        while (var22_39 < var21_38) {
                            if (!var20_36[var22_39].isActive()) ** GOTO lbl114
                            var19_32 = true;
                            break;
lbl114:
                            // 1 sources

                            ++var22_39;
                        }
                    }
                    catch (Throwable v2) {}
                    if (!var19_32) {
                        var12_18 &= -32769;
                    }
lbl120:
                    // 4 sources

                    if (var4_4.isTraceOn()) {
                        var19_33 = new StringBuffer();
                        var19_33.append("Restoring component event '");
                        var19_33.append(var3_3.toString(null));
                        var19_33.append(" flags=").append(Flags.toDisplayString(var12_18, null)).append("'");
                        var4_4.trace(var19_33.toString());
                    }
                    var8_11.setFlags(var18_31, var12_18);
                    break;
                }
                case 7: {
                    var13_20 = (BFacets)BDataRecoveryComponentRecorder.decodeValue(var7_10);
                    if (var4_4.isTraceOn()) {
                        var19_34 = new StringBuffer();
                        var19_34.append("Restoring component event '");
                        var19_34.append(var3_3.toString(null));
                        var19_34.append(" facets=").append(var13_20.toString(null)).append("'");
                        var4_4.trace(var19_34.toString());
                    }
                    var8_11.asComponent().setFacets(var8_11.getSlot(var3_3.getSlotName()), var13_20);
                    break;
                }
                case 10: {
                    var19_35 = (BCategoryMask)BDataRecoveryComponentRecorder.decodeValue(var7_10);
                    if (var4_4.isTraceOn()) {
                        var20_37 = new StringBuffer();
                        var20_37.append("Restoring component event '");
                        var20_37.append(var3_3.toString(null));
                        var20_37.append(" mask=").append(var19_35.toString(null)).append("'");
                        var4_4.trace(var20_37.toString());
                    }
                    var8_11.asComponent().setCategoryMask(var19_35, null);
                    break;
                }
                default: {
                    var4_4.error("DataRecoveryService could not restore unexpected component event '" + var3_3 + '\'');
                    return false;
                }
            }
        }
        catch (UnresolvedException var5_6) {
            if (var4_4.isTraceOn()) {
                var4_4.trace("DataRecoveryService could not restore component event '" + var3_3 + '\'', var5_6);
            }
        }
        catch (DuplicateSlotException var5_7) {
            if (var4_4.isTraceOn()) {
                var4_4.trace("DataRecoveryService could not restore component event '" + var3_3 + '\'', var5_7);
            }
        }
        catch (Exception var5_8) {
            var4_4.error("DataRecoveryService could not restore component event '" + var3_3 + '\'', var5_8);
            throw var5_8;
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dataRecoverySpy(BComponentSpace bComponentSpace, SpyWriter spyWriter, Iterator iterator) throws Exception {
        Object object;
        int n;
        Object[] objectArray;
        if (PROG_OBJ_STATS) {
            spyWriter.startProps("Program Object Data Recovery Statistics");
            spyWriter.prop((Object)"Records Generated", new Long(this.totalProgObjEvents));
            spyWriter.prop((Object)"Data Generated", new Long(this.totalProgObjDataSize));
            double d = this.totalProgObjEvents > 0L ? (double)this.totalProgObjDataSize / (double)this.totalProgObjEvents : 0.0;
            spyWriter.prop((Object)"Average Record Size", new Double(d));
            spyWriter.prop((Object)"Change Events Generated", new Long(this.progObjChangedEvents));
            spyWriter.prop((Object)"Change Data Generated", new Long(this.progObjChangedEventDataSize));
            d = this.progObjChangedEvents > 0L ? (double)this.progObjChangedEventDataSize / (double)this.progObjChangedEvents : 0.0;
            spyWriter.prop((Object)"Average Change Event Size", new Double(d));
            spyWriter.endProps();
        }
        Hashtable<BDataRecoveryComponentEvent, DataRecoverySpyStat> hashtable = new Hashtable<BDataRecoveryComponentEvent, DataRecoverySpyStat>();
        int n2 = 0;
        int n3 = 0;
        while (true) {
            Object var8_8;
            if (!iterator.hasNext()) {
                if (n3 <= 0) return;
                objectArray = new DataRecoverySpyStat[n3];
                objectArray = hashtable.values().toArray(objectArray);
                SortUtil.rsort((Object[])objectArray);
                n = objectArray.length;
                object = n2 + " Component Events Recently Recorded in Data Recovery";
                if (n > SPY_EVENT_LIMIT) {
                    n = SPY_EVENT_LIMIT;
                    object = (String)object + " (truncated to " + n + " rows)";
                }
                break;
            }
            try {
                try {
                    object = (IDataRecoveryRecord)iterator.next();
                    byte[] byArray = object.getKey();
                    ByteBuffer byteBuffer = new ByteBuffer(byArray);
                    BDataRecoveryComponentEvent bDataRecoveryComponentEvent = (BDataRecoveryComponentEvent)BDataRecoveryComponentEvent.DEFAULT.decode(byteBuffer);
                    bDataRecoveryComponentEvent.getComplex(bComponentSpace);
                    byte[] byArray2 = object.getData();
                    int n4 = byArray2 != null ? byArray.length + byArray2.length : byArray.length;
                    DataRecoverySpyStat dataRecoverySpyStat = (DataRecoverySpyStat)hashtable.get(bDataRecoveryComponentEvent);
                    if (dataRecoverySpyStat == null) {
                        dataRecoverySpyStat = new DataRecoverySpyStat();
                        hashtable.put(bDataRecoveryComponentEvent, dataRecoverySpyStat);
                        ++n3;
                    }
                    dataRecoverySpyStat.event = bDataRecoveryComponentEvent;
                    ++dataRecoverySpyStat.occurrences;
                    dataRecoverySpyStat.totalSize += n4;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                ++n2;
                throw throwable;
            }
            {
                var8_8 = null;
                ++n2;
                continue;
            }
            break;
        }
        spyWriter.startTable(true);
        spyWriter.trTitle(object, 4);
        spyWriter.w("<tr><th>Occurrences</th><th>Total Bytes</th><th>Avg Bytes</th><th>Component Event</th></tr>\n");
        int n5 = 0;
        while (true) {
            if (n5 >= n) {
                spyWriter.endTable();
                return;
            }
            double d = (double)((DataRecoverySpyStat)objectArray[n5]).totalSize / (double)((DataRecoverySpyStat)objectArray[n5]).occurrences;
            spyWriter.tr("" + ((DataRecoverySpyStat)objectArray[n5]).occurrences, "" + ((DataRecoverySpyStat)objectArray[n5]).totalSize, "" + d, ((DataRecoverySpyStat)objectArray[n5]).event.toString(null));
            ++n5;
        }
    }

    static ByteBuffer encodeValue(BValue bValue) throws Exception {
        ValueByteBuffer valueByteBuffer = ValueByteBuffer.make();
        valueByteBuffer.setEncodeContext(Context.encrypt);
        valueByteBuffer.encode(bValue);
        return valueByteBuffer;
    }

    static BValue decodeValue(byte[] byArray) throws Exception {
        ValueByteBuffer valueByteBuffer = ValueByteBuffer.make(byArray);
        valueByteBuffer.setEncodeContext(Context.encrypt);
        return (BValue)valueByteBuffer.decode();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.totalProgObjEvents = 0L;
        this.progObjChangedEvents = 0L;
        this.totalProgObjDataSize = 0L;
        this.progObjChangedEventDataSize = 0L;
    }

    public BDataRecoveryComponentRecorder() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dataRecovery$BDataRecoveryComponentRecorder;
        if (clazz == null) {
            clazz = class$com$tridium$dataRecovery$BDataRecoveryComponentRecorder = BDataRecoveryComponentRecorder.class("[Lcom.tridium.dataRecovery.BDataRecoveryComponentRecorder;", false);
        }
        TYPE = Sys.loadType(clazz);
        SKIP_CRITICAL_CX = new BasicContext(){

            public final boolean equals(Object object) {
                boolean bl = false;
                if (this == object) {
                    bl = true;
                }
                return bl;
            }

            public final String toString() {
                return "Context.skipDataRecovery";
            }
        };
        EMPTY_DATA = new byte[0];
        LOG = Log.getLog("sys.dataRecovery");
        RECORD_LOGS = new Log[]{Log.getLog("sys.dataRecovery.save.change"), Log.getLog("sys.dataRecovery.save.add"), Log.getLog("sys.dataRecovery.save.remove"), Log.getLog("sys.dataRecovery.save.rename"), Log.getLog("sys.dataRecovery.save.reorder"), LOG, Log.getLog("sys.dataRecovery.save.flagsChange"), Log.getLog("sys.dataRecovery.save.facetsChange"), LOG, LOG, Log.getLog("sys.dataRecovery.save.recategorize")};
        RESTORE_LOGS = new Log[]{Log.getLog("sys.dataRecovery.load.change"), Log.getLog("sys.dataRecovery.load.add"), Log.getLog("sys.dataRecovery.load.remove"), Log.getLog("sys.dataRecovery.load.rename"), Log.getLog("sys.dataRecovery.load.reorder"), LOG, Log.getLog("sys.dataRecovery.load.flagsChange"), Log.getLog("sys.dataRecovery.load.facetsChange"), LOG, LOG, Log.getLog("sys.dataRecovery.load.recategorize")};
        SPY_EVENT_LIMIT = Integer.getInteger("sys.dataRecovery.spy.limit", 200);
        PROG_OBJ_STATS = Boolean.getBoolean("sys.dataRecovery.progObjStats");
        PROG_OBJ_LOG = Log.getLog("sys.dataRecovery.progObj");
        PROG_OBJ_TYPE_INFO = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class DataRecoverySpyStat
    implements Comparable {
        BDataRecoveryComponentEvent event;
        int occurrences;
        int totalSize;

        public int compareTo(Object object) {
            DataRecoverySpyStat dataRecoverySpyStat = (DataRecoverySpyStat)object;
            int n = this.occurrences - dataRecoverySpyStat.occurrences;
            if (n == 0) {
                return 0;
            }
            if (n < 0) {
                return -1;
            }
            return 1;
        }

        private final /* synthetic */ void this() {
            this.occurrences = 0;
            this.totalSize = 0;
        }

        DataRecoverySpyStat() {
            this.this();
        }
    }
}

