/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dataRecovery;

import com.tridium.sys.schema.NSlot;
import com.tridium.util.ArrayUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIEncodable;
import javax.baja.io.ByteBuffer;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Base64;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDataRecoveryComponentEvent
extends BObject
implements BIEncodable {
    public static final Type TYPE;
    public static final BDataRecoveryComponentEvent DEFAULT;
    protected static String[] ID_STRINGS;
    private int eventId;
    private int[] slotIndex;
    private String slotName;
    private BComplex comp;
    private BOrd ord;
    private int hashCode;
    private BValue value;
    private int flags;
    private BFacets facets;
    private String oldSlotName;
    private Property[] properties;
    private BCategoryMask oldMask;
    static /* synthetic */ Class class$com$tridium$dataRecovery$BDataRecoveryComponentEvent;

    public static final BDataRecoveryComponentEvent makeChangeEvent(BComponent bComponent, Slot slot, BValue bValue) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 0;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.slotName = slot.getName();
        if (slot.isFrozen()) {
            try {
                int n = ((NSlot)slot).index;
                bDataRecoveryComponentEvent.slotIndex = new int[1];
                bDataRecoveryComponentEvent.slotIndex[0] = n;
            }
            catch (Throwable throwable) {}
        }
        bDataRecoveryComponentEvent.value = bValue;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeChangeEvent(BComplex bComplex, BOrd bOrd, int[] nArray, Slot slot, BValue bValue) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 0;
        bDataRecoveryComponentEvent.comp = bComplex;
        bDataRecoveryComponentEvent.slotIndex = nArray;
        bDataRecoveryComponentEvent.ord = bOrd;
        bDataRecoveryComponentEvent.slotName = slot.getName();
        bDataRecoveryComponentEvent.value = bValue;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeAddEvent(BComponent bComponent, String string, BValue bValue, int n, BFacets bFacets) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 1;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.slotName = string;
        bDataRecoveryComponentEvent.value = bValue;
        bDataRecoveryComponentEvent.flags = n;
        bDataRecoveryComponentEvent.facets = bFacets;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeRemoveEvent(BComponent bComponent, String string) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 2;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.slotName = string;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeRenameEvent(BComponent bComponent, String string, String string2) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 3;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.slotName = string2;
        bDataRecoveryComponentEvent.oldSlotName = string;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeReorderEvent(BComponent bComponent, Property[] propertyArray) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 4;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.properties = propertyArray;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeFlagsChangeEvent(BComponent bComponent, String string, int n) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 6;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.slotName = string;
        bDataRecoveryComponentEvent.flags = n;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeFacetsChangeEvent(BComponent bComponent, String string, BFacets bFacets) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 7;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.slotName = string;
        bDataRecoveryComponentEvent.facets = bFacets;
        return bDataRecoveryComponentEvent;
    }

    public static final BDataRecoveryComponentEvent makeRecategorizeEvent(BComponent bComponent, BCategoryMask bCategoryMask, BCategoryMask bCategoryMask2) {
        BDataRecoveryComponentEvent bDataRecoveryComponentEvent = new BDataRecoveryComponentEvent();
        bDataRecoveryComponentEvent.eventId = 10;
        bDataRecoveryComponentEvent.comp = bComponent;
        bDataRecoveryComponentEvent.ord = bComponent.getOrdInSpace();
        bDataRecoveryComponentEvent.value = bCategoryMask;
        bDataRecoveryComponentEvent.oldMask = bCategoryMask2;
        return bDataRecoveryComponentEvent;
    }

    public int getId() {
        return this.eventId;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public BComponent getComponent(BObject bObject) {
        return this.getComplex(bObject).asComponent();
    }

    public BComplex getComplex(BObject bObject) {
        if (this.comp != null) {
            return this.comp;
        }
        this.comp = (BComplex)this.ord.get(bObject);
        if (this.slotIndex != null) {
            SlotCursor slotCursor;
            int n = this.slotIndex.length;
            int n2 = 0;
            while (n2 < n - 1) {
                slotCursor = this.comp.getSlots();
                boolean bl = false;
                while (slotCursor.next()) {
                    Slot slot = slotCursor.slot();
                    if (!slot.isFrozen() || ((NSlot)slot).index != this.slotIndex[n2]) continue;
                    this.comp = slotCursor.get().asComplex();
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new IllegalStateException("Could not retrieve complex.");
                }
                ++n2;
            }
            n2 = this.slotIndex[n - 1];
            if (this.slotName == null && n2 != -1) {
                slotCursor = this.comp.getSlots();
                while (slotCursor.next()) {
                    Slot slot = slotCursor.slot();
                    if (!slot.isFrozen()) continue;
                    try {
                        if (((NSlot)slot).index != n2) continue;
                        this.slotName = slot.getName();
                        break;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return this.comp;
    }

    public BValue getValue() {
        return this.value;
    }

    public int getFlags() {
        return this.flags;
    }

    public BFacets getFacets() {
        return this.facets;
    }

    public String getOldSlotName() {
        return this.oldSlotName;
    }

    public Property[] getDynamicProperties() {
        return this.properties;
    }

    public BCategoryMask getCategoryMask() {
        return (BCategoryMask)this.value;
    }

    public BCategoryMask getOldCategoryMask() {
        return this.oldMask;
    }

    public String toString(Context context) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ID_STRINGS[this.eventId]).append(" ");
        if (this.comp instanceof BComponent) {
            stringBuffer.append(((BComponent)this.comp).toDisplayPathString(context));
        } else if ((this.comp == null || this.slotIndex == null) && this.ord != null) {
            stringBuffer.append(this.ord.toString());
        }
        int n2 = 0;
        if (this.slotIndex != null) {
            n2 = this.slotIndex.length;
            if (this.comp != null) {
                BComplex bComplex;
                n = this.slotName != null ? n2 - 1 : n2;
                BComponent bComponent = this.comp.getParentComponent();
                stringBuffer.append(bComponent.toDisplayPathString(context));
                BComplex bComplex2 = bComplex = (BComplex)this.ord.get(bComponent);
                int n3 = stringBuffer.length();
                while (bComplex2 != null && bComponent != bComplex2) {
                    stringBuffer.insert(n3, '/');
                    stringBuffer.insert(n3 + 1, SlotPath.unescape(bComplex2.getPropertyInParent().getName()));
                    bComplex2 = bComplex2.getParent();
                }
                int n4 = 0;
                while (n4 < n) {
                    SlotCursor slotCursor = bComplex.getSlots();
                    boolean bl = false;
                    while (slotCursor.next()) {
                        Slot slot = slotCursor.slot();
                        if (!slot.isFrozen() || ((NSlot)slot).index != this.slotIndex[n4]) continue;
                        stringBuffer.append('/').append(SlotPath.unescape(slot.getName()));
                        if (n4 != n - 1) {
                            bComplex = slotCursor.get().asComplex();
                        }
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        throw new IllegalStateException("Invalid slot index " + this.slotIndex[n4]);
                    }
                    ++n4;
                }
            }
        }
        if (this.slotName != null) {
            stringBuffer.append("/").append(SlotPath.unescape(this.slotName));
        }
        if (n2 > 0) {
            stringBuffer.append("[");
            n = 0;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.slotIndex[n]);
                ++n;
            }
            stringBuffer.append("]");
        }
        if (this.value != null) {
            stringBuffer.append(", ").append(this.value.toString(context));
        }
        if (this.flags != -1) {
            stringBuffer.append(", flags={").append(Flags.toDisplayString(this.flags, context)).append("}");
        }
        if (this.facets != null) {
            stringBuffer.append(", facets={").append(this.facets.toString(context)).append("}");
        }
        if (this.oldSlotName != null) {
            stringBuffer.append(", oldSlotName=").append(this.oldSlotName);
        }
        if (this.oldMask != null) {
            stringBuffer.append(", oldMask=").append(this.oldMask);
        }
        if (this.properties != null) {
            stringBuffer.append(": {");
            n = 0;
            while (n < this.properties.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.properties[n].getName());
                ++n;
            }
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n = 11;
            n ^= this.eventId;
            if (this.ord != null) {
                n ^= this.ord.hashCode();
            }
            if (this.slotName != null) {
                n ^= this.slotName.hashCode();
            }
            if (this.slotIndex != null) {
                int n2 = 0;
                while (n2 < this.slotIndex.length) {
                    n ^= this.slotIndex[n2];
                    ++n2;
                }
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof BDataRecoveryComponentEvent) {
            BDataRecoveryComponentEvent bDataRecoveryComponentEvent = (BDataRecoveryComponentEvent)object;
            boolean bl = false;
            if (this.eventId == bDataRecoveryComponentEvent.eventId && (this.ord == bDataRecoveryComponentEvent.ord || this.ord != null && this.ord.equals(bDataRecoveryComponentEvent.ord)) && Arrays.equals(this.slotIndex, bDataRecoveryComponentEvent.slotIndex) && (this.slotName == bDataRecoveryComponentEvent.slotName || this.slotName != null && this.slotName.equals(bDataRecoveryComponentEvent.slotName))) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void encode(DataOutput dataOutput) throws IOException {
        int n;
        dataOutput.writeByte(this.eventId);
        this.ord.encode(dataOutput);
        int n2 = 0;
        if (this.slotIndex != null) {
            n2 = this.slotIndex.length;
        }
        int n3 = n2;
        boolean bl = false;
        if (n3 > 0) {
            if (n3 == 1 && this.slotIndex[0] == -1) {
                dataOutput.writeBoolean(false);
            } else {
                bl = true;
                dataOutput.writeBoolean(true);
                n = 0;
                while (n < n3) {
                    dataOutput.writeBoolean(true);
                    dataOutput.writeInt(this.slotIndex[n]);
                    ++n;
                }
                dataOutput.writeBoolean(false);
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        int n4 = 0;
        if (!bl && this.slotName != null) {
            n4 = 1;
        }
        n = n4;
        dataOutput.writeBoolean(n != 0);
        if (n != 0) {
            dataOutput.writeUTF(this.slotName);
        }
    }

    public BObject decode(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        BOrd bOrd = (BOrd)BOrd.DEFAULT.decode(dataInput);
        int[] nArray = null;
        if (dataInput.readBoolean()) {
            int n = 1;
            int n2 = 0;
            int[] nArray2 = new int[n];
            while (dataInput.readBoolean()) {
                if (n2 >= n) {
                    n += Math.min(n, 10);
                    nArray2 = ArrayUtil.grow(nArray2, n);
                }
                nArray2[n2] = dataInput.readInt();
                ++n2;
            }
            if (n2 != n) {
                nArray = new int[n2];
                System.arraycopy(nArray2, 0, nArray, 0, n2);
            } else {
                nArray = nArray2;
            }
        }
        String string = null;
        if (dataInput.readBoolean()) {
            string = dataInput.readUTF();
        }
        return new BDataRecoveryComponentEvent(by, string, nArray, bOrd);
    }

    public String encodeToString() throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer();
        this.encode(byteBuffer);
        return Base64.encode((byte[])byteBuffer.toByteArray());
    }

    public BObject decodeFromString(String string) throws IOException {
        ByteBuffer byteBuffer = new ByteBuffer(Base64.decode((String)string));
        return this.decode(byteBuffer);
    }

    int getEncodingLen() {
        int n = 3 + this.numBytesToEncode(this.ord.encodeToString());
        int n2 = 0;
        if (this.slotIndex != null) {
            n2 = this.slotIndex.length;
        }
        int n3 = n2;
        boolean bl = false;
        if (n3 > 0 && (n3 != 1 || this.slotIndex[0] != -1)) {
            bl = true;
            n += 5 * n3 + 1;
        }
        if (!bl && this.slotName != null) {
            n += this.numBytesToEncode(this.slotName);
        }
        return n;
    }

    private final int numBytesToEncode(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        if (n2 > (int)-1) {
            return 0;
        }
        return n2 + 2;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.slotIndex = null;
        this.slotName = null;
        this.comp = null;
        this.ord = null;
        this.hashCode = -1;
        this.value = null;
        this.flags = -1;
        this.facets = null;
        this.oldSlotName = null;
        this.properties = null;
        this.oldMask = null;
    }

    private BDataRecoveryComponentEvent(int n, String string, int[] nArray, BOrd bOrd) {
        this.this();
        this.eventId = n;
        this.slotName = string;
        this.slotIndex = nArray;
        this.ord = bOrd;
    }

    private BDataRecoveryComponentEvent() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dataRecovery$BDataRecoveryComponentEvent;
        if (clazz == null) {
            clazz = class$com$tridium$dataRecovery$BDataRecoveryComponentEvent = BDataRecoveryComponentEvent.class("[Lcom.tridium.dataRecovery.BDataRecoveryComponentEvent;", false);
        }
        TYPE = Sys.loadType(clazz);
        DEFAULT = new BDataRecoveryComponentEvent();
        ID_STRINGS = new String[]{"changed", "added", "removed", "renamed", "reordered", "topicFired", "flagsChanged", "facetsChanged", "knobAdded", "knobRemoved", "recategorized"};
    }
}

