/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.asm;

import com.tridium.asm.Assembler;
import com.tridium.asm.AttributeInfo;
import com.tridium.asm.Buffer;
import com.tridium.asm.ConstantPool;
import com.tridium.asm.Jvm;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Code
extends AttributeInfo {
    public final ConstantPool cp;
    public int maxStack;
    public int maxLocals;
    public Buffer code;

    public int add(int n) {
        if (Jvm.OPCODE_ARGS[n] != 0) {
            throw new IllegalStateException("Opcode requires arguments: " + n);
        }
        return this.code.u1(n);
    }

    public int add(int n, int n2) {
        int n3 = this.code.count;
        if (n == 18) {
            if (n2 < 255) {
                this.code.u1(18);
                this.code.u1(n2);
            } else {
                this.code.u1(19);
                this.code.u2(n2);
            }
            return n3;
        }
        byte by = Jvm.OPCODE_ARGS[n];
        this.code.u1(n);
        if (by == 1) {
            this.code.u1(n2);
        } else if (by == 2) {
            this.code.u2(n2);
        } else {
            throw new IllegalStateException("Opcode does not take u1 or u2 args: " + n);
        }
        return n3;
    }

    public int addIntConst(int n) {
        switch (n) {
            case -1: {
                return this.add(2);
            }
            case 0: {
                return this.add(3);
            }
            case 1: {
                return this.add(4);
            }
            case 2: {
                return this.add(5);
            }
            case 3: {
                return this.add(6);
            }
            case 4: {
                return this.add(7);
            }
            case 5: {
                return this.add(8);
            }
        }
        if (-128 <= n && n <= 127) {
            return this.add(16, n);
        }
        if (Short.MIN_VALUE <= n && n <= Short.MAX_VALUE) {
            return this.add(17, n);
        }
        return this.add(18, this.cp.integer(n));
    }

    public int addPad(int n) {
        int n2 = this.code.u1(n);
        int n3 = 3 - n2 % 4;
        int n4 = 0;
        while (n4 < n3) {
            this.code.u1(0);
            ++n4;
        }
        return n2;
    }

    public int invoke(Method method) {
        int n = this.cp.method(method);
        int n2 = method.getModifiers();
        if (Modifier.isInterface(n2)) {
            return this.invokeInterface(n, method.getParameterTypes().length + 1);
        }
        if (Modifier.isStatic(n2)) {
            return this.add(184, n);
        }
        return this.add(182, n);
    }

    public int invokeInterface(int n, int n2) {
        int n3 = this.code.count;
        this.code.u1(185);
        this.code.u2(n);
        this.code.u1(n2);
        this.code.u1(0);
        return n3;
    }

    void compile(Buffer buffer) {
        int n = 8 + this.code.count + 4;
        buffer.u2(this.name);
        buffer.u4(n);
        buffer.u2(this.maxStack);
        buffer.u2(this.maxLocals);
        buffer.u4(this.code.count);
        buffer.append(this.code);
        buffer.u2(0);
        buffer.u2(0);
    }

    private final /* synthetic */ void this() {
        this.maxStack = 10;
        this.maxLocals = 10;
        this.code = new Buffer(512);
    }

    public Code(Assembler assembler) {
        super(assembler, "Code");
        this.this();
        this.cp = assembler.cp;
    }
}

