/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.stack;

import com.tridium.eibnetIp.BEibnetIpDevice;
import com.tridium.eibnetIp.BEibnetIpNetwork;
import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.datatypes.ConnectionHeader;
import com.tridium.eibnetIp.messages.CEmiMessage;
import com.tridium.eibnetIp.messages.LDataCon;
import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.point.BKnxProxyExt;
import java.io.IOException;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEibnetIpTunnelLayer
extends BComponent
implements EibnetConst {
    public static final Property confirmationTimeout = BEibnetIpTunnelLayer.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.MINUTE)));
    public static final Type TYPE;
    private static final Log log;
    Object tunnelSendMonitor;
    boolean isConfirmed;
    static /* synthetic */ Class class$com$tridium$eibnetIp$stack$BEibnetIpTunnelLayer;

    public BRelTime getConfirmationTimeout() {
        return (BRelTime)this.get(confirmationTimeout);
    }

    public void setConfirmationTimeout(BRelTime bRelTime) {
        this.set(confirmationTimeout, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BEibnetIpNetwork network() {
        return (BEibnetIpNetwork)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean sendTunnelRequest(BEibnetIpDevice bEibnetIpDevice, LDataReq lDataReq) {
        if (!bEibnetIpDevice.getEnabled()) {
            return false;
        }
        Object object = this.tunnelSendMonitor;
        synchronized (object) {
            block10: {
                this.isConfirmed = false;
                if (!bEibnetIpDevice.isConnected()) break block10;
                try {
                    int n = bEibnetIpDevice.getTunnelSendCounter();
                    int n2 = 0;
                    while (n2 < 2) {
                        this.network().getLinkLayer().sendTunnelRequest(bEibnetIpDevice, lDataReq, n);
                        this.tunnelSendMonitor.wait(this.getConfirmationTimeout().getMillis());
                        if (this.isConfirmed) {
                            bEibnetIpDevice.setTimeOfLastMessage();
                            break;
                        }
                        bEibnetIpDevice.doKeepAlive();
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return false;
                }
                catch (NotRunningException notRunningException) {
                    notRunningException.printStackTrace();
                    return false;
                }
            }
            return this.isConfirmed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processTunnelingResponse(BEibnetIpDevice bEibnetIpDevice, byte[] byArray) {
        CEmiMessage cEmiMessage = CEmiMessage.fromBytes(byArray);
        if (cEmiMessage == null) {
            log.error("attempt to process null tunnel response!");
            return;
        }
        if (cEmiMessage instanceof LDataReq) {
            if (this.network().getLinkLayer().getTelegramTrace()) {
                log.trace("rx " + cEmiMessage);
            }
            log.error("cannot respond to incoming LDataReq messages:" + ByteArrayUtil.toHexString((byte[])byArray));
            return;
        }
        if (cEmiMessage instanceof LDataCon) {
            LDataCon lDataCon = (LDataCon)cEmiMessage;
            if (this.network().getLinkLayer().getTelegramTrace()) {
                log.trace("rx " + lDataCon);
            }
            Object object = this.tunnelSendMonitor;
            synchronized (object) {
                this.isConfirmed = lDataCon.isConfirmError() ^ true;
                this.tunnelSendMonitor.notifyAll();
                return;
            }
        }
        if (cEmiMessage instanceof LDataInd) {
            Vector vector;
            LDataInd lDataInd = (LDataInd)cEmiMessage;
            if (this.network().getLinkLayer().getTelegramTrace()) {
                log.trace("rx " + lDataInd);
            }
            if ((vector = (Vector)bEibnetIpDevice.getGroupAddressMap().get(cEmiMessage.getDestination().toInteger())) != null) {
                int n = 0;
                while (n < vector.size()) {
                    BKnxProxyExt bKnxProxyExt = (BKnxProxyExt)vector.elementAt(n);
                    bKnxProxyExt.setValue(lDataInd);
                    ++n;
                }
            }
        }
    }

    public void processTunnelingAck(ConnectionHeader connectionHeader, BEibnetIpDevice bEibnetIpDevice) {
        if (connectionHeader.getStatus() == 0 && connectionHeader.getSequenceCounter() == bEibnetIpDevice.getTunnelSendCounter()) {
            bEibnetIpDevice.incrementTunnelSendCounter();
        }
    }

    public void processTunnelingAck(int n) {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tunnelSendMonitor = new Object();
    }

    public BEibnetIpTunnelLayer() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$stack$BEibnetIpTunnelLayer;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$stack$BEibnetIpTunnelLayer = BEibnetIpTunnelLayer.class("[Lcom.tridium.eibnetIp.stack.BEibnetIpTunnelLayer;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"eibnetIp");
    }
}

