/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.point;

import com.tridium.eibnetIp.datatypes.BKnxTime;
import com.tridium.eibnetIp.enums.BKnxWeekdayEnum;
import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.point.BKnxProxyExt;
import com.tridium.eibnetIp.util.EibUtil;
import java.io.UnsupportedEncodingException;
import javax.baja.control.BStringPoint;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BKnxStringProxyExt
extends BKnxProxyExt {
    static BFacets dateFacets = BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE, (String)"showTime", (BIDataValue)BBoolean.FALSE);
    static BFacets timeFacets = BFacets.make((String)"showDate", (BIDataValue)BBoolean.FALSE, (String)"showTimeZone", (BIDataValue)BBoolean.FALSE, (String)"showTime", (BIDataValue)BBoolean.TRUE);
    public static final Type TYPE;
    BAbsTime knxDate;
    BKnxTime knxTime;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxStringProxyExt;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BStringPoint;
    }

    public void setValue(LDataInd lDataInd) {
        byte[] byArray;
        try {
            byArray = lDataInd.getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.readFail("data unavailable");
            return;
        }
        try {
            BValue bValue = this.readOk(byArray);
            this.fireBusDataReceived(bValue);
            this.checkPollOnceSatisfied(lDataInd);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail(illegalArgumentException.getMessage());
        }
    }

    protected String bytesToString(byte[] byArray) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                BString bString = (BString)this.getDeviceFacets().get("trueText");
                BString bString2 = (BString)this.getDeviceFacets().get("falseText");
                if (bString == null) {
                    bString = BString.make((String)"1");
                }
                if (bString2 == null) {
                    bString2 = BString.make((String)"0");
                }
                return (byArray[0] & 0xFF) == 0 ? bString2.getString() : bString.getString();
            }
            case 1: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                StringBuffer stringBuffer = new StringBuffer();
                if ((byArray[0] & 2) == 0) {
                    stringBuffer.append("no control");
                } else {
                    stringBuffer.append("control at ");
                    stringBuffer.append((byArray[0] & 1) == 0 ? "function value 0" : "function value 1");
                }
                stringBuffer.append(":").append(ByteArrayUtil.toHexString((byte[])byArray));
                return stringBuffer.toString();
            }
            case 2: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 3007: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((byArray[0] & 8) == 8 ? lex.get("dimming.increase") : lex.get("dimming.decrease"));
                int n = byArray[0] & 7;
                if (n == 0) {
                    stringBuffer.append(":").append(lex.get("dimming.stepBreak"));
                } else {
                    stringBuffer.append(":" + n);
                }
                return stringBuffer.toString();
            }
            case 3008: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((byArray[0] & 8) == 8 ? lex.get("blinds.up") : lex.get("blinds.down"));
                int n = byArray[0] & 7;
                if (n == 0) {
                    stringBuffer.append(":").append(lex.get("blinds.stepBreak"));
                }
                return stringBuffer.toString();
            }
            case 3009: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append((byArray[0] & 8) == 8 ? lex.get("boiler.calculated") : lex.get("boiler.fixed"));
                stringBuffer.append(":");
                if ((byArray[0] & 1) == 1) {
                    stringBuffer.append(lex.get("boiler.mode0"));
                } else if ((byArray[0] & 1) == 2) {
                    stringBuffer.append(lex.get("boiler.mode1"));
                } else if ((byArray[0] & 1) == 4) {
                    stringBuffer.append(lex.get("boiler.mode2"));
                } else {
                    stringBuffer.append("mode undefined");
                }
                stringBuffer.append(":").append(ByteArrayUtil.toHexString((byte[])byArray));
                return stringBuffer.toString();
            }
            case 4001: 
            case 4002: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return new String(byArray);
            }
            case 5001: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return Double.toString(0.39215686274509803 * (double)byArray[0]);
            }
            case 5003: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return Double.toString(1.411764705882353 * (double)byArray[0]);
            }
            case 3: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 5004: 
            case 5010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return Integer.toString(byArray[0]);
            }
            case 6010: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return Integer.toString(byArray[0]);
            }
            case 6020: {
                if (byArray.length != 1) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 4: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 7001: 
            case 7010: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = byArray[1] & 0xFF | (byArray[0] & 0xFF) << 8;
                return Integer.toString(n);
            }
            case 8001: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = byArray[1] & 0xFF | byArray[0] << 8;
                return Integer.toString(n);
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                if (byArray.length != 2) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return Float.toString(EibUtil.getFloat16Value(byArray));
            }
            case 5: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 10001: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                this.knxTime = this.bytesToTime(byArray);
                return this.knxTime.toString((Context)timeFacets);
            }
            case 11001: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                this.knxDate = this.bytesToDate(byArray);
                return this.knxDate.toDateString((Context)dateFacets);
            }
            case 6: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 12001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[3] & 0xFFL | ((long)byArray[2] & 0xFFL) << 8 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[0] & 0xFFL) << 24;
                return Long.toString(l);
            }
            case 13001: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                long l = (long)byArray[3] & 0xFFL | ((long)byArray[2] & 0xFFL) << 8 | ((long)byArray[1] & 0xFFL) << 16 | (long)byArray[0] << 24;
                return Long.toString(l);
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return Float.toString(EibUtil.getFloat32Value(byArray));
            }
            case 15000: {
                if (byArray.length != 4) {
                    throw new IllegalArgumentException("data length incorrect for " + (Object)((Object)this.getDataType()) + ':' + ByteArrayUtil.toHexString((byte[])byArray));
                }
                return ByteArrayUtil.toHexString((byte[])byArray);
            }
            case 16000: 
            case 16001: {
                return new String(byArray);
            }
        }
        throw new IllegalArgumentException("data type " + (Object)((Object)this.getDataType()) + " not supported:" + ByteArrayUtil.toHexString((byte[])byArray));
    }

    public BAbsTime bytesToDate(byte[] byArray) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 11001: {
                if (byArray.length != 3) {
                    throw new IllegalArgumentException("data length incorrect for date type:" + ByteArrayUtil.toHexString((byte[])byArray));
                }
                int n = byArray[2] & 0x7F;
                n = n < 90 ? (n += 2000) : (n += 1900);
                int n2 = byArray[1] & 0xF;
                int n3 = byArray[0] & 0x1F;
                BAbsTime bAbsTime = BAbsTime.make((int)n, (BMonth)BMonth.make((int)(n2 - 1)), (int)n3);
                return bAbsTime;
            }
        }
        throw new IllegalArgumentException("data type must be a date type:" + ByteArrayUtil.toHexString((byte[])byArray));
    }

    public BKnxTime bytesToTime(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 3) {
            throw new IllegalArgumentException("data length incorrect for data type:" + ByteArrayUtil.toHexString((byte[])byArray));
        }
        int n = byArray[2] & 0x3F;
        int n2 = byArray[1] & 0x3F;
        int n3 = byArray[0] & 0x1F;
        int n4 = (byArray[0] & 0xE0) >>> 5;
        return new BKnxTime(n3, n2, n, BKnxWeekdayEnum.make(n4));
    }

    public void updateOutput(BStatusValue bStatusValue) {
        byte[] byArray;
        if (!(bStatusValue instanceof BStatusString)) {
            this.writeFail("unsupported data type");
            return;
        }
        try {
            byArray = this.stringToBytes(((BStatusString)bStatusValue).getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.writeFail(illegalArgumentException.getMessage());
            return;
        }
        boolean bl = this.getDataType().shouldOptimize();
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress(), byArray, bl);
        boolean bl2 = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl2) {
            this.writeFail("no confirmation");
        } else {
            this.writeOk(bStatusValue);
            this.readOkAll(byArray);
        }
        if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
            this.pollNow();
        }
    }

    public BValue readOk(byte[] byArray) throws IllegalArgumentException {
        BStatusString bStatusString = new BStatusString(this.bytesToString(byArray));
        this.readOk((BStatusValue)new BStatusString(this.bytesToString(byArray)));
        return bStatusString;
    }

    void updateOutput(BAbsTime bAbsTime) {
        byte[] byArray;
        try {
            byArray = EibUtil.dateToBytes(bAbsTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.writeFail(illegalArgumentException.getMessage());
            return;
        }
        boolean bl = this.getDataType().shouldOptimize();
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress(), byArray, bl);
        boolean bl2 = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl2) {
            this.writeFail("no confirmation");
        } else {
            if (this.getParentPoint().isWritablePoint()) {
                this.writeOk((BStatusValue)new BStatusString(bAbsTime.toString((Context)timeFacets)));
            }
            this.readOkAll(byArray);
            this.knxDate = bAbsTime;
        }
        if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
            this.pollNow();
        }
    }

    void updateOutput(BKnxTime bKnxTime) {
        byte[] byArray;
        try {
            byArray = EibUtil.timeToBytes(bKnxTime);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.writeFail(illegalArgumentException.getMessage());
            return;
        }
        boolean bl = this.getDataType().shouldOptimize();
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress(), byArray, bl);
        boolean bl2 = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl2) {
            this.writeFail("no confirmation");
        } else {
            if (this.getParentPoint().isWritablePoint()) {
                this.writeOk((BStatusValue)new BStatusString(bKnxTime.toString((Context)timeFacets)));
            }
            this.readOkAll(byArray);
            this.knxTime = bKnxTime;
        }
        if (this.getParentPoint().isSubscribed() && this.getPollAfterWrite()) {
            this.pollNow();
        }
    }

    protected byte[] stringToBytes(String string) throws IllegalArgumentException {
        switch (this.getDataType().getOrdinal()) {
            case 0: {
                long l = 0L;
                try {
                    l = (long)this.stringToNumber(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a number");
                }
                if (l == 0L) {
                    return new byte[1];
                }
                return new byte[]{1};
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                BString bString = (BString)this.getDeviceFacets().get("trueText");
                BString bString2 = (BString)this.getDeviceFacets().get("falseText");
                if (bString != null && string.equalsIgnoreCase(bString.getString())) {
                    return new byte[]{1};
                }
                if (bString2 != null && string.equalsIgnoreCase(bString2.getString())) {
                    return new byte[1];
                }
                if (string.equals("1")) {
                    return new byte[]{1};
                }
                if (string.equals("0")) {
                    return new byte[1];
                }
                throw new IllegalArgumentException("value must be a device facets true text or false text or 0 or 1");
            }
            case 1: {
                long l = 0L;
                try {
                    l = Long.parseLong(string);
                    if (l >= 0L && l <= (long)3) {
                        return new byte[]{(byte)l};
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a number");
                }
                throw new IllegalArgumentException("value " + string + " is out of range");
            }
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                throw new IllegalArgumentException("string cannot be converted to data type");
            }
            case 2: {
                long l = 0L;
                try {
                    long l2 = Long.parseLong(string, 16);
                    if (l >= 0L && l <= 15L) {
                        return new byte[]{(byte)l};
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a hex number");
                }
                throw new IllegalArgumentException("value " + string + " is out of range");
            }
            case 3007: 
            case 3008: 
            case 3009: {
                throw new IllegalArgumentException("string cannot be converted to data type");
            }
            case 4001: 
            case 4002: {
                if (string.length() != 1) {
                    throw new IllegalArgumentException("string length should be 1 for data type");
                }
                byte[] byArray = string.getBytes();
                return new byte[]{byArray[0]};
            }
            case 5001: {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (n > 100 || n < 0) {
                    throw new IllegalArgumentException("value out of range for dataType and dimension:" + string);
                }
                return new byte[]{(byte)((double)n * 255.0 / 100.0)};
            }
            case 5003: {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (n > 360 || n < 0) {
                    throw new IllegalArgumentException("value out of range for dataType and dimension:" + string);
                }
                return new byte[]{(byte)((double)n * 255.0 / 360.0)};
            }
            case 3: {
                long l = 0L;
                try {
                    l = Long.parseLong(string, 16);
                    if (l >= 0L && l <= 255L) {
                        return new byte[]{(byte)l};
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a hex number");
                }
                throw new IllegalArgumentException("value " + string + " is out of range");
            }
            case 5004: 
            case 5010: {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (n > 255 || n < 0) {
                    throw new IllegalArgumentException("value out of range for dataType:" + string);
                }
                return new byte[]{(byte)n};
            }
            case 6010: {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (n > 127) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (n < -128) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (n < 0) {
                    n = -1 * n & 0x7F;
                    n = (~n & 0x7F) + 1;
                    n |= 0x80;
                }
                return new byte[]{(byte)n};
            }
            case 6020: {
                throw new IllegalArgumentException("string cannot be converted to data type");
            }
            case 4: {
                long l = 0L;
                try {
                    l = Long.parseLong(string, 16);
                    if (l >= 0L && l <= 65535L) {
                        byte[] byArray = new byte[]{(byte)l, (byte)(l >> 8)};
                        return byArray;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a hex number");
                }
                throw new IllegalArgumentException("value " + string + " is out of range");
            }
            case 7001: 
            case 7010: {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (n > (char)-1) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (n < 0) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8)};
                return byArray;
            }
            case 8001: {
                int n;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (n > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (n < Short.MIN_VALUE) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (n < 0) {
                    n = -1 * n & Short.MAX_VALUE;
                    n = (~n & Short.MAX_VALUE) + 1;
                    n |= 0x8000;
                }
                byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8)};
                return byArray;
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                float f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if ((double)f > 670760.96) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if ((double)f < -671088.64) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                return EibUtil.encodeFloat16ToBytes(f);
            }
            case 5: {
                long l = 0L;
                try {
                    l = Long.parseLong(string, 16);
                    if (l >= 0L && l <= 0xFFFFFFL) {
                        byte[] byArray = new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16)};
                        return byArray;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a hex number");
                }
                throw new IllegalArgumentException("value " + string + " is out of range");
            }
            case 10001: {
                throw new IllegalArgumentException("string cannot be converted to data type");
            }
            case 11001: {
                throw new IllegalArgumentException("string cannot be converted to data type");
            }
            case 6: {
                long l = 0L;
                try {
                    l = Long.parseLong(string, 16);
                    if (l >= 0L && l <= (long)-1) {
                        byte[] byArray = new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16)};
                        byArray[3] = (byte)(l >> 24);
                        return byArray;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value " + string + " is not a hex number");
                }
                throw new IllegalArgumentException("value " + string + " is out of range");
            }
            case 12001: {
                long l;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (l > (long)-1) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (l < 0L) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                byte[] byArray = new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24)};
                return byArray;
            }
            case 13001: {
                long l;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (l > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (l < Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (l < 0L) {
                    l = (long)-1 * l & Integer.MAX_VALUE;
                    l = ((l ^ -1L) & Integer.MAX_VALUE) + 1L;
                    l |= Integer.MIN_VALUE;
                }
                byte[] byArray = new byte[]{(byte)l, (byte)(l >> 8)};
                byArray[2] = (byte)(l >> 16);
                byArray[3] = (byte)(l >> 24);
                return byArray;
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                float f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("value not a number:" + string);
                }
                if (f > Float.MAX_VALUE) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                if (f < Float.MIN_VALUE) {
                    throw new IllegalArgumentException("value out of range for dataTypeFE:" + string);
                }
                return EibUtil.encodeFloat32ToBytes(f);
            }
            case 15000: {
                throw new IllegalArgumentException("string cannot be converted to data type");
            }
            case 16000: 
            case 16001: {
                if (string.length() < 1 || string.length() > 14) {
                    throw new IllegalArgumentException("string length should be between 1 and 14 for data type");
                }
                if (this.getDataType().getOrdinal() == 16001) {
                    try {
                        return string.getBytes("ISO-8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                return string.getBytes();
            }
        }
        throw new IllegalArgumentException("data type not supported");
    }

    private final double stringToNumber(String string) throws NumberFormatException {
        switch (this.getDataType().getOrdinal()) {
            case 4001: 
            case 4002: 
            case 16000: 
            case 16001: {
                return Long.parseLong(string, 16);
            }
        }
        return Double.parseDouble(string);
    }

    public void doModifyDate(final BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.network().postWrite(new Runnable(){

            public final void run() {
                BAbsTime bAbsTime = (BAbsTime)bValue;
                BKnxStringProxyExt.this.updateOutput(bAbsTime);
            }
        });
    }

    public void doModifyTime(final BValue bValue, Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.network().postWrite(new Runnable(){

            public final void run() {
                BKnxTime bKnxTime;
                if (bValue.getType().is(BAbsTime.TYPE)) {
                    BAbsTime bAbsTime = (BAbsTime)bValue;
                    bKnxTime = new BKnxTime(bAbsTime.getHour(), bAbsTime.getMinute(), bAbsTime.getSecond(), BKnxWeekdayEnum.convertAbsToKnx(bAbsTime));
                } else {
                    bKnxTime = (BKnxTime)bValue;
                }
                BKnxStringProxyExt.this.updateOutput(bKnxTime);
            }
        });
    }

    public BAbsTime getKnxDate() {
        return this.knxDate;
    }

    public BKnxTime getKnxTime() {
        return this.knxTime;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$point$BKnxStringProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxStringProxyExt = BKnxStringProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxStringProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

