/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.point;

import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.eibnetIp.BEibnetIpDevice;
import com.tridium.eibnetIp.BEibnetIpNetwork;
import com.tridium.eibnetIp.BEibnetIpPointDeviceExt;
import com.tridium.eibnetIp.BGroupAddressFolder;
import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.datatypes.BGroupAddress;
import com.tridium.eibnetIp.enums.BKnxDimensionEnum;
import com.tridium.eibnetIp.messages.LDataInd;
import com.tridium.eibnetIp.messages.LDataReq;
import com.tridium.eibnetIp.point.BKnxAction;
import com.tridium.eibnetIp.point.BKnxCounterDecrementAction;
import com.tridium.eibnetIp.point.BKnxCounterIncrementAction;
import com.tridium.eibnetIp.point.BKnxCounterPresetAction;
import com.tridium.eibnetIp.point.BKnxCounterResetAction;
import com.tridium.eibnetIp.point.BKnxDateAction;
import com.tridium.eibnetIp.point.BKnxSetAction;
import com.tridium.eibnetIp.point.BKnxStepBreakAction;
import com.tridium.eibnetIp.point.BKnxStepDownAction;
import com.tridium.eibnetIp.point.BKnxStepUpAction;
import com.tridium.eibnetIp.point.BKnxSwitchControlAutoAction;
import com.tridium.eibnetIp.point.BKnxSwitchControlOffAction;
import com.tridium.eibnetIp.point.BKnxSwitchControlOnAction;
import com.tridium.eibnetIp.point.BKnxTimeAction;
import com.tridium.eibnetIp.point.BKnxToggleAction;
import com.tridium.eibnetIp.point.BKnxTriggerOffAction;
import com.tridium.eibnetIp.point.BKnxTriggerOnAction;
import com.tridium.eibnetIp.util.KnxWriteAsyncRequest;
import java.util.Vector;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BKnxProxyExt
extends BProxyExt
implements BIBasicPollable,
EibnetConst {
    public static final Property pollEnable = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollOnceOnSubscribed = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollOnceOnOperational = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollUntilAnswerReceivedOnPollOnce = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollAfterWrite = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Property pollFrequency = BKnxProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property groupAddresses = BKnxProxyExt.newProperty((int)0, (BValue)new BGroupAddressFolder(), null);
    public static final Property dataType = BKnxProxyExt.newProperty((int)0, (BValue)BKnxDimensionEnum.dpt1001_switch, (BFacets)BFacets.make((String)"fieldEditor", (String)"eibnetIp:KnxDimensionFE"));
    public static final Property hideDynamicActions = BKnxProxyExt.newProperty((int)0, (boolean)false, null);
    public static final Action pollNow = BKnxProxyExt.newAction((int)0, null);
    public static final Action writeNow = BKnxProxyExt.newAction((int)0, null);
    public static final Action dump = BKnxProxyExt.newAction((int)4, null);
    public static final Topic busDataReceived = BKnxProxyExt.newTopic((int)0, null);
    public static final Type TYPE;
    static final Log log;
    static Lexicon lex;
    boolean pollSubscribed;
    BStatus oldStatus;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxProxyExt;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxStepUpAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxStepDownAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxStepBreakAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxDateAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxTimeAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxTriggerOnAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxTriggerOffAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxToggleAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxSetAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxSwitchControlOnAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxSwitchControlOffAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxSwitchControlAutoAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxCounterIncrementAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxCounterDecrementAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxCounterResetAction;
    static /* synthetic */ Class class$com$tridium$eibnetIp$point$BKnxCounterPresetAction;

    public boolean getPollEnable() {
        return this.getBoolean(pollEnable);
    }

    public void setPollEnable(boolean bl) {
        this.setBoolean(pollEnable, bl, null);
    }

    public boolean getPollOnceOnSubscribed() {
        return this.getBoolean(pollOnceOnSubscribed);
    }

    public void setPollOnceOnSubscribed(boolean bl) {
        this.setBoolean(pollOnceOnSubscribed, bl, null);
    }

    public boolean getPollOnceOnOperational() {
        return this.getBoolean(pollOnceOnOperational);
    }

    public void setPollOnceOnOperational(boolean bl) {
        this.setBoolean(pollOnceOnOperational, bl, null);
    }

    public boolean getPollUntilAnswerReceivedOnPollOnce() {
        return this.getBoolean(pollUntilAnswerReceivedOnPollOnce);
    }

    public void setPollUntilAnswerReceivedOnPollOnce(boolean bl) {
        this.setBoolean(pollUntilAnswerReceivedOnPollOnce, bl, null);
    }

    public boolean getPollAfterWrite() {
        return this.getBoolean(pollAfterWrite);
    }

    public void setPollAfterWrite(boolean bl) {
        this.setBoolean(pollAfterWrite, bl, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BGroupAddressFolder getGroupAddresses() {
        return (BGroupAddressFolder)this.get(groupAddresses);
    }

    public void setGroupAddresses(BGroupAddressFolder bGroupAddressFolder) {
        this.set(groupAddresses, (BValue)bGroupAddressFolder, null);
    }

    public BKnxDimensionEnum getDataType() {
        return (BKnxDimensionEnum)this.get(dataType);
    }

    public void setDataType(BKnxDimensionEnum bKnxDimensionEnum) {
        this.set(dataType, (BValue)bKnxDimensionEnum, null);
    }

    public boolean getHideDynamicActions() {
        return this.getBoolean(hideDynamicActions);
    }

    public void setHideDynamicActions(boolean bl) {
        this.setBoolean(hideDynamicActions, bl, null);
    }

    public void pollNow() {
        this.invoke(pollNow, null, null);
    }

    public void writeNow() {
        this.invoke(writeNow, null, null);
    }

    public void dump() {
        this.invoke(dump, null, null);
    }

    public void fireBusDataReceived(BValue bValue) {
        this.fire(busDataReceived, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkActions();
        this.lexiconizeWritableActions();
        this.setStale(true, null);
        this.oldStatus = this.getStatus();
        if (!(this.getParentPoint() instanceof BIWritablePoint)) {
            this.setFlags((Slot)writeNow, 4);
        }
    }

    public void stopped() {
        this.device().unregisterLDataListener(this);
    }

    public void changed(Property property, Context context) {
        block30: {
            super.changed(property, context);
            if (!this.isRunning()) {
                return;
            }
            if (!property.equals((Object)groupAddresses)) {
                if (property.equals((Object)status)) {
                    BStatus bStatus = this.getStatus();
                    if (BKnxProxyExt.isOperational(bStatus)) {
                        if (!BKnxProxyExt.isOperational(this.oldStatus)) {
                            log.trace(this.getGroupAddresses().getPrimaryGroupAddress() + " transition to operational");
                            if (this.getPollOnceOnOperational()) {
                                if (this.getPollUntilAnswerReceivedOnPollOnce()) {
                                    try {
                                        this.readSubscribed(null);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                } else {
                                    this.doPollNow();
                                }
                            }
                        }
                    } else if (BKnxProxyExt.isOperational(this.oldStatus)) {
                        log.trace(this.getGroupAddresses().getPrimaryGroupAddress() + " transition to non operational");
                        if (!bStatus.isFault()) {
                            try {
                                this.readUnsubscribed(null);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        this.setStale(true, null);
                    }
                    this.oldStatus = bStatus;
                } else if (property.equals((Object)dataType)) {
                    this.setDeviceFacets(this.getDataType().getDeviceFacets());
                    if (this.getParentPoint() != null) {
                        this.getParentPoint().setFacets(this.getDeviceFacets());
                        this.removeActions();
                        this.checkActions();
                    }
                } else if (property.equals((Object)pollEnable)) {
                    try {
                        if (this.getPollEnable() && this.getEnabled()) {
                            this.readSubscribed(null);
                            break block30;
                        }
                        this.readUnsubscribed(null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (property.equals((Object)pollUntilAnswerReceivedOnPollOnce)) {
                    if (!this.getPollUntilAnswerReceivedOnPollOnce() && !this.getPollEnable()) {
                        try {
                            this.readUnsubscribed(null);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (property.equals((Object)hideDynamicActions)) {
                    this.hideDynamicActions(this.getHideDynamicActions());
                }
            }
        }
    }

    static boolean isOperational(BStatus bStatus) {
        return !bStatus.isDisabled() && !bStatus.isDown() && !bStatus.isFault();
    }

    public void poll() {
        log.trace(this.getGroupAddresses().getPrimaryGroupAddress() + " poll");
        boolean bl = false;
        LDataReq lDataReq = new LDataReq(this.getGroupAddresses().getPrimaryGroupAddress());
        bl = this.network().getTunnelLayer().sendTunnelRequest(this.device(), lDataReq);
        if (!bl) {
            this.readFail("no confirmation");
            return;
        }
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.device().registerLDataListener(this);
    }

    public void registerLDataListener() {
        if (!this.isRunning()) {
            return;
        }
        this.device().registerLDataListener(this);
        this.setStale(true, null);
        if (this.getParentPoint().isWritablePoint()) {
            this.getTuning().writeDesired();
        }
    }

    public void unregisterLDataListener() {
        if (!this.isRunning()) {
            return;
        }
        this.device().unregisterLDataListener(this);
    }

    public void doWrite(BStatusValue bStatusValue) {
        log.trace(this.getName() + " :write for " + this.getGroupAddresses().getPrimaryGroupAddress());
        if (bStatusValue == null) {
            this.updateOutput(this.getWriteValue());
        } else {
            this.updateOutput(bStatusValue);
        }
    }

    public abstract void setValue(LDataInd var1);

    public abstract void updateOutput(BStatusValue var1);

    void checkPollOnceSatisfied(LDataInd lDataInd) {
        if (lDataInd.getDestination().toInteger() == this.getGroupAddresses().getPrimaryGroupAddress().toInteger()) {
            try {
                this.readUnsubscribed(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public abstract BValue readOk(byte[] var1) throws IllegalArgumentException;

    protected void readOkAll(byte[] byArray) {
        int n = this.getGroupAddresses().getPrimaryGroupAddress().toInteger();
        Vector vector = this.device().getGroupedExtensions(n);
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                BKnxProxyExt bKnxProxyExt = (BKnxProxyExt)vector.elementAt(n2);
                try {
                    bKnxProxyExt.readOk(byArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bKnxProxyExt.readFail(illegalArgumentException.getMessage());
                }
                ++n2;
            }
        }
    }

    public Type getDeviceExtType() {
        return BEibnetIpPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void readSubscribed(Context context) throws Exception {
        if (this.pollSubscribed) {
            return;
        }
        log.trace(this + ".readSubscribed() on " + this);
        if (this.getPollEnable()) {
            this.network().getPollScheduler().subscribe((BIPollable)this);
            this.pollSubscribed = true;
        } else if (this.getPollUntilAnswerReceivedOnPollOnce()) {
            if (this.getPollOnceOnOperational() || this.getPollOnceOnSubscribed()) {
                this.network().getPollScheduler().subscribe((BIPollable)this);
                this.pollSubscribed = true;
            }
        } else if (this.getPollOnceOnSubscribed() && !this.isUnoperational()) {
            this.doPollNow();
        }
    }

    public void readUnsubscribed(Context context) throws Exception {
        if (!this.pollSubscribed) {
            return;
        }
        if (this.isSubscribed() && this.getPollEnable()) {
            return;
        }
        log.trace("readUnsubscribed() on " + this);
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.pollSubscribed = false;
    }

    public void doDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName()).append("group addreses:").append(this.getGroupAddresses().dump());
        System.out.println(stringBuffer.toString());
    }

    public void doPollNow() {
        this.network().postAsync(new Runnable(){

            public final void run() {
                log.trace(BKnxProxyExt.this.getGroupAddresses().getPrimaryGroupAddress() + " doPollNow");
                BKnxProxyExt.this.poll();
            }
        });
    }

    public void doWriteNow() {
        try {
            this.write(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString(Context context) {
        return super.toString(context) + " group:" + this.getGroupAddresses().getPrimaryGroupAddress();
    }

    protected BEibnetIpDevice device() {
        return (BEibnetIpDevice)this.getDevice();
    }

    protected BEibnetIpNetwork network() {
        return this.device().eibNetwork();
    }

    protected boolean isTraceOn() {
        return log.isTraceOn();
    }

    public void writeFail(String string) {
        if (log.isTraceOn()) {
            log.error(this.getSlotPath().toDisplayString() + ' ' + this.getParentPoint().getOutStatusValue() + " to " + this.getWriteValue() + ' ' + string);
        }
        super.writeFail(string);
    }

    public boolean write(Context context) throws Exception {
        if (this.getMode() != BReadWriteMode.readonly) {
            BStatusValue bStatusValue = this.getWriteValue();
            if (bStatusValue.getStatus().isNull()) {
                return false;
            }
            if (this.network().getLog().isTraceOn()) {
                this.network().getLog().trace("Write <" + this + "> " + bStatusValue);
            }
            try {
                this.network().postWrite(new KnxWriteAsyncRequest(this, bStatusValue));
            }
            catch (Exception exception) {
                this.writeFail(lex.getText("postWriteFail") + ": " + exception);
                this.network().getLog().error("Could not post write for " + this.getParent().getName(), (Throwable)exception);
            }
        }
        return false;
    }

    private final void checkActions() {
        if (this.getParentPoint().isWritablePoint()) {
            return;
        }
        switch (this.getDataType().getOrdinal()) {
            case 0: {
                this.addSwitchActions();
                break;
            }
            case 1: {
                this.addSwitchControlActions();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: {
                this.addSwitchActions();
                break;
            }
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 2008: 
            case 2009: 
            case 2010: 
            case 2011: 
            case 2012: {
                this.addSwitchControlActions();
                break;
            }
            case 3007: 
            case 3008: {
                this.addDimmingActions();
                break;
            }
            case 3009: 
            case 4001: 
            case 4002: {
                break;
            }
            case 5001: 
            case 5003: {
                this.addCounterActions();
                break;
            }
            case 5004: {
                break;
            }
            case 5010: 
            case 6010: {
                this.addCounterActions();
                break;
            }
            case 6020: {
                break;
            }
            case 7001: {
                this.addCounterActions();
                break;
            }
            case 7010: {
                break;
            }
            case 8001: {
                this.addCounterActions();
                break;
            }
            case 9001: 
            case 9002: 
            case 9003: 
            case 9004: 
            case 9005: 
            case 9006: 
            case 9010: 
            case 9011: 
            case 9020: 
            case 9021: {
                this.addCounterActions();
                break;
            }
            case 10001: {
                this.addTimeActions();
                break;
            }
            case 11001: {
                this.addDateActions();
                break;
            }
            case 12001: 
            case 13001: {
                this.addCounterActions();
                break;
            }
            case 14000: 
            case 14001: 
            case 14002: 
            case 14003: 
            case 14004: 
            case 14005: 
            case 14006: 
            case 14007: 
            case 14008: 
            case 14009: 
            case 14010: 
            case 14011: 
            case 14012: 
            case 14013: 
            case 14014: 
            case 14015: 
            case 14016: 
            case 14017: 
            case 14018: 
            case 14019: 
            case 14020: 
            case 14021: 
            case 14022: 
            case 14023: 
            case 14024: 
            case 14025: 
            case 14026: 
            case 14027: 
            case 14028: 
            case 14029: 
            case 14030: 
            case 14031: 
            case 14032: 
            case 14033: 
            case 14034: 
            case 14035: 
            case 14036: 
            case 14037: 
            case 14038: 
            case 14039: 
            case 14040: 
            case 14041: 
            case 14042: 
            case 14043: 
            case 14044: 
            case 14045: 
            case 14046: 
            case 14047: 
            case 14048: 
            case 14049: 
            case 14050: 
            case 14051: 
            case 14052: 
            case 14053: 
            case 14054: 
            case 14055: 
            case 14056: 
            case 14057: 
            case 14058: 
            case 14059: 
            case 14060: 
            case 14061: 
            case 14062: 
            case 14063: 
            case 14064: 
            case 14065: 
            case 14066: 
            case 14067: 
            case 14068: 
            case 14069: 
            case 14070: 
            case 14071: 
            case 14072: 
            case 14073: 
            case 14074: 
            case 14075: 
            case 14076: 
            case 14077: 
            case 14078: 
            case 14079: {
                break;
            }
            case 15000: {
                break;
            }
            case 16000: 
            case 16001: {
                this.addBooleanTextSlots();
                break;
            }
        }
    }

    private final void removeActions() {
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxAction;", false);
        }
        BKnxAction[] bKnxActionArray = (BKnxAction[])bControlPoint.getChildren(clazz);
        int n = 0;
        while (n < bKnxActionArray.length) {
            this.getParentPoint().remove((BComplex)bKnxActionArray[n]);
            ++n;
        }
    }

    private final void hideDynamicActions(boolean bl) {
        if (!this.isRunning()) {
            return;
        }
        Slot[] slotArray = this.getParentPoint().getSlotsArray();
        int n = 0;
        while (n < slotArray.length) {
            if (slotArray[n].isAction() && slotArray[n].isDynamic()) {
                Slot slot = slotArray[n];
                int n2 = this.getParentPoint().getFlags(slot);
                n2 = bl ? (n2 |= 4) : (n2 &= 0xFFFFFFFB);
                this.getParentPoint().setFlags(slot, n2);
            }
            ++n;
        }
    }

    private final void addDimmingActions() {
        BKnxAction bKnxAction;
        if (this.getParentPoint().getType() != BNumericPoint.TYPE) {
            return;
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxStepUpAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxStepUpAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxStepUpAction;", false);
        }
        BKnxStepUpAction[] bKnxStepUpActionArray = (BKnxStepUpAction[])bControlPoint.getChildren(clazz);
        BControlPoint bControlPoint2 = this.getParentPoint();
        Class clazz2 = class$com$tridium$eibnetIp$point$BKnxStepDownAction;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$eibnetIp$point$BKnxStepDownAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxStepDownAction;", false);
        }
        BKnxStepDownAction[] bKnxStepDownActionArray = (BKnxStepDownAction[])bControlPoint2.getChildren(clazz2);
        BControlPoint bControlPoint3 = this.getParentPoint();
        Class clazz3 = class$com$tridium$eibnetIp$point$BKnxStepBreakAction;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$eibnetIp$point$BKnxStepBreakAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxStepBreakAction;", false);
        }
        BKnxStepBreakAction[] bKnxStepBreakActionArray = (BKnxStepBreakAction[])bControlPoint3.getChildren(clazz3);
        if (bKnxStepUpActionArray.length == 0) {
            bKnxAction = new BKnxStepUpAction();
            bKnxAction.setParameterTypeSpec(BInteger.TYPE.getTypeSpec());
            this.getParentPoint().add("stepUpAction", (BValue)bKnxAction);
            if (this.getDataType().equals((Object)BKnxDimensionEnum.dpt3007_controlDimming)) {
                this.lexiconizeSlotInPoint("stepUpAction", "%lexicon(eibnetIp:dpt3.007.increase)%");
            }
            if (this.getDataType().equals((Object)BKnxDimensionEnum.dpt3008_controlBlinds)) {
                this.lexiconizeSlotInPoint("stepUpAction", "%lexicon(eibnetIp:dpt3.008.increase)%");
            }
        }
        if (bKnxStepDownActionArray.length == 0) {
            bKnxAction = new BKnxStepDownAction();
            bKnxAction.setParameterTypeSpec(BInteger.TYPE.getTypeSpec());
            this.getParentPoint().add("stepDownAction", (BValue)bKnxAction);
            if (this.getDataType().equals((Object)BKnxDimensionEnum.dpt3007_controlDimming)) {
                this.lexiconizeSlotInPoint("stepDownAction", "%lexicon(eibnetIp:dpt3.007.decrease)%");
            }
            if (this.getDataType().equals((Object)BKnxDimensionEnum.dpt3008_controlBlinds)) {
                this.lexiconizeSlotInPoint("stepDownAction", "%lexicon(eibnetIp:dpt3.008.decrease)%");
            }
        }
        if (bKnxStepBreakActionArray.length == 0) {
            bKnxAction = new BKnxStepBreakAction();
            bKnxAction.setParameterTypeSpec(BInteger.TYPE.getTypeSpec());
            this.getParentPoint().add("stepBreakAction", (BValue)bKnxAction);
            if (this.getDataType().equals((Object)BKnxDimensionEnum.dpt3007_controlDimming)) {
                this.lexiconizeSlotInPoint("stepBreakAction", "%lexicon(eibnetIp:dpt3.007.stepBreak)%");
            }
            if (this.getDataType().equals((Object)BKnxDimensionEnum.dpt3008_controlBlinds)) {
                this.lexiconizeSlotInPoint("stepBreakAction", "%lexicon(eibnetIp:dpt3.008.stepBreak)%");
            }
        }
        if (this.get("stepSize") == null) {
            this.add("stepSize", (BValue)BInteger.make((int)1));
        }
    }

    private final void addBooleanTextSlots() {
        if (this.getParentPoint() instanceof BBooleanPoint) {
            if (this.get("falseTxt") == null) {
                this.add("falseTxt", (BValue)BString.make((String)"%lexicon(eibnetIp:stringToBoolean.trueTxt)%"));
            }
            if (this.get("trueTxt") == null) {
                this.add("falseTxt", (BValue)BString.make((String)"%lexicon(eibnetIp:stringToBoolean.falseTxt)%"));
            }
        }
    }

    private final void addDateActions() {
        BKnxDateAction[] bKnxDateActionArray;
        if (this.getParentPoint().getType() != BStringPoint.TYPE) {
            return;
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxDateAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxDateAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxDateAction;", false);
        }
        if ((bKnxDateActionArray = (BKnxDateAction[])bControlPoint.getChildren(clazz)).length > 0) {
            return;
        }
        BKnxDateAction bKnxDateAction = new BKnxDateAction();
        bKnxDateAction.setParameterTypeSpec(BAbsTime.TYPE.getTypeSpec());
        this.getParentPoint().add("modifyDateAction", (BValue)bKnxDateAction);
        this.lexiconizeSlotInPoint("modifyDateAction", "%lexicon(eibnetIp:modifyDateAction)%");
    }

    private final void addTimeActions() {
        BKnxTimeAction[] bKnxTimeActionArray;
        if (this.getParentPoint().getType() != BStringPoint.TYPE) {
            return;
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxTimeAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxTimeAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxTimeAction;", false);
        }
        if ((bKnxTimeActionArray = (BKnxTimeAction[])bControlPoint.getChildren(clazz)).length > 0) {
            return;
        }
        BKnxTimeAction bKnxTimeAction = new BKnxTimeAction();
        bKnxTimeAction.setParameterTypeSpec(BAbsTime.TYPE.getTypeSpec());
        this.getParentPoint().add("modifyTimeAction", (BValue)bKnxTimeAction);
        this.lexiconizeSlotInPoint("modifyTimeAction", "%lexicon(eibnetIp:modifyTimeAction)%");
    }

    private final void addSwitchActions() {
        BKnxAction bKnxAction;
        if (this.getParentPoint().getType() != BBooleanPoint.TYPE) {
            return;
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxTriggerOnAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxTriggerOnAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxTriggerOnAction;", false);
        }
        BKnxTriggerOnAction[] bKnxTriggerOnActionArray = (BKnxTriggerOnAction[])bControlPoint.getChildren(clazz);
        BControlPoint bControlPoint2 = this.getParentPoint();
        Class clazz2 = class$com$tridium$eibnetIp$point$BKnxTriggerOffAction;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$eibnetIp$point$BKnxTriggerOffAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxTriggerOffAction;", false);
        }
        BKnxTriggerOffAction[] bKnxTriggerOffActionArray = (BKnxTriggerOffAction[])bControlPoint2.getChildren(clazz2);
        BControlPoint bControlPoint3 = this.getParentPoint();
        Class clazz3 = class$com$tridium$eibnetIp$point$BKnxToggleAction;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$eibnetIp$point$BKnxToggleAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxToggleAction;", false);
        }
        BKnxToggleAction[] bKnxToggleActionArray = (BKnxToggleAction[])bControlPoint3.getChildren(clazz3);
        BControlPoint bControlPoint4 = this.getParentPoint();
        Class clazz4 = class$com$tridium$eibnetIp$point$BKnxSetAction;
        if (clazz4 == null) {
            clazz4 = class$com$tridium$eibnetIp$point$BKnxSetAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxSetAction;", false);
        }
        BKnxSetAction[] bKnxSetActionArray = (BKnxSetAction[])bControlPoint4.getChildren(clazz4);
        if (bKnxTriggerOnActionArray.length == 0) {
            bKnxAction = new BKnxTriggerOnAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("triggerOnAction", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 1001: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.001.triggerOnAction)%");
                    break;
                }
                case 1002: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.002.triggerOnAction)%");
                    break;
                }
                case 1003: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.003.triggerOnAction)%");
                    break;
                }
                case 1004: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.004.triggerOnAction)%");
                    break;
                }
                case 1005: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.005.triggerOnAction)%");
                    break;
                }
                case 1006: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.006.triggerOnAction)%");
                    break;
                }
                case 1007: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.007.triggerOnAction)%");
                    break;
                }
                case 1008: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.008.triggerOnAction)%");
                    break;
                }
                case 1009: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.009.triggerOnAction)%");
                    break;
                }
                case 1010: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.010.triggerOnAction)%");
                    break;
                }
                case 1011: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.011.triggerOnAction)%");
                    break;
                }
                case 1012: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.012.triggerOnAction)%");
                    break;
                }
                case 1013: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.013.triggerOnAction)%");
                    break;
                }
                case 1014: {
                    this.lexiconizeSlotInPoint("triggerOnAction", "%lexicon(eibnetIp:dpt1.014.triggerOnAction)%");
                    break;
                }
            }
        }
        if (bKnxTriggerOffActionArray.length == 0) {
            bKnxAction = new BKnxTriggerOffAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("triggerOffAction", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 1001: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.001.triggerOffAction)%");
                    break;
                }
                case 1002: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.002.triggerOffAction)%");
                    break;
                }
                case 1003: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.003.triggerOffAction)%");
                    break;
                }
                case 1004: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.004.triggerOffAction)%");
                    break;
                }
                case 1005: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.005.triggerOffAction)%");
                    break;
                }
                case 1006: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.006.triggerOffAction)%");
                    break;
                }
                case 1007: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.007.triggerOffAction)%");
                    break;
                }
                case 1008: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.008.triggerOffAction)%");
                    break;
                }
                case 1009: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.009.triggerOffAction)%");
                    break;
                }
                case 1010: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.010.triggerOffAction)%");
                    break;
                }
                case 1011: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.011.triggerOffAction)%");
                    break;
                }
                case 1012: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.012.triggerOffAction)%");
                    break;
                }
                case 1013: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.013.triggerOffAction)%");
                    break;
                }
                case 1014: {
                    this.lexiconizeSlotInPoint("triggerOffAction", "%lexicon(eibnetIp:dpt1.014.triggerOffAction)%");
                    break;
                }
            }
        }
        if (bKnxToggleActionArray.length == 0) {
            bKnxAction = new BKnxToggleAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("toggleAction", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 1001: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.001.toggleAction)%");
                    break;
                }
                case 1002: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.002.toggleAction)%");
                    break;
                }
                case 1003: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.003.toggleAction)%");
                    break;
                }
                case 1004: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.004.toggleAction)%");
                    break;
                }
                case 1005: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.005.toggleAction)%");
                    break;
                }
                case 1006: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.006.toggleAction)%");
                    break;
                }
                case 1007: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.007.toggleAction)%");
                    break;
                }
                case 1008: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.008.toggleAction)%");
                    break;
                }
                case 1009: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.009.toggleAction)%");
                    break;
                }
                case 1010: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.010.toggleAction)%");
                    break;
                }
                case 1011: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.011.toggleAction)%");
                    break;
                }
                case 1012: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.012.toggleAction)%");
                    break;
                }
                case 1013: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.013.toggleAction)%");
                    break;
                }
                case 1014: {
                    this.lexiconizeSlotInPoint("toggleAction", "%lexicon(eibnetIp:dpt1.014.toggleAction)%");
                    break;
                }
            }
        }
        if (bKnxSetActionArray.length == 0) {
            bKnxAction = new BKnxSetAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("set", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 1001: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.001.setAction)%");
                    break;
                }
                case 1002: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.002.setAction)%");
                    break;
                }
                case 1003: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.003.setAction)%");
                    break;
                }
                case 1004: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.004.setAction)%");
                    break;
                }
                case 1005: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.005.setAction)%");
                    break;
                }
                case 1006: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.006.setAction)%");
                    break;
                }
                case 1007: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.007.setAction)%");
                    break;
                }
                case 1008: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.008.setAction)%");
                    break;
                }
                case 1009: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.009.setAction)%");
                    break;
                }
                case 1010: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.010.setAction)%");
                    break;
                }
                case 1011: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.011.setAction)%");
                    break;
                }
                case 1012: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.012.setAction)%");
                    break;
                }
                case 1013: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.013.setAction)%");
                    break;
                }
                case 1014: {
                    this.lexiconizeSlotInPoint("set", "%lexicon(eibnetIp:dpt1.014.setAction)%");
                    break;
                }
            }
        }
    }

    private final void addSwitchControlActions() {
        BKnxAction bKnxAction;
        if (this.getParentPoint().getType() != BBooleanPoint.TYPE) {
            return;
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxSwitchControlOnAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxSwitchControlOnAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxSwitchControlOnAction;", false);
        }
        BKnxSwitchControlOnAction[] bKnxSwitchControlOnActionArray = (BKnxSwitchControlOnAction[])bControlPoint.getChildren(clazz);
        BControlPoint bControlPoint2 = this.getParentPoint();
        Class clazz2 = class$com$tridium$eibnetIp$point$BKnxSwitchControlOffAction;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$eibnetIp$point$BKnxSwitchControlOffAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxSwitchControlOffAction;", false);
        }
        BKnxSwitchControlOffAction[] bKnxSwitchControlOffActionArray = (BKnxSwitchControlOffAction[])bControlPoint2.getChildren(clazz2);
        BControlPoint bControlPoint3 = this.getParentPoint();
        Class clazz3 = class$com$tridium$eibnetIp$point$BKnxSwitchControlAutoAction;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$eibnetIp$point$BKnxSwitchControlAutoAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxSwitchControlAutoAction;", false);
        }
        BKnxSwitchControlAutoAction[] bKnxSwitchControlAutoActionArray = (BKnxSwitchControlAutoAction[])bControlPoint3.getChildren(clazz3);
        if (bKnxSwitchControlOnActionArray.length == 0) {
            bKnxAction = new BKnxSwitchControlOnAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("switchControlOnAction", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 2001: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.001.switchControlOnAction)%");
                    break;
                }
                case 2002: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.002.switchControlOnAction)%");
                    break;
                }
                case 2003: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.003.switchControlOnAction)%");
                    break;
                }
                case 2004: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.004.switchControlOnAction)%");
                    break;
                }
                case 2005: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.005.switchControlOnAction)%");
                    break;
                }
                case 2006: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.006.switchControlOnAction)%");
                    break;
                }
                case 2007: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.007.switchControlOnAction)%");
                    break;
                }
                case 2008: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.008.switchControlOnAction)%");
                    break;
                }
                case 2009: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.009.switchControlOnAction)%");
                    break;
                }
                case 2010: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.010.switchControlOnAction)%");
                    break;
                }
                case 2011: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.011.switchControlOnAction)%");
                    break;
                }
                case 2012: {
                    this.lexiconizeSlotInPoint("switchControlOnAction", "%lexicon(eibnetIp:dpt2.012.switchControlOnAction)%");
                    break;
                }
            }
        }
        if (bKnxSwitchControlOffActionArray.length == 0) {
            bKnxAction = new BKnxSwitchControlOffAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("switchControlOffAction", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 2001: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.001.switchControlOffAction)%");
                    break;
                }
                case 2002: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.002.switchControlOffAction)%");
                    break;
                }
                case 2003: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.003.switchControlOffAction)%");
                    break;
                }
                case 2004: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.004.switchControlOffAction)%");
                    break;
                }
                case 2005: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.005.switchControlOffAction)%");
                    break;
                }
                case 2006: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.006.switchControlOffAction)%");
                    break;
                }
                case 2007: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.007.switchControlOffAction)%");
                    break;
                }
                case 2008: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.008.switchControlOffAction)%");
                    break;
                }
                case 2009: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.009.switchControlOffAction)%");
                    break;
                }
                case 2010: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.010.switchControlOffAction)%");
                    break;
                }
                case 2011: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.011.switchControlOffAction)%");
                    break;
                }
                case 2012: {
                    this.lexiconizeSlotInPoint("switchControlOffAction", "%lexicon(eibnetIp:dpt2.012.switchControlOffAction)%");
                    break;
                }
            }
        }
        if (bKnxSwitchControlAutoActionArray.length == 0) {
            bKnxAction = new BKnxSwitchControlAutoAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("switchControlAutoAction", (BValue)bKnxAction);
            switch (this.getDataType().getOrdinal()) {
                case 2001: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.001.switchControlAutoAction)%");
                    break;
                }
                case 2002: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.002.switchControlAutoAction)%");
                    break;
                }
                case 2003: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.003.switchControlAutoAction)%");
                    break;
                }
                case 2004: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.004.switchControlAutoAction)%");
                    break;
                }
                case 2005: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.005.switchControlAutoAction)%");
                    break;
                }
                case 2006: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.006.switchControlAutoAction)%");
                    break;
                }
                case 2007: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.007.switchControlAutoAction)%");
                    break;
                }
                case 2008: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.008.switchControlAutoAction)%");
                    break;
                }
                case 2009: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.009.switchControlAutoAction)%");
                    break;
                }
                case 2010: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.010.switchControlAutoAction)%");
                    break;
                }
                case 2011: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.011.switchControlAutoAction)%");
                    break;
                }
                case 2012: {
                    this.lexiconizeSlotInPoint("switchControlAutoAction", "%lexicon(eibnetIp:dpt2.012.switchControlAutoAction)%");
                    break;
                }
            }
        }
    }

    private final void addCounterActions() {
        BKnxAction bKnxAction;
        if (this.getParentPoint().getType() != BNumericPoint.TYPE) {
            return;
        }
        BControlPoint bControlPoint = this.getParentPoint();
        Class clazz = class$com$tridium$eibnetIp$point$BKnxCounterIncrementAction;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxCounterIncrementAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxCounterIncrementAction;", false);
        }
        BKnxCounterIncrementAction[] bKnxCounterIncrementActionArray = (BKnxCounterIncrementAction[])bControlPoint.getChildren(clazz);
        BControlPoint bControlPoint2 = this.getParentPoint();
        Class clazz2 = class$com$tridium$eibnetIp$point$BKnxCounterDecrementAction;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$eibnetIp$point$BKnxCounterDecrementAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxCounterDecrementAction;", false);
        }
        BKnxCounterDecrementAction[] bKnxCounterDecrementActionArray = (BKnxCounterDecrementAction[])bControlPoint2.getChildren(clazz2);
        BControlPoint bControlPoint3 = this.getParentPoint();
        Class clazz3 = class$com$tridium$eibnetIp$point$BKnxCounterResetAction;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$eibnetIp$point$BKnxCounterResetAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxCounterResetAction;", false);
        }
        BKnxCounterResetAction[] bKnxCounterResetActionArray = (BKnxCounterResetAction[])bControlPoint3.getChildren(clazz3);
        BControlPoint bControlPoint4 = this.getParentPoint();
        Class clazz4 = class$com$tridium$eibnetIp$point$BKnxCounterPresetAction;
        if (clazz4 == null) {
            clazz4 = class$com$tridium$eibnetIp$point$BKnxCounterPresetAction = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxCounterPresetAction;", false);
        }
        BKnxCounterPresetAction[] bKnxCounterPresetActionArray = (BKnxCounterPresetAction[])bControlPoint4.getChildren(clazz4);
        if (bKnxCounterIncrementActionArray.length == 0) {
            bKnxAction = new BKnxCounterIncrementAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("incrementAction", (BValue)bKnxAction);
            this.lexiconizeSlotInPoint("incrementAction", "%lexicon(eibnetIp:incrementAction)%");
        }
        if (bKnxCounterDecrementActionArray.length == 0) {
            bKnxAction = new BKnxCounterDecrementAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("decrementAction", (BValue)bKnxAction);
            this.lexiconizeSlotInPoint("decrementAction", "%lexicon(eibnetIp:decrementAction)%");
        }
        if (bKnxCounterResetActionArray.length == 0) {
            bKnxAction = new BKnxCounterResetAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("resetCountAction", (BValue)bKnxAction);
            this.lexiconizeSlotInPoint("resetCountAction", "%lexicon(eibnetIp:resetCountAction)%");
        }
        if (bKnxCounterPresetActionArray.length == 0) {
            bKnxAction = new BKnxCounterPresetAction();
            bKnxAction.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            this.getParentPoint().add("presetCountAction", (BValue)bKnxAction);
            this.lexiconizeSlotInPoint("presetCountAction", "%lexicon(eibnetIp:presetCountAction)%");
        }
    }

    public void doTriggerOnAction(Context context) {
        System.out.println("default doTriggerOnAction");
    }

    public void doTriggerOffAction(Context context) {
        System.out.println("default doTriggerOffAction");
    }

    public void doToggleAction(Context context) {
        System.out.println("default doTriggerOffAction");
    }

    public void doSwitchControlOnAction(Context context) {
        System.out.println("default doSwitchControlOnAction");
    }

    public void doSwitchControlOffAction(Context context) {
        System.out.println("default doSwitchControlOffAction");
    }

    public void doSwitchControlAutoAction(Context context) {
        System.out.println("default doSwitchControlAutoAction");
    }

    public void doStepUpAction(Context context) {
        System.out.println("default doStepUpAction");
    }

    public void doStepDownAction(Context context) {
        System.out.println("default doStepDownAction");
    }

    public void doStepBreakAction(Context context) {
        System.out.println("default doStepBreakAction");
    }

    public void doIncrementCount(BValue bValue, Context context) {
        System.out.println("default doIncrementCount");
    }

    public void doDecrementCount(BValue bValue, Context context) {
        System.out.println("default doDecrementCount");
    }

    public void doResetCount(Context context) {
        System.out.println("default doResetCount");
    }

    public void doPresetCount(BValue bValue, Context context) {
        System.out.println("default doPresetCount");
    }

    public void doSet(BValue bValue, Context context) {
        System.out.println("default doSet");
    }

    public void doModifyDate(BValue bValue, Context context) {
        System.out.println("default doModifyDate");
    }

    public void doModifyTime(BValue bValue, Context context) {
        System.out.println("default doModifyTime");
    }

    private final void lexiconizeSlotInPoint(String string, String string2) {
        BControlPoint bControlPoint = this.getParentPoint();
        BNameMap bNameMap = (BNameMap)bControlPoint.get("displayNames");
        if (bNameMap == null) {
            bNameMap = BNameMap.NULL;
            bControlPoint.add("displayNames", (BValue)bNameMap, 261);
        }
        bNameMap = BNameMap.make((BNameMap)bNameMap, (String)string, (String)string2);
        bControlPoint.set("displayNames", (BValue)bNameMap);
    }

    private final void lexiconizeWritableActions() {
        BControlPoint bControlPoint = this.getParentPoint();
        if (bControlPoint instanceof BNumericWritable) {
            this.lexiconizeSlotInPoint(BNumericWritable.emergencyOverride.getName(), "%lexicon(eibnetIp:numeric.emergencyOverride)%");
            this.lexiconizeSlotInPoint(BNumericWritable.emergencyAuto.getName(), "%lexicon(eibnetIp:numeric.emergencyAuto)%");
            this.lexiconizeSlotInPoint(BNumericWritable.override.getName(), "%lexicon(eibnetIp:numeric.override)%");
            this.lexiconizeSlotInPoint(BNumericWritable.auto.getName(), "%lexicon(eibnetIp:numeric.auto)%");
            this.lexiconizeSlotInPoint(BNumericWritable.set.getName(), "%lexicon(eibnetIp:numeric.set)%");
        } else if (bControlPoint instanceof BStringWritable) {
            this.lexiconizeSlotInPoint(BStringWritable.emergencyOverride.getName(), "%lexicon(eibnetIp:string.emergencyOverride)%");
            this.lexiconizeSlotInPoint(BStringWritable.emergencyAuto.getName(), "%lexicon(eibnetIp:string.emergencyAuto)%");
            this.lexiconizeSlotInPoint(BStringWritable.override.getName(), "%lexicon(eibnetIp:string.override)%");
            this.lexiconizeSlotInPoint(BStringWritable.auto.getName(), "%lexicon(eibnetIp:string.auto)%");
            this.lexiconizeSlotInPoint(BStringWritable.set.getName(), "%lexicon(eibnetIp:string.set)%");
        } else if (bControlPoint instanceof BEnumWritable) {
            this.lexiconizeSlotInPoint(BEnumWritable.emergencyOverride.getName(), "%lexicon(eibnetIp:enum.emergencyOverride)%");
            this.lexiconizeSlotInPoint(BEnumWritable.emergencyAuto.getName(), "%lexicon(eibnetIp:enum.emergencyAuto)%");
            this.lexiconizeSlotInPoint(BEnumWritable.override.getName(), "%lexicon(eibnetIp:enum.override)%");
            this.lexiconizeSlotInPoint(BEnumWritable.auto.getName(), "%lexicon(eibnetIp:enum.auto)%");
            this.lexiconizeSlotInPoint(BEnumWritable.set.getName(), "%lexicon(eibnetIp:enum.set)%");
        } else if (bControlPoint instanceof BBooleanWritable) {
            this.lexiconizeSlotInPoint(BBooleanWritable.emergencyActive.getName(), "%lexicon(eibnetIp:boolean.emergencyActive)%");
            this.lexiconizeSlotInPoint(BBooleanWritable.emergencyInactive.getName(), "%lexicon(eibnetIp:boolean.emergencyInactive)%");
            this.lexiconizeSlotInPoint(BBooleanWritable.emergencyAuto.getName(), "%lexicon(eibnetIp:boolean.emergencyAuto)%");
            this.lexiconizeSlotInPoint(BBooleanWritable.active.getName(), "%lexicon(eibnetIp:boolean.active)%");
            this.lexiconizeSlotInPoint(BBooleanWritable.inactive.getName(), "%lexicon(eibnetIp:boolean.inactive)%");
            this.lexiconizeSlotInPoint(BBooleanWritable.auto.getName(), "%lexicon(eibnetIp:boolean.auto)%");
            this.lexiconizeSlotInPoint(BBooleanWritable.set.getName(), "%lexicon(eibnetIp:boolean.set)%");
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pollSubscribed = false;
        this.oldStatus = BStatus.DEFAULT;
    }

    public BKnxProxyExt() {
        this.this();
    }

    public BKnxProxyExt(BGroupAddress bGroupAddress) {
        this.this();
        this.getGroupAddresses().setPrimaryGroupAddress(bGroupAddress);
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$point$BKnxProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$point$BKnxProxyExt = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"eibnetIp");
        Class clazz2 = class$com$tridium$eibnetIp$point$BKnxProxyExt;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$eibnetIp$point$BKnxProxyExt = BKnxProxyExt.class("[Lcom.tridium.eibnetIp.point.BKnxProxyExt;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }
}

