/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.messages;

import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.datatypes.BDeviceHardwareDib;
import com.tridium.eibnetIp.datatypes.BEibnetIpHpai;
import com.tridium.eibnetIp.datatypes.BGroupAddress;
import com.tridium.eibnetIp.datatypes.BIndividualAddress;
import com.tridium.eibnetIp.datatypes.BServiceFamily;
import com.tridium.eibnetIp.datatypes.BSupportedServices;
import com.tridium.eibnetIp.datatypes.ConnectionHeader;
import com.tridium.eibnetIp.enums.BKnxMediumCodeEnum;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BEnum;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EibnetIpInputStream
extends ByteArrayInputStream
implements EibnetConst {
    public static final int STREAM_POOL_SIZE = 20;
    private static int cnt = 0;
    private static EibnetIpInputStream[] pool = new EibnetIpInputStream[20];
    private boolean freeBuf;
    public EibnetIpInputStream next;

    public static EibnetIpInputStream make(byte[] byArray) {
        return new EibnetIpInputStream(byArray, 0, byArray.length);
    }

    public void setBuffer(byte[] byArray) {
        this.buf = byArray;
        this.mark = 0;
        this.pos = 0;
        this.count = this.buf.length;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int readInt() {
        return this.read() << 8 | this.read();
    }

    public BEibnetIpHpai readHpai() throws IOException {
        BEibnetIpHpai bEibnetIpHpai = new BEibnetIpHpai();
        if (this.read() != 8) {
            throw new IOException("incorrect struct length for HPAI");
        }
        if (this.read() != 1) {
            throw new IOException("host protocol not IPV4_UDP");
        }
        bEibnetIpHpai.setAddress(Integer.toString(this.read()) + '.' + Integer.toString(this.read()) + '.' + Integer.toString(this.read()) + '.' + Integer.toString(this.read()));
        bEibnetIpHpai.setPort(this.readInt());
        return bEibnetIpHpai;
    }

    public ConnectionHeader readConnectionHeader() throws IOException {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        if (this.read() != 4) {
            throw new IOException("incorrect connection header length");
        }
        connectionHeader.setId(this.read());
        connectionHeader.setSequenceCounter(this.read());
        connectionHeader.setStatus(this.read());
        return connectionHeader;
    }

    public BIndividualAddress readIndividualAddress() {
        return new BIndividualAddress(this.readInt());
    }

    public BGroupAddress readGroupAddress() {
        return new BGroupAddress(this.readInt());
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int n) {
        this.pos = this.mark = n;
    }

    public void dump() {
        this.dump(null);
    }

    public void dump(String string) {
        System.out.println("\nEibIpInputStream dump: " + string);
        System.out.println("This stream: pos=" + this.pos + ", mark=" + this.mark + ", count=" + this.count);
        System.out.println("Pool info: freeBuf=" + this.freeBuf + ", cnt=" + cnt + ", next=" + this.next + '\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EibnetIpInputStream make() {
        EibnetIpInputStream[] eibnetIpInputStreamArray = pool;
        synchronized (pool) {
            EibnetIpInputStream eibnetIpInputStream = cnt > 0 && cnt <= 20 ? pool[--cnt] : new EibnetIpInputStream();
            eibnetIpInputStream.freeBuf = false;
            // ** MonitorExit[var1] (shouldn't be in output)
            return eibnetIpInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EibnetIpInputStream make(byte[] byArray, int n, int n2) {
        EibnetIpInputStream[] eibnetIpInputStreamArray = pool;
        synchronized (pool) {
            EibnetIpInputStream eibnetIpInputStream;
            block4: {
                block3: {
                    if (cnt <= 0 || cnt > 20) break block3;
                    eibnetIpInputStream = pool[--cnt];
                    eibnetIpInputStream.pos = n;
                    eibnetIpInputStream.mark = n;
                    eibnetIpInputStream.buf = byArray;
                    eibnetIpInputStream.count = n2;
                    break block4;
                }
                eibnetIpInputStream = new EibnetIpInputStream(byArray, n, n2);
            }
            eibnetIpInputStream.freeBuf = false;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return eibnetIpInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        EibnetIpInputStream[] eibnetIpInputStreamArray = pool;
        synchronized (pool) {
            EibnetIpInputStream eibnetIpInputStream = this;
            while (true) {
                if (eibnetIpInputStream == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (eibnetIpInputStream.freeBuf) continue;
                if (cnt < pool.length) {
                    EibnetIpInputStream.pool[EibnetIpInputStream.cnt++] = eibnetIpInputStream;
                }
                eibnetIpInputStream.freeBuf = true;
                eibnetIpInputStream = eibnetIpInputStream.next;
            }
        }
    }

    public BDeviceHardwareDib readHardwareDib() throws IOException {
        BDeviceHardwareDib bDeviceHardwareDib = new BDeviceHardwareDib();
        if (this.read() != 54) {
            throw new IOException("incorrect struct length for hardware DIB");
        }
        if (this.read() != 1) {
            throw new IOException("not a device DIB");
        }
        bDeviceHardwareDib.setKnxMedium((BEnum)BKnxMediumCodeEnum.make(this.read()));
        boolean bl = false;
        if (this.read() != 0) {
            bl = true;
        }
        bDeviceHardwareDib.setStatus(bl);
        bDeviceHardwareDib.setIndividualAddress(this.readIndividualAddress());
        int n = this.readInt();
        bDeviceHardwareDib.setProjectNumber(n >>> 4);
        bDeviceHardwareDib.setInstallationNumber(n & 0xF);
        byte[] byArray = new byte[6];
        this.read(byArray);
        bDeviceHardwareDib.setSerialNumber(ByteArrayUtil.toHexString((byte[])byArray));
        byte[] byArray2 = new byte[4];
        this.read(byArray2);
        byte[] byArray3 = new byte[6];
        this.read(byArray3);
        bDeviceHardwareDib.setMacAddress(ByteArrayUtil.toHexString((byte[])byArray3));
        byte[] byArray4 = new byte[30];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 30) {
            int n4 = this.read();
            if (n4 != 0) {
                byArray4[n3] = (byte)n4;
                ++n2;
            } else {
                this.skip(30 - n3 - 1);
                break;
            }
            ++n3;
        }
        bDeviceHardwareDib.setFriendlyName(new String(byArray4, 0, n2));
        return bDeviceHardwareDib;
    }

    public BSupportedServices readServices() throws IOException {
        int n = this.read();
        if (this.read() != 2) {
            throw new IOException("DIB is not a serices family DIB");
        }
        BSupportedServices bSupportedServices = new BSupportedServices();
        int n2 = 0;
        while (n2 < n - 2) {
            int n3 = this.read();
            int n4 = this.read();
            BServiceFamily bServiceFamily = new BServiceFamily();
            bServiceFamily.setSupport(true);
            bServiceFamily.setVersion(n4);
            switch (n3) {
                case 2: {
                    bSupportedServices.setCore(bServiceFamily);
                    break;
                }
                case 3: {
                    bSupportedServices.setDeviceManagement(bServiceFamily);
                    break;
                }
                case 4: {
                    bSupportedServices.setTunneling(bServiceFamily);
                    break;
                }
                case 5: {
                    bSupportedServices.setRouting(bServiceFamily);
                    break;
                }
                case 6: {
                    bSupportedServices.setRemoteLogging(bServiceFamily);
                    break;
                }
                case 7: {
                    bSupportedServices.setRemoteConfiguration(bServiceFamily);
                    break;
                }
                case 8: {
                    bSupportedServices.setObjectServer(bServiceFamily);
                    break;
                }
            }
            n2 += 2;
        }
        return bSupportedServices;
    }

    private final /* synthetic */ void this() {
        this.freeBuf = false;
        this.next = null;
    }

    private EibnetIpInputStream() {
        super(new byte[0]);
        this.this();
    }

    private EibnetIpInputStream(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.this();
    }
}

