/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp.job;

import com.tridium.eibnetIp.BEibnetIpNetwork;
import com.tridium.eibnetIp.datatypes.BDeviceHardwareDib;
import com.tridium.eibnetIp.datatypes.BKnxDiscoveryDevice;
import com.tridium.eibnetIp.datatypes.BSupportedServices;
import com.tridium.eibnetIp.messages.EibnetIpInputStream;
import com.tridium.eibnetIp.messages.IgmpLeaveGroupMessage;
import com.tridium.eibnetIp.messages.IgmpMembershipReportMessage;
import com.tridium.eibnetIp.stack.BEibnetIpLinkLayer;
import com.tridium.eibnetIp.stack.KnxSearchResponseListener;
import com.tridium.eibnetIp.stack.LinkLayerSearchRequest;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BKnxDiscoverDevicesJob
extends BSimpleJob
implements KnxSearchResponseListener {
    public static final Property learnedDevices = BKnxDiscoverDevicesJob.newProperty((int)0, (BValue)new BFolder(), null);
    public static final Topic deviceLearned = BKnxDiscoverDevicesJob.newTopic((int)0, null);
    public static final Type TYPE;
    private BEibnetIpNetwork network;
    private BEibnetIpLinkLayer linkLayer;
    private BacnetEthernetAdapter igmpAdapter;
    byte[] myMacAddress;
    static /* synthetic */ Class class$com$tridium$eibnetIp$job$BKnxDiscoverDevicesJob;

    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    public void setLearnedDevices(BFolder bFolder) {
        this.set(learnedDevices, (BValue)bFolder, null);
    }

    public void fireDeviceLearned(BValue bValue) {
        this.fire(deviceLearned, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        if (this.network == null) {
            throw new IllegalStateException("Must submit thru BEibnetIpNetwork.submitDeviceDiscoveryJob()");
        }
        this.network.getLinkLayer().registerSearchResponseListener(this);
        if (!this.isAlive()) {
            return;
        }
        this.progress(50);
        try {
            this.sendIgmpMembershipReport();
        }
        catch (Exception exception) {
            this.failed(exception);
        }
        this.network.getLinkLayer().unregisterSearchResponseListener(this);
    }

    public void sendIgmpMembershipReport() throws Exception {
        Object object;
        this.logMessage("sendIgmpMembershipReport");
        this.getBacnetPlatformService().init();
        try {
            this.igmpAdapter = this.openAdapter();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("unable to open adapter");
        }
        this.igmpAdapter.commStart();
        this.myMacAddress = new byte[6];
        try {
            this.igmpAdapter.getAddress(this.myMacAddress);
        }
        catch (Exception exception) {
            throw new Exception("unable to determine mac");
        }
        byte[] byArray = this.linkLayer.getLocalAddress().getAddress();
        IgmpMembershipReportMessage igmpMembershipReportMessage = new IgmpMembershipReportMessage(this.myMacAddress, byArray);
        byte[] byArray2 = igmpMembershipReportMessage.getBytes();
        if (byArray2 == null) {
            this.logMessage("null IgmpMembershipReport message - cannot proceed with device discovery");
            return;
        }
        try {
            this.igmpAdapter.sendPacket(byArray2);
            this.logMessage("Packet Sent:" + ByteArrayUtil.toHexString((byte[])byArray2));
        }
        catch (Exception exception) {
            this.logMessage("Error sending IGMP membership report packet:" + exception);
        }
        this.progress(25);
        try {
            object = this.linkLayer.getLocalAddress();
            LinkLayerSearchRequest linkLayerSearchRequest = new LinkLayerSearchRequest((InetAddress)object, this.linkLayer.getLocalPort());
            this.logMessage("search req:" + ByteArrayUtil.toHexString((byte[])linkLayerSearchRequest.toBytes()));
            InetAddress inetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)"224.0.23.12"));
            DatagramPacket datagramPacket = new DatagramPacket(linkLayerSearchRequest.toBytes(), linkLayerSearchRequest.length(), inetAddress, 3671);
            this.linkLayer.transmit(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.progress(50);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {}
        object = new IgmpLeaveGroupMessage(this.myMacAddress, byArray);
        byArray2 = ((IgmpLeaveGroupMessage)object).getBytes();
        if (byArray2 == null) {
            this.logMessage("null IgmpLeaveGroup message - cannot proceed with device discovery");
            return;
        }
        try {
            this.igmpAdapter.sendPacket(byArray2);
            this.logMessage("Packet Sent:" + ByteArrayUtil.toHexString((byte[])byArray2));
        }
        catch (Exception exception) {
            this.logMessage("Cannot send IGMP leave group packet:" + exception);
        }
        this.progress(75);
        this.igmpAdapter.commCleanup();
    }

    public BBacnetEthernetPlatformService getBacnetPlatformService() {
        try {
            return (BBacnetEthernetPlatformService)Sys.getService((Type)BBacnetEthernetPlatformService.TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void rcvSearchResponse(byte[] byArray) throws IOException {
        this.logMessage("rcvSearchResponse");
        EibnetIpInputStream eibnetIpInputStream = EibnetIpInputStream.make(byArray);
        BKnxDiscoveryDevice bKnxDiscoveryDevice = new BKnxDiscoveryDevice();
        this.logMessage("reading HPAI");
        bKnxDiscoveryDevice.setControlEndpoint(eibnetIpInputStream.readHpai());
        bKnxDiscoveryDevice.setIpAddress(bKnxDiscoveryDevice.getControlEndpoint().getAddress());
        this.logMessage("reading hw DIB");
        BDeviceHardwareDib bDeviceHardwareDib = eibnetIpInputStream.readHardwareDib();
        bKnxDiscoveryDevice.setDeviceHardware(bDeviceHardwareDib);
        bKnxDiscoveryDevice.setMacAddress(bDeviceHardwareDib.getMacAddress());
        bKnxDiscoveryDevice.setFriendlyName(bDeviceHardwareDib.getFriendlyName());
        this.logMessage("reading services DIB");
        BSupportedServices bSupportedServices = eibnetIpInputStream.readServices();
        bKnxDiscoveryDevice.setSupportedServices(bSupportedServices);
        this.add(null, (BValue)bKnxDiscoveryDevice);
        this.logMessage("fireDeviceLearned");
        this.fireDeviceLearned((BValue)bKnxDiscoveryDevice);
    }

    private final void logMessage(String string) {
        this.log().message(string);
        if (this.network != null) {
            int n = this.network.getLog().getSeverity();
            this.network.getLog().setSeverity(1);
            this.network.getLog().message("Discover Devices Job:" + string);
            this.network.getLog().setSeverity(n);
        }
    }

    BacnetEthernetAdapter openAdapter() throws Exception {
        String string = SlotPath.unescape((String)this.linkLayer.getLocalAdapterId().getTag());
        String string2 = SlotPath.unescape((String)this.linkLayer.getLocalAdapter().getTag());
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        BacnetEthernetAdapter bacnetEthernetAdapter = null;
        this.getBacnetPlatformService().getAdapterChoices(vector, vector2, vector3);
        int n = 0;
        while (n < vector3.size()) {
            String string3 = (String)vector.elementAt(n);
            String string4 = (String)vector2.elementAt(n);
            String string5 = (String)vector3.elementAt(n);
            if (string5.endsWith(string)) {
                bacnetEthernetAdapter = this.getBacnetPlatformService().openAdapter((String)vector3.elementAt(n));
            } else if (string2.startsWith(string4)) {
                bacnetEthernetAdapter = this.getBacnetPlatformService().openAdapter((String)vector3.elementAt(n));
            }
            ++n;
        }
        return bacnetEthernetAdapter;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BKnxDiscoverDevicesJob() {
    }

    public BKnxDiscoverDevicesJob(BEibnetIpNetwork bEibnetIpNetwork) {
        this.network = bEibnetIpNetwork;
        this.linkLayer = this.network.getLinkLayer();
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$job$BKnxDiscoverDevicesJob;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$job$BKnxDiscoverDevicesJob = BKnxDiscoverDevicesJob.class("[Lcom.tridium.eibnetIp.job.BKnxDiscoverDevicesJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

