/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp;

import com.tridium.basicdriver.util.BBasicPollScheduler;
import com.tridium.eibnetIp.BEibnetIpDevice;
import com.tridium.eibnetIp.BEibnetIpDeviceFolder;
import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.job.BKnxDiscoverDevicesJob;
import com.tridium.eibnetIp.stack.BEibnetIpLinkLayer;
import com.tridium.eibnetIp.stack.BEibnetIpTunnelLayer;
import com.tridium.eibnetIp.util.BEibnetWorker;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollScheduler;
import javax.baja.license.Feature;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEibnetIpNetwork
extends BLoadableNetwork
implements EibnetConst,
BIService {
    public static final Property worker = BEibnetIpNetwork.newProperty((int)4, (BValue)new BEibnetWorker("EibWrk"), null);
    public static final Property writeWorker = BEibnetIpNetwork.newProperty((int)4, (BValue)new BEibnetWorker("EibWWk"), null);
    public static final Property tuningPolicies = BEibnetIpNetwork.newProperty((int)0, (BValue)new BTuningPolicyMap(), null);
    public static final Property pollScheduler = BEibnetIpNetwork.newProperty((int)0, (BValue)new BBasicPollScheduler(), null);
    public static final Property interMessageDelay = BEibnetIpNetwork.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)0), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property linkLayer = BEibnetIpNetwork.newProperty((int)0, (BValue)new BEibnetIpLinkLayer(), null);
    public static final Property tunnelLayer = BEibnetIpNetwork.newProperty((int)0, (BValue)new BEibnetIpTunnelLayer(), null);
    public static final Action submitDeviceDiscoveryJob = BEibnetIpNetwork.newAction((int)4, null);
    public static final Action disconnectAll = BEibnetIpNetwork.newAction((int)0, null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static BEibnetIpNetwork eibnetService;
    protected static final Log log;
    private static Lexicon lex;
    static /* synthetic */ Class class$com$tridium$eibnetIp$BEibnetIpNetwork;
    static /* synthetic */ Class class$com$tridium$eibnetIp$BEibnetIpDevice;

    public BEibnetWorker getWorker() {
        return (BEibnetWorker)this.get(worker);
    }

    public void setWorker(BEibnetWorker bEibnetWorker) {
        this.set(worker, (BValue)bEibnetWorker, null);
    }

    public BEibnetWorker getWriteWorker() {
        return (BEibnetWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BEibnetWorker bEibnetWorker) {
        this.set(writeWorker, (BValue)bEibnetWorker, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BPollScheduler getPollScheduler() {
        return (BPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BPollScheduler bPollScheduler) {
        this.set(pollScheduler, (BValue)bPollScheduler, null);
    }

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime bRelTime) {
        this.set(interMessageDelay, (BValue)bRelTime, null);
    }

    public BEibnetIpLinkLayer getLinkLayer() {
        return (BEibnetIpLinkLayer)this.get(linkLayer);
    }

    public void setLinkLayer(BEibnetIpLinkLayer bEibnetIpLinkLayer) {
        this.set(linkLayer, (BValue)bEibnetIpLinkLayer, null);
    }

    public BEibnetIpTunnelLayer getTunnelLayer() {
        return (BEibnetIpTunnelLayer)this.get(tunnelLayer);
    }

    public void setTunnelLayer(BEibnetIpTunnelLayer bEibnetIpTunnelLayer) {
        this.set(tunnelLayer, (BValue)bEibnetIpTunnelLayer, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public void disconnectAll() {
        this.invoke(disconnectAll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
        eibnetService = this;
    }

    public final void serviceStopped() {
        eibnetService = null;
    }

    public void started() throws Exception {
        try {
            super.started();
            if (Sys.getService((Type)TYPE) != this) {
                this.configFail(lex.get(TYPE.getTypeName() + ".duplicateNetwork"));
                throw new IllegalStateException("Only one EibnetIpNetwork allowed per station!");
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("EibnetIpNetwork not registered as a service!");
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled && !this.getEnabled()) {
            this.disconnectAll();
        }
    }

    public Type getDeviceType() {
        return BEibnetIpDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BEibnetIpDeviceFolder.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "eibnetIp");
    }

    public IFuture postAsync(Runnable runnable) {
        return this.getWorker().post(runnable);
    }

    public IFuture postWrite(Runnable runnable) {
        return this.getWriteWorker().post(runnable);
    }

    public BEibnetIpDevice[] getDeviceList() {
        Class clazz = class$com$tridium$eibnetIp$BEibnetIpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$BEibnetIpDevice = BEibnetIpNetwork.class("[Lcom.tridium.eibnetIp.BEibnetIpDevice;", false);
        }
        return (BEibnetIpDevice[])this.getChildren(clazz);
    }

    public static final BEibnetIpNetwork eibnet() {
        try {
            if (Sys.getStation() == null) {
                return eibnetService;
            }
            return (BEibnetIpNetwork)Sys.getService((Type)TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            log.error("Unable to locate Eibnet Service!", (Throwable)serviceNotFoundException);
            return null;
        }
    }

    public BOrd doSubmitDeviceDiscoveryJob(Context context) {
        return new BKnxDiscoverDevicesJob(this).submit(context);
    }

    public void doDisconnectAll() {
        BEibnetIpDevice[] bEibnetIpDeviceArray = this.getDeviceList();
        int n = 0;
        while (n < bEibnetIpDeviceArray.length) {
            bEibnetIpDeviceArray[n].doDisconnect();
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BEibnetIpNetwork() {
        this.setFlags((Slot)ping, 4);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.getMonitor().setPingFrequency(BRelTime.makeSeconds((int)5));
        this.getMonitor().setStartupAlarmDelay(BRelTime.makeMinutes((int)2));
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$BEibnetIpNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$BEibnetIpNetwork = BEibnetIpNetwork.class("[Lcom.tridium.eibnetIp.BEibnetIpNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        eibnetService = null;
        log = Log.getLog((String)"eibnetIp");
        Class clazz2 = class$com$tridium$eibnetIp$BEibnetIpNetwork;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$eibnetIp$BEibnetIpNetwork = BEibnetIpNetwork.class("[Lcom.tridium.eibnetIp.BEibnetIpNetwork;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        UnitDatabase.getDefault();
    }
}

