/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eibnetIp;

import com.tridium.eibnetIp.BEibnetIpNetwork;
import com.tridium.eibnetIp.BEibnetIpPointDeviceExt;
import com.tridium.eibnetIp.EibnetConst;
import com.tridium.eibnetIp.datatypes.BDeviceHardwareDib;
import com.tridium.eibnetIp.datatypes.BEibnetIpConnection;
import com.tridium.eibnetIp.datatypes.BEibnetIpHpai;
import com.tridium.eibnetIp.datatypes.BSupportedServices;
import com.tridium.eibnetIp.enums.BEibnetIpConnectionTypeEnum;
import com.tridium.eibnetIp.point.BKnxProxyExt;
import com.tridium.eibnetIp.stack.BEibnetIpLinkLayer;
import com.tridium.eibnetIp.util.BEibnetWorker;
import com.tridium.eibnetIp.util.EibUtil;
import com.tridium.nre.util.IPAddressUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import javax.baja.driver.loadable.BLoadableDevice;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEibnetIpDevice
extends BLoadableDevice
implements EibnetConst {
    public static final Property ipAddress = BEibnetIpDevice.newProperty((int)0, (String)"0.0.0.0", (BFacets)BFacets.make((String)"fieldEditor", (String)"platform:IpHostFE"));
    public static final Property macAddress = BEibnetIpDevice.newProperty((int)1, (String)"", null);
    public static final Property description = BEibnetIpDevice.newProperty((int)1, (String)"", null);
    public static final Property deviceInfo = BEibnetIpDevice.newProperty((int)3, (BValue)new BDeviceHardwareDib(), null);
    public static final Property servicesInfo = BEibnetIpDevice.newProperty((int)3, (BValue)new BSupportedServices(), null);
    public static final Property dataEndpoint = BEibnetIpDevice.newProperty((int)3, (BValue)new BEibnetIpHpai(), null);
    public static final Property connection = BEibnetIpDevice.newProperty((int)3, (BValue)new BEibnetIpConnection(), null);
    public static final Property etsExportFile = BEibnetIpDevice.newProperty((int)1, (BValue)BOrd.make((String)"local:|file:/C:/Program Files/Ets/Database/export.efs"), null);
    public static final Property connectWorker = BEibnetIpDevice.newProperty((int)4, (BValue)new BEibnetWorker("EibDevWrk"), null);
    public static final Property sendKeepAlivesWhileCommActivity = BEibnetIpDevice.newProperty((int)0, (boolean)true, null);
    public static final Property points = BEibnetIpDevice.newProperty((int)0, (BValue)new BEibnetIpPointDeviceExt(), null);
    public static final Action retrieveDeviceInfo = BEibnetIpDevice.newAction((int)0, null);
    public static final Action connect = BEibnetIpDevice.newAction((int)0, null);
    public static final Action disconnect = BEibnetIpDevice.newAction((int)0, null);
    public static final Action keepAlive = BEibnetIpDevice.newAction((int)4, null);
    public static final Action dumpObjectMap = BEibnetIpDevice.newAction((int)0, null);
    public static final Type TYPE;
    protected static final Log log;
    private boolean disconnectPending;
    private long timeOfLastMessage;
    private int tunnelSendCounter;
    boolean connectRequestPending;
    Object connectionMonitor;
    private int connectionError;
    private int lastConnectError;
    boolean connected;
    private InetAddress deviceIpAddress;
    Clock.Ticket keepAliveTimer;
    boolean wasEnabled;
    private IntHashMap groupAddressMap;
    static /* synthetic */ Class class$com$tridium$eibnetIp$BEibnetIpDevice;

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String string) {
        this.setString(ipAddress, string, null);
    }

    public String getMacAddress() {
        return this.getString(macAddress);
    }

    public void setMacAddress(String string) {
        this.setString(macAddress, string, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String string) {
        this.setString(description, string, null);
    }

    public BDeviceHardwareDib getDeviceInfo() {
        return (BDeviceHardwareDib)this.get(deviceInfo);
    }

    public void setDeviceInfo(BDeviceHardwareDib bDeviceHardwareDib) {
        this.set(deviceInfo, (BValue)bDeviceHardwareDib, null);
    }

    public BSupportedServices getServicesInfo() {
        return (BSupportedServices)this.get(servicesInfo);
    }

    public void setServicesInfo(BSupportedServices bSupportedServices) {
        this.set(servicesInfo, (BValue)bSupportedServices, null);
    }

    public BEibnetIpHpai getDataEndpoint() {
        return (BEibnetIpHpai)this.get(dataEndpoint);
    }

    public void setDataEndpoint(BEibnetIpHpai bEibnetIpHpai) {
        this.set(dataEndpoint, (BValue)bEibnetIpHpai, null);
    }

    public BEibnetIpConnection getConnection() {
        return (BEibnetIpConnection)this.get(connection);
    }

    public void setConnection(BEibnetIpConnection bEibnetIpConnection) {
        this.set(connection, (BValue)bEibnetIpConnection, null);
    }

    public BOrd getEtsExportFile() {
        return (BOrd)this.get(etsExportFile);
    }

    public void setEtsExportFile(BOrd bOrd) {
        this.set(etsExportFile, (BValue)bOrd, null);
    }

    public BEibnetWorker getConnectWorker() {
        return (BEibnetWorker)this.get(connectWorker);
    }

    public void setConnectWorker(BEibnetWorker bEibnetWorker) {
        this.set(connectWorker, (BValue)bEibnetWorker, null);
    }

    public boolean getSendKeepAlivesWhileCommActivity() {
        return this.getBoolean(sendKeepAlivesWhileCommActivity);
    }

    public void setSendKeepAlivesWhileCommActivity(boolean bl) {
        this.setBoolean(sendKeepAlivesWhileCommActivity, bl, null);
    }

    public BEibnetIpPointDeviceExt getPoints() {
        return (BEibnetIpPointDeviceExt)this.get(points);
    }

    public void setPoints(BEibnetIpPointDeviceExt bEibnetIpPointDeviceExt) {
        this.set(points, (BValue)bEibnetIpPointDeviceExt, null);
    }

    public void retrieveDeviceInfo() {
        this.invoke(retrieveDeviceInfo, null, null);
    }

    public void connect() {
        this.invoke(connect, null, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void keepAlive() {
        this.invoke(keepAlive, null, null);
    }

    public void dumpObjectMap() {
        this.invoke(dumpObjectMap, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.pingFail("startup");
        this.keepAliveTimer = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)keepAlive, null);
        this.timeOfLastMessage = Clock.ticks();
        this.deviceIpAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)this.getIpAddress()));
        if (!this.deviceIpAddress.isLoopbackAddress()) {
            this.eibNetwork().getLinkLayer().registerDevice(this);
        }
        this.wasEnabled = this.isDisabled() ^ true;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        this.connect();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)status)) {
            if (!this.eibNetwork().getLinkLayer().isAlive()) {
                return;
            }
            if (this.isDisabled() && this.wasEnabled) {
                this.lastConnectError = 259;
                this.disconnect();
            } else if (!this.isDisabled() && !this.wasEnabled && Sys.isStationStarted()) {
                this.connect();
            }
            this.wasEnabled = this.isDisabled() ^ true;
        }
        if (property.equals((Object)ipAddress)) {
            this.eibNetwork().getLinkLayer().unregisterDevice(this);
            try {
                InetAddress inetAddress;
                this.deviceIpAddress = inetAddress = InetAddress.getByAddress(IPAddressUtil.numericStringToByteArray((String)this.getIpAddress()));
                this.eibNetwork().getLinkLayer().registerDevice(this);
            }
            catch (Exception exception) {
                log.error("invalid ip:" + this.getIpAddress(), (Throwable)exception);
                exception.printStackTrace();
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
        }
        this.keepAliveTimer = null;
        this.eibNetwork().getLinkLayer().unregisterDevice(this);
    }

    public BEibnetIpNetwork eibNetwork() {
        return (BEibnetIpNetwork)this.getNetwork();
    }

    public Log getLog() {
        return log;
    }

    public Type getNetworkType() {
        return BEibnetIpNetwork.TYPE;
    }

    public void doPing() throws Exception {
        if (!this.getEnabled()) {
            this.lastConnectError = 259;
            this.pingFail(this.lastConnectError);
            return;
        }
        if (this.isConnected()) {
            this.pingOk();
            return;
        }
        this.pingFail(this.lastConnectError);
        this.doConnect();
    }

    public void pingOk() {
        this.isDown();
        super.pingOk();
    }

    public void doKeepAlive() throws NotRunningException {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.eibNetwork().getLinkLayer().isAlive()) {
            return;
        }
        if (!this.connected) {
            return;
        }
        if (this.timeOfLastMessage + 60000L < Clock.ticks() || this.getSendKeepAlivesWhileCommActivity()) {
            this.getConnectWorker().post(new Runnable(){

                public final void run() {
                    if (!BEibnetIpDevice.this.getEnabled()) {
                        return;
                    }
                    BEibnetIpDevice.this.sendKeepAlive();
                }
            });
        } else {
            log.trace(this.getIpAddress() + ":inhibit keep alive");
        }
    }

    public void doRetrieveDeviceInfo() {
        this.eibNetwork().postAsync(new Runnable(){

            public final void run() {
                try {
                    BEibnetIpDevice.this.eibNetwork().getLinkLayer().sendDescriptionRequest(BEibnetIpDevice.this);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendKeepAlive() {
        if (!this.isConnected()) {
            return;
        }
        try {
            int n = 0;
            while (n < 4) {
                if (this.eibNetwork().getLinkLayer().getTunnelTrace()) {
                    log.trace("tx CONNECTIONSTATE_REQUEST " + n + " to " + this.getIpAddress());
                }
                Object object = this.connectionMonitor;
                synchronized (object) {
                    this.connectionError = 256;
                    this.eibNetwork().getLinkLayer().sendConnectionStateRequest(this);
                    this.connectionMonitor.wait(10000L);
                    switch (this.connectionError) {
                        case 0: {
                            return;
                        }
                        case 256: {
                            if (n < 3) {
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 5, 10, 12] lbl20 : MonitorExitStatement: MONITOREXIT : var2_4
                                break;
                            } else {
                                this.lastConnectError = 257;
                                this.connectionError = 257;
                                break;
                            }
                        }
                        default: {
                            log.error(this.getIpAddress() + ":connection state request " + n + "  error:" + BEibnetIpLinkLayer.connectErrors.get(this.connectionError).toString());
                        }
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            log.error(this.getIpAddress() + ":sendKeepAlive IOException");
        }
        catch (InterruptedException interruptedException) {
            log.error(this.getIpAddress() + ":sendKeepAlive interruptedException");
        }
        log.error(this.getIpAddress() + ":sendKeepAlive failed with following error:" + BEibnetIpLinkLayer.connectErrors.get(this.connectionError).toString());
        this.doDisconnect();
    }

    public void doConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.isRunning() || !this.getEnabled()) {
            return;
        }
        if (!this.connectRequestPending) {
            this.connectRequestPending = true;
            this.getConnectWorker().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void run() {
                    if (!BEibnetIpDevice.this.isRunning() || !BEibnetIpDevice.this.getEnabled() || BEibnetIpDevice.this.isConnected()) {
                        log.error(BEibnetIpDevice.this.getIpAddress() + ":doConnect cannot process because device object not in running state or already connected");
                        BEibnetIpDevice.this.connectRequestPending = false;
                        return;
                    }
                    if (BEibnetIpDevice.this.eibNetwork().getLinkLayer().getLocalAdapter().getOrdinal() == -1) {
                        log.error(BEibnetIpDevice.this.getIpAddress() + ":doConnect cannot process because ethernet adpater not selected");
                        BEibnetIpDevice.this.connectRequestPending = false;
                        return;
                    }
                    log.message("connect from " + BEibnetIpDevice.this.eibNetwork().getLinkLayer().getLocalAddress().getHostAddress() + " to " + BEibnetIpDevice.this.getIpAddress());
                    BEibnetIpDevice.this.connectionError = 256;
                    int n = 0;
                    while (n < 3) {
                        block12: {
                            try {
                                Object object = BEibnetIpDevice.this.connectionMonitor;
                                synchronized (object) {
                                    if (!BEibnetIpDevice.this.isRunning()) {
                                        BEibnetIpDevice.this.connectRequestPending = false;
                                        BEibnetIpDevice.this.pingFail(260);
                                        return;
                                    }
                                    BEibnetIpDevice.this.eibNetwork().getLinkLayer().sendConnectRequest(BEibnetIpDevice.this);
                                    BEibnetIpDevice.this.connectionMonitor.wait(10000L);
                                }
                                if (BEibnetIpDevice.this.connectionError == 0) {
                                    log.message("device " + BEibnetIpDevice.this.getIpAddress() + " is connected on channel " + BEibnetIpDevice.this.getConnection().getChannelId());
                                    BEibnetIpDevice.this.setConnected(true);
                                    BEibnetIpDevice.this.pingOk();
                                    BEibnetIpDevice.this.connectRequestPending = false;
                                    BEibnetIpDevice.this.retrieveDeviceInfo();
                                    return;
                                }
                                if (BEibnetIpDevice.this.connectionError == 256) {
                                    log.message(BEibnetIpDevice.this.getIpAddress() + ":connect timeout " + n);
                                }
                                if (BEibnetIpDevice.this.connectionError != 36) break block12;
                                BEibnetIpDevice.this.disconnect();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                break;
                            }
                        }
                        ++n;
                    }
                    log.error(BEibnetIpDevice.this.getIpAddress() + ":cannot connect");
                    BEibnetIpDevice.this.setConnected(false);
                    if (BEibnetIpDevice.this.connectionError == 256) {
                        BEibnetIpDevice.this.connectionError = 257;
                    }
                    BEibnetIpDevice.this.lastConnectError = BEibnetIpDevice.this.connectionError;
                    BEibnetIpDevice.this.pingFail(BEibnetIpDevice.this.lastConnectError);
                    BEibnetIpDevice.this.connectRequestPending = false;
                }
            });
        }
    }

    private final void pingFail(int n) {
        this.pingFail(BEibnetIpLinkLayer.connectErrors.get(n).toString());
    }

    public void doDisconnect() {
        if (this.disconnectPending) {
            return;
        }
        this.disconnectPending = true;
        this.getConnectWorker().post(new Runnable(){

            public final void run() {
                int n = BEibnetIpDevice.this.getConnection().getChannelId();
                log.message(BEibnetIpDevice.this.getIpAddress() + ":doDisconnect channel " + n);
                try {
                    BEibnetIpDevice.this.eibNetwork().getLinkLayer().sendDisconnectRequest(BEibnetIpDevice.this, n);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (BEibnetIpDevice.this.isConnected()) {
                    BEibnetIpDevice.this.pingFail(BEibnetIpDevice.this.lastConnectError);
                }
                BEibnetIpDevice.this.setConnected(false);
                BEibnetIpDevice.this.disconnectPending = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnectionMessage(int n, int n2) {
        this.getConnection().setChannelId(n);
        this.getConnection().setChannelStatus(BEibnetIpLinkLayer.connectErrors.get(n2).toString());
        this.connectionError = n2;
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.connectionMonitor.notifyAll();
            return;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
        if (!this.connected) {
            this.getConnection().setChannelStatus("no connection");
            this.getConnection().setTypeCode(BEibnetIpConnectionTypeEnum.none);
        }
    }

    public void setTimeOfLastMessage() {
        this.timeOfLastMessage = Clock.ticks();
    }

    public void incrementTunnelSendCounter() {
        ++this.tunnelSendCounter;
        if (this.tunnelSendCounter == 256) {
            this.tunnelSendCounter = 0;
        }
    }

    public void resetTunnelSendCounter() {
        this.tunnelSendCounter = 0;
    }

    public int getTunnelSendCounter() {
        return this.tunnelSendCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerLDataListener(BKnxProxyExt bKnxProxyExt) {
        IntHashMap intHashMap = this.groupAddressMap;
        synchronized (intHashMap) {
            IntHashMap.Iterator iterator = bKnxProxyExt.getGroupAddresses().getGroups().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int n = iterator.key();
                Vector<BKnxProxyExt> vector = (Vector<BKnxProxyExt>)this.groupAddressMap.get(n);
                if (vector == null) {
                    vector = new Vector<BKnxProxyExt>();
                    this.groupAddressMap.put(n, vector);
                }
                if (vector.contains(bKnxProxyExt)) continue;
                vector.add(bKnxProxyExt);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterLDataListener(BKnxProxyExt bKnxProxyExt) {
        IntHashMap intHashMap = this.groupAddressMap;
        synchronized (intHashMap) {
            IntHashMap.Iterator iterator = this.groupAddressMap.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int n = iterator.key();
                Vector vector = (Vector)this.groupAddressMap.get(n);
                if (vector == null) continue;
                while (vector.contains(bKnxProxyExt)) {
                    vector.removeElement(bKnxProxyExt);
                }
                if (!vector.isEmpty()) continue;
                this.groupAddressMap.remove(n);
            }
            return;
        }
    }

    public Vector getGroupedExtensions(int n) {
        return (Vector)this.groupAddressMap.get(n);
    }

    public IntHashMap getGroupAddressMap() {
        return this.groupAddressMap;
    }

    public void doDumpObjectMap() {
        IntHashMap.Iterator iterator = this.groupAddressMap.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("---ALL GROUPS---\n");
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            stringBuffer.append("  group key:" + EibUtil.groupIntegerToString(iterator.key()) + ' ');
            int n = 0;
            while (n < vector.size()) {
                BComponent bComponent = (BComponent)vector.get(n);
                stringBuffer.append(bComponent.getParent().getDisplayName(null)).append("  ");
                ++n;
            }
            stringBuffer.append("\n");
        }
        System.out.println(stringBuffer.toString());
    }

    public InetAddress getDeviceIpAddress() {
        return this.deviceIpAddress;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        if (!this.isRunning()) {
            return;
        }
        spyWriter.startProps();
        spyWriter.trTitle((Object)"EibnetIpDevice", 2);
        spyWriter.prop((Object)"deviceIpAddress", (Object)this.deviceIpAddress.getHostAddress());
        spyWriter.prop((Object)"connectRequestPending", this.connectRequestPending);
        spyWriter.prop((Object)"connectionError", this.connectionError);
        spyWriter.prop((Object)"lastConnectError", this.lastConnectError);
        spyWriter.prop((Object)"connected", this.connected);
        spyWriter.prop((Object)"tunnelSendCounter", this.tunnelSendCounter);
        spyWriter.prop((Object)"dataEndpoint-address", (Object)this.getDataEndpoint().getAddress());
        spyWriter.prop((Object)"dataEndpoint-port", this.getDataEndpoint().getPort());
        spyWriter.prop((Object)"connection-channelId", this.getConnection().getChannelId());
        spyWriter.prop((Object)"connection-channelStatus", (Object)this.getConnection().getChannelStatus());
        spyWriter.prop((Object)"connection-typeCode", (Object)this.getConnection().getTypeCode());
        spyWriter.prop((Object)"connection-individualAddress", (Object)this.getConnection().getIndividualAddress().getAddress());
        spyWriter.prop((Object)"connection-sequenceCounter", this.getConnection().getSequenceCounter());
        spyWriter.prop((Object)"disconnectPending", this.disconnectPending);
        spyWriter.endProps();
    }

    static /* synthetic */ boolean access$5(BEibnetIpDevice bEibnetIpDevice) {
        return bEibnetIpDevice.disconnectPending;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.disconnectPending = false;
        this.timeOfLastMessage = 0L;
        this.tunnelSendCounter = 0;
        this.connectRequestPending = false;
        this.connectionMonitor = new Object();
        this.lastConnectError = 0;
        this.connected = false;
        this.groupAddressMap = new IntHashMap(100);
    }

    public BEibnetIpDevice() {
        this.this();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    static {
        Class clazz = class$com$tridium$eibnetIp$BEibnetIpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$eibnetIp$BEibnetIpDevice = BEibnetIpDevice.class("[Lcom.tridium.eibnetIp.BEibnetIpDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"eibnetIp");
    }
}

