/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ValueReference;

public class ObjectIdentifierValue
extends MibValue {
    private FileLocation location = null;
    private MibValue parent;
    private ArrayList children = new ArrayList();
    private String name;
    private int value;
    private MibValueSymbol symbol = null;
    private String cachedNumericValue = null;

    public ObjectIdentifierValue(String string, int n) {
        super("OBJECT IDENTIFIER");
        this.parent = null;
        this.name = string;
        this.value = n;
    }

    public ObjectIdentifierValue(FileLocation fileLocation, ObjectIdentifierValue objectIdentifierValue, String string, int n) throws MibException {
        super("OBJECT IDENTIFIER");
        this.parent = objectIdentifierValue;
        this.name = string;
        this.value = n;
        if (objectIdentifierValue.getChildByValue(n) != null) {
            throw new MibException(fileLocation, "cannot add duplicate OID children with value " + n);
        }
        objectIdentifierValue.addChild(null, fileLocation, this);
    }

    public ObjectIdentifierValue(FileLocation fileLocation, ValueReference valueReference, String string, int n) {
        super("OBJECT IDENTIFIER");
        this.location = fileLocation;
        this.parent = valueReference;
        this.name = string;
        this.value = n;
    }

    public MibValue initialize(MibLoaderLog mibLoaderLog, MibType mibType) throws MibException {
        ValueReference valueReference = null;
        if (this.parent == null) {
            return this;
        }
        if (this.parent instanceof ValueReference) {
            valueReference = (ValueReference)this.parent;
        }
        this.parent = this.parent.initialize(mibLoaderLog, mibType);
        if (valueReference != null) {
            if (this.parent instanceof ObjectIdentifierValue) {
                ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)this.parent;
                objectIdentifierValue.addChild(mibLoaderLog, this.location, this);
            } else {
                throw new MibException(valueReference.getLocation(), "referenced value is not an object identifier");
            }
        }
        this.location = null;
        if (this.parent instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.parent).getChildByValue(this.value);
        }
        return this;
    }

    public MibValue createReference() {
        return this;
    }

    protected void clear() {
        if (this.children != null) {
            Mib mib = this.getMib();
            ArrayList arrayList = (ArrayList)this.children.clone();
            for (int i = 0; i < arrayList.size(); ++i) {
                ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)arrayList.get(i);
                if (mib != null && mib != objectIdentifierValue.getMib()) continue;
                objectIdentifierValue.clear();
            }
        }
        if (this.getChildCount() <= 0) {
            if (this.parent != null) {
                this.getParent().children.remove(this);
                this.parent = null;
            }
            this.children = null;
        }
        this.symbol = null;
        super.clear();
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ObjectIdentifierValue getParent() {
        if (this.parent != null && this.parent instanceof ObjectIdentifierValue) {
            return (ObjectIdentifierValue)this.parent;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public MibValueSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(MibValueSymbol mibValueSymbol) {
        if (this.name == null) {
            this.name = mibValueSymbol.getName();
        }
        this.symbol = mibValueSymbol;
    }

    private Mib getMib() {
        return this.symbol == null ? null : this.symbol.getMib();
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public ObjectIdentifierValue getChild(int n) {
        return (ObjectIdentifierValue)this.children.get(n);
    }

    public ObjectIdentifierValue getChildByName(String string) {
        for (int i = 0; i < this.children.size(); ++i) {
            ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)this.children.get(i);
            if (!string.equals(objectIdentifierValue.getName())) continue;
            return objectIdentifierValue;
        }
        return null;
    }

    public ObjectIdentifierValue getChildByValue(int n) {
        int n2 = 0;
        int n3 = this.children.size();
        int n4 = n2 < n && n <= n3 ? n - 1 : (n2 + n3) / 2;
        while (n2 < n3) {
            ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)this.children.get(n4);
            if (objectIdentifierValue.getValue() == n) {
                return objectIdentifierValue;
            }
            if (objectIdentifierValue.getValue() < n) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = (n2 + n3) / 2;
        }
        return null;
    }

    public ObjectIdentifierValue[] getAllChildren() {
        ObjectIdentifierValue[] objectIdentifierValueArray = new ObjectIdentifierValue[this.children.size()];
        this.children.toArray(objectIdentifierValueArray);
        return objectIdentifierValueArray;
    }

    private ObjectIdentifierValue addChild(MibLoaderLog mibLoaderLog, FileLocation fileLocation, ObjectIdentifierValue objectIdentifierValue) throws MibException {
        int n;
        for (n = this.children.size(); n > 0; --n) {
            ObjectIdentifierValue objectIdentifierValue2 = (ObjectIdentifierValue)this.children.get(n - 1);
            if (objectIdentifierValue2.getValue() == objectIdentifierValue.getValue()) {
                objectIdentifierValue2 = objectIdentifierValue2.merge(mibLoaderLog, fileLocation, objectIdentifierValue);
                this.children.set(n - 1, objectIdentifierValue2);
                return objectIdentifierValue2;
            }
            if (objectIdentifierValue2.getValue() < objectIdentifierValue.getValue()) break;
        }
        this.children.add(n, objectIdentifierValue);
        return objectIdentifierValue;
    }

    private void addChildren(MibLoaderLog mibLoaderLog, FileLocation fileLocation, ObjectIdentifierValue objectIdentifierValue) throws MibException {
        if (this.name == null) {
            this.name = objectIdentifierValue.name;
        } else if (objectIdentifierValue.name != null && !objectIdentifierValue.name.equals(this.name)) {
            String string = "OID component '" + objectIdentifierValue.name + "' was previously " + "defined as '" + this.name + "'";
            if (mibLoaderLog == null) {
                throw new MibException(fileLocation, string);
            }
            mibLoaderLog.addWarning(fileLocation, string);
        }
        if (objectIdentifierValue.symbol != null) {
            throw new MibException(fileLocation, "INTERNAL ERROR: OID merge with symbol reference already set");
        }
        for (int i = 0; i < objectIdentifierValue.children.size(); ++i) {
            ObjectIdentifierValue objectIdentifierValue2 = (ObjectIdentifierValue)objectIdentifierValue.children.get(i);
            objectIdentifierValue2.parent = this;
            this.addChild(mibLoaderLog, fileLocation, objectIdentifierValue2);
        }
        objectIdentifierValue.children = null;
    }

    private ObjectIdentifierValue merge(MibLoaderLog mibLoaderLog, FileLocation fileLocation, ObjectIdentifierValue objectIdentifierValue) throws MibException {
        if (this.symbol != null || objectIdentifierValue.symbol == null && this.children.size() > 0) {
            this.addChildren(mibLoaderLog, fileLocation, objectIdentifierValue);
            return this;
        }
        objectIdentifierValue.addChildren(mibLoaderLog, fileLocation, this);
        return objectIdentifierValue;
    }

    public Object toObject() {
        return this.toString();
    }

    public String toString() {
        if (this.cachedNumericValue == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.parent != null) {
                stringBuffer.append(this.parent.toString());
                stringBuffer.append(".");
            }
            stringBuffer.append(this.value);
            this.cachedNumericValue = stringBuffer.toString();
        }
        return this.cachedNumericValue;
    }

    public String toDetailString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parent instanceof ObjectIdentifierValue) {
            stringBuffer.append(((ObjectIdentifierValue)this.parent).toDetailString());
            stringBuffer.append(".");
        }
        if (this.name == null) {
            stringBuffer.append(this.value);
        } else {
            stringBuffer.append(this.name);
            stringBuffer.append("(");
            stringBuffer.append(this.value);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String toAsn1String() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parent instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)this.parent;
            if (objectIdentifierValue.getSymbol() == null) {
                stringBuffer.append(objectIdentifierValue.toAsn1String());
            } else {
                stringBuffer.append(objectIdentifierValue.getSymbol().getName());
            }
            stringBuffer.append(" ");
        }
        if (this.name == null || this.getSymbol() != null) {
            stringBuffer.append(this.value);
        } else {
            stringBuffer.append(this.name);
            stringBuffer.append("(");
            stringBuffer.append(this.value);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

