/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ValueReference;

public class BitSetValue
extends MibValue {
    private BitSet value;
    private ArrayList references;

    public BitSetValue(BitSet bitSet) {
        this(bitSet, null);
    }

    public BitSetValue(BitSet bitSet, ArrayList arrayList) {
        super("BIT STRING");
        this.value = bitSet;
        this.references = arrayList;
    }

    public MibValue initialize(MibLoaderLog mibLoaderLog, MibType mibType) throws MibException {
        if (this.references != null) {
            for (int i = 0; i < this.references.size(); ++i) {
                this.initialize(mibLoaderLog, mibType, (ValueReference)this.references.get(i));
            }
            this.references = null;
        }
        return this;
    }

    public MibValue createReference() {
        return new BitSetValue(this.value, this.references);
    }

    private void initialize(MibLoaderLog mibLoaderLog, MibType mibType, ValueReference valueReference) throws MibException {
        MibValue mibValue = valueReference.initialize(mibLoaderLog, mibType);
        if (!(mibValue instanceof NumberValue)) {
            throw new MibException(valueReference.getLocation(), "referenced value is not a number");
        }
        this.value.set(((Number)mibValue.toObject()).intValue());
    }

    protected void clear() {
        super.clear();
        this.value = null;
        this.references = null;
    }

    public ArrayList getBits() {
        ArrayList<NumberValue> arrayList = new ArrayList<NumberValue>();
        for (int i = 0; i < this.value.size(); ++i) {
            if (!this.value.get(i)) continue;
            arrayList.add(new NumberValue(new Integer(i)));
        }
        return arrayList;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object toObject() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public String toAsn1String(MibValueSymbol[] mibValueSymbolArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.value.size(); ++i) {
            if (!this.value.get(i)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.toAsn1String(new Integer(i), mibValueSymbolArray));
        }
        if (stringBuffer.length() > 0) {
            return "{ " + stringBuffer.toString() + " }";
        }
        return "{}";
    }

    private String toAsn1String(Integer n, MibValueSymbol[] mibValueSymbolArray) {
        for (int i = 0; i < mibValueSymbolArray.length; ++i) {
            if (!mibValueSymbolArray[i].getValue().equals(n)) continue;
            return mibValueSymbolArray[i].getName();
        }
        return n.toString();
    }
}

