/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.math.BigInteger;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.value.NumberValue;

public class BinaryNumberValue
extends NumberValue {
    private int minLength;

    public BinaryNumberValue(Number number) {
        this(number, 1);
    }

    public BinaryNumberValue(Number number, int n) {
        super(number);
        this.minLength = n;
    }

    public MibValue initialize(MibLoaderLog mibLoaderLog, MibType mibType) {
        int n = this.minLength / 8 + (this.minLength % 8 > 0 ? 1 : 0);
        int n2 = this.getByteSize(mibType, n) * 8;
        if (n2 > this.minLength) {
            this.minLength = n2;
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        String string = this.toBinaryString();
        if (string.equals("0")) {
            string = "";
        }
        for (int i = string.length(); i < this.minLength; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append("'B");
        return stringBuffer.toString();
    }

    private String toBinaryString() {
        Number number = (Number)this.toObject();
        if (number instanceof BigInteger) {
            return ((BigInteger)number).toString(2);
        }
        if (number instanceof Long) {
            return Long.toBinaryString(number.longValue());
        }
        return Integer.toBinaryString(number.intValue());
    }
}

