/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.value.StringValue;

public class StringType
extends MibType {
    private Constraint constraint = null;

    public StringType() {
        this(true, null);
    }

    public StringType(Constraint constraint) {
        this(true, constraint);
    }

    private StringType(boolean bl, Constraint constraint) {
        super("OCTET STRING", bl);
        this.constraint = constraint;
        this.setTag(true, MibTypeTag.OCTET_STRING);
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        if (this.constraint != null) {
            this.constraint.initialize(this, mibLoaderLog);
        }
        return this;
    }

    public MibType createReference() {
        StringType stringType = new StringType(false, this.constraint);
        stringType.setTag(true, this.getTag());
        return stringType;
    }

    public MibType createReference(Constraint constraint) {
        StringType stringType = new StringType(false, constraint);
        stringType.setTag(true, this.getTag());
        return stringType;
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    public boolean isCompatible(MibValue mibValue) {
        return this.isCompatibleType(mibValue) && (this.constraint == null || this.constraint.isCompatible(mibValue));
    }

    private boolean isCompatibleType(MibValue mibValue) {
        return mibValue instanceof StringValue;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.constraint != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.constraint.toString());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

