/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.StringValue;

public class SizeConstraint
implements Constraint {
    private FileLocation location;
    private Constraint values;

    public SizeConstraint(FileLocation fileLocation, Constraint constraint) {
        this.location = fileLocation;
        this.values = constraint;
    }

    public void initialize(MibType mibType, MibLoaderLog mibLoaderLog) throws MibException {
        this.values.initialize(new IntegerType(), mibLoaderLog);
        if (this.location != null && !this.isCompatible(mibType)) {
            String string = "Size constraint not compatible with this type";
            mibLoaderLog.addWarning(this.location, string);
        }
        this.location = null;
    }

    public boolean isCompatible(MibType mibType) {
        return mibType instanceof SequenceOfType || mibType instanceof StringType;
    }

    public boolean isCompatible(MibValue mibValue) {
        if (mibValue instanceof StringValue) {
            Integer n = new Integer(mibValue.toString().length());
            return this.values.isCompatible(new NumberValue(n));
        }
        return false;
    }

    public ArrayList getValues() {
        if (this.values instanceof CompoundConstraint) {
            return ((CompoundConstraint)this.values).getConstraintList();
        }
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        arrayList.add(this.values);
        return arrayList;
    }

    public int nextValue(int n) {
        ArrayList arrayList = this.getValues();
        Object object = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Constraint constraint = (Constraint)arrayList.get(i);
            if (constraint instanceof ValueConstraint) {
                object = ((ValueConstraint)constraint).getValue().toObject();
            } else if (constraint instanceof ValueRangeConstraint) {
                if (((ValueRangeConstraint)constraint).isCompatible(new Integer(n))) {
                    return n;
                }
                object = ((ValueRangeConstraint)constraint).getLowerBound().toObject();
            }
            if (!(object instanceof Number) || n > ((Number)object).intValue()) continue;
            return ((Number)object).intValue();
        }
        return -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SIZE (");
        stringBuffer.append(this.values);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

