/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.value.NumberValue;

public class IntegerType
extends MibType
implements MibContext {
    private Constraint constraint = null;
    private LinkedHashMap symbols = new LinkedHashMap();

    public IntegerType() {
        this(true, null, null);
    }

    public IntegerType(Constraint constraint) {
        this(true, constraint, null);
    }

    public IntegerType(ArrayList arrayList) {
        this(true, null, null);
        this.createValueConstraints(arrayList);
    }

    private IntegerType(boolean bl, Constraint constraint, LinkedHashMap linkedHashMap) {
        super("INTEGER", bl);
        if (constraint != null) {
            this.constraint = constraint;
        }
        if (linkedHashMap != null) {
            this.symbols = linkedHashMap;
        }
        this.setTag(true, MibTypeTag.INTEGER);
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        Iterator iterator = this.symbols.values().iterator();
        if (this.constraint != null) {
            this.constraint.initialize(this, mibLoaderLog);
        }
        while (iterator.hasNext()) {
            MibValueSymbol mibValueSymbol = (MibValueSymbol)iterator.next();
            mibValueSymbol.initialize(mibLoaderLog);
            if (this.isCompatibleType(mibValueSymbol.getValue())) continue;
            String string = "value is not compatible with type";
            throw new MibException(mibValueSymbol.getLocation(), string);
        }
        return this;
    }

    public MibType createReference() {
        IntegerType integerType = new IntegerType(false, this.constraint, this.symbols);
        integerType.setTag(true, this.getTag());
        return integerType;
    }

    public MibType createReference(Constraint constraint) {
        IntegerType integerType = new IntegerType(false, constraint, null);
        integerType.setTag(true, this.getTag());
        return integerType;
    }

    public MibType createReference(ArrayList arrayList) {
        IntegerType integerType = new IntegerType(false, null, null);
        integerType.createValueConstraints(arrayList);
        integerType.setTag(true, this.getTag());
        return integerType;
    }

    private void createValueConstraints(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!(arrayList.get(i) instanceof MibValueSymbol)) continue;
            MibValueSymbol mibValueSymbol = (MibValueSymbol)arrayList.get(i);
            this.symbols.put(mibValueSymbol.getName(), mibValueSymbol);
            ValueConstraint valueConstraint = new ValueConstraint(null, mibValueSymbol.getValue());
            this.constraint = this.constraint == null ? valueConstraint : new CompoundConstraint(this.constraint, valueConstraint);
        }
    }

    public boolean hasConstraint() {
        return this.constraint != null;
    }

    public boolean hasSymbols() {
        return this.symbols.size() > 0;
    }

    public boolean isCompatible(MibValue mibValue) {
        return this.isCompatibleType(mibValue) && (this.constraint == null || this.constraint.isCompatible(mibValue));
    }

    private boolean isCompatibleType(MibValue mibValue) {
        return mibValue instanceof NumberValue && !(mibValue.toObject() instanceof Float);
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public MibValueSymbol getSymbol(String string) {
        return (MibValueSymbol)this.symbols.get(string);
    }

    public MibValueSymbol[] getAllSymbols() {
        Iterator iterator = this.symbols.values().iterator();
        MibValueSymbol[] mibValueSymbolArray = new MibValueSymbol[this.symbols.size()];
        int n = 0;
        while (iterator.hasNext()) {
            mibValueSymbolArray[n] = (MibValueSymbol)iterator.next();
            ++n;
        }
        return mibValueSymbolArray;
    }

    public MibSymbol findSymbol(String string, boolean bl) {
        return this.getSymbol(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.symbols.size() > 0) {
            stringBuffer.append(" { ");
            Iterator iterator = this.symbols.values().iterator();
            while (iterator.hasNext()) {
                MibValueSymbol mibValueSymbol = (MibValueSymbol)iterator.next();
                stringBuffer.append(mibValueSymbol.getName());
                stringBuffer.append("(");
                stringBuffer.append(mibValueSymbol.getValue());
                stringBuffer.append(")");
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
        } else if (this.constraint != null) {
            stringBuffer.append(" (");
            stringBuffer.append(this.constraint.toString());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }
}

