/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpVariation {
    private MibValue value;
    private MibType syntax;
    private MibType writeSyntax;
    private SnmpAccess access;
    private ArrayList requiredCells;
    private MibValue defaultValue;
    private String description;

    public SnmpVariation(MibValue mibValue, MibType mibType, MibType mibType2, SnmpAccess snmpAccess, ArrayList arrayList, MibValue mibValue2, String string) {
        this.value = mibValue;
        this.syntax = mibType;
        this.writeSyntax = mibType2;
        this.access = snmpAccess;
        this.requiredCells = arrayList;
        this.defaultValue = mibValue2;
        this.description = string;
    }

    void initialize(MibLoaderLog mibLoaderLog) throws MibException {
        ArrayList<MibValue> arrayList = new ArrayList<MibValue>();
        MibType mibType = null;
        this.value = this.value.initialize(mibLoaderLog, null);
        if (this.getBaseSymbol() != null) {
            mibType = this.getBaseSymbol().getType();
            if (mibType instanceof SnmpTextualConvention) {
                mibType = ((SnmpTextualConvention)mibType).getSyntax();
            }
            if (mibType instanceof SnmpObjectType) {
                mibType = ((SnmpObjectType)mibType).getSyntax();
            }
        }
        if (this.syntax != null) {
            this.syntax = this.syntax.initialize(null, mibLoaderLog);
        }
        if (this.writeSyntax != null) {
            this.writeSyntax = this.writeSyntax.initialize(null, mibLoaderLog);
        }
        for (int i = 0; i < this.requiredCells.size(); ++i) {
            arrayList.add(((MibValue)this.requiredCells.get(i)).initialize(mibLoaderLog, mibType));
        }
        this.requiredCells = arrayList;
        if (this.defaultValue != null) {
            this.defaultValue = this.defaultValue.initialize(mibLoaderLog, mibType);
        }
    }

    public MibValueSymbol getBaseSymbol() {
        if (this.value instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.value).getSymbol();
        }
        return null;
    }

    public MibValue getValue() {
        return this.value;
    }

    public MibType getSyntax() {
        return this.syntax;
    }

    public MibType getWriteSyntax() {
        return this.writeSyntax;
    }

    public SnmpAccess getAccess() {
        return this.access;
    }

    public ArrayList getRequiredCells() {
        return this.requiredCells;
    }

    public MibValue getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.value);
        if (this.syntax != null) {
            stringBuffer.append("\n      Syntax: ");
            stringBuffer.append(this.syntax);
        }
        if (this.writeSyntax != null) {
            stringBuffer.append("\n      Write-Syntax: ");
            stringBuffer.append(this.writeSyntax);
        }
        if (this.access != null) {
            stringBuffer.append("\n      Access: ");
            stringBuffer.append(this.access);
        }
        if (this.requiredCells.size() > 0) {
            stringBuffer.append("\n      Creation-Requires: ");
            stringBuffer.append(this.requiredCells);
        }
        if (this.defaultValue != null) {
            stringBuffer.append("\n      Default Value: ");
            stringBuffer.append(this.defaultValue);
        }
        stringBuffer.append("\n      Description: ");
        stringBuffer.append(this.description);
        return stringBuffer.toString();
    }
}

