/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpVariation;

public class SnmpModuleSupport {
    private String module;
    private ArrayList groups;
    private ArrayList variations;

    public SnmpModuleSupport(String string, ArrayList arrayList, ArrayList arrayList2) {
        this.module = string;
        this.groups = arrayList;
        this.variations = arrayList2;
    }

    void initialize(MibLoaderLog mibLoaderLog) throws MibException {
        int n;
        ArrayList<MibValue> arrayList = new ArrayList<MibValue>();
        for (n = 0; n < this.groups.size(); ++n) {
            arrayList.add(((MibValue)this.groups.get(n)).initialize(mibLoaderLog, null));
        }
        this.groups = arrayList;
        for (n = 0; n < this.variations.size(); ++n) {
            try {
                ((SnmpVariation)this.variations.get(n)).initialize(mibLoaderLog);
                continue;
            }
            catch (MibException mibException) {
                mibLoaderLog.addError(mibException.getLocation(), mibException.getMessage());
            }
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public ArrayList getVariations() {
        return this.variations;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.module != null) {
            stringBuffer.append(this.module);
        }
        stringBuffer.append("\n    Includes: ");
        stringBuffer.append(this.groups);
        for (int i = 0; i < this.variations.size(); ++i) {
            stringBuffer.append("\n    Variation: ");
            stringBuffer.append(this.variations.get(i));
        }
        return stringBuffer.toString();
    }
}

