/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.snmp.SnmpCompliance;

public class SnmpModule {
    private String module;
    private ArrayList groups;
    private ArrayList compliances;
    private String comment = null;

    public SnmpModule(String string, ArrayList arrayList, ArrayList arrayList2) {
        this.module = string;
        this.groups = arrayList;
        this.compliances = arrayList2;
    }

    void initialize(MibLoaderLog mibLoaderLog) throws MibException {
        int n;
        ArrayList<MibValue> arrayList = new ArrayList<MibValue>();
        for (n = 0; n < this.groups.size(); ++n) {
            arrayList.add(((MibValue)this.groups.get(n)).initialize(mibLoaderLog, null));
        }
        this.groups = arrayList;
        for (n = 0; n < this.compliances.size(); ++n) {
            ((SnmpCompliance)this.compliances.get(n)).initialize(mibLoaderLog);
        }
    }

    public String getModule() {
        return this.module;
    }

    public ArrayList getGroups() {
        return this.groups;
    }

    public ArrayList getCompliances() {
        return this.compliances;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        if (this.module != null || !"THIS MODULE".equalsIgnoreCase(string)) {
            this.comment = string;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.module != null) {
            stringBuffer.append(this.module);
        }
        if (this.groups.size() > 0) {
            stringBuffer.append("\n    Mandatory Groups: ");
            stringBuffer.append(this.groups);
        }
        for (int i = 0; i < this.compliances.size(); ++i) {
            stringBuffer.append("\n    Module: ");
            stringBuffer.append(this.compliances.get(i));
        }
        return stringBuffer.toString();
    }
}

