/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpAgentCapabilities
extends SnmpType {
    private String productRelease;
    private SnmpStatus status;
    private String reference;
    private ArrayList modules;

    public SnmpAgentCapabilities(String string, SnmpStatus snmpStatus, String string2, String string3, ArrayList arrayList) {
        super("AGENT-CAPABILITIES", string2);
        this.productRelease = string;
        this.status = snmpStatus;
        this.reference = string3;
        this.modules = arrayList;
    }

    public MibType initialize(MibSymbol mibSymbol, MibLoaderLog mibLoaderLog) throws MibException {
        if (!(mibSymbol instanceof MibValueSymbol)) {
            throw new MibException(mibSymbol.getLocation(), "only values can have the " + this.getName() + " type");
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            ((SnmpModuleSupport)this.modules.get(i)).initialize(mibLoaderLog);
        }
        return this;
    }

    public boolean isCompatible(MibValue mibValue) {
        return mibValue instanceof ObjectIdentifierValue;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList getModules() {
        return this.modules;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" (");
        stringBuffer.append("\n  Product Release: ");
        stringBuffer.append(this.productRelease);
        stringBuffer.append("\n  Status: ");
        stringBuffer.append(this.status);
        stringBuffer.append("\n  Description: ");
        stringBuffer.append(this.getDescription("               "));
        if (this.reference != null) {
            stringBuffer.append("\n  Reference: ");
            stringBuffer.append(this.reference);
        }
        for (int i = 0; i < this.modules.size(); ++i) {
            stringBuffer.append("\n  Supports Module: ");
            stringBuffer.append(this.modules.get(i));
        }
        stringBuffer.append("\n)");
        return stringBuffer.toString();
    }
}

