/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.asn1;

import net.percederberg.grammatica.parser.Analyzer;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

public abstract class Asn1Analyzer
extends Analyzer {
    boolean debug = false;
    int ccnt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void enter(Node node) throws ParseException {
        if (this.debug) {
            this.pad(this.ccnt++);
            System.out.print("e " + this.asnToString(node.getId()) + "  ");
        }
        try {
            switch (node.getId()) {
                case 1001: {
                    this.enterDot((Token)node);
                    return;
                }
                case 1002: {
                    this.enterDoubleDot((Token)node);
                    return;
                }
                case 1003: {
                    this.enterTripleDot((Token)node);
                    return;
                }
                case 1004: {
                    this.enterComma((Token)node);
                    return;
                }
                case 1005: {
                    this.enterSemiColon((Token)node);
                    return;
                }
                case 1006: {
                    this.enterLeftParen((Token)node);
                    return;
                }
                case 1007: {
                    this.enterRightParen((Token)node);
                    return;
                }
                case 1008: {
                    this.enterLeftBrace((Token)node);
                    return;
                }
                case 1009: {
                    this.enterRightBrace((Token)node);
                    return;
                }
                case 1010: {
                    this.enterLeftBracket((Token)node);
                    return;
                }
                case 1011: {
                    this.enterRightBracket((Token)node);
                    return;
                }
                case 1012: {
                    this.enterMinus((Token)node);
                    return;
                }
                case 1013: {
                    this.enterLessThan((Token)node);
                    return;
                }
                case 1014: {
                    this.enterVerticalBar((Token)node);
                    return;
                }
                case 1015: {
                    this.enterDefinition((Token)node);
                    return;
                }
                case 1016: {
                    this.enterDefinitions((Token)node);
                    return;
                }
                case 1017: {
                    this.enterExplicit((Token)node);
                    return;
                }
                case 1018: {
                    this.enterImplicit((Token)node);
                    return;
                }
                case 1019: {
                    this.enterTags((Token)node);
                    return;
                }
                case 1020: {
                    this.enterBegin((Token)node);
                    return;
                }
                case 1021: {
                    this.enterEnd((Token)node);
                    return;
                }
                case 1022: {
                    this.enterExports((Token)node);
                    return;
                }
                case 1023: {
                    this.enterImports((Token)node);
                    return;
                }
                case 1024: {
                    this.enterFrom((Token)node);
                    return;
                }
                case 1025: {
                    this.enterMacro((Token)node);
                    return;
                }
                case 1026: {
                    this.enterInteger((Token)node);
                    return;
                }
                case 1027: {
                    this.enterReal((Token)node);
                    return;
                }
                case 1028: {
                    this.enterBoolean((Token)node);
                    return;
                }
                case 1029: {
                    this.enterNull((Token)node);
                    return;
                }
                case 1030: {
                    this.enterBit((Token)node);
                    return;
                }
                case 1031: {
                    this.enterOctet((Token)node);
                    return;
                }
                case 1032: {
                    this.enterString((Token)node);
                    return;
                }
                case 1033: {
                    this.enterEnumerated((Token)node);
                    return;
                }
                case 1034: {
                    this.enterSequence((Token)node);
                    return;
                }
                case 1035: {
                    this.enterSet((Token)node);
                    return;
                }
                case 1036: {
                    this.enterOf((Token)node);
                    return;
                }
                case 1037: {
                    this.enterChoice((Token)node);
                    return;
                }
                case 1038: {
                    this.enterUniversal((Token)node);
                    return;
                }
                case 1039: {
                    this.enterApplication((Token)node);
                    return;
                }
                case 1040: {
                    this.enterPrivate((Token)node);
                    return;
                }
                case 1041: {
                    this.enterAny((Token)node);
                    return;
                }
                case 1042: {
                    this.enterDefined((Token)node);
                    return;
                }
                case 1043: {
                    this.enterBy((Token)node);
                    return;
                }
                case 1044: {
                    this.enterObject((Token)node);
                    return;
                }
                case 1045: {
                    this.enterIdentifier((Token)node);
                    return;
                }
                case 1046: {
                    this.enterIncludes((Token)node);
                    return;
                }
                case 1047: {
                    this.enterMin((Token)node);
                    return;
                }
                case 1048: {
                    this.enterMax((Token)node);
                    return;
                }
                case 1049: {
                    this.enterSize((Token)node);
                    return;
                }
                case 1050: {
                    this.enterWith((Token)node);
                    return;
                }
                case 1051: {
                    this.enterComponent((Token)node);
                    return;
                }
                case 1052: {
                    this.enterComponents((Token)node);
                    return;
                }
                case 1053: {
                    this.enterPresent((Token)node);
                    return;
                }
                case 1054: {
                    this.enterAbsent((Token)node);
                    return;
                }
                case 1055: {
                    this.enterOptional((Token)node);
                    return;
                }
                case 1056: {
                    this.enterDefault((Token)node);
                    return;
                }
                case 1057: {
                    this.enterTrue((Token)node);
                    return;
                }
                case 1058: {
                    this.enterFalse((Token)node);
                    return;
                }
                case 1059: {
                    this.enterPlusInfinity((Token)node);
                    return;
                }
                case 1060: {
                    this.enterMinusInfinity((Token)node);
                    return;
                }
                case 1061: {
                    this.enterModuleIdentity((Token)node);
                    return;
                }
                case 1062: {
                    this.enterObjectIdentity((Token)node);
                    return;
                }
                case 1063: {
                    this.enterObjectType((Token)node);
                    return;
                }
                case 1064: {
                    this.enterNotificationType((Token)node);
                    return;
                }
                case 1065: {
                    this.enterTrapType((Token)node);
                    return;
                }
                case 1066: {
                    this.enterTextualConvention((Token)node);
                    return;
                }
                case 1067: {
                    this.enterObjectGroup((Token)node);
                    return;
                }
                case 1068: {
                    this.enterNotificationGroup((Token)node);
                    return;
                }
                case 1069: {
                    this.enterModuleCompliance((Token)node);
                    return;
                }
                case 1070: {
                    this.enterAgentCapabilities((Token)node);
                    return;
                }
                case 1071: {
                    this.enterLastUpdated((Token)node);
                    return;
                }
                case 1072: {
                    this.enterOrganization((Token)node);
                    return;
                }
                case 1073: {
                    this.enterContactInfo((Token)node);
                    return;
                }
                case 1074: {
                    this.enterDescription((Token)node);
                    return;
                }
                case 1075: {
                    this.enterRevision((Token)node);
                    return;
                }
                case 1076: {
                    this.enterStatus((Token)node);
                    return;
                }
                case 1077: {
                    this.enterReference((Token)node);
                    return;
                }
                case 1078: {
                    this.enterSyntax((Token)node);
                    return;
                }
                case 1079: {
                    this.enterBits((Token)node);
                    return;
                }
                case 1080: {
                    this.enterUnits((Token)node);
                    return;
                }
                case 1081: {
                    this.enterAccess((Token)node);
                    return;
                }
                case 1082: {
                    this.enterMaxAccess((Token)node);
                    return;
                }
                case 1083: {
                    this.enterMinAccess((Token)node);
                    return;
                }
                case 1084: {
                    this.enterIndex((Token)node);
                    return;
                }
                case 1085: {
                    this.enterAugments((Token)node);
                    return;
                }
                case 1086: {
                    this.enterImplied((Token)node);
                    return;
                }
                case 1087: {
                    this.enterDefval((Token)node);
                    return;
                }
                case 1088: {
                    this.enterObjects((Token)node);
                    return;
                }
                case 1089: {
                    this.enterEnterprise((Token)node);
                    return;
                }
                case 1090: {
                    this.enterVariables((Token)node);
                    return;
                }
                case 1091: {
                    this.enterDisplayHint((Token)node);
                    return;
                }
                case 1092: {
                    this.enterNotifications((Token)node);
                    return;
                }
                case 1093: {
                    this.enterModule((Token)node);
                    return;
                }
                case 1094: {
                    this.enterMandatoryGroups((Token)node);
                    return;
                }
                case 1095: {
                    this.enterGroup((Token)node);
                    return;
                }
                case 1096: {
                    this.enterWriteSyntax((Token)node);
                    return;
                }
                case 1097: {
                    this.enterProductRelease((Token)node);
                    return;
                }
                case 1098: {
                    this.enterSupports((Token)node);
                    return;
                }
                case 1099: {
                    this.enterVariation((Token)node);
                    return;
                }
                case 1100: {
                    this.enterCreationRequires((Token)node);
                    return;
                }
                case 1101: {
                    this.enterBinaryString((Token)node);
                    return;
                }
                case 1102: {
                    this.enterHexadecimalString((Token)node);
                    return;
                }
                case 1103: {
                    this.enterQuotedString((Token)node);
                    return;
                }
                case 1104: {
                    this.enterIdentifierString((Token)node);
                    if (!this.debug) return;
                    System.out.print(((Token)node).getImage());
                    return;
                }
                case 1105: {
                    this.enterNumberString((Token)node);
                    return;
                }
                case 2001: {
                    this.enterStart((Production)node);
                    return;
                }
                case 2002: {
                    this.enterModuleDefinition((Production)node);
                    return;
                }
                case 2003: {
                    this.enterModuleIdentifier((Production)node);
                    return;
                }
                case 2004: {
                    this.enterModuleReference((Production)node);
                    return;
                }
                case 2005: {
                    this.enterTagDefault((Production)node);
                    return;
                }
                case 2006: {
                    this.enterModuleBody((Production)node);
                    return;
                }
                case 2007: {
                    this.enterExportList((Production)node);
                    return;
                }
                case 2008: {
                    this.enterImportList((Production)node);
                    return;
                }
                case 2009: {
                    this.enterSymbolsFromModule((Production)node);
                    return;
                }
                case 2010: {
                    this.enterSymbolList((Production)node);
                    return;
                }
                case 2011: {
                    this.enterSymbol((Production)node);
                    return;
                }
                case 2012: {
                    this.enterAssignmentList((Production)node);
                    return;
                }
                case 2013: {
                    this.enterAssignment((Production)node);
                    return;
                }
                case 2014: {
                    this.enterMacroDefinition((Production)node);
                    return;
                }
                case 2015: {
                    this.enterMacroReference((Production)node);
                    return;
                }
                case 2016: {
                    this.enterMacroBody((Production)node);
                    return;
                }
                case 2017: {
                    this.enterMacroBodyElement((Production)node);
                    return;
                }
                case 2018: {
                    this.enterTypeAssignment((Production)node);
                    return;
                }
                case 2019: {
                    this.enterType((Production)node);
                    return;
                }
                case 2020: {
                    this.enterDefinedType((Production)node);
                    return;
                }
                case 2021: {
                    this.enterBuiltinType((Production)node);
                    return;
                }
                case 2022: {
                    this.enterNullType((Production)node);
                    return;
                }
                case 2023: {
                    this.enterBooleanType((Production)node);
                    return;
                }
                case 2024: {
                    this.enterRealType((Production)node);
                    return;
                }
                case 2025: {
                    this.enterIntegerType((Production)node);
                    return;
                }
                case 2026: {
                    this.enterObjectIdentifierType((Production)node);
                    return;
                }
                case 2027: {
                    this.enterStringType((Production)node);
                    return;
                }
                case 2028: {
                    this.enterBitStringType((Production)node);
                    return;
                }
                case 2029: {
                    this.enterBitsType((Production)node);
                    return;
                }
                case 2030: {
                    this.enterSequenceType((Production)node);
                    return;
                }
                case 2031: {
                    this.enterSequenceOfType((Production)node);
                    return;
                }
                case 2032: {
                    this.enterSetType((Production)node);
                    return;
                }
                case 2033: {
                    this.enterSetOfType((Production)node);
                    return;
                }
                case 2034: {
                    this.enterChoiceType((Production)node);
                    return;
                }
                case 2035: {
                    this.enterEnumeratedType((Production)node);
                    return;
                }
                case 2036: {
                    this.enterSelectionType((Production)node);
                    return;
                }
                case 2037: {
                    this.enterTaggedType((Production)node);
                    return;
                }
                case 2038: {
                    this.enterTag((Production)node);
                    return;
                }
                case 2039: {
                    this.enterClass((Production)node);
                    return;
                }
                case 2040: {
                    this.enterExplicitOrImplicitTag((Production)node);
                    return;
                }
                case 2041: {
                    this.enterAnyType((Production)node);
                    return;
                }
                case 2042: {
                    this.enterElementTypeList((Production)node);
                    return;
                }
                case 2043: {
                    this.enterElementType((Production)node);
                    return;
                }
                case 2044: {
                    this.enterOptionalOrDefaultElement((Production)node);
                    return;
                }
                case 2045: {
                    this.enterValueOrConstraintList((Production)node);
                    return;
                }
                case 2046: {
                    this.enterNamedNumberList((Production)node);
                    return;
                }
                case 2047: {
                    this.enterNamedNumber((Production)node);
                    return;
                }
                case 2048: {
                    this.enterNumber((Production)node);
                    return;
                }
                case 2049: {
                    this.enterConstraintList((Production)node);
                    return;
                }
                case 2050: {
                    this.enterConstraint((Production)node);
                    return;
                }
                case 2051: {
                    this.enterValueConstraintList((Production)node);
                    return;
                }
                case 2052: {
                    this.enterValueConstraint((Production)node);
                    return;
                }
                case 2053: {
                    this.enterValueRange((Production)node);
                    return;
                }
                case 2054: {
                    this.enterLowerEndPoint((Production)node);
                    return;
                }
                case 2055: {
                    this.enterUpperEndPoint((Production)node);
                    return;
                }
                case 2056: {
                    this.enterSizeConstraint((Production)node);
                    return;
                }
                case 2057: {
                    this.enterAlphabetConstraint((Production)node);
                    return;
                }
                case 2058: {
                    this.enterContainedTypeConstraint((Production)node);
                    return;
                }
                case 2059: {
                    this.enterInnerTypeConstraint((Production)node);
                    return;
                }
                case 2060: {
                    this.enterComponentsList((Production)node);
                    return;
                }
                case 2061: {
                    this.enterComponentsListTail((Production)node);
                    return;
                }
                case 2062: {
                    this.enterComponentConstraint((Production)node);
                    return;
                }
                case 2063: {
                    this.enterComponentValuePresence((Production)node);
                    return;
                }
                case 2064: {
                    this.enterComponentPresence((Production)node);
                    return;
                }
                case 2065: {
                    this.enterValueAssignment((Production)node);
                    return;
                }
                case 2066: {
                    this.enterValue((Production)node);
                    return;
                }
                case 2067: {
                    this.enterDefinedValue((Production)node);
                    return;
                }
                case 2068: {
                    this.enterBuiltinValue((Production)node);
                    return;
                }
                case 2069: {
                    this.enterNullValue((Production)node);
                    return;
                }
                case 2070: {
                    this.enterBooleanValue((Production)node);
                    return;
                }
                case 2071: {
                    this.enterSpecialRealValue((Production)node);
                    return;
                }
                case 2072: {
                    this.enterNumberValue((Production)node);
                    return;
                }
                case 2073: {
                    this.enterBinaryValue((Production)node);
                    return;
                }
                case 2074: {
                    this.enterHexadecimalValue((Production)node);
                    return;
                }
                case 2075: {
                    this.enterStringValue((Production)node);
                    return;
                }
                case 2076: {
                    this.enterBitOrObjectIdentifierValue((Production)node);
                    return;
                }
                case 2077: {
                    this.enterBitValue((Production)node);
                    return;
                }
                case 2078: {
                    this.enterObjectIdentifierValue((Production)node);
                    return;
                }
                case 2079: {
                    this.enterNameValueList((Production)node);
                    return;
                }
                case 2080: {
                    this.enterNameValueComponent((Production)node);
                    return;
                }
                case 2081: {
                    this.enterNameOrNumber((Production)node);
                    return;
                }
                case 2082: {
                    this.enterNameAndNumber((Production)node);
                    return;
                }
                case 2083: {
                    this.enterDefinedMacroType((Production)node);
                    return;
                }
                case 2084: {
                    this.enterDefinedMacroName((Production)node);
                    return;
                }
                case 2085: {
                    this.enterSnmpModuleIdentityMacroType((Production)node);
                    return;
                }
                case 2086: {
                    this.enterSnmpObjectIdentityMacroType((Production)node);
                    return;
                }
                case 2087: {
                    this.enterSnmpObjectTypeMacroType((Production)node);
                    return;
                }
                case 2088: {
                    this.enterSnmpNotificationTypeMacroType((Production)node);
                    return;
                }
                case 2089: {
                    this.enterSnmpTrapTypeMacroType((Production)node);
                    return;
                }
                case 2090: {
                    this.enterSnmpTextualConventionMacroType((Production)node);
                    return;
                }
                case 2091: {
                    this.enterSnmpObjectGroupMacroType((Production)node);
                    return;
                }
                case 2092: {
                    this.enterSnmpNotificationGroupMacroType((Production)node);
                    return;
                }
                case 2093: {
                    this.enterSnmpModuleComplianceMacroType((Production)node);
                    return;
                }
                case 2094: {
                    this.enterSnmpAgentCapabilitiesMacroType((Production)node);
                    return;
                }
                case 2095: {
                    this.enterSnmpUpdatePart((Production)node);
                    return;
                }
                case 2096: {
                    this.enterSnmpOrganizationPart((Production)node);
                    return;
                }
                case 2097: {
                    this.enterSnmpContactPart((Production)node);
                    return;
                }
                case 2098: {
                    this.enterSnmpDescrPart((Production)node);
                    return;
                }
                case 2099: {
                    this.enterSnmpRevisionPart((Production)node);
                    return;
                }
                case 2100: {
                    this.enterSnmpStatusPart((Production)node);
                    return;
                }
                case 2101: {
                    this.enterSnmpReferPart((Production)node);
                    return;
                }
                case 2102: {
                    this.enterSnmpSyntaxPart((Production)node);
                    return;
                }
                case 2103: {
                    this.enterSnmpUnitsPart((Production)node);
                    return;
                }
                case 2104: {
                    this.enterSnmpAccessPart((Production)node);
                    return;
                }
                case 2105: {
                    this.enterSnmpIndexPart((Production)node);
                    return;
                }
                case 2106: {
                    this.enterIndexValueList((Production)node);
                    return;
                }
                case 2107: {
                    this.enterIndexValue((Production)node);
                    return;
                }
                case 2108: {
                    this.enterIndexType((Production)node);
                    return;
                }
                case 2109: {
                    this.enterSnmpDefValPart((Production)node);
                    return;
                }
                case 2110: {
                    this.enterSnmpObjectsPart((Production)node);
                    return;
                }
                case 2111: {
                    this.enterValueList((Production)node);
                    return;
                }
                case 2112: {
                    this.enterSnmpEnterprisePart((Production)node);
                    return;
                }
                case 2113: {
                    this.enterSnmpVarPart((Production)node);
                    return;
                }
                case 2114: {
                    this.enterSnmpDisplayPart((Production)node);
                    return;
                }
                case 2115: {
                    this.enterSnmpNotificationsPart((Production)node);
                    return;
                }
                case 2116: {
                    this.enterSnmpModulePart((Production)node);
                    return;
                }
                case 2117: {
                    this.enterSnmpModuleImport((Production)node);
                    return;
                }
                case 2118: {
                    this.enterSnmpMandatoryPart((Production)node);
                    return;
                }
                case 2119: {
                    this.enterSnmpCompliancePart((Production)node);
                    return;
                }
                case 2120: {
                    this.enterComplianceGroup((Production)node);
                    return;
                }
                case 2121: {
                    this.enterComplianceObject((Production)node);
                    return;
                }
                case 2122: {
                    this.enterSnmpWriteSyntaxPart((Production)node);
                    return;
                }
                case 2123: {
                    this.enterSnmpProductReleasePart((Production)node);
                    return;
                }
                case 2124: {
                    this.enterSnmpModuleSupportPart((Production)node);
                    return;
                }
                case 2125: {
                    this.enterSnmpVariationPart((Production)node);
                    return;
                }
                case 2126: {
                    this.enterSnmpCreationPart((Production)node);
                    return;
                }
            }
            return;
        }
        finally {
            if (this.debug) {
                System.out.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node exit(Node node) throws ParseException {
        if (this.debug) {
            this.pad(--this.ccnt);
            System.out.print("x " + this.asnToString(node.getId()));
        }
        try {
            switch (node.getId()) {
                case 1001: {
                    Node node2 = this.exitDot((Token)node);
                    return node2;
                }
                case 1002: {
                    Node node3 = this.exitDoubleDot((Token)node);
                    return node3;
                }
                case 1003: {
                    Node node4 = this.exitTripleDot((Token)node);
                    return node4;
                }
                case 1004: {
                    Node node5 = this.exitComma((Token)node);
                    return node5;
                }
                case 1005: {
                    Node node6 = this.exitSemiColon((Token)node);
                    return node6;
                }
                case 1006: {
                    Node node7 = this.exitLeftParen((Token)node);
                    return node7;
                }
                case 1007: {
                    Node node8 = this.exitRightParen((Token)node);
                    return node8;
                }
                case 1008: {
                    Node node9 = this.exitLeftBrace((Token)node);
                    return node9;
                }
                case 1009: {
                    Node node10 = this.exitRightBrace((Token)node);
                    return node10;
                }
                case 1010: {
                    Node node11 = this.exitLeftBracket((Token)node);
                    return node11;
                }
                case 1011: {
                    Node node12 = this.exitRightBracket((Token)node);
                    return node12;
                }
                case 1012: {
                    Node node13 = this.exitMinus((Token)node);
                    return node13;
                }
                case 1013: {
                    Node node14 = this.exitLessThan((Token)node);
                    return node14;
                }
                case 1014: {
                    Node node15 = this.exitVerticalBar((Token)node);
                    return node15;
                }
                case 1015: {
                    Node node16 = this.exitDefinition((Token)node);
                    return node16;
                }
                case 1016: {
                    Node node17 = this.exitDefinitions((Token)node);
                    return node17;
                }
                case 1017: {
                    Node node18 = this.exitExplicit((Token)node);
                    return node18;
                }
                case 1018: {
                    Node node19 = this.exitImplicit((Token)node);
                    return node19;
                }
                case 1019: {
                    Node node20 = this.exitTags((Token)node);
                    return node20;
                }
                case 1020: {
                    Node node21 = this.exitBegin((Token)node);
                    return node21;
                }
                case 1021: {
                    Node node22 = this.exitEnd((Token)node);
                    return node22;
                }
                case 1022: {
                    Node node23 = this.exitExports((Token)node);
                    return node23;
                }
                case 1023: {
                    Node node24 = this.exitImports((Token)node);
                    return node24;
                }
                case 1024: {
                    Node node25 = this.exitFrom((Token)node);
                    return node25;
                }
                case 1025: {
                    Node node26 = this.exitMacro((Token)node);
                    return node26;
                }
                case 1026: {
                    Node node27 = this.exitInteger((Token)node);
                    return node27;
                }
                case 1027: {
                    Node node28 = this.exitReal((Token)node);
                    return node28;
                }
                case 1028: {
                    Node node29 = this.exitBoolean((Token)node);
                    return node29;
                }
                case 1029: {
                    Node node30 = this.exitNull((Token)node);
                    return node30;
                }
                case 1030: {
                    Node node31 = this.exitBit((Token)node);
                    return node31;
                }
                case 1031: {
                    Node node32 = this.exitOctet((Token)node);
                    return node32;
                }
                case 1032: {
                    Node node33 = this.exitString((Token)node);
                    return node33;
                }
                case 1033: {
                    Node node34 = this.exitEnumerated((Token)node);
                    return node34;
                }
                case 1034: {
                    Node node35 = this.exitSequence((Token)node);
                    return node35;
                }
                case 1035: {
                    Node node36 = this.exitSet((Token)node);
                    return node36;
                }
                case 1036: {
                    Node node37 = this.exitOf((Token)node);
                    return node37;
                }
                case 1037: {
                    Node node38 = this.exitChoice((Token)node);
                    return node38;
                }
                case 1038: {
                    Node node39 = this.exitUniversal((Token)node);
                    return node39;
                }
                case 1039: {
                    Node node40 = this.exitApplication((Token)node);
                    return node40;
                }
                case 1040: {
                    Node node41 = this.exitPrivate((Token)node);
                    return node41;
                }
                case 1041: {
                    Node node42 = this.exitAny((Token)node);
                    return node42;
                }
                case 1042: {
                    Node node43 = this.exitDefined((Token)node);
                    return node43;
                }
                case 1043: {
                    Node node44 = this.exitBy((Token)node);
                    return node44;
                }
                case 1044: {
                    Node node45 = this.exitObject((Token)node);
                    return node45;
                }
                case 1045: {
                    Node node46 = this.exitIdentifier((Token)node);
                    return node46;
                }
                case 1046: {
                    Node node47 = this.exitIncludes((Token)node);
                    return node47;
                }
                case 1047: {
                    Node node48 = this.exitMin((Token)node);
                    return node48;
                }
                case 1048: {
                    Node node49 = this.exitMax((Token)node);
                    return node49;
                }
                case 1049: {
                    Node node50 = this.exitSize((Token)node);
                    return node50;
                }
                case 1050: {
                    Node node51 = this.exitWith((Token)node);
                    return node51;
                }
                case 1051: {
                    Node node52 = this.exitComponent((Token)node);
                    return node52;
                }
                case 1052: {
                    Node node53 = this.exitComponents((Token)node);
                    return node53;
                }
                case 1053: {
                    Node node54 = this.exitPresent((Token)node);
                    return node54;
                }
                case 1054: {
                    Node node55 = this.exitAbsent((Token)node);
                    return node55;
                }
                case 1055: {
                    Node node56 = this.exitOptional((Token)node);
                    return node56;
                }
                case 1056: {
                    Node node57 = this.exitDefault((Token)node);
                    return node57;
                }
                case 1057: {
                    Node node58 = this.exitTrue((Token)node);
                    return node58;
                }
                case 1058: {
                    Node node59 = this.exitFalse((Token)node);
                    return node59;
                }
                case 1059: {
                    Node node60 = this.exitPlusInfinity((Token)node);
                    return node60;
                }
                case 1060: {
                    Node node61 = this.exitMinusInfinity((Token)node);
                    return node61;
                }
                case 1061: {
                    Node node62 = this.exitModuleIdentity((Token)node);
                    return node62;
                }
                case 1062: {
                    Node node63 = this.exitObjectIdentity((Token)node);
                    return node63;
                }
                case 1063: {
                    Node node64 = this.exitObjectType((Token)node);
                    return node64;
                }
                case 1064: {
                    Node node65 = this.exitNotificationType((Token)node);
                    return node65;
                }
                case 1065: {
                    Node node66 = this.exitTrapType((Token)node);
                    return node66;
                }
                case 1066: {
                    Node node67 = this.exitTextualConvention((Token)node);
                    return node67;
                }
                case 1067: {
                    Node node68 = this.exitObjectGroup((Token)node);
                    return node68;
                }
                case 1068: {
                    Node node69 = this.exitNotificationGroup((Token)node);
                    return node69;
                }
                case 1069: {
                    Node node70 = this.exitModuleCompliance((Token)node);
                    return node70;
                }
                case 1070: {
                    Node node71 = this.exitAgentCapabilities((Token)node);
                    return node71;
                }
                case 1071: {
                    Node node72 = this.exitLastUpdated((Token)node);
                    return node72;
                }
                case 1072: {
                    Node node73 = this.exitOrganization((Token)node);
                    return node73;
                }
                case 1073: {
                    Node node74 = this.exitContactInfo((Token)node);
                    return node74;
                }
                case 1074: {
                    Node node75 = this.exitDescription((Token)node);
                    return node75;
                }
                case 1075: {
                    Node node76 = this.exitRevision((Token)node);
                    return node76;
                }
                case 1076: {
                    Node node77 = this.exitStatus((Token)node);
                    return node77;
                }
                case 1077: {
                    Node node78 = this.exitReference((Token)node);
                    return node78;
                }
                case 1078: {
                    Node node79 = this.exitSyntax((Token)node);
                    return node79;
                }
                case 1079: {
                    Node node80 = this.exitBits((Token)node);
                    return node80;
                }
                case 1080: {
                    Node node81 = this.exitUnits((Token)node);
                    return node81;
                }
                case 1081: {
                    Node node82 = this.exitAccess((Token)node);
                    return node82;
                }
                case 1082: {
                    Node node83 = this.exitMaxAccess((Token)node);
                    return node83;
                }
                case 1083: {
                    Node node84 = this.exitMinAccess((Token)node);
                    return node84;
                }
                case 1084: {
                    Node node85 = this.exitIndex((Token)node);
                    return node85;
                }
                case 1085: {
                    Node node86 = this.exitAugments((Token)node);
                    return node86;
                }
                case 1086: {
                    Node node87 = this.exitImplied((Token)node);
                    return node87;
                }
                case 1087: {
                    Node node88 = this.exitDefval((Token)node);
                    return node88;
                }
                case 1088: {
                    Node node89 = this.exitObjects((Token)node);
                    return node89;
                }
                case 1089: {
                    Node node90 = this.exitEnterprise((Token)node);
                    return node90;
                }
                case 1090: {
                    Node node91 = this.exitVariables((Token)node);
                    return node91;
                }
                case 1091: {
                    Node node92 = this.exitDisplayHint((Token)node);
                    return node92;
                }
                case 1092: {
                    Node node93 = this.exitNotifications((Token)node);
                    return node93;
                }
                case 1093: {
                    Node node94 = this.exitModule((Token)node);
                    return node94;
                }
                case 1094: {
                    Node node95 = this.exitMandatoryGroups((Token)node);
                    return node95;
                }
                case 1095: {
                    Node node96 = this.exitGroup((Token)node);
                    return node96;
                }
                case 1096: {
                    Node node97 = this.exitWriteSyntax((Token)node);
                    return node97;
                }
                case 1097: {
                    Node node98 = this.exitProductRelease((Token)node);
                    return node98;
                }
                case 1098: {
                    Node node99 = this.exitSupports((Token)node);
                    return node99;
                }
                case 1099: {
                    Node node100 = this.exitVariation((Token)node);
                    return node100;
                }
                case 1100: {
                    Node node101 = this.exitCreationRequires((Token)node);
                    return node101;
                }
                case 1101: {
                    Node node102 = this.exitBinaryString((Token)node);
                    return node102;
                }
                case 1102: {
                    Node node103 = this.exitHexadecimalString((Token)node);
                    return node103;
                }
                case 1103: {
                    Node node104 = this.exitQuotedString((Token)node);
                    return node104;
                }
                case 1104: {
                    Node node105 = this.exitIdentifierString((Token)node);
                    return node105;
                }
                case 1105: {
                    Node node106 = this.exitNumberString((Token)node);
                    return node106;
                }
                case 2001: {
                    Node node107 = this.exitStart((Production)node);
                    return node107;
                }
                case 2002: {
                    Node node108 = this.exitModuleDefinition((Production)node);
                    return node108;
                }
                case 2003: {
                    Node node109 = this.exitModuleIdentifier((Production)node);
                    return node109;
                }
                case 2004: {
                    Node node110 = this.exitModuleReference((Production)node);
                    return node110;
                }
                case 2005: {
                    Node node111 = this.exitTagDefault((Production)node);
                    return node111;
                }
                case 2006: {
                    Node node112 = this.exitModuleBody((Production)node);
                    return node112;
                }
                case 2007: {
                    Node node113 = this.exitExportList((Production)node);
                    return node113;
                }
                case 2008: {
                    Node node114 = this.exitImportList((Production)node);
                    return node114;
                }
                case 2009: {
                    Node node115 = this.exitSymbolsFromModule((Production)node);
                    return node115;
                }
                case 2010: {
                    Node node116 = this.exitSymbolList((Production)node);
                    return node116;
                }
                case 2011: {
                    Node node117 = this.exitSymbol((Production)node);
                    return node117;
                }
                case 2012: {
                    Node node118 = this.exitAssignmentList((Production)node);
                    return node118;
                }
                case 2013: {
                    Node node119 = this.exitAssignment((Production)node);
                    return node119;
                }
                case 2014: {
                    Node node120 = this.exitMacroDefinition((Production)node);
                    return node120;
                }
                case 2015: {
                    Node node121 = this.exitMacroReference((Production)node);
                    return node121;
                }
                case 2016: {
                    Node node122 = this.exitMacroBody((Production)node);
                    return node122;
                }
                case 2017: {
                    Node node123 = this.exitMacroBodyElement((Production)node);
                    return node123;
                }
                case 2018: {
                    Node node124 = this.exitTypeAssignment((Production)node);
                    return node124;
                }
                case 2019: {
                    Node node125 = this.exitType((Production)node);
                    return node125;
                }
                case 2020: {
                    Node node126 = this.exitDefinedType((Production)node);
                    return node126;
                }
                case 2021: {
                    Node node127 = this.exitBuiltinType((Production)node);
                    return node127;
                }
                case 2022: {
                    Node node128 = this.exitNullType((Production)node);
                    return node128;
                }
                case 2023: {
                    Node node129 = this.exitBooleanType((Production)node);
                    return node129;
                }
                case 2024: {
                    Node node130 = this.exitRealType((Production)node);
                    return node130;
                }
                case 2025: {
                    Node node131 = this.exitIntegerType((Production)node);
                    return node131;
                }
                case 2026: {
                    Node node132 = this.exitObjectIdentifierType((Production)node);
                    return node132;
                }
                case 2027: {
                    Node node133 = this.exitStringType((Production)node);
                    return node133;
                }
                case 2028: {
                    Node node134 = this.exitBitStringType((Production)node);
                    return node134;
                }
                case 2029: {
                    Node node135 = this.exitBitsType((Production)node);
                    return node135;
                }
                case 2030: {
                    Node node136 = this.exitSequenceType((Production)node);
                    return node136;
                }
                case 2031: {
                    Node node137 = this.exitSequenceOfType((Production)node);
                    return node137;
                }
                case 2032: {
                    Node node138 = this.exitSetType((Production)node);
                    return node138;
                }
                case 2033: {
                    Node node139 = this.exitSetOfType((Production)node);
                    return node139;
                }
                case 2034: {
                    Node node140 = this.exitChoiceType((Production)node);
                    return node140;
                }
                case 2035: {
                    Node node141 = this.exitEnumeratedType((Production)node);
                    return node141;
                }
                case 2036: {
                    Node node142 = this.exitSelectionType((Production)node);
                    return node142;
                }
                case 2037: {
                    Node node143 = this.exitTaggedType((Production)node);
                    return node143;
                }
                case 2038: {
                    Node node144 = this.exitTag((Production)node);
                    return node144;
                }
                case 2039: {
                    Node node145 = this.exitClass((Production)node);
                    return node145;
                }
                case 2040: {
                    Node node146 = this.exitExplicitOrImplicitTag((Production)node);
                    return node146;
                }
                case 2041: {
                    Node node147 = this.exitAnyType((Production)node);
                    return node147;
                }
                case 2042: {
                    Node node148 = this.exitElementTypeList((Production)node);
                    return node148;
                }
                case 2043: {
                    Node node149 = this.exitElementType((Production)node);
                    return node149;
                }
                case 2044: {
                    Node node150 = this.exitOptionalOrDefaultElement((Production)node);
                    return node150;
                }
                case 2045: {
                    Node node151 = this.exitValueOrConstraintList((Production)node);
                    return node151;
                }
                case 2046: {
                    Node node152 = this.exitNamedNumberList((Production)node);
                    return node152;
                }
                case 2047: {
                    Node node153 = this.exitNamedNumber((Production)node);
                    return node153;
                }
                case 2048: {
                    Node node154 = this.exitNumber((Production)node);
                    return node154;
                }
                case 2049: {
                    Node node155 = this.exitConstraintList((Production)node);
                    return node155;
                }
                case 2050: {
                    Node node156 = this.exitConstraint((Production)node);
                    return node156;
                }
                case 2051: {
                    Node node157 = this.exitValueConstraintList((Production)node);
                    return node157;
                }
                case 2052: {
                    Node node158 = this.exitValueConstraint((Production)node);
                    return node158;
                }
                case 2053: {
                    Node node159 = this.exitValueRange((Production)node);
                    return node159;
                }
                case 2054: {
                    Node node160 = this.exitLowerEndPoint((Production)node);
                    return node160;
                }
                case 2055: {
                    Node node161 = this.exitUpperEndPoint((Production)node);
                    return node161;
                }
                case 2056: {
                    Node node162 = this.exitSizeConstraint((Production)node);
                    return node162;
                }
                case 2057: {
                    Node node163 = this.exitAlphabetConstraint((Production)node);
                    return node163;
                }
                case 2058: {
                    Node node164 = this.exitContainedTypeConstraint((Production)node);
                    return node164;
                }
                case 2059: {
                    Node node165 = this.exitInnerTypeConstraint((Production)node);
                    return node165;
                }
                case 2060: {
                    Node node166 = this.exitComponentsList((Production)node);
                    return node166;
                }
                case 2061: {
                    Node node167 = this.exitComponentsListTail((Production)node);
                    return node167;
                }
                case 2062: {
                    Node node168 = this.exitComponentConstraint((Production)node);
                    return node168;
                }
                case 2063: {
                    Node node169 = this.exitComponentValuePresence((Production)node);
                    return node169;
                }
                case 2064: {
                    Node node170 = this.exitComponentPresence((Production)node);
                    return node170;
                }
                case 2065: {
                    Node node171 = this.exitValueAssignment((Production)node);
                    return node171;
                }
                case 2066: {
                    Node node172 = this.exitValue((Production)node);
                    return node172;
                }
                case 2067: {
                    Node node173 = this.exitDefinedValue((Production)node);
                    return node173;
                }
                case 2068: {
                    Node node174 = this.exitBuiltinValue((Production)node);
                    return node174;
                }
                case 2069: {
                    Node node175 = this.exitNullValue((Production)node);
                    return node175;
                }
                case 2070: {
                    Node node176 = this.exitBooleanValue((Production)node);
                    return node176;
                }
                case 2071: {
                    Node node177 = this.exitSpecialRealValue((Production)node);
                    return node177;
                }
                case 2072: {
                    Node node178 = this.exitNumberValue((Production)node);
                    return node178;
                }
                case 2073: {
                    Node node179 = this.exitBinaryValue((Production)node);
                    return node179;
                }
                case 2074: {
                    Node node180 = this.exitHexadecimalValue((Production)node);
                    return node180;
                }
                case 2075: {
                    Node node181 = this.exitStringValue((Production)node);
                    return node181;
                }
                case 2076: {
                    Node node182 = this.exitBitOrObjectIdentifierValue((Production)node);
                    return node182;
                }
                case 2077: {
                    Node node183 = this.exitBitValue((Production)node);
                    return node183;
                }
                case 2078: {
                    Node node184 = this.exitObjectIdentifierValue((Production)node);
                    return node184;
                }
                case 2079: {
                    Node node185 = this.exitNameValueList((Production)node);
                    return node185;
                }
                case 2080: {
                    Node node186 = this.exitNameValueComponent((Production)node);
                    return node186;
                }
                case 2081: {
                    Node node187 = this.exitNameOrNumber((Production)node);
                    return node187;
                }
                case 2082: {
                    Node node188 = this.exitNameAndNumber((Production)node);
                    return node188;
                }
                case 2083: {
                    Node node189 = this.exitDefinedMacroType((Production)node);
                    return node189;
                }
                case 2084: {
                    Node node190 = this.exitDefinedMacroName((Production)node);
                    return node190;
                }
                case 2085: {
                    Node node191 = this.exitSnmpModuleIdentityMacroType((Production)node);
                    return node191;
                }
                case 2086: {
                    Node node192 = this.exitSnmpObjectIdentityMacroType((Production)node);
                    return node192;
                }
                case 2087: {
                    Node node193 = this.exitSnmpObjectTypeMacroType((Production)node);
                    return node193;
                }
                case 2088: {
                    Node node194 = this.exitSnmpNotificationTypeMacroType((Production)node);
                    return node194;
                }
                case 2089: {
                    Node node195 = this.exitSnmpTrapTypeMacroType((Production)node);
                    return node195;
                }
                case 2090: {
                    Node node196 = this.exitSnmpTextualConventionMacroType((Production)node);
                    return node196;
                }
                case 2091: {
                    Node node197 = this.exitSnmpObjectGroupMacroType((Production)node);
                    return node197;
                }
                case 2092: {
                    Node node198 = this.exitSnmpNotificationGroupMacroType((Production)node);
                    return node198;
                }
                case 2093: {
                    Node node199 = this.exitSnmpModuleComplianceMacroType((Production)node);
                    return node199;
                }
                case 2094: {
                    Node node200 = this.exitSnmpAgentCapabilitiesMacroType((Production)node);
                    return node200;
                }
                case 2095: {
                    Node node201 = this.exitSnmpUpdatePart((Production)node);
                    return node201;
                }
                case 2096: {
                    Node node202 = this.exitSnmpOrganizationPart((Production)node);
                    return node202;
                }
                case 2097: {
                    Node node203 = this.exitSnmpContactPart((Production)node);
                    return node203;
                }
                case 2098: {
                    Node node204 = this.exitSnmpDescrPart((Production)node);
                    return node204;
                }
                case 2099: {
                    Node node205 = this.exitSnmpRevisionPart((Production)node);
                    return node205;
                }
                case 2100: {
                    Node node206 = this.exitSnmpStatusPart((Production)node);
                    return node206;
                }
                case 2101: {
                    Node node207 = this.exitSnmpReferPart((Production)node);
                    return node207;
                }
                case 2102: {
                    Node node208 = this.exitSnmpSyntaxPart((Production)node);
                    return node208;
                }
                case 2103: {
                    Node node209 = this.exitSnmpUnitsPart((Production)node);
                    return node209;
                }
                case 2104: {
                    Node node210 = this.exitSnmpAccessPart((Production)node);
                    return node210;
                }
                case 2105: {
                    Node node211 = this.exitSnmpIndexPart((Production)node);
                    return node211;
                }
                case 2106: {
                    Node node212 = this.exitIndexValueList((Production)node);
                    return node212;
                }
                case 2107: {
                    Node node213 = this.exitIndexValue((Production)node);
                    return node213;
                }
                case 2108: {
                    Node node214 = this.exitIndexType((Production)node);
                    return node214;
                }
                case 2109: {
                    Node node215 = this.exitSnmpDefValPart((Production)node);
                    return node215;
                }
                case 2110: {
                    Node node216 = this.exitSnmpObjectsPart((Production)node);
                    return node216;
                }
                case 2111: {
                    Node node217 = this.exitValueList((Production)node);
                    return node217;
                }
                case 2112: {
                    Node node218 = this.exitSnmpEnterprisePart((Production)node);
                    return node218;
                }
                case 2113: {
                    Node node219 = this.exitSnmpVarPart((Production)node);
                    return node219;
                }
                case 2114: {
                    Node node220 = this.exitSnmpDisplayPart((Production)node);
                    return node220;
                }
                case 2115: {
                    Node node221 = this.exitSnmpNotificationsPart((Production)node);
                    return node221;
                }
                case 2116: {
                    Node node222 = this.exitSnmpModulePart((Production)node);
                    return node222;
                }
                case 2117: {
                    Node node223 = this.exitSnmpModuleImport((Production)node);
                    return node223;
                }
                case 2118: {
                    Node node224 = this.exitSnmpMandatoryPart((Production)node);
                    return node224;
                }
                case 2119: {
                    Node node225 = this.exitSnmpCompliancePart((Production)node);
                    return node225;
                }
                case 2120: {
                    Node node226 = this.exitComplianceGroup((Production)node);
                    return node226;
                }
                case 2121: {
                    Node node227 = this.exitComplianceObject((Production)node);
                    return node227;
                }
                case 2122: {
                    Node node228 = this.exitSnmpWriteSyntaxPart((Production)node);
                    return node228;
                }
                case 2123: {
                    Node node229 = this.exitSnmpProductReleasePart((Production)node);
                    return node229;
                }
                case 2124: {
                    Node node230 = this.exitSnmpModuleSupportPart((Production)node);
                    return node230;
                }
                case 2125: {
                    Node node231 = this.exitSnmpVariationPart((Production)node);
                    return node231;
                }
                case 2126: {
                    Node node232 = this.exitSnmpCreationPart((Production)node);
                    return node232;
                }
            }
            Node node233 = node;
            return node233;
        }
        finally {
            if (this.debug) {
                System.out.println();
            }
        }
    }

    protected void child(Production production, Node node) throws ParseException {
        switch (production.getId()) {
            case 2001: {
                this.childStart(production, node);
                break;
            }
            case 2002: {
                this.childModuleDefinition(production, node);
                break;
            }
            case 2003: {
                this.childModuleIdentifier(production, node);
                break;
            }
            case 2004: {
                this.childModuleReference(production, node);
                break;
            }
            case 2005: {
                this.childTagDefault(production, node);
                break;
            }
            case 2006: {
                this.childModuleBody(production, node);
                break;
            }
            case 2007: {
                this.childExportList(production, node);
                break;
            }
            case 2008: {
                this.childImportList(production, node);
                break;
            }
            case 2009: {
                this.childSymbolsFromModule(production, node);
                break;
            }
            case 2010: {
                this.childSymbolList(production, node);
                break;
            }
            case 2011: {
                this.childSymbol(production, node);
                break;
            }
            case 2012: {
                this.childAssignmentList(production, node);
                break;
            }
            case 2013: {
                this.childAssignment(production, node);
                break;
            }
            case 2014: {
                this.childMacroDefinition(production, node);
                break;
            }
            case 2015: {
                this.childMacroReference(production, node);
                break;
            }
            case 2016: {
                this.childMacroBody(production, node);
                break;
            }
            case 2017: {
                this.childMacroBodyElement(production, node);
                break;
            }
            case 2018: {
                this.childTypeAssignment(production, node);
                break;
            }
            case 2019: {
                this.childType(production, node);
                break;
            }
            case 2020: {
                this.childDefinedType(production, node);
                break;
            }
            case 2021: {
                this.childBuiltinType(production, node);
                break;
            }
            case 2022: {
                this.childNullType(production, node);
                break;
            }
            case 2023: {
                this.childBooleanType(production, node);
                break;
            }
            case 2024: {
                this.childRealType(production, node);
                break;
            }
            case 2025: {
                this.childIntegerType(production, node);
                break;
            }
            case 2026: {
                this.childObjectIdentifierType(production, node);
                break;
            }
            case 2027: {
                this.childStringType(production, node);
                break;
            }
            case 2028: {
                this.childBitStringType(production, node);
                break;
            }
            case 2029: {
                this.childBitsType(production, node);
                break;
            }
            case 2030: {
                this.childSequenceType(production, node);
                break;
            }
            case 2031: {
                this.childSequenceOfType(production, node);
                break;
            }
            case 2032: {
                this.childSetType(production, node);
                break;
            }
            case 2033: {
                this.childSetOfType(production, node);
                break;
            }
            case 2034: {
                this.childChoiceType(production, node);
                break;
            }
            case 2035: {
                this.childEnumeratedType(production, node);
                break;
            }
            case 2036: {
                this.childSelectionType(production, node);
                break;
            }
            case 2037: {
                this.childTaggedType(production, node);
                break;
            }
            case 2038: {
                this.childTag(production, node);
                break;
            }
            case 2039: {
                this.childClass(production, node);
                break;
            }
            case 2040: {
                this.childExplicitOrImplicitTag(production, node);
                break;
            }
            case 2041: {
                this.childAnyType(production, node);
                break;
            }
            case 2042: {
                this.childElementTypeList(production, node);
                break;
            }
            case 2043: {
                this.childElementType(production, node);
                break;
            }
            case 2044: {
                this.childOptionalOrDefaultElement(production, node);
                break;
            }
            case 2045: {
                this.childValueOrConstraintList(production, node);
                break;
            }
            case 2046: {
                this.childNamedNumberList(production, node);
                break;
            }
            case 2047: {
                this.childNamedNumber(production, node);
                break;
            }
            case 2048: {
                this.childNumber(production, node);
                break;
            }
            case 2049: {
                this.childConstraintList(production, node);
                break;
            }
            case 2050: {
                this.childConstraint(production, node);
                break;
            }
            case 2051: {
                this.childValueConstraintList(production, node);
                break;
            }
            case 2052: {
                this.childValueConstraint(production, node);
                break;
            }
            case 2053: {
                this.childValueRange(production, node);
                break;
            }
            case 2054: {
                this.childLowerEndPoint(production, node);
                break;
            }
            case 2055: {
                this.childUpperEndPoint(production, node);
                break;
            }
            case 2056: {
                this.childSizeConstraint(production, node);
                break;
            }
            case 2057: {
                this.childAlphabetConstraint(production, node);
                break;
            }
            case 2058: {
                this.childContainedTypeConstraint(production, node);
                break;
            }
            case 2059: {
                this.childInnerTypeConstraint(production, node);
                break;
            }
            case 2060: {
                this.childComponentsList(production, node);
                break;
            }
            case 2061: {
                this.childComponentsListTail(production, node);
                break;
            }
            case 2062: {
                this.childComponentConstraint(production, node);
                break;
            }
            case 2063: {
                this.childComponentValuePresence(production, node);
                break;
            }
            case 2064: {
                this.childComponentPresence(production, node);
                break;
            }
            case 2065: {
                this.childValueAssignment(production, node);
                break;
            }
            case 2066: {
                this.childValue(production, node);
                break;
            }
            case 2067: {
                this.childDefinedValue(production, node);
                break;
            }
            case 2068: {
                this.childBuiltinValue(production, node);
                break;
            }
            case 2069: {
                this.childNullValue(production, node);
                break;
            }
            case 2070: {
                this.childBooleanValue(production, node);
                break;
            }
            case 2071: {
                this.childSpecialRealValue(production, node);
                break;
            }
            case 2072: {
                this.childNumberValue(production, node);
                break;
            }
            case 2073: {
                this.childBinaryValue(production, node);
                break;
            }
            case 2074: {
                this.childHexadecimalValue(production, node);
                break;
            }
            case 2075: {
                this.childStringValue(production, node);
                break;
            }
            case 2076: {
                this.childBitOrObjectIdentifierValue(production, node);
                break;
            }
            case 2077: {
                this.childBitValue(production, node);
                break;
            }
            case 2078: {
                this.childObjectIdentifierValue(production, node);
                break;
            }
            case 2079: {
                this.childNameValueList(production, node);
                break;
            }
            case 2080: {
                this.childNameValueComponent(production, node);
                break;
            }
            case 2081: {
                this.childNameOrNumber(production, node);
                break;
            }
            case 2082: {
                this.childNameAndNumber(production, node);
                break;
            }
            case 2083: {
                this.childDefinedMacroType(production, node);
                break;
            }
            case 2084: {
                this.childDefinedMacroName(production, node);
                break;
            }
            case 2085: {
                this.childSnmpModuleIdentityMacroType(production, node);
                break;
            }
            case 2086: {
                this.childSnmpObjectIdentityMacroType(production, node);
                break;
            }
            case 2087: {
                this.childSnmpObjectTypeMacroType(production, node);
                break;
            }
            case 2088: {
                this.childSnmpNotificationTypeMacroType(production, node);
                break;
            }
            case 2089: {
                this.childSnmpTrapTypeMacroType(production, node);
                break;
            }
            case 2090: {
                this.childSnmpTextualConventionMacroType(production, node);
                break;
            }
            case 2091: {
                this.childSnmpObjectGroupMacroType(production, node);
                break;
            }
            case 2092: {
                this.childSnmpNotificationGroupMacroType(production, node);
                break;
            }
            case 2093: {
                this.childSnmpModuleComplianceMacroType(production, node);
                break;
            }
            case 2094: {
                this.childSnmpAgentCapabilitiesMacroType(production, node);
                break;
            }
            case 2095: {
                this.childSnmpUpdatePart(production, node);
                break;
            }
            case 2096: {
                this.childSnmpOrganizationPart(production, node);
                break;
            }
            case 2097: {
                this.childSnmpContactPart(production, node);
                break;
            }
            case 2098: {
                this.childSnmpDescrPart(production, node);
                break;
            }
            case 2099: {
                this.childSnmpRevisionPart(production, node);
                break;
            }
            case 2100: {
                this.childSnmpStatusPart(production, node);
                break;
            }
            case 2101: {
                this.childSnmpReferPart(production, node);
                break;
            }
            case 2102: {
                this.childSnmpSyntaxPart(production, node);
                break;
            }
            case 2103: {
                this.childSnmpUnitsPart(production, node);
                break;
            }
            case 2104: {
                this.childSnmpAccessPart(production, node);
                break;
            }
            case 2105: {
                this.childSnmpIndexPart(production, node);
                break;
            }
            case 2106: {
                this.childIndexValueList(production, node);
                break;
            }
            case 2107: {
                this.childIndexValue(production, node);
                break;
            }
            case 2108: {
                this.childIndexType(production, node);
                break;
            }
            case 2109: {
                this.childSnmpDefValPart(production, node);
                break;
            }
            case 2110: {
                this.childSnmpObjectsPart(production, node);
                break;
            }
            case 2111: {
                this.childValueList(production, node);
                break;
            }
            case 2112: {
                this.childSnmpEnterprisePart(production, node);
                break;
            }
            case 2113: {
                this.childSnmpVarPart(production, node);
                break;
            }
            case 2114: {
                this.childSnmpDisplayPart(production, node);
                break;
            }
            case 2115: {
                this.childSnmpNotificationsPart(production, node);
                break;
            }
            case 2116: {
                this.childSnmpModulePart(production, node);
                break;
            }
            case 2117: {
                this.childSnmpModuleImport(production, node);
                break;
            }
            case 2118: {
                this.childSnmpMandatoryPart(production, node);
                break;
            }
            case 2119: {
                this.childSnmpCompliancePart(production, node);
                break;
            }
            case 2120: {
                this.childComplianceGroup(production, node);
                break;
            }
            case 2121: {
                this.childComplianceObject(production, node);
                break;
            }
            case 2122: {
                this.childSnmpWriteSyntaxPart(production, node);
                break;
            }
            case 2123: {
                this.childSnmpProductReleasePart(production, node);
                break;
            }
            case 2124: {
                this.childSnmpModuleSupportPart(production, node);
                break;
            }
            case 2125: {
                this.childSnmpVariationPart(production, node);
                break;
            }
            case 2126: {
                this.childSnmpCreationPart(production, node);
            }
        }
    }

    protected void enterDot(Token token) throws ParseException {
    }

    protected Node exitDot(Token token) throws ParseException {
        return token;
    }

    protected void enterDoubleDot(Token token) throws ParseException {
    }

    protected Node exitDoubleDot(Token token) throws ParseException {
        return token;
    }

    protected void enterTripleDot(Token token) throws ParseException {
    }

    protected Node exitTripleDot(Token token) throws ParseException {
        return token;
    }

    protected void enterComma(Token token) throws ParseException {
    }

    protected Node exitComma(Token token) throws ParseException {
        return token;
    }

    protected void enterSemiColon(Token token) throws ParseException {
    }

    protected Node exitSemiColon(Token token) throws ParseException {
        return token;
    }

    protected void enterLeftParen(Token token) throws ParseException {
    }

    protected Node exitLeftParen(Token token) throws ParseException {
        return token;
    }

    protected void enterRightParen(Token token) throws ParseException {
    }

    protected Node exitRightParen(Token token) throws ParseException {
        return token;
    }

    protected void enterLeftBrace(Token token) throws ParseException {
    }

    protected Node exitLeftBrace(Token token) throws ParseException {
        return token;
    }

    protected void enterRightBrace(Token token) throws ParseException {
    }

    protected Node exitRightBrace(Token token) throws ParseException {
        return token;
    }

    protected void enterLeftBracket(Token token) throws ParseException {
    }

    protected Node exitLeftBracket(Token token) throws ParseException {
        return token;
    }

    protected void enterRightBracket(Token token) throws ParseException {
    }

    protected Node exitRightBracket(Token token) throws ParseException {
        return token;
    }

    protected void enterMinus(Token token) throws ParseException {
    }

    protected Node exitMinus(Token token) throws ParseException {
        return token;
    }

    protected void enterLessThan(Token token) throws ParseException {
    }

    protected Node exitLessThan(Token token) throws ParseException {
        return token;
    }

    protected void enterVerticalBar(Token token) throws ParseException {
    }

    protected Node exitVerticalBar(Token token) throws ParseException {
        return token;
    }

    protected void enterDefinition(Token token) throws ParseException {
    }

    protected Node exitDefinition(Token token) throws ParseException {
        return token;
    }

    protected void enterDefinitions(Token token) throws ParseException {
    }

    protected Node exitDefinitions(Token token) throws ParseException {
        return token;
    }

    protected void enterExplicit(Token token) throws ParseException {
    }

    protected Node exitExplicit(Token token) throws ParseException {
        return token;
    }

    protected void enterImplicit(Token token) throws ParseException {
    }

    protected Node exitImplicit(Token token) throws ParseException {
        return token;
    }

    protected void enterTags(Token token) throws ParseException {
    }

    protected Node exitTags(Token token) throws ParseException {
        return token;
    }

    protected void enterBegin(Token token) throws ParseException {
    }

    protected Node exitBegin(Token token) throws ParseException {
        return token;
    }

    protected void enterEnd(Token token) throws ParseException {
    }

    protected Node exitEnd(Token token) throws ParseException {
        return token;
    }

    protected void enterExports(Token token) throws ParseException {
    }

    protected Node exitExports(Token token) throws ParseException {
        return token;
    }

    protected void enterImports(Token token) throws ParseException {
    }

    protected Node exitImports(Token token) throws ParseException {
        return token;
    }

    protected void enterFrom(Token token) throws ParseException {
    }

    protected Node exitFrom(Token token) throws ParseException {
        return token;
    }

    protected void enterMacro(Token token) throws ParseException {
    }

    protected Node exitMacro(Token token) throws ParseException {
        return token;
    }

    protected void enterInteger(Token token) throws ParseException {
    }

    protected Node exitInteger(Token token) throws ParseException {
        return token;
    }

    protected void enterReal(Token token) throws ParseException {
    }

    protected Node exitReal(Token token) throws ParseException {
        return token;
    }

    protected void enterBoolean(Token token) throws ParseException {
    }

    protected Node exitBoolean(Token token) throws ParseException {
        return token;
    }

    protected void enterNull(Token token) throws ParseException {
    }

    protected Node exitNull(Token token) throws ParseException {
        return token;
    }

    protected void enterBit(Token token) throws ParseException {
    }

    protected Node exitBit(Token token) throws ParseException {
        return token;
    }

    protected void enterOctet(Token token) throws ParseException {
    }

    protected Node exitOctet(Token token) throws ParseException {
        return token;
    }

    protected void enterString(Token token) throws ParseException {
    }

    protected Node exitString(Token token) throws ParseException {
        return token;
    }

    protected void enterEnumerated(Token token) throws ParseException {
    }

    protected Node exitEnumerated(Token token) throws ParseException {
        return token;
    }

    protected void enterSequence(Token token) throws ParseException {
    }

    protected Node exitSequence(Token token) throws ParseException {
        return token;
    }

    protected void enterSet(Token token) throws ParseException {
    }

    protected Node exitSet(Token token) throws ParseException {
        return token;
    }

    protected void enterOf(Token token) throws ParseException {
    }

    protected Node exitOf(Token token) throws ParseException {
        return token;
    }

    protected void enterChoice(Token token) throws ParseException {
    }

    protected Node exitChoice(Token token) throws ParseException {
        return token;
    }

    protected void enterUniversal(Token token) throws ParseException {
    }

    protected Node exitUniversal(Token token) throws ParseException {
        return token;
    }

    protected void enterApplication(Token token) throws ParseException {
    }

    protected Node exitApplication(Token token) throws ParseException {
        return token;
    }

    protected void enterPrivate(Token token) throws ParseException {
    }

    protected Node exitPrivate(Token token) throws ParseException {
        return token;
    }

    protected void enterAny(Token token) throws ParseException {
    }

    protected Node exitAny(Token token) throws ParseException {
        return token;
    }

    protected void enterDefined(Token token) throws ParseException {
    }

    protected Node exitDefined(Token token) throws ParseException {
        return token;
    }

    protected void enterBy(Token token) throws ParseException {
    }

    protected Node exitBy(Token token) throws ParseException {
        return token;
    }

    protected void enterObject(Token token) throws ParseException {
    }

    protected Node exitObject(Token token) throws ParseException {
        return token;
    }

    protected void enterIdentifier(Token token) throws ParseException {
    }

    protected Node exitIdentifier(Token token) throws ParseException {
        return token;
    }

    protected void enterIncludes(Token token) throws ParseException {
    }

    protected Node exitIncludes(Token token) throws ParseException {
        return token;
    }

    protected void enterMin(Token token) throws ParseException {
    }

    protected Node exitMin(Token token) throws ParseException {
        return token;
    }

    protected void enterMax(Token token) throws ParseException {
    }

    protected Node exitMax(Token token) throws ParseException {
        return token;
    }

    protected void enterSize(Token token) throws ParseException {
    }

    protected Node exitSize(Token token) throws ParseException {
        return token;
    }

    protected void enterWith(Token token) throws ParseException {
    }

    protected Node exitWith(Token token) throws ParseException {
        return token;
    }

    protected void enterComponent(Token token) throws ParseException {
    }

    protected Node exitComponent(Token token) throws ParseException {
        return token;
    }

    protected void enterComponents(Token token) throws ParseException {
    }

    protected Node exitComponents(Token token) throws ParseException {
        return token;
    }

    protected void enterPresent(Token token) throws ParseException {
    }

    protected Node exitPresent(Token token) throws ParseException {
        return token;
    }

    protected void enterAbsent(Token token) throws ParseException {
    }

    protected Node exitAbsent(Token token) throws ParseException {
        return token;
    }

    protected void enterOptional(Token token) throws ParseException {
    }

    protected Node exitOptional(Token token) throws ParseException {
        return token;
    }

    protected void enterDefault(Token token) throws ParseException {
    }

    protected Node exitDefault(Token token) throws ParseException {
        return token;
    }

    protected void enterTrue(Token token) throws ParseException {
    }

    protected Node exitTrue(Token token) throws ParseException {
        return token;
    }

    protected void enterFalse(Token token) throws ParseException {
    }

    protected Node exitFalse(Token token) throws ParseException {
        return token;
    }

    protected void enterPlusInfinity(Token token) throws ParseException {
    }

    protected Node exitPlusInfinity(Token token) throws ParseException {
        return token;
    }

    protected void enterMinusInfinity(Token token) throws ParseException {
    }

    protected Node exitMinusInfinity(Token token) throws ParseException {
        return token;
    }

    protected void enterModuleIdentity(Token token) throws ParseException {
    }

    protected Node exitModuleIdentity(Token token) throws ParseException {
        return token;
    }

    protected void enterObjectIdentity(Token token) throws ParseException {
    }

    protected Node exitObjectIdentity(Token token) throws ParseException {
        return token;
    }

    protected void enterObjectType(Token token) throws ParseException {
    }

    protected Node exitObjectType(Token token) throws ParseException {
        return token;
    }

    protected void enterNotificationType(Token token) throws ParseException {
    }

    protected Node exitNotificationType(Token token) throws ParseException {
        return token;
    }

    protected void enterTrapType(Token token) throws ParseException {
    }

    protected Node exitTrapType(Token token) throws ParseException {
        return token;
    }

    protected void enterTextualConvention(Token token) throws ParseException {
    }

    protected Node exitTextualConvention(Token token) throws ParseException {
        return token;
    }

    protected void enterObjectGroup(Token token) throws ParseException {
    }

    protected Node exitObjectGroup(Token token) throws ParseException {
        return token;
    }

    protected void enterNotificationGroup(Token token) throws ParseException {
    }

    protected Node exitNotificationGroup(Token token) throws ParseException {
        return token;
    }

    protected void enterModuleCompliance(Token token) throws ParseException {
    }

    protected Node exitModuleCompliance(Token token) throws ParseException {
        return token;
    }

    protected void enterAgentCapabilities(Token token) throws ParseException {
    }

    protected Node exitAgentCapabilities(Token token) throws ParseException {
        return token;
    }

    protected void enterLastUpdated(Token token) throws ParseException {
    }

    protected Node exitLastUpdated(Token token) throws ParseException {
        return token;
    }

    protected void enterOrganization(Token token) throws ParseException {
    }

    protected Node exitOrganization(Token token) throws ParseException {
        return token;
    }

    protected void enterContactInfo(Token token) throws ParseException {
    }

    protected Node exitContactInfo(Token token) throws ParseException {
        return token;
    }

    protected void enterDescription(Token token) throws ParseException {
    }

    protected Node exitDescription(Token token) throws ParseException {
        return token;
    }

    protected void enterRevision(Token token) throws ParseException {
    }

    protected Node exitRevision(Token token) throws ParseException {
        return token;
    }

    protected void enterStatus(Token token) throws ParseException {
    }

    protected Node exitStatus(Token token) throws ParseException {
        return token;
    }

    protected void enterReference(Token token) throws ParseException {
    }

    protected Node exitReference(Token token) throws ParseException {
        return token;
    }

    protected void enterSyntax(Token token) throws ParseException {
    }

    protected Node exitSyntax(Token token) throws ParseException {
        return token;
    }

    protected void enterBits(Token token) throws ParseException {
    }

    protected Node exitBits(Token token) throws ParseException {
        return token;
    }

    protected void enterUnits(Token token) throws ParseException {
    }

    protected Node exitUnits(Token token) throws ParseException {
        return token;
    }

    protected void enterAccess(Token token) throws ParseException {
    }

    protected Node exitAccess(Token token) throws ParseException {
        return token;
    }

    protected void enterMaxAccess(Token token) throws ParseException {
    }

    protected Node exitMaxAccess(Token token) throws ParseException {
        return token;
    }

    protected void enterMinAccess(Token token) throws ParseException {
    }

    protected Node exitMinAccess(Token token) throws ParseException {
        return token;
    }

    protected void enterIndex(Token token) throws ParseException {
    }

    protected Node exitIndex(Token token) throws ParseException {
        return token;
    }

    protected void enterAugments(Token token) throws ParseException {
    }

    protected Node exitAugments(Token token) throws ParseException {
        return token;
    }

    protected void enterImplied(Token token) throws ParseException {
    }

    protected Node exitImplied(Token token) throws ParseException {
        return token;
    }

    protected void enterDefval(Token token) throws ParseException {
    }

    protected Node exitDefval(Token token) throws ParseException {
        return token;
    }

    protected void enterObjects(Token token) throws ParseException {
    }

    protected Node exitObjects(Token token) throws ParseException {
        return token;
    }

    protected void enterEnterprise(Token token) throws ParseException {
    }

    protected Node exitEnterprise(Token token) throws ParseException {
        return token;
    }

    protected void enterVariables(Token token) throws ParseException {
    }

    protected Node exitVariables(Token token) throws ParseException {
        return token;
    }

    protected void enterDisplayHint(Token token) throws ParseException {
    }

    protected Node exitDisplayHint(Token token) throws ParseException {
        return token;
    }

    protected void enterNotifications(Token token) throws ParseException {
    }

    protected Node exitNotifications(Token token) throws ParseException {
        return token;
    }

    protected void enterModule(Token token) throws ParseException {
    }

    protected Node exitModule(Token token) throws ParseException {
        return token;
    }

    protected void enterMandatoryGroups(Token token) throws ParseException {
    }

    protected Node exitMandatoryGroups(Token token) throws ParseException {
        return token;
    }

    protected void enterGroup(Token token) throws ParseException {
    }

    protected Node exitGroup(Token token) throws ParseException {
        return token;
    }

    protected void enterWriteSyntax(Token token) throws ParseException {
    }

    protected Node exitWriteSyntax(Token token) throws ParseException {
        return token;
    }

    protected void enterProductRelease(Token token) throws ParseException {
    }

    protected Node exitProductRelease(Token token) throws ParseException {
        return token;
    }

    protected void enterSupports(Token token) throws ParseException {
    }

    protected Node exitSupports(Token token) throws ParseException {
        return token;
    }

    protected void enterVariation(Token token) throws ParseException {
    }

    protected Node exitVariation(Token token) throws ParseException {
        return token;
    }

    protected void enterCreationRequires(Token token) throws ParseException {
    }

    protected Node exitCreationRequires(Token token) throws ParseException {
        return token;
    }

    protected void enterBinaryString(Token token) throws ParseException {
    }

    protected Node exitBinaryString(Token token) throws ParseException {
        return token;
    }

    protected void enterHexadecimalString(Token token) throws ParseException {
    }

    protected Node exitHexadecimalString(Token token) throws ParseException {
        return token;
    }

    protected void enterQuotedString(Token token) throws ParseException {
    }

    protected Node exitQuotedString(Token token) throws ParseException {
        return token;
    }

    protected void enterIdentifierString(Token token) throws ParseException {
    }

    protected Node exitIdentifierString(Token token) throws ParseException {
        return token;
    }

    protected void enterNumberString(Token token) throws ParseException {
    }

    protected Node exitNumberString(Token token) throws ParseException {
        return token;
    }

    protected void enterStart(Production production) throws ParseException {
    }

    protected Node exitStart(Production production) throws ParseException {
        return production;
    }

    protected void childStart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterModuleDefinition(Production production) throws ParseException {
    }

    protected Node exitModuleDefinition(Production production) throws ParseException {
        return production;
    }

    protected void childModuleDefinition(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterModuleIdentifier(Production production) throws ParseException {
    }

    protected Node exitModuleIdentifier(Production production) throws ParseException {
        return production;
    }

    protected void childModuleIdentifier(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterModuleReference(Production production) throws ParseException {
    }

    protected Node exitModuleReference(Production production) throws ParseException {
        return production;
    }

    protected void childModuleReference(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterTagDefault(Production production) throws ParseException {
    }

    protected Node exitTagDefault(Production production) throws ParseException {
        return production;
    }

    protected void childTagDefault(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterModuleBody(Production production) throws ParseException {
    }

    protected Node exitModuleBody(Production production) throws ParseException {
        return production;
    }

    protected void childModuleBody(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterExportList(Production production) throws ParseException {
    }

    protected Node exitExportList(Production production) throws ParseException {
        return production;
    }

    protected void childExportList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterImportList(Production production) throws ParseException {
    }

    protected Node exitImportList(Production production) throws ParseException {
        return production;
    }

    protected void childImportList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSymbolsFromModule(Production production) throws ParseException {
    }

    protected Node exitSymbolsFromModule(Production production) throws ParseException {
        return production;
    }

    protected void childSymbolsFromModule(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSymbolList(Production production) throws ParseException {
    }

    protected Node exitSymbolList(Production production) throws ParseException {
        return production;
    }

    protected void childSymbolList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSymbol(Production production) throws ParseException {
    }

    protected Node exitSymbol(Production production) throws ParseException {
        return production;
    }

    protected void childSymbol(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterAssignmentList(Production production) throws ParseException {
    }

    protected Node exitAssignmentList(Production production) throws ParseException {
        return production;
    }

    protected void childAssignmentList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterAssignment(Production production) throws ParseException {
    }

    protected Node exitAssignment(Production production) throws ParseException {
        return production;
    }

    protected void childAssignment(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterMacroDefinition(Production production) throws ParseException {
    }

    protected Node exitMacroDefinition(Production production) throws ParseException {
        return production;
    }

    protected void childMacroDefinition(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterMacroReference(Production production) throws ParseException {
    }

    protected Node exitMacroReference(Production production) throws ParseException {
        return production;
    }

    protected void childMacroReference(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterMacroBody(Production production) throws ParseException {
    }

    protected Node exitMacroBody(Production production) throws ParseException {
        return production;
    }

    protected void childMacroBody(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterMacroBodyElement(Production production) throws ParseException {
    }

    protected Node exitMacroBodyElement(Production production) throws ParseException {
        return production;
    }

    protected void childMacroBodyElement(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterTypeAssignment(Production production) throws ParseException {
    }

    protected Node exitTypeAssignment(Production production) throws ParseException {
        return production;
    }

    protected void childTypeAssignment(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterType(Production production) throws ParseException {
    }

    protected Node exitType(Production production) throws ParseException {
        return production;
    }

    protected void childType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterDefinedType(Production production) throws ParseException {
    }

    protected Node exitDefinedType(Production production) throws ParseException {
        return production;
    }

    protected void childDefinedType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBuiltinType(Production production) throws ParseException {
    }

    protected Node exitBuiltinType(Production production) throws ParseException {
        return production;
    }

    protected void childBuiltinType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNullType(Production production) throws ParseException {
    }

    protected Node exitNullType(Production production) throws ParseException {
        return production;
    }

    protected void childNullType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBooleanType(Production production) throws ParseException {
    }

    protected Node exitBooleanType(Production production) throws ParseException {
        return production;
    }

    protected void childBooleanType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterRealType(Production production) throws ParseException {
    }

    protected Node exitRealType(Production production) throws ParseException {
        return production;
    }

    protected void childRealType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterIntegerType(Production production) throws ParseException {
    }

    protected Node exitIntegerType(Production production) throws ParseException {
        return production;
    }

    protected void childIntegerType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterObjectIdentifierType(Production production) throws ParseException {
    }

    protected Node exitObjectIdentifierType(Production production) throws ParseException {
        return production;
    }

    protected void childObjectIdentifierType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterStringType(Production production) throws ParseException {
    }

    protected Node exitStringType(Production production) throws ParseException {
        return production;
    }

    protected void childStringType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBitStringType(Production production) throws ParseException {
    }

    protected Node exitBitStringType(Production production) throws ParseException {
        return production;
    }

    protected void childBitStringType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBitsType(Production production) throws ParseException {
    }

    protected Node exitBitsType(Production production) throws ParseException {
        return production;
    }

    protected void childBitsType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSequenceType(Production production) throws ParseException {
    }

    protected Node exitSequenceType(Production production) throws ParseException {
        return production;
    }

    protected void childSequenceType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSequenceOfType(Production production) throws ParseException {
    }

    protected Node exitSequenceOfType(Production production) throws ParseException {
        return production;
    }

    protected void childSequenceOfType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSetType(Production production) throws ParseException {
    }

    protected Node exitSetType(Production production) throws ParseException {
        return production;
    }

    protected void childSetType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSetOfType(Production production) throws ParseException {
    }

    protected Node exitSetOfType(Production production) throws ParseException {
        return production;
    }

    protected void childSetOfType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterChoiceType(Production production) throws ParseException {
    }

    protected Node exitChoiceType(Production production) throws ParseException {
        return production;
    }

    protected void childChoiceType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterEnumeratedType(Production production) throws ParseException {
    }

    protected Node exitEnumeratedType(Production production) throws ParseException {
        return production;
    }

    protected void childEnumeratedType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSelectionType(Production production) throws ParseException {
    }

    protected Node exitSelectionType(Production production) throws ParseException {
        return production;
    }

    protected void childSelectionType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterTaggedType(Production production) throws ParseException {
    }

    protected Node exitTaggedType(Production production) throws ParseException {
        return production;
    }

    protected void childTaggedType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterTag(Production production) throws ParseException {
    }

    protected Node exitTag(Production production) throws ParseException {
        return production;
    }

    protected void childTag(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterClass(Production production) throws ParseException {
    }

    protected Node exitClass(Production production) throws ParseException {
        return production;
    }

    protected void childClass(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterExplicitOrImplicitTag(Production production) throws ParseException {
    }

    protected Node exitExplicitOrImplicitTag(Production production) throws ParseException {
        return production;
    }

    protected void childExplicitOrImplicitTag(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterAnyType(Production production) throws ParseException {
    }

    protected Node exitAnyType(Production production) throws ParseException {
        return production;
    }

    protected void childAnyType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterElementTypeList(Production production) throws ParseException {
    }

    protected Node exitElementTypeList(Production production) throws ParseException {
        return production;
    }

    protected void childElementTypeList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterElementType(Production production) throws ParseException {
    }

    protected Node exitElementType(Production production) throws ParseException {
        return production;
    }

    protected void childElementType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterOptionalOrDefaultElement(Production production) throws ParseException {
    }

    protected Node exitOptionalOrDefaultElement(Production production) throws ParseException {
        return production;
    }

    protected void childOptionalOrDefaultElement(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValueOrConstraintList(Production production) throws ParseException {
    }

    protected Node exitValueOrConstraintList(Production production) throws ParseException {
        return production;
    }

    protected void childValueOrConstraintList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNamedNumberList(Production production) throws ParseException {
    }

    protected Node exitNamedNumberList(Production production) throws ParseException {
        return production;
    }

    protected void childNamedNumberList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNamedNumber(Production production) throws ParseException {
    }

    protected Node exitNamedNumber(Production production) throws ParseException {
        return production;
    }

    protected void childNamedNumber(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNumber(Production production) throws ParseException {
    }

    protected Node exitNumber(Production production) throws ParseException {
        return production;
    }

    protected void childNumber(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterConstraintList(Production production) throws ParseException {
    }

    protected Node exitConstraintList(Production production) throws ParseException {
        return production;
    }

    protected void childConstraintList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterConstraint(Production production) throws ParseException {
    }

    protected Node exitConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValueConstraintList(Production production) throws ParseException {
    }

    protected Node exitValueConstraintList(Production production) throws ParseException {
        return production;
    }

    protected void childValueConstraintList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValueConstraint(Production production) throws ParseException {
    }

    protected Node exitValueConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childValueConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValueRange(Production production) throws ParseException {
    }

    protected Node exitValueRange(Production production) throws ParseException {
        return production;
    }

    protected void childValueRange(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterLowerEndPoint(Production production) throws ParseException {
    }

    protected Node exitLowerEndPoint(Production production) throws ParseException {
        return production;
    }

    protected void childLowerEndPoint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterUpperEndPoint(Production production) throws ParseException {
    }

    protected Node exitUpperEndPoint(Production production) throws ParseException {
        return production;
    }

    protected void childUpperEndPoint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSizeConstraint(Production production) throws ParseException {
    }

    protected Node exitSizeConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childSizeConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterAlphabetConstraint(Production production) throws ParseException {
    }

    protected Node exitAlphabetConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childAlphabetConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterContainedTypeConstraint(Production production) throws ParseException {
    }

    protected Node exitContainedTypeConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childContainedTypeConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterInnerTypeConstraint(Production production) throws ParseException {
    }

    protected Node exitInnerTypeConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childInnerTypeConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComponentsList(Production production) throws ParseException {
    }

    protected Node exitComponentsList(Production production) throws ParseException {
        return production;
    }

    protected void childComponentsList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComponentsListTail(Production production) throws ParseException {
    }

    protected Node exitComponentsListTail(Production production) throws ParseException {
        return production;
    }

    protected void childComponentsListTail(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComponentConstraint(Production production) throws ParseException {
    }

    protected Node exitComponentConstraint(Production production) throws ParseException {
        return production;
    }

    protected void childComponentConstraint(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComponentValuePresence(Production production) throws ParseException {
    }

    protected Node exitComponentValuePresence(Production production) throws ParseException {
        return production;
    }

    protected void childComponentValuePresence(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComponentPresence(Production production) throws ParseException {
    }

    protected Node exitComponentPresence(Production production) throws ParseException {
        return production;
    }

    protected void childComponentPresence(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValueAssignment(Production production) throws ParseException {
    }

    protected Node exitValueAssignment(Production production) throws ParseException {
        return production;
    }

    protected void childValueAssignment(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValue(Production production) throws ParseException {
    }

    protected Node exitValue(Production production) throws ParseException {
        return production;
    }

    protected void childValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterDefinedValue(Production production) throws ParseException {
    }

    protected Node exitDefinedValue(Production production) throws ParseException {
        return production;
    }

    protected void childDefinedValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBuiltinValue(Production production) throws ParseException {
    }

    protected Node exitBuiltinValue(Production production) throws ParseException {
        return production;
    }

    protected void childBuiltinValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNullValue(Production production) throws ParseException {
    }

    protected Node exitNullValue(Production production) throws ParseException {
        return production;
    }

    protected void childNullValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBooleanValue(Production production) throws ParseException {
    }

    protected Node exitBooleanValue(Production production) throws ParseException {
        return production;
    }

    protected void childBooleanValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSpecialRealValue(Production production) throws ParseException {
    }

    protected Node exitSpecialRealValue(Production production) throws ParseException {
        return production;
    }

    protected void childSpecialRealValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNumberValue(Production production) throws ParseException {
    }

    protected Node exitNumberValue(Production production) throws ParseException {
        return production;
    }

    protected void childNumberValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBinaryValue(Production production) throws ParseException {
    }

    protected Node exitBinaryValue(Production production) throws ParseException {
        return production;
    }

    protected void childBinaryValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterHexadecimalValue(Production production) throws ParseException {
    }

    protected Node exitHexadecimalValue(Production production) throws ParseException {
        return production;
    }

    protected void childHexadecimalValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterStringValue(Production production) throws ParseException {
    }

    protected Node exitStringValue(Production production) throws ParseException {
        return production;
    }

    protected void childStringValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBitOrObjectIdentifierValue(Production production) throws ParseException {
    }

    protected Node exitBitOrObjectIdentifierValue(Production production) throws ParseException {
        return production;
    }

    protected void childBitOrObjectIdentifierValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterBitValue(Production production) throws ParseException {
    }

    protected Node exitBitValue(Production production) throws ParseException {
        return production;
    }

    protected void childBitValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterObjectIdentifierValue(Production production) throws ParseException {
    }

    protected Node exitObjectIdentifierValue(Production production) throws ParseException {
        return production;
    }

    protected void childObjectIdentifierValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNameValueList(Production production) throws ParseException {
    }

    protected Node exitNameValueList(Production production) throws ParseException {
        return production;
    }

    protected void childNameValueList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNameValueComponent(Production production) throws ParseException {
    }

    protected Node exitNameValueComponent(Production production) throws ParseException {
        return production;
    }

    protected void childNameValueComponent(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNameOrNumber(Production production) throws ParseException {
    }

    protected Node exitNameOrNumber(Production production) throws ParseException {
        return production;
    }

    protected void childNameOrNumber(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterNameAndNumber(Production production) throws ParseException {
    }

    protected Node exitNameAndNumber(Production production) throws ParseException {
        return production;
    }

    protected void childNameAndNumber(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterDefinedMacroType(Production production) throws ParseException {
    }

    protected Node exitDefinedMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childDefinedMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterDefinedMacroName(Production production) throws ParseException {
    }

    protected Node exitDefinedMacroName(Production production) throws ParseException {
        return production;
    }

    protected void childDefinedMacroName(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpModuleIdentityMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpModuleIdentityMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpModuleIdentityMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpObjectIdentityMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpObjectIdentityMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpObjectIdentityMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpObjectTypeMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpObjectTypeMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpObjectTypeMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpNotificationTypeMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpNotificationTypeMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpNotificationTypeMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpTrapTypeMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpTrapTypeMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpTrapTypeMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpTextualConventionMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpTextualConventionMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpTextualConventionMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpObjectGroupMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpObjectGroupMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpObjectGroupMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpNotificationGroupMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpNotificationGroupMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpNotificationGroupMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpModuleComplianceMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpModuleComplianceMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpModuleComplianceMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpAgentCapabilitiesMacroType(Production production) throws ParseException {
    }

    protected Node exitSnmpAgentCapabilitiesMacroType(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpAgentCapabilitiesMacroType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpUpdatePart(Production production) throws ParseException {
    }

    protected Node exitSnmpUpdatePart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpUpdatePart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpOrganizationPart(Production production) throws ParseException {
    }

    protected Node exitSnmpOrganizationPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpOrganizationPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpContactPart(Production production) throws ParseException {
    }

    protected Node exitSnmpContactPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpContactPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpDescrPart(Production production) throws ParseException {
    }

    protected Node exitSnmpDescrPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpDescrPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpRevisionPart(Production production) throws ParseException {
    }

    protected Node exitSnmpRevisionPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpRevisionPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpStatusPart(Production production) throws ParseException {
    }

    protected Node exitSnmpStatusPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpStatusPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpReferPart(Production production) throws ParseException {
    }

    protected Node exitSnmpReferPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpReferPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpSyntaxPart(Production production) throws ParseException {
    }

    protected Node exitSnmpSyntaxPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpSyntaxPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpUnitsPart(Production production) throws ParseException {
    }

    protected Node exitSnmpUnitsPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpUnitsPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpAccessPart(Production production) throws ParseException {
    }

    protected Node exitSnmpAccessPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpAccessPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpIndexPart(Production production) throws ParseException {
    }

    protected Node exitSnmpIndexPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpIndexPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterIndexValueList(Production production) throws ParseException {
    }

    protected Node exitIndexValueList(Production production) throws ParseException {
        return production;
    }

    protected void childIndexValueList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterIndexValue(Production production) throws ParseException {
    }

    protected Node exitIndexValue(Production production) throws ParseException {
        return production;
    }

    protected void childIndexValue(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterIndexType(Production production) throws ParseException {
    }

    protected Node exitIndexType(Production production) throws ParseException {
        return production;
    }

    protected void childIndexType(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpDefValPart(Production production) throws ParseException {
    }

    protected Node exitSnmpDefValPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpDefValPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpObjectsPart(Production production) throws ParseException {
    }

    protected Node exitSnmpObjectsPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpObjectsPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterValueList(Production production) throws ParseException {
    }

    protected Node exitValueList(Production production) throws ParseException {
        return production;
    }

    protected void childValueList(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpEnterprisePart(Production production) throws ParseException {
    }

    protected Node exitSnmpEnterprisePart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpEnterprisePart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpVarPart(Production production) throws ParseException {
    }

    protected Node exitSnmpVarPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpVarPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpDisplayPart(Production production) throws ParseException {
    }

    protected Node exitSnmpDisplayPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpDisplayPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpNotificationsPart(Production production) throws ParseException {
    }

    protected Node exitSnmpNotificationsPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpNotificationsPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpModulePart(Production production) throws ParseException {
    }

    protected Node exitSnmpModulePart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpModulePart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpModuleImport(Production production) throws ParseException {
    }

    protected Node exitSnmpModuleImport(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpModuleImport(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpMandatoryPart(Production production) throws ParseException {
    }

    protected Node exitSnmpMandatoryPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpMandatoryPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpCompliancePart(Production production) throws ParseException {
    }

    protected Node exitSnmpCompliancePart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpCompliancePart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComplianceGroup(Production production) throws ParseException {
    }

    protected Node exitComplianceGroup(Production production) throws ParseException {
        return production;
    }

    protected void childComplianceGroup(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterComplianceObject(Production production) throws ParseException {
    }

    protected Node exitComplianceObject(Production production) throws ParseException {
        return production;
    }

    protected void childComplianceObject(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpWriteSyntaxPart(Production production) throws ParseException {
    }

    protected Node exitSnmpWriteSyntaxPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpWriteSyntaxPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpProductReleasePart(Production production) throws ParseException {
    }

    protected Node exitSnmpProductReleasePart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpProductReleasePart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpModuleSupportPart(Production production) throws ParseException {
    }

    protected Node exitSnmpModuleSupportPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpModuleSupportPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpVariationPart(Production production) throws ParseException {
    }

    protected Node exitSnmpVariationPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpVariationPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    protected void enterSnmpCreationPart(Production production) throws ParseException {
    }

    protected Node exitSnmpCreationPart(Production production) throws ParseException {
        return production;
    }

    protected void childSnmpCreationPart(Production production, Node node) throws ParseException {
        production.addChild(node);
    }

    private void pad(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
    }

    private String asnToString(int n) {
        switch (n) {
            case 1001: {
                return "DOT";
            }
            case 1002: {
                return "DOUBLE_DOT";
            }
            case 1003: {
                return "TRIPLE_DOT";
            }
            case 1004: {
                return "COMMA";
            }
            case 1005: {
                return "SEMI_COLON";
            }
            case 1006: {
                return "LEFT_PAREN";
            }
            case 1007: {
                return "RIGHT_PAREN";
            }
            case 1008: {
                return "LEFT_BRACE";
            }
            case 1009: {
                return "RIGHT_BRACE";
            }
            case 1010: {
                return "LEFT_BRACKET";
            }
            case 1011: {
                return "RIGHT_BRACKET";
            }
            case 1012: {
                return "MINUS";
            }
            case 1013: {
                return "LESS_THAN";
            }
            case 1014: {
                return "VERTICAL_BAR";
            }
            case 1015: {
                return "DEFINITION";
            }
            case 1016: {
                return "DEFINITIONS";
            }
            case 1017: {
                return "EXPLICIT";
            }
            case 1018: {
                return "IMPLICIT";
            }
            case 1019: {
                return "TAGS";
            }
            case 1020: {
                return "BEGIN";
            }
            case 1021: {
                return "END";
            }
            case 1022: {
                return "EXPORTS";
            }
            case 1023: {
                return "IMPORTS";
            }
            case 1024: {
                return "FROM";
            }
            case 1025: {
                return "MACRO";
            }
            case 1026: {
                return "INTEGER";
            }
            case 1027: {
                return "REAL";
            }
            case 1028: {
                return "BOOLEAN";
            }
            case 1029: {
                return "NULL";
            }
            case 1030: {
                return "BIT";
            }
            case 1031: {
                return "OCTET";
            }
            case 1032: {
                return "STRING";
            }
            case 1033: {
                return "ENUMERATED";
            }
            case 1034: {
                return "SEQUENCE";
            }
            case 1035: {
                return "SET";
            }
            case 1036: {
                return "OF";
            }
            case 1037: {
                return "CHOICE";
            }
            case 1038: {
                return "UNIVERSAL";
            }
            case 1039: {
                return "APPLICATION";
            }
            case 1040: {
                return "PRIVATE";
            }
            case 1041: {
                return "ANY";
            }
            case 1042: {
                return "DEFINED";
            }
            case 1043: {
                return "BY";
            }
            case 1044: {
                return "OBJECT";
            }
            case 1045: {
                return "IDENTIFIER";
            }
            case 1046: {
                return "INCLUDES";
            }
            case 1047: {
                return "MIN";
            }
            case 1048: {
                return "MAX";
            }
            case 1050: {
                return "WITH";
            }
            case 1051: {
                return "COMPONENT";
            }
            case 1052: {
                return "COMPONENTS";
            }
            case 1053: {
                return "PRESENT";
            }
            case 1054: {
                return "ABSENT";
            }
            case 1055: {
                return "OPTIONAL";
            }
            case 1056: {
                return "DEFAULT";
            }
            case 1057: {
                return "TRUE";
            }
            case 1058: {
                return "FALSE";
            }
            case 1059: {
                return "PLUS_INFINITY";
            }
            case 1060: {
                return "MINUS_INFINITY";
            }
            case 1061: {
                return "MODULE_IDENTITY";
            }
            case 1062: {
                return "OBJECT_IDENTITY";
            }
            case 1063: {
                return "OBJECT_TYPE";
            }
            case 1064: {
                return "NOTIFICATION_TYPE";
            }
            case 1065: {
                return "TRAP_TYPE";
            }
            case 1066: {
                return "TEXTUAL_CONVENTION";
            }
            case 1067: {
                return "OBJECT_GROUP";
            }
            case 1068: {
                return "NOTIFICATION_GROUP";
            }
            case 1069: {
                return "MODULE_COMPLIANCE";
            }
            case 1070: {
                return "AGENT_CAPABILITIES";
            }
            case 1071: {
                return "LAST_UPDATED";
            }
            case 1073: {
                return "CONTACT_INFO";
            }
            case 1074: {
                return "DESCRIPTION";
            }
            case 1075: {
                return "REVISION";
            }
            case 1076: {
                return "STATUS";
            }
            case 1077: {
                return "REFERENCE";
            }
            case 1078: {
                return "SYNTAX";
            }
            case 1079: {
                return "BITS";
            }
            case 1080: {
                return "UNITS";
            }
            case 1081: {
                return "ACCESS";
            }
            case 1082: {
                return "MAX_ACCESS";
            }
            case 1083: {
                return "MIN_ACCESS";
            }
            case 1084: {
                return "INDEX";
            }
            case 1085: {
                return "AUGMENTS";
            }
            case 1086: {
                return "IMPLIED";
            }
            case 1087: {
                return "DEFVAL";
            }
            case 1088: {
                return "OBJECTS";
            }
            case 1089: {
                return "ENTERPRISE";
            }
            case 1090: {
                return "VARIABLES";
            }
            case 1091: {
                return "DISPLAY_HINT";
            }
            case 1092: {
                return "NOTIFICATIONS";
            }
            case 1093: {
                return "MODULE";
            }
            case 1094: {
                return "MANDATORY_GROUPS";
            }
            case 1095: {
                return "GROUP";
            }
            case 1096: {
                return "WRITE_SYNTAX";
            }
            case 1097: {
                return "PRODUCT_RELEASE";
            }
            case 1098: {
                return "SUPPORTS";
            }
            case 1099: {
                return "VARIATION";
            }
            case 1100: {
                return "CREATION_REQUIRES";
            }
            case 1101: {
                return "BINARY_STRING";
            }
            case 1102: {
                return "HEXADECIMAL_STRING";
            }
            case 1103: {
                return "QUOTED_STRING";
            }
            case 1104: {
                return "IDENTIFIER_STRING";
            }
            case 1105: {
                return "NUMBER_STRING";
            }
            case 1106: {
                return "WHITESPACE";
            }
            case 1107: {
                return "COMMENT";
            }
            case 2001: {
                return "START";
            }
            case 2002: {
                return "MODULE_DEFINITION";
            }
            case 2003: {
                return "MODULE_IDENTIFIER";
            }
            case 2004: {
                return "MODULE_REFERENCE";
            }
            case 2005: {
                return "TAG_DEFAULT";
            }
            case 2006: {
                return "MODULE_BODY";
            }
            case 2007: {
                return "EXPORT_LIST";
            }
            case 2008: {
                return "IMPORT_LIST";
            }
            case 2009: {
                return "SYMBOLS_FROM_MODULE";
            }
            case 2010: {
                return "SYMBOL_LIST";
            }
            case 2011: {
                return "SYMBOL";
            }
            case 2012: {
                return "ASSIGNMENT_LIST";
            }
            case 2013: {
                return "ASSIGNMENT";
            }
            case 2014: {
                return "MACRO_DEFINITION";
            }
            case 2015: {
                return "MACRO_REFERENCE";
            }
            case 2016: {
                return "MACRO_BODY";
            }
            case 2017: {
                return "MACRO_BODY_ELEMENT";
            }
            case 2018: {
                return "TYPE_ASSIGNMENT";
            }
            case 2019: {
                return "TYPE";
            }
            case 2020: {
                return "DEFINED_TYPE";
            }
            case 2021: {
                return "BUILTIN_TYPE";
            }
            case 2022: {
                return "NULL_TYPE";
            }
            case 2023: {
                return "BOOLEAN_TYPE";
            }
            case 2024: {
                return "REAL_TYPE";
            }
            case 2025: {
                return "INTEGER_TYPE";
            }
            case 2026: {
                return "OBJECT_IDENTIFIER_TYPE";
            }
            case 2027: {
                return "STRING_TYPE";
            }
            case 2028: {
                return "BIT_STRING_TYPE";
            }
            case 2029: {
                return "BITS_TYPE";
            }
            case 2030: {
                return "SEQUENCE_TYPE";
            }
            case 2031: {
                return "SEQUENCE_OF_TYPE";
            }
            case 2032: {
                return "SET_TYPE";
            }
            case 2033: {
                return "SET_OF_TYPE";
            }
            case 2034: {
                return "CHOICE_TYPE";
            }
            case 2035: {
                return "ENUMERATED_TYPE";
            }
            case 2036: {
                return "SELECTION_TYPE";
            }
            case 2037: {
                return "TAGGED_TYPE";
            }
            case 2038: {
                return "TAG";
            }
            case 2039: {
                return "CLASS";
            }
            case 2040: {
                return "EXPLICIT_OR_IMPLICIT_TAG";
            }
            case 2041: {
                return "ANY_TYPE";
            }
            case 2042: {
                return "ELEMENT_TYPE_LIST";
            }
            case 2043: {
                return "ELEMENT_TYPE";
            }
            case 2044: {
                return "OPTIONAL_OR_DEFAULT_ELEMENT";
            }
            case 2045: {
                return "VALUE_OR_CONSTRAINT_LIST";
            }
            case 2046: {
                return "NAMED_NUMBER_LIST";
            }
            case 2047: {
                return "NAMED_NUMBER";
            }
            case 2048: {
                return "NUMBER";
            }
            case 2049: {
                return "CONSTRAINT_LIST";
            }
            case 2050: {
                return "CONSTRAINT";
            }
            case 2051: {
                return "VALUE_CONSTRAINT_LIST";
            }
            case 2052: {
                return "VALUE_CONSTRAINT";
            }
            case 2053: {
                return "VALUE_RANGE";
            }
            case 2054: {
                return "LOWER_END_POINT";
            }
            case 2055: {
                return "UPPER_END_POINT";
            }
            case 2057: {
                return "ALPHABET_CONSTRAINT";
            }
            case 2058: {
                return "CONTAINED_TYPE_CONSTRAINT";
            }
            case 2059: {
                return "INNER_TYPE_CONSTRAINT";
            }
            case 2060: {
                return "COMPONENTS_LIST";
            }
            case 2061: {
                return "COMPONENTS_LIST_TAIL";
            }
            case 2062: {
                return "COMPONENT_CONSTRAINT";
            }
            case 2063: {
                return "COMPONENT_VALUE_PRESENCE";
            }
            case 2064: {
                return "COMPONENT_PRESENCE";
            }
            case 2065: {
                return "VALUE_ASSIGNMENT";
            }
            case 2066: {
                return "VALUE";
            }
            case 2067: {
                return "DEFINED_VALUE";
            }
            case 2068: {
                return "BUILTIN_VALUE";
            }
            case 2069: {
                return "NULL_VALUE";
            }
            case 2070: {
                return "BOOLEAN_VALUE";
            }
            case 2071: {
                return "SPECIAL_REAL_VALUE";
            }
            case 2072: {
                return "NUMBER_VALUE";
            }
            case 2073: {
                return "BINARY_VALUE";
            }
            case 2074: {
                return "HEXADECIMAL_VALUE";
            }
            case 2075: {
                return "STRING_VALUE";
            }
            case 2076: {
                return "BIT_OR_OBJECT_IDENTIFIER_VALUE";
            }
            case 2077: {
                return "BIT_VALUE";
            }
            case 2078: {
                return "OBJECT_IDENTIFIER_VALUE";
            }
            case 2079: {
                return "NAME_VALUE_LIST";
            }
            case 2080: {
                return "NAME_VALUE_COMPONENT";
            }
            case 2081: {
                return "NAME_OR_NUMBER";
            }
            case 2082: {
                return "NAME_AND_NUMBER";
            }
            case 2083: {
                return "DEFINED_MACRO_TYPE";
            }
            case 2084: {
                return "DEFINED_MACRO_NAME";
            }
            case 2085: {
                return "SNMP_MODULE_IDENTITY_MACRO_TYPE";
            }
            case 2086: {
                return "SNMP_OBJECT_IDENTITY_MACRO_TYPE";
            }
            case 2087: {
                return "SNMP_OBJECT_TYPE_MACRO_TYPE";
            }
            case 2088: {
                return "SNMP_NOTIFICATION_TYPE_MACRO_TYPE";
            }
            case 2089: {
                return "SNMP_TRAP_TYPE_MACRO_TYPE";
            }
            case 2090: {
                return "SNMP_TEXTUAL_CONVENTION_MACRO_TYPE";
            }
            case 2091: {
                return "SNMP_OBJECT_GROUP_MACRO_TYPE";
            }
            case 2092: {
                return "SNMP_NOTIFICATION_GROUP_MACRO_TYPE";
            }
            case 2093: {
                return "SNMP_MODULE_COMPLIANCE_MACRO_TYPE";
            }
            case 2094: {
                return "SNMP_AGENT_CAPABILITIES_MACRO_TYPE";
            }
            case 2095: {
                return "SNMP_UPDATE_PART";
            }
            case 2097: {
                return "SNMP_CONTACT_PART";
            }
            case 2098: {
                return "SNMP_DESCR_PART";
            }
            case 2099: {
                return "SNMP_REVISION_PART";
            }
            case 2100: {
                return "SNMP_STATUS_PART";
            }
            case 2101: {
                return "SNMP_REFER_PART";
            }
            case 2102: {
                return "SNMP_SYNTAX_PART";
            }
            case 2103: {
                return "SNMP_UNITS_PART";
            }
            case 2104: {
                return "SNMP_ACCESS_PART";
            }
            case 2105: {
                return "SNMP_INDEX_PART";
            }
            case 2106: {
                return "INDEX_VALUE_LIST";
            }
            case 2107: {
                return "INDEX_VALUE";
            }
            case 2108: {
                return "INDEX_TYPE";
            }
            case 2109: {
                return "SNMP_DEF_VAL_PART";
            }
            case 2110: {
                return "SNMP_OBJECTS_PART";
            }
            case 2111: {
                return "VALUE_LIST";
            }
            case 2112: {
                return "SNMP_ENTERPRISE_PART";
            }
            case 2113: {
                return "SNMP_VAR_PART";
            }
            case 2114: {
                return "SNMP_DISPLAY_PART";
            }
            case 2115: {
                return "SNMP_NOTIFICATIONS_PART";
            }
            case 2116: {
                return "SNMP_MODULE_PART";
            }
            case 2117: {
                return "SNMP_MODULE_IMPORT";
            }
            case 2118: {
                return "SNMP_MANDATORY_PART";
            }
            case 2119: {
                return "SNMP_COMPLIANCE_PART";
            }
            case 2120: {
                return "COMPLIANCE_GROUP";
            }
            case 2121: {
                return "COMPLIANCE_OBJECT";
            }
            case 2122: {
                return "SNMP_WRITE_SYNTAX_PART";
            }
            case 2123: {
                return "SNMP_PRODUCT_RELEASE_PART";
            }
            case 2124: {
                return "SNMP_MODULE_SUPPORT_PART";
            }
            case 2125: {
                return "SNMP_VARIATION_PART";
            }
            case 2126: {
                return "SNMP_CREATION_PART";
            }
        }
        return Integer.toString(n);
    }
}

