/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAgentCapabilities;
import net.percederberg.mibble.snmp.SnmpCompliance;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpModuleCompliance;
import net.percederberg.mibble.snmp.SnmpModuleIdentity;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpNotificationGroup;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectGroup;
import net.percederberg.mibble.snmp.SnmpObjectIdentity;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpVariation;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.value.BitSetValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import net.percederberg.mibble.value.StringValue;

public class MibWriter {
    private PrintWriter os;
    private int margin;

    public MibWriter(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    public MibWriter(Writer writer) {
        this(writer, 0);
    }

    public MibWriter(Writer writer, int n) {
        this.os = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.margin = n;
    }

    public void close() {
        this.os.close();
    }

    public void print(Mib mib) {
        Iterator iterator;
        this.printComment(mib.getHeaderComment(), "", true);
        if (mib.getHeaderComment() != null) {
            this.os.println();
        }
        this.os.print(mib.getName());
        this.os.println(" DEFINITIONS ::= BEGIN");
        this.os.println();
        Collection collection = mib.getAllImports();
        if (collection.size() > 0) {
            this.os.println("IMPORTS");
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.printImport((MibImport)iterator.next());
                if (!iterator.hasNext()) continue;
                this.os.println();
            }
            this.os.println(";");
            this.os.println();
        }
        iterator = mib.getAllSymbols().iterator();
        while (iterator.hasNext()) {
            this.printSymbol((MibSymbol)iterator.next(), mib.getSmiVersion());
        }
        this.os.println("END");
        this.printComment(mib.getFooterComment(), "", true);
        this.os.flush();
    }

    private void printComment(String string, String string2, boolean bl) {
        if (string != null) {
            if (bl) {
                this.printIndent(string2 + "-- ", string);
                this.os.println();
            } else if (string.indexOf("\n") >= 0) {
                int n = string.indexOf("\n");
                this.os.print(" -- ");
                this.os.print(string.substring(0, n));
                this.os.println();
                this.printIndent(string2 + " -- ", string.substring(n + 1));
            } else {
                this.os.print(" -- ");
                this.os.print(string);
            }
        }
    }

    private void printImport(MibImport mibImport) {
        int n = 0;
        Iterator iterator = mibImport.getAllSymbolNames().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            if (n <= 0) {
                n = string.length();
                this.os.print("    ");
            } else {
                n = string.length();
                this.os.println(",");
                this.os.print("    ");
            }
            this.os.print(string);
        }
        this.os.println();
        this.os.print("        FROM ");
        this.os.print(mibImport.getName());
    }

    private void printSymbol(MibSymbol mibSymbol, int n) {
        this.printComment(mibSymbol.getComment(), "", true);
        if (mibSymbol instanceof MibTypeSymbol) {
            this.os.print(mibSymbol.getName());
            this.os.print(" ::= ");
            this.printType(((MibTypeSymbol)mibSymbol).getType(), "", n);
        } else if (mibSymbol instanceof MibValueSymbol) {
            this.os.print(mibSymbol.getName());
            this.os.print(" ");
            this.printType(((MibValueSymbol)mibSymbol).getType(), "", n);
            this.os.println();
            this.os.print("    ::= ");
            this.printValue(((MibValueSymbol)mibSymbol).getValue());
        } else {
            this.os.print("-- ");
            this.os.print(mibSymbol.getName());
            this.os.print(" MACRO ... not printed");
        }
        this.os.println();
        this.os.println();
    }

    private void printType(MibType mibType, String string, int n) {
        if (mibType.getReferenceSymbol() != null) {
            this.os.print(mibType.getReferenceSymbol().getName());
            MibType mibType2 = mibType.getReferenceSymbol().getType();
            Constraint constraint = this.getConstraint(mibType2);
            Constraint constraint2 = this.getConstraint(mibType);
            if (constraint2 != null && constraint2 != constraint) {
                this.printConstraint(mibType, string);
            }
        } else if (mibType instanceof SequenceType) {
            SequenceType sequenceType = (SequenceType)mibType;
            this.os.println("SEQUENCE {");
            this.printTypeElements(sequenceType.getAllElements(), string + "    ", n);
            this.os.println();
            this.os.print(string);
            this.os.print("}");
        } else if (mibType instanceof SequenceOfType) {
            SequenceOfType sequenceOfType = (SequenceOfType)mibType;
            this.os.print("SEQUENCE ");
            if (sequenceOfType.getConstraint() != null) {
                this.os.print("(");
                this.os.print(sequenceOfType.getConstraint());
                this.os.print(") ");
            }
            this.os.print("OF ");
            this.printType(sequenceOfType.getElementType(), string, n);
        } else if (mibType instanceof IntegerType) {
            this.os.print("INTEGER");
            this.printConstraint(mibType, string);
        } else if (mibType instanceof BitSetType) {
            this.os.print("BITS");
            this.printConstraint(mibType, string);
        } else if (mibType instanceof StringType) {
            this.os.print("OCTET STRING");
            this.printConstraint(mibType, string);
        } else if (mibType.isPrimitive()) {
            this.os.print(mibType.getName());
        } else if (mibType instanceof SnmpModuleIdentity) {
            this.printType((SnmpModuleIdentity)mibType, string);
        } else if (mibType instanceof SnmpObjectIdentity) {
            this.printType((SnmpObjectIdentity)mibType, string);
        } else if (mibType instanceof SnmpObjectType) {
            this.printType((SnmpObjectType)mibType, string, n);
        } else if (mibType instanceof SnmpNotificationType) {
            this.printType((SnmpNotificationType)mibType, string);
        } else if (mibType instanceof SnmpTrapType) {
            this.printType((SnmpTrapType)mibType, string);
        } else if (mibType instanceof SnmpTextualConvention) {
            this.printType((SnmpTextualConvention)mibType, string, n);
        } else if (mibType instanceof SnmpObjectGroup) {
            this.printType((SnmpObjectGroup)mibType, string);
        } else if (mibType instanceof SnmpNotificationGroup) {
            this.printType((SnmpNotificationGroup)mibType, string);
        } else if (mibType instanceof SnmpModuleCompliance) {
            this.printType((SnmpModuleCompliance)mibType, string, n);
        } else if (mibType instanceof SnmpAgentCapabilities) {
            this.printType((SnmpAgentCapabilities)mibType, string, n);
        } else {
            this.os.print("-- ERROR: type definition unknown");
        }
        this.printComment(mibType.getComment(), string, false);
    }

    private void printType(SnmpModuleIdentity snmpModuleIdentity, String string) {
        this.os.println("MODULE-IDENTITY");
        this.os.print("    LAST-UPDATED    ");
        this.os.println(this.getQuote(snmpModuleIdentity.getLastUpdated()));
        this.os.print("    ORGANIZATION    ");
        this.os.println(this.getQuote(snmpModuleIdentity.getOrganization()));
        this.os.println("    CONTACT-INFO");
        this.printIndent("            ", this.getQuote(snmpModuleIdentity.getContactInfo()));
        this.os.println();
        this.printDescription(snmpModuleIdentity.getDescription());
        ArrayList arrayList = snmpModuleIdentity.getRevisions();
        for (int i = 0; i < arrayList.size(); ++i) {
            SnmpRevision snmpRevision = (SnmpRevision)arrayList.get(i);
            this.os.println();
            if (snmpRevision.getComment() != null) {
                this.os.println();
                this.printComment(snmpRevision.getComment(), "    ", true);
            }
            this.os.print("    REVISION        ");
            this.printValue(snmpRevision.getValue());
            this.os.println();
            this.os.println("    DESCRIPTION");
            this.printIndent("            ", this.getQuote(snmpRevision.getDescription()));
        }
    }

    private void printType(SnmpObjectIdentity snmpObjectIdentity, String string) {
        this.os.println("OBJECT-IDENTITY");
        this.os.print("    STATUS          ");
        this.os.println(snmpObjectIdentity.getStatus());
        this.printDescription(snmpObjectIdentity.getDescription());
        if (snmpObjectIdentity.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpObjectIdentity.getReference()));
        }
    }

    private void printType(SnmpObjectType snmpObjectType, String string, int n) {
        this.os.println("OBJECT-TYPE");
        this.os.print("    SYNTAX          ");
        this.printType(snmpObjectType.getSyntax(), "                    ", n);
        this.os.println();
        if (snmpObjectType.getUnits() != null) {
            this.os.print("    UNITS           ");
            this.os.print(this.getQuote(snmpObjectType.getUnits()));
            this.os.println();
        }
        if (n == 1) {
            this.os.print("    ACCESS          ");
        } else {
            this.os.print("    MAX-ACCESS      ");
        }
        this.os.println(snmpObjectType.getAccess());
        this.os.print("    STATUS          ");
        this.os.print(snmpObjectType.getStatus());
        if (snmpObjectType.getDescription() != null) {
            this.os.println();
            this.printDescription(snmpObjectType.getDescription());
        }
        if (snmpObjectType.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpObjectType.getReference()));
        }
        if (snmpObjectType.getIndex() != null && snmpObjectType.getIndex().size() > 0) {
            this.os.println();
            this.os.print("    INDEX           ");
            this.printReferenceList(snmpObjectType.getIndex(), "                    ");
        }
        if (snmpObjectType.getAugments() != null) {
            this.os.println();
            this.os.print("    AUGMENTS        ");
            this.printReference(snmpObjectType.getAugments());
        }
        if (snmpObjectType.getDefaultValue() != null) {
            this.os.println();
            this.os.print("    DEFVAL          ");
            this.printReference(snmpObjectType.getDefaultValue(), this.getSymbols(snmpObjectType.getSyntax()));
        }
    }

    private void printType(SnmpNotificationType snmpNotificationType, String string) {
        this.os.println("NOTIFICATION-TYPE");
        if (snmpNotificationType.getObjects().size() > 0) {
            this.os.print("    OBJECTS         ");
            this.printReferenceList(snmpNotificationType.getObjects(), "                    ");
            this.os.println();
        }
        this.os.print("    STATUS          ");
        this.os.println(snmpNotificationType.getStatus());
        this.printDescription(snmpNotificationType.getDescription());
        if (snmpNotificationType.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpNotificationType.getReference()));
        }
    }

    private void printType(SnmpTrapType snmpTrapType, String string) {
        this.os.println("TRAP-TYPE");
        this.os.print("    ENTERPRISE      ");
        this.printReferenceEntry(snmpTrapType.getEnterprise());
        if (snmpTrapType.getVariables().size() > 0) {
            this.os.println();
            this.os.print("    VARIABLES       ");
            this.printReferenceList(snmpTrapType.getVariables(), "                    ");
        }
        if (snmpTrapType.getDescription() != null) {
            this.os.println();
            this.printDescription(snmpTrapType.getDescription());
        }
        if (snmpTrapType.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpTrapType.getReference()));
        }
    }

    private void printType(SnmpTextualConvention snmpTextualConvention, String string, int n) {
        this.os.println("TEXTUAL-CONVENTION");
        if (snmpTextualConvention.getDisplayHint() != null) {
            this.os.print("    DISPLAY-HINT    ");
            this.os.print(this.getQuote(snmpTextualConvention.getDisplayHint()));
            this.os.println();
        }
        this.os.print("    STATUS          ");
        this.os.println(snmpTextualConvention.getStatus());
        this.printDescription(snmpTextualConvention.getDescription());
        if (snmpTextualConvention.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpTextualConvention.getReference()));
        }
        this.os.println();
        this.os.print("    SYNTAX          ");
        this.printType(snmpTextualConvention.getSyntax(), "                    ", n);
    }

    private void printType(SnmpObjectGroup snmpObjectGroup, String string) {
        this.os.println("OBJECT-GROUP");
        this.os.print("    OBJECTS         ");
        this.printReferenceList(snmpObjectGroup.getObjects(), "                    ");
        this.os.println();
        this.os.print("    STATUS          ");
        this.os.println(snmpObjectGroup.getStatus());
        this.printDescription(snmpObjectGroup.getDescription());
        if (snmpObjectGroup.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpObjectGroup.getReference()));
        }
    }

    private void printType(SnmpNotificationGroup snmpNotificationGroup, String string) {
        this.os.println("NOTIFICATION-GROUP");
        this.os.print("    NOTIFICATIONS   ");
        this.printReferenceList(snmpNotificationGroup.getNotifications(), "                    ");
        this.os.println();
        this.os.print("    STATUS          ");
        this.os.println(snmpNotificationGroup.getStatus());
        this.printDescription(snmpNotificationGroup.getDescription());
        if (snmpNotificationGroup.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpNotificationGroup.getReference()));
        }
    }

    private void printType(SnmpModuleCompliance snmpModuleCompliance, String string, int n) {
        this.os.println("MODULE-COMPLIANCE");
        this.os.print("    STATUS          ");
        this.os.println(snmpModuleCompliance.getStatus());
        this.printDescription(snmpModuleCompliance.getDescription());
        if (snmpModuleCompliance.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpModuleCompliance.getReference()));
        }
        for (int i = 0; i < snmpModuleCompliance.getModules().size(); ++i) {
            SnmpModule snmpModule = (SnmpModule)snmpModuleCompliance.getModules().get(i);
            this.os.println();
            this.printComment(snmpModule.getComment(), "    ", true);
            this.os.print("    MODULE          ");
            if (snmpModule.getModule() == null) {
                this.os.print("-- this module");
            } else {
                this.os.print(snmpModule.getModule());
            }
            if (snmpModule.getGroups().size() > 0) {
                this.os.println();
                this.os.print("    MANDATORY-GROUPS ");
                this.printReferenceList(snmpModule.getGroups(), "                    ");
            }
            ArrayList arrayList = snmpModule.getCompliances();
            for (int j = 0; j < arrayList.size(); ++j) {
                this.os.println();
                this.os.println();
                this.printModuleCompliance((SnmpCompliance)arrayList.get(j), n);
            }
        }
    }

    private void printType(SnmpAgentCapabilities snmpAgentCapabilities, String string, int n) {
        this.os.println("AGENT-CAPABILITIES");
        this.os.print("    PRODUCT-RELEASE ");
        this.os.println(this.getQuote(snmpAgentCapabilities.getProductRelease()));
        this.os.print("    STATUS          ");
        this.os.println(snmpAgentCapabilities.getStatus());
        this.printDescription(snmpAgentCapabilities.getDescription());
        if (snmpAgentCapabilities.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(snmpAgentCapabilities.getReference()));
        }
        for (int i = 0; i < snmpAgentCapabilities.getModules().size(); ++i) {
            SnmpModuleSupport snmpModuleSupport = (SnmpModuleSupport)snmpAgentCapabilities.getModules().get(i);
            this.os.println();
            this.os.print("    SUPPORTS        ");
            this.os.println(snmpModuleSupport.getModule());
            this.os.print("    INCLUDES        ");
            this.printReferenceList(snmpModuleSupport.getGroups(), "                    ");
            ArrayList arrayList = snmpModuleSupport.getVariations();
            for (int j = 0; j < arrayList.size(); ++j) {
                this.os.println();
                this.os.println();
                this.printVariation((SnmpVariation)arrayList.get(j), n);
            }
        }
    }

    private void printModuleCompliance(SnmpCompliance snmpCompliance, int n) {
        this.printComment(snmpCompliance.getComment(), "    ", true);
        if (snmpCompliance.isGroup()) {
            this.os.print("    GROUP           ");
            this.printReferenceEntry(snmpCompliance.getValue());
            this.os.println();
        } else {
            this.os.print("    OBJECT          ");
            this.printReferenceEntry(snmpCompliance.getValue());
            this.os.println();
            if (snmpCompliance.getSyntax() != null) {
                this.os.print("    SYNTAX          ");
                this.printType(snmpCompliance.getSyntax(), "                    ", n);
                this.os.println();
            }
            if (snmpCompliance.getWriteSyntax() != null) {
                this.os.print("    WRITE-SYNTAX    ");
                this.printType(snmpCompliance.getWriteSyntax(), "                    ", n);
                this.os.println();
            }
            if (snmpCompliance.getAccess() != null) {
                this.os.print("    MIN-ACCESS      ");
                this.os.println(snmpCompliance.getAccess());
            }
        }
        this.printDescription(snmpCompliance.getDescription());
    }

    private void printVariation(SnmpVariation snmpVariation, int n) {
        this.os.print("    VARIATION       ");
        this.printReferenceEntry(snmpVariation.getValue());
        this.os.println();
        if (snmpVariation.getSyntax() != null) {
            this.os.print("    SYNTAX          ");
            this.printType(snmpVariation.getSyntax(), "                    ", n);
            this.os.println();
        }
        if (snmpVariation.getWriteSyntax() != null) {
            this.os.print("    WRITE-SYNTAX    ");
            this.printType(snmpVariation.getWriteSyntax(), "                    ", n);
            this.os.println();
        }
        if (snmpVariation.getAccess() != null) {
            this.os.print("    ACCESS          ");
            this.os.println(snmpVariation.getAccess());
        }
        if (snmpVariation.getRequiredCells().size() > 0) {
            this.os.print("    CREATION-REQUIRES ");
            this.printReferenceList(snmpVariation.getRequiredCells(), "                     ");
            this.os.println();
        }
        if (snmpVariation.getDefaultValue() != null) {
            this.os.print("    DEFVAL          ");
            this.printReference(snmpVariation.getDefaultValue(), this.getSymbols(snmpVariation.getBaseSymbol()));
            this.os.println();
        }
        this.printDescription(snmpVariation.getDescription());
    }

    private void printDescription(String string) {
        if (string.length() < 50 && string.indexOf("\n") < 0) {
            this.os.print("    DESCRIPTION     ");
            this.os.print(this.getQuote(string));
        } else {
            this.os.println("    DESCRIPTION");
            this.printIndent("            ", this.getQuote(string));
        }
    }

    private void printTypeElements(ElementType[] elementTypeArray, String string, int n) {
        int n2;
        int n3 = 20;
        String string2 = string;
        for (n2 = 0; n2 < elementTypeArray.length; ++n2) {
            if (elementTypeArray[n2].getName().length() + 2 <= n3) continue;
            n3 = elementTypeArray[n2].getName().length() + 2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            string2 = string2 + " ";
        }
        for (n2 = 0; n2 < elementTypeArray.length; ++n2) {
            if (n2 > 0) {
                this.os.println(",");
            }
            this.printComment(elementTypeArray[n2].getComment(), string, true);
            this.os.print(string);
            this.os.print(elementTypeArray[n2].getName());
            for (int i = elementTypeArray[n2].getName().length(); i < n3; ++i) {
                this.os.print(" ");
            }
            this.printType(elementTypeArray[n2].getType(), string2, n);
        }
    }

    private void printConstraint(MibType mibType, String string) {
        StringType stringType;
        if (mibType instanceof IntegerType) {
            IntegerType integerType = (IntegerType)mibType;
            if (integerType.hasSymbols()) {
                this.os.println(" {");
                this.printEnumeration(integerType.getAllSymbols(), string + "    ");
                this.os.println();
                this.os.print(string);
                this.os.print("}");
            } else if (integerType.hasConstraint()) {
                this.os.print(" (");
                this.os.print(integerType.getConstraint());
                this.os.print(")");
            }
        } else if (mibType instanceof BitSetType) {
            BitSetType bitSetType = (BitSetType)mibType;
            if (bitSetType.hasSymbols()) {
                this.os.println(" {");
                this.printEnumeration(bitSetType.getAllSymbols(), string + "    ");
                this.os.println();
                this.os.print(string);
                this.os.print("}");
            } else if (bitSetType.hasConstraint()) {
                this.os.print(" (");
                this.os.print(bitSetType.getConstraint());
                this.os.print(")");
            }
        } else if (mibType instanceof StringType && (stringType = (StringType)mibType).hasConstraint()) {
            this.os.print(" (");
            this.os.print(stringType.getConstraint());
            this.os.print(")");
        }
    }

    private void printEnumeration(MibValueSymbol[] mibValueSymbolArray, String string) {
        for (int i = 0; i < mibValueSymbolArray.length; ++i) {
            if (i > 0) {
                this.os.println(",");
            }
            this.printComment(mibValueSymbolArray[i].getComment(), string, true);
            this.os.print(string);
            this.os.print(mibValueSymbolArray[i].getName());
            this.os.print("(");
            this.os.print(mibValueSymbolArray[i].getValue());
            this.os.print(")");
        }
    }

    private void printValue(MibValue mibValue) {
        if (mibValue instanceof ObjectIdentifierValue) {
            this.os.print("{ ");
            this.os.print(((ObjectIdentifierValue)mibValue).toAsn1String());
            this.os.print(" }");
        } else if (mibValue instanceof StringValue) {
            this.os.print(this.getQuote(mibValue.toString()));
        } else {
            this.os.print(mibValue.toString());
        }
    }

    private void printReference(Object object) {
        this.os.print("{ ");
        this.printReferenceEntry(object);
        this.os.print(" }");
    }

    private void printReference(Object object, MibValueSymbol[] mibValueSymbolArray) {
        if (object instanceof BitSetValue) {
            object = ((BitSetValue)object).toAsn1String(mibValueSymbolArray);
        } else if (mibValueSymbolArray != null) {
            for (int i = 0; i < mibValueSymbolArray.length; ++i) {
                if (!mibValueSymbolArray[i].getValue().equals(object)) continue;
                this.printReference(mibValueSymbolArray[i].getName());
                return;
            }
        }
        this.printReference(object);
    }

    private void printReferenceList(ArrayList arrayList, String string) {
        if (arrayList.size() == 1) {
            this.printReference(arrayList.get(0));
        } else {
            this.os.print("{");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0) {
                    this.os.print(",");
                }
                this.os.println();
                this.os.print(string);
                this.os.print("    ");
                this.printReferenceEntry(arrayList.get(i));
            }
            this.os.println();
            this.os.print(string);
            this.os.print("}");
        }
    }

    private void printReferenceEntry(Object object) {
        if (object instanceof SnmpIndex) {
            if (((SnmpIndex)object).isImplied()) {
                this.os.print("IMPLIED ");
            }
            this.printReferenceEntry(((SnmpIndex)object).getTypeOrValue());
        } else if (object instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue objectIdentifierValue = (ObjectIdentifierValue)object;
            if (objectIdentifierValue.getSymbol() != null) {
                this.os.print(objectIdentifierValue.getSymbol().getName());
            } else {
                this.os.print(objectIdentifierValue.toAsn1String());
            }
        } else if (object instanceof StringValue) {
            this.os.print(this.getQuote(object.toString()));
        } else {
            this.os.print(object.toString());
        }
    }

    private void printIndent(String string, String string2) {
        int n;
        if (this.margin > 0) {
            string2 = this.reflow(string2, this.margin - string.length());
        }
        while (string2 != null && (n = string2.indexOf(10)) >= 0) {
            if (n == 0) {
                this.os.println();
            } else {
                this.os.print(string);
                this.os.println(string2.substring(0, n));
            }
            string2 = string2.substring(n + 1);
        }
        if (string2 != null && string2.length() > 0) {
            this.os.print(string);
            this.os.print(string2);
        }
    }

    private String reflow(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        while (stringBuffer.length() > 0) {
            int n2 = stringBuffer.indexOf("\n");
            if (bl && n2 > 0) {
                bl = false;
                stringBuffer.setCharAt(n2, ' ');
                n2 = stringBuffer.indexOf("\n");
            }
            if (n2 == 0) {
                bl = false;
                stringBuffer2.append("\n");
            } else {
                int n3;
                if (n2 < 0) {
                    n2 = stringBuffer.length();
                }
                while (n2 > n && (n3 = stringBuffer.lastIndexOf(" ", n2 - 1)) >= 0) {
                    n2 = n3;
                    bl = true;
                }
                stringBuffer2.append(stringBuffer.substring(0, n2));
                stringBuffer2.append("\n");
            }
            if (n2 + 1 >= stringBuffer.length()) {
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.delete(0, n2 + 1);
        }
        return stringBuffer2.toString();
    }

    private Constraint getConstraint(MibType mibType) {
        if (mibType instanceof IntegerType) {
            return ((IntegerType)mibType).getConstraint();
        }
        if (mibType instanceof BitSetType) {
            return ((BitSetType)mibType).getConstraint();
        }
        if (mibType instanceof StringType) {
            return ((StringType)mibType).getConstraint();
        }
        if (mibType instanceof SnmpTextualConvention) {
            return this.getConstraint(((SnmpTextualConvention)mibType).getSyntax());
        }
        return null;
    }

    private MibValueSymbol[] getSymbols(Object object) {
        if (object instanceof IntegerType) {
            return ((IntegerType)object).getAllSymbols();
        }
        if (object instanceof BitSetType) {
            return ((BitSetType)object).getAllSymbols();
        }
        if (object instanceof SnmpTextualConvention) {
            return this.getSymbols(((SnmpTextualConvention)object).getSyntax());
        }
        if (object instanceof SnmpObjectType) {
            return this.getSymbols(((SnmpObjectType)object).getSyntax());
        }
        if (object instanceof MibValueSymbol) {
            return this.getSymbols(((MibValueSymbol)object).getType());
        }
        return null;
    }

    private String getQuote(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                stringBuffer.append("\"\"");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

