/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValueSymbol;

public abstract class MibValue
implements Comparable {
    private String name;
    private MibValueSymbol reference = null;

    protected MibValue(String string) {
        this.name = string;
    }

    public abstract MibValue initialize(MibLoaderLog var1, MibType var2) throws MibException;

    public MibValue createReference() throws UnsupportedOperationException {
        String string = this.name + " value cannot be referenced";
        throw new UnsupportedOperationException(string);
    }

    protected void clear() {
        this.reference = null;
    }

    public boolean isReferenceTo(String string) {
        if (this.reference == null) {
            return false;
        }
        if (this.reference.getName().equals(string)) {
            return true;
        }
        return this.reference.getValue().isReferenceTo(string);
    }

    public boolean isReferenceTo(String string, String string2) {
        if (this.reference == null) {
            return false;
        }
        Mib mib = this.reference.getMib();
        if (mib.getName().equals(string) && this.reference.getName().equals(string2)) {
            return true;
        }
        return this.reference.getValue().isReferenceTo(string, string2);
    }

    public String getName() {
        return this.name;
    }

    public MibValueSymbol getReferenceSymbol() {
        return this.reference;
    }

    public void setReferenceSymbol(MibValueSymbol mibValueSymbol) {
        this.reference = mibValueSymbol;
    }

    public abstract Object toObject();
}

