/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.type.Constraint;

public abstract class MibType {
    private String name;
    private boolean primitive;
    private MibTypeTag tag = null;
    private MibTypeSymbol reference = null;
    private String comment = null;

    protected MibType(String string, boolean bl) {
        this.name = string;
        this.primitive = bl;
    }

    public abstract MibType initialize(MibSymbol var1, MibLoaderLog var2) throws MibException;

    public MibType createReference() throws UnsupportedOperationException {
        String string = this.name + " type cannot be referenced";
        throw new UnsupportedOperationException(string);
    }

    public MibType createReference(Constraint constraint) throws UnsupportedOperationException {
        String string = this.name + " type cannot be referenced with constraints";
        throw new UnsupportedOperationException(string);
    }

    public MibType createReference(ArrayList arrayList) throws UnsupportedOperationException {
        String string = this.name + " type cannot be referenced with " + "defined values";
        throw new UnsupportedOperationException(string);
    }

    public abstract boolean isCompatible(MibValue var1);

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean hasTag(MibTypeTag mibTypeTag) {
        return this.hasTag(mibTypeTag.getCategory(), mibTypeTag.getValue());
    }

    public boolean hasTag(int n, int n2) {
        for (MibTypeTag mibTypeTag = this.getTag(); mibTypeTag != null; mibTypeTag = mibTypeTag.getNext()) {
            if (!mibTypeTag.equals(n, n2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReferenceTo(String string) {
        if (this.reference == null) {
            return false;
        }
        if (this.reference.getName().equals(string)) {
            return true;
        }
        return this.reference.getType().hasReferenceTo(string);
    }

    public boolean hasReferenceTo(String string, String string2) {
        if (this.reference == null) {
            return false;
        }
        Mib mib = this.reference.getMib();
        if (mib.getName().equals(string) && this.reference.getName().equals(string2)) {
            return true;
        }
        return this.reference.getType().hasReferenceTo(string, string2);
    }

    public String getName() {
        return this.name;
    }

    public MibTypeTag getTag() {
        return this.tag;
    }

    public void setTag(boolean bl, MibTypeTag mibTypeTag) {
        MibTypeTag mibTypeTag2 = this.tag;
        if (bl && mibTypeTag2 != null) {
            mibTypeTag2 = mibTypeTag2.getNext();
        }
        if (mibTypeTag != null) {
            mibTypeTag.setNext(mibTypeTag2);
        }
        this.tag = mibTypeTag;
    }

    public MibTypeSymbol getReferenceSymbol() {
        return this.reference;
    }

    public void setReferenceSymbol(MibTypeSymbol mibTypeSymbol) {
        this.reference = mibTypeSymbol;
    }

    public String getComment() {
        return this.comment;
    }

    void setComment(String string) {
        this.comment = string;
    }

    public String toString() {
        if (this.tag != null) {
            return this.tag.toString() + " " + this.name;
        }
        return this.name;
    }
}

