/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.FileLocation;

public class MibLoaderLog {
    private ArrayList entries = new ArrayList();
    private int errors = 0;
    private int warnings = 0;

    public int errorCount() {
        return this.errors;
    }

    public int warningCount() {
        return this.warnings;
    }

    public void add(LogEntry logEntry) {
        if (logEntry.isError()) {
            ++this.errors;
        }
        if (logEntry.isWarning()) {
            ++this.warnings;
        }
        this.entries.add(logEntry);
    }

    public void addInternalError(FileLocation fileLocation, String string) {
        this.add(new LogEntry(1, fileLocation, string));
    }

    public void addInternalError(File file, String string) {
        this.addInternalError(new FileLocation(file), string);
    }

    public void addError(FileLocation fileLocation, String string) {
        this.add(new LogEntry(2, fileLocation, string));
    }

    public void addError(File file, int n, int n2, String string) {
        this.addError(new FileLocation(file, n, n2), string);
    }

    public void addWarning(FileLocation fileLocation, String string) {
        this.add(new LogEntry(3, fileLocation, string));
    }

    public void addWarning(File file, int n, int n2, String string) {
        this.addWarning(new FileLocation(file, n, n2), string);
    }

    public void addAll(MibLoaderLog mibLoaderLog) {
        for (int i = 0; i < mibLoaderLog.entries.size(); ++i) {
            this.add((LogEntry)mibLoaderLog.entries.get(i));
        }
    }

    void addAll(File file, ParserLogException parserLogException) {
        for (int i = 0; i < parserLogException.getErrorCount(); ++i) {
            ParseException parseException = parserLogException.getError(i);
            this.addError(file, parseException.getLine(), parseException.getColumn(), parseException.getErrorMessage());
        }
    }

    public Iterator entries() {
        return this.entries.iterator();
    }

    public void printTo(PrintStream printStream) {
        this.printTo(new PrintWriter(printStream));
    }

    public void printTo(PrintStream printStream, boolean bl) {
        this.printTo(new PrintWriter(printStream), bl);
    }

    public void printTo(PrintWriter printWriter) {
        this.printTo(printWriter, 70, false);
    }

    public void printTo(PrintWriter printWriter, boolean bl) {
        this.printTo(printWriter, 70, bl);
    }

    public void printTo(PrintWriter printWriter, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.entries.size(); ++i) {
            LogEntry logEntry = (LogEntry)this.entries.get(i);
            if (bl && logEntry.isWarning()) continue;
            stringBuffer.setLength(0);
            switch (logEntry.getType()) {
                case 2: {
                    stringBuffer.append("Error: ");
                    break;
                }
                case 3: {
                    stringBuffer.append("Warning: ");
                    break;
                }
                default: {
                    stringBuffer.append("Internal Error: ");
                }
            }
            stringBuffer.append("in ");
            stringBuffer.append(this.relativeFilename(logEntry.getFile()));
            if (logEntry.getLineNumber() > 0) {
                stringBuffer.append(": line ");
                stringBuffer.append(logEntry.getLineNumber());
            }
            stringBuffer.append(":\n");
            String string = this.linebreakString(logEntry.getMessage(), "    ", n);
            stringBuffer.append(string);
            string = logEntry.readLine();
            if (string != null && string.length() >= logEntry.getColumnNumber()) {
                stringBuffer.append("\n\n");
                stringBuffer.append(string);
                stringBuffer.append("\n");
                for (int j = 1; j < logEntry.getColumnNumber(); ++j) {
                    if (string.charAt(j - 1) == '\t') {
                        stringBuffer.append("\t");
                        continue;
                    }
                    stringBuffer.append(" ");
                }
                stringBuffer.append("^");
            }
            printWriter.println(stringBuffer.toString());
        }
        printWriter.flush();
    }

    private String relativeFilename(File file) {
        if (file == null) {
            return "<unknown file>";
        }
        try {
            String string = new File(".").getCanonicalPath();
            String string2 = file.getCanonicalPath();
            if (string2.startsWith(string)) {
                if ((string2 = string2.substring(string.length())).charAt(0) == '/' || string2.charAt(0) == '\\') {
                    return string2.substring(1);
                }
                return string2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.toString();
    }

    private String linebreakString(String string, String string2, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        while (string.length() + string2.length() > n && ((n2 = string.lastIndexOf(32, n - string2.length())) >= 0 || (n2 = string.indexOf(32)) >= 0)) {
            stringBuffer.append(string2);
            stringBuffer.append(string.substring(0, n2));
            string = string.substring(n2 + 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public class LogEntry {
        public static final int INTERNAL_ERROR = 1;
        public static final int ERROR = 2;
        public static final int WARNING = 3;
        private int type;
        private FileLocation location;
        private String message;

        public LogEntry(int n, FileLocation fileLocation, String string) {
            this.type = n;
            this.location = fileLocation == null || fileLocation.getFile() == null ? new FileLocation(new File("<unknown file>")) : fileLocation;
            this.message = string;
        }

        public boolean isError() {
            return this.type == 1 || this.type == 2;
        }

        public boolean isWarning() {
            return this.type == 3;
        }

        public int getType() {
            return this.type;
        }

        public File getFile() {
            return this.location.getFile();
        }

        public int getLineNumber() {
            return this.location.getLineNumber();
        }

        public int getColumnNumber() {
            return this.location.getColumnNumber();
        }

        public String getMessage() {
            return this.message;
        }

        public String readLine() {
            return this.location.readLine();
        }
    }
}

