/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ParserLogException;
import net.percederberg.mibble.DefaultContext;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibAnalyzer;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibDirectoryCache;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.asn1.Asn1Parser;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibLoader {
    private ArrayList dirCaches = new ArrayList();
    private ArrayList resources = new ArrayList();
    private ArrayList mibs = new ArrayList();
    private ArrayList queue = new ArrayList();
    private DefaultContext context = new DefaultContext();

    public MibLoader() {
        this.addResourceDir("mibs/iana");
        this.addResourceDir("mibs/ietf");
    }

    public boolean hasDir(File file) {
        if (file == null) {
            file = new File(".");
        } else if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        for (int i = 0; i < this.dirCaches.size(); ++i) {
            MibDirectoryCache mibDirectoryCache = (MibDirectoryCache)this.dirCaches.get(i);
            if (!mibDirectoryCache.getDir().equals(file)) continue;
            return true;
        }
        return false;
    }

    public File[] getDirs() {
        File[] fileArray = new File[this.dirCaches.size()];
        for (int i = 0; i < this.dirCaches.size(); ++i) {
            MibDirectoryCache mibDirectoryCache = (MibDirectoryCache)this.dirCaches.get(i);
            fileArray[i] = mibDirectoryCache.getDir();
        }
        return fileArray;
    }

    public void addDir(File file) {
        if (file == null) {
            file = new File(".");
        }
        if (!this.hasDir(file)) {
            this.dirCaches.add(new MibDirectoryCache(file));
        }
    }

    public void addDirs(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            this.addDir(fileArray[i]);
        }
    }

    public void addAllDirs(File file) {
        if (file == null) {
            file = new File(".");
        }
        this.addDir(file);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            this.addAllDirs(fileArray[i]);
        }
    }

    public void removeDir(File file) {
        for (int i = 0; i < this.dirCaches.size(); ++i) {
            MibDirectoryCache mibDirectoryCache = (MibDirectoryCache)this.dirCaches.get(i);
            if (!mibDirectoryCache.getDir().equals(file)) continue;
            this.dirCaches.remove(i--);
        }
    }

    public void removeAllDirs() {
        this.dirCaches.clear();
    }

    public boolean hasResourceDir(String string) {
        return this.resources.contains(string);
    }

    public String[] getResourceDirs() {
        return this.resources.toArray(new String[this.resources.size()]);
    }

    public void addResourceDir(String string) {
        if (!this.hasResourceDir(string)) {
            this.resources.add(string);
        }
    }

    public void removeResourceDir(String string) {
        this.resources.remove(string);
    }

    public void removeAllResourceDirs() {
        this.resources.clear();
    }

    public void reset() {
        this.mibs.clear();
        this.queue.clear();
        this.context = new DefaultContext();
    }

    public MibContext getDefaultContext() {
        return this.context;
    }

    public ObjectIdentifierValue getRootOid() {
        MibSymbol mibSymbol = this.context.findSymbol("iso", false);
        MibValue mibValue = ((MibValueSymbol)mibSymbol).getValue();
        return (ObjectIdentifierValue)mibValue;
    }

    public Mib getMib(String string) {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(string)) continue;
            return mib;
        }
        return null;
    }

    public Mib getMib(File file) {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(file)) continue;
            return mib;
        }
        return null;
    }

    public Mib[] getAllMibs() {
        Mib[] mibArray = new Mib[this.mibs.size()];
        this.mibs.toArray(mibArray);
        return mibArray;
    }

    public Mib load(String string) throws IOException, MibLoaderException {
        Mib mib = this.getMib(string);
        if (mib == null) {
            MibSource mibSource = this.locate(string);
            if (mibSource == null) {
                throw new FileNotFoundException("couldn't locate MIB: '" + string + "'");
            }
            mib = this.load(mibSource);
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(File file) throws IOException, MibLoaderException {
        Mib mib = this.getMib(file);
        if (mib == null) {
            mib = this.load(new MibSource(file));
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(URL uRL) throws IOException, MibLoaderException {
        return this.load(new MibSource(uRL));
    }

    public Mib load(Reader reader) throws IOException, MibLoaderException {
        return this.load(new MibSource(reader));
    }

    private Mib load(MibSource mibSource) throws IOException, MibLoaderException {
        int n = this.mibs.size();
        this.queue.clear();
        this.queue.add(mibSource);
        MibLoaderLog mibLoaderLog = this.loadQueue();
        if (mibLoaderLog.errorCount() > 0) {
            throw new MibLoaderException(mibLoaderLog);
        }
        return (Mib)this.mibs.get(n);
    }

    public void unload(String string) throws MibLoaderException {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(string)) continue;
            this.unload(mib);
            return;
        }
    }

    public void unload(File file) throws MibLoaderException {
        for (int i = 0; i < this.mibs.size(); ++i) {
            Mib mib = (Mib)this.mibs.get(i);
            if (!mib.equals(file)) continue;
            this.unload(mib);
            return;
        }
    }

    public void unload(Mib mib) throws MibLoaderException {
        int n = this.mibs.indexOf(mib);
        if (n >= 0) {
            Mib[] mibArray = mib.getImportingMibs();
            if (mibArray.length > 0) {
                String string = "cannot be unloaded due to reference in " + mibArray[0];
                throw new MibLoaderException(mib.getFile(), string);
            }
            mib = (Mib)this.mibs.remove(n);
            mib.clear();
        }
    }

    public void unloadAll() {
        for (int i = 0; i < this.mibs.size(); ++i) {
            ((Mib)this.mibs.get(i)).clear();
        }
        this.reset();
    }

    void scheduleLoad(String string) {
        if (this.getMib(string) == null && !this.queue.contains(string)) {
            this.queue.add(string);
        }
    }

    private MibLoaderLog loadQueue() throws IOException {
        int n;
        MibLoaderLog mibLoaderLog = new MibLoaderLog();
        ArrayList arrayList = new ArrayList();
        while (this.queue.size() > 0) {
            try {
                MibSource mibSource;
                boolean bl = false;
                Object e = this.queue.get(0);
                if (e instanceof MibSource) {
                    bl = true;
                    mibSource = (MibSource)e;
                } else {
                    mibSource = this.getMib((String)e) == null ? this.locate((String)e) : null;
                }
                if (mibSource != null && this.getMib(mibSource.getFile()) == null) {
                    ArrayList arrayList2 = mibSource.parseMib(this, mibLoaderLog);
                    for (n = 0; n < arrayList2.size(); ++n) {
                        ((Mib)arrayList2.get(n)).setLoaded(bl);
                    }
                    this.mibs.addAll(arrayList2);
                    arrayList.addAll(arrayList2);
                }
            }
            catch (MibLoaderException mibLoaderException) {
                // empty catch block
            }
            this.queue.remove(0);
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            try {
                ((Mib)arrayList.get(n)).initialize();
                continue;
            }
            catch (MibLoaderException mibLoaderException) {
                // empty catch block
            }
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            try {
                ((Mib)arrayList.get(n)).validate();
                continue;
            }
            catch (MibLoaderException mibLoaderException) {
                // empty catch block
            }
        }
        if (mibLoaderLog.errorCount() > 0) {
            this.mibs.removeAll(arrayList);
        }
        return mibLoaderLog;
    }

    private MibSource locate(String string) {
        File file;
        MibDirectoryCache mibDirectoryCache;
        int n;
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (n = 0; n < this.dirCaches.size(); ++n) {
            mibDirectoryCache = (MibDirectoryCache)this.dirCaches.get(n);
            file = mibDirectoryCache.findByName(string);
            if (file == null) continue;
            return new MibSource(file);
        }
        for (n = 0; n < this.resources.size(); ++n) {
            URL uRL = classLoader.getResource(this.resources.get(n) + "/" + string);
            if (uRL == null) continue;
            return new MibSource(string, uRL);
        }
        for (n = 0; n < this.dirCaches.size(); ++n) {
            mibDirectoryCache = (MibDirectoryCache)this.dirCaches.get(n);
            file = mibDirectoryCache.findByContent(string);
            if (file == null) continue;
            return new MibSource(file);
        }
        return null;
    }

    private static class MibSource {
        private static Asn1Parser parser = null;
        private File file = null;
        private URL url = null;
        private Reader input = null;

        public MibSource(File file) {
            this.file = file;
        }

        public MibSource(URL uRL) {
            this.url = uRL;
        }

        public MibSource(String string, URL uRL) {
            this(uRL);
            this.file = new File(string);
        }

        public MibSource(Reader reader) {
            this.input = reader;
        }

        public boolean equals(Object object) {
            if (object instanceof MibSource) {
                MibSource mibSource = (MibSource)object;
                if (this.url != null) {
                    return this.url.equals(mibSource.url);
                }
                if (this.file != null) {
                    return this.file.equals(mibSource.file);
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.url != null) {
                return this.url.hashCode();
            }
            if (this.file != null) {
                return this.file.hashCode();
            }
            return super.hashCode();
        }

        public File getFile() {
            return this.file;
        }

        public ArrayList parseMib(MibLoader mibLoader, MibLoaderLog mibLoaderLog) throws IOException, MibLoaderException {
            if (this.input == null) {
                this.input = this.url != null ? new InputStreamReader(this.url.openStream()) : new FileReader(this.file);
            }
            MibAnalyzer mibAnalyzer = new MibAnalyzer(this.file, mibLoader, mibLoaderLog);
            try {
                if (parser == null) {
                    parser = new Asn1Parser(this.input, mibAnalyzer);
                    parser.getTokenizer().setUseTokenList(true);
                } else {
                    parser.reset(this.input, mibAnalyzer);
                }
                parser.parse();
                ArrayList arrayList = mibAnalyzer.getMibs();
                return arrayList;
            }
            catch (ParserCreationException parserCreationException) {
                String string = "parser creation error in ASN.1 parser: " + parserCreationException.getMessage();
                mibLoaderLog.addInternalError(this.file, string);
                throw new MibLoaderException(mibLoaderLog);
            }
            catch (ParserLogException parserLogException) {
                mibLoaderLog.addAll(this.file, parserLogException);
                throw new MibLoaderException(mibLoaderLog);
            }
            finally {
                try {
                    this.input.close();
                }
                catch (Throwable throwable) {}
                mibAnalyzer.reset();
            }
        }
    }
}

