/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import java.util.Collection;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;

public class MibImport
implements MibContext {
    private MibLoader loader;
    private Mib mib = null;
    private FileLocation location;
    private String name;
    private ArrayList symbols;

    MibImport(MibLoader mibLoader, FileLocation fileLocation, String string, ArrayList arrayList) {
        this.loader = mibLoader;
        this.location = fileLocation;
        this.name = string;
        this.symbols = arrayList;
    }

    public void initialize(MibLoaderLog mibLoaderLog) throws MibException {
        this.mib = this.loader.getMib(this.name);
        if (this.mib == null) {
            String string = "couldn't find referenced MIB '" + this.name + "'";
            mibLoaderLog.addWarning(this.location, string);
            return;
        }
        if (this.symbols != null) {
            for (int i = 0; i < this.symbols.size(); ++i) {
                if (this.mib.getSymbol(this.symbols.get(i).toString()) != null) continue;
                String string = "couldn't find imported symbol '" + this.symbols.get(i) + "' in MIB '" + this.name + "'";
                mibLoaderLog.addWarning(this.location, string);
            }
        }
    }

    boolean hasSymbols() {
        return this.symbols != null;
    }

    public String getName() {
        return this.name;
    }

    public Mib getMib() {
        return this.mib;
    }

    public Collection getAllSymbolNames() {
        return this.symbols;
    }

    public MibSymbol findSymbol(String string, boolean bl) {
        if (this.mib == null) {
            return null;
        }
        if (!bl && this.symbols != null && !this.symbols.contains(string)) {
            return null;
        }
        return this.mib.getSymbol(string);
    }

    public String toString() {
        return this.name;
    }
}

