/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MibDirectoryCache {
    private static final Pattern NAME = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_]*");
    private File dir;
    private HashMap nameCache = null;
    private HashMap contentCache = null;

    public MibDirectoryCache(File file) {
        this.dir = file;
    }

    public File getDir() {
        return this.dir;
    }

    public File findByName(String string) {
        if (this.nameCache == null) {
            this.initNameCache();
        }
        return (File)this.nameCache.get(string.toUpperCase());
    }

    private void initNameCache() {
        File[] fileArray = this.dir.listFiles();
        this.nameCache = new HashMap();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            Matcher matcher = NAME.matcher(string);
            if (!matcher.lookingAt() || !fileArray[i].isFile()) continue;
            this.nameCache.put(matcher.group().toUpperCase(), fileArray[i]);
        }
    }

    public File findByContent(String string) {
        if (this.contentCache == null) {
            this.initContentCache();
        }
        return (File)this.contentCache.get(string);
    }

    private void initContentCache() {
        File[] fileArray = this.dir.listFiles();
        this.contentCache = new HashMap();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = this.readMibName(fileArray[i]);
            if (string == null) continue;
            this.contentCache.put(string, fileArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readMibName(File file) {
        block20: {
            BufferedReader bufferedReader = null;
            if (!file.canRead() || !file.isFile()) {
                return null;
            }
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(file));
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    break block20;
                } while ((string = string.trim()).equals("") || string.startsWith("--"));
                Matcher matcher = NAME.matcher(string);
                String string2 = matcher.lookingAt() ? matcher.group() : null;
                return string2;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }
}

