/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.ArrayList;
import java.util.HashMap;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

class MibAnalyzerUtil {
    private static HashMap commentTokens = new HashMap();

    MibAnalyzerUtil() {
    }

    static boolean isBitValue(Node node) {
        if (node.getId() == 1004) {
            return true;
        }
        if (node.getId() == 2079 && node.getChildCount() < 4) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!MibAnalyzerUtil.isBitValue(node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    static String getComments(Node node) {
        Token token;
        String string = "";
        String string2 = MibAnalyzerUtil.getCommentsBefore(node);
        if (string2 != null) {
            string = string2;
        }
        if ((string2 = MibAnalyzerUtil.getCommentsInside(node)) != null) {
            if (string.length() > 0) {
                string = string + "\n\n";
            }
            string = string + string2;
        }
        if ((token = MibAnalyzerUtil.getCommentTokenSameLine(node)) != null) {
            if (string.length() > 0) {
                string = string + "\n\n";
            }
            token = token.getPreviousToken();
            string = string + MibAnalyzerUtil.getCommentsAfter(token);
        }
        return string.length() <= 0 ? null : string;
    }

    static String getCommentsFooter(Node node) {
        String string = MibAnalyzerUtil.getCommentsAfter(node);
        commentTokens.clear();
        return string;
    }

    private static String getCommentsBefore(Node node) {
        Token token = MibAnalyzerUtil.getFirstToken(node);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        if (token != null) {
            token = token.getPreviousToken();
        }
        while (token != null) {
            if (token.getId() == 1106) {
                arrayList.add(MibAnalyzerUtil.getLineBreaks(token.getImage()));
            } else {
                if (token.getId() != 1107 || commentTokens.containsKey(token)) break;
                commentTokens.put(token, null);
                arrayList.add(token.getImage().substring(2).trim());
            }
            token = token.getPreviousToken();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            stringBuffer.append(arrayList.get(i));
        }
        string = stringBuffer.toString().trim();
        return string.length() <= 0 ? null : string;
    }

    private static String getCommentsAfter(Node node) {
        String string;
        Token token = MibAnalyzerUtil.getLastToken(node);
        StringBuffer stringBuffer = new StringBuffer();
        if (token != null) {
            token = token.getNextToken();
        }
        while (token != null) {
            if (token.getId() == 1106) {
                stringBuffer.append(MibAnalyzerUtil.getLineBreaks(token.getImage()));
            } else {
                if (token.getId() != 1107 || commentTokens.containsKey(token)) break;
                commentTokens.put(token, null);
                stringBuffer.append(token.getImage().substring(2).trim());
            }
            token = token.getNextToken();
        }
        return (string = stringBuffer.toString().trim()).length() <= 0 ? null : string;
    }

    private static String getCommentsInside(Node node) {
        Token token = MibAnalyzerUtil.getLastToken(node);
        StringBuffer stringBuffer = new StringBuffer();
        for (Token token2 = MibAnalyzerUtil.getFirstToken(node); token2 != null && token2 != token; token2 = token2.getNextToken()) {
            if (token2.getId() != 1107 || commentTokens.containsKey(token2)) continue;
            commentTokens.put(token2, null);
            stringBuffer.append(token2.getImage().substring(2).trim());
            stringBuffer.append("\n");
        }
        String string = stringBuffer.toString().trim();
        return string.length() <= 0 ? null : string;
    }

    private static Token getCommentTokenSameLine(Node node) {
        Token token = MibAnalyzerUtil.getLastToken(node);
        if (token == null) {
            return null;
        }
        block4: for (Token token2 = token.getNextToken(); token2 != null; token2 = token2.getNextToken()) {
            switch (token2.getId()) {
                case 1004: 
                case 1106: {
                    continue block4;
                }
                case 1107: {
                    if (token.getEndLine() == token2.getStartLine()) {
                        return token2;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static Token getFirstToken(Node node) {
        while (node instanceof Production) {
            node = node.getChildAt(0);
        }
        return (Token)node;
    }

    private static Token getLastToken(Node node) {
        while (node instanceof Production) {
            node = node.getChildAt(node.getChildCount() - 1);
        }
        return (Token)node;
    }

    private static String getLineBreaks(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\n') continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }
}

