/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.mibble.CompoundContext;
import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibAnalyzerUtil;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibMacroSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeContext;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibTypeTag;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.NamedNumber;
import net.percederberg.mibble.asn1.Asn1Analyzer;
import net.percederberg.mibble.snmp.SnmpAccess;
import net.percederberg.mibble.snmp.SnmpAgentCapabilities;
import net.percederberg.mibble.snmp.SnmpCompliance;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpModuleCompliance;
import net.percederberg.mibble.snmp.SnmpModuleIdentity;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpNotificationGroup;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectGroup;
import net.percederberg.mibble.snmp.SnmpObjectIdentity;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpVariation;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.BooleanType;
import net.percederberg.mibble.type.ChoiceType;
import net.percederberg.mibble.type.CompoundConstraint;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.NullType;
import net.percederberg.mibble.type.ObjectIdentifierType;
import net.percederberg.mibble.type.RealType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.SizeConstraint;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.type.TypeReference;
import net.percederberg.mibble.type.ValueConstraint;
import net.percederberg.mibble.type.ValueRangeConstraint;
import net.percederberg.mibble.value.BinaryNumberValue;
import net.percederberg.mibble.value.BitSetValue;
import net.percederberg.mibble.value.BooleanValue;
import net.percederberg.mibble.value.HexNumberValue;
import net.percederberg.mibble.value.NullValue;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import net.percederberg.mibble.value.StringValue;
import net.percederberg.mibble.value.ValueReference;

class MibAnalyzer
extends Asn1Analyzer {
    private ArrayList mibs = new ArrayList();
    private File file;
    private MibLoader loader;
    private MibLoaderLog log;
    private Mib currentMib = null;
    private MibContext baseContext = null;
    private ArrayList contextStack = new ArrayList();
    private boolean implicitTags = true;
    boolean impVerified = false;

    public MibAnalyzer(File file, MibLoader mibLoader, MibLoaderLog mibLoaderLog) {
        this.file = file;
        this.loader = mibLoader;
        this.log = mibLoaderLog;
    }

    public void reset() {
        this.mibs = new ArrayList();
        this.currentMib = null;
        this.baseContext = null;
        this.contextStack.clear();
        this.implicitTags = true;
    }

    public ArrayList getMibs() {
        return this.mibs;
    }

    protected Node exitBinaryString(Token token) {
        String string = token.getImage();
        Number number = (string = string.substring(1, string.length() - 2)).length() == 0 ? (Number)new Integer(0) : (Number)(string.length() < 32 ? (Number)new Integer(Integer.parseInt(string, 2)) : (Number)(string.length() < 64 ? new Long(Long.parseLong(string, 2)) : new BigInteger(string, 2)));
        token.addValue(number);
        token.addValue(string);
        return token;
    }

    protected Node exitHexadecimalString(Token token) {
        String string = token.getImage();
        Number number = (string = string.substring(1, string.length() - 2)).length() == 0 ? (Number)new Integer(0) : (Number)(string.length() < 8 ? (Number)new Integer(Integer.parseInt(string, 16)) : (Number)(string.length() < 16 ? new Long(Long.parseLong(string, 16)) : new BigInteger(string, 16)));
        token.addValue(number);
        token.addValue(string);
        return token;
    }

    protected Node exitQuotedString(Token token) {
        int n;
        String string = token.getImage();
        string = string.substring(1, string.length() - 1);
        do {
            if ((n = string.indexOf("\"\"")) < 0) continue;
            string = string.substring(0, n) + '\"' + string.substring(n + 2);
        } while (n >= 0);
        token.addValue(string);
        return token;
    }

    protected Node exitIdentifierString(Token token) {
        token.addValue(token.getImage());
        return token;
    }

    protected Node exitNumberString(Token token) {
        String string = token.getImage();
        Number number = string.length() < 10 ? (Number)new Integer(string) : (Number)(string.length() < 19 ? new Long(string) : new BigInteger(string));
        token.addValue(number);
        return token;
    }

    protected Node exitStart(Production production) {
        String string = MibAnalyzerUtil.getCommentsFooter(production);
        if (this.currentMib != null) {
            this.currentMib.setFooterComment(string);
        }
        return null;
    }

    protected void enterModuleDefinition(Production production) {
        this.currentMib = new Mib(this.file, this.loader, this.log);
        this.baseContext = this.loader.getDefaultContext();
        this.baseContext = new CompoundContext(this.currentMib, this.baseContext);
        this.pushContext(this.baseContext);
    }

    protected Node exitModuleDefinition(Production production) throws ParseException {
        this.currentMib.setName(this.getStringValue(this.getChildAt(production, 0), 0));
        this.currentMib.setHeaderComment(MibAnalyzerUtil.getComments(production));
        this.mibs.add(this.currentMib);
        return production;
    }

    protected void enterAssignmentList(Production production) throws ParseException {
        this.verifyImports();
    }

    private void verifyImports() {
        MibImport mibImport;
        if (this.impVerified) {
            return;
        }
        this.impVerified = true;
        ArrayList arrayList = (ArrayList)this.currentMib.getAllImports();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            mibImport = (MibImport)arrayList.get(i);
            if (mibImport.getName().startsWith("RFC1065-SMI") || mibImport.getName().startsWith("RFC1155-SMI")) {
                bl = false;
            }
            if (mibImport.getName().startsWith("SNMPv2-SMI")) {
                bl2 = false;
            }
            if (!mibImport.getName().startsWith("SNMPv2-TC")) continue;
            bl3 = false;
        }
        FileLocation fileLocation = new FileLocation(null);
        if (bl) {
            mibImport = new MibImport(this.loader, fileLocation, "RFC1155-SMI", new ArrayList());
            this.loader.scheduleLoad(mibImport.getName());
            this.currentMib.addImport(mibImport);
            arrayList.add(mibImport);
        }
        if (bl2) {
            mibImport = new MibImport(this.loader, fileLocation, "SNMPv2-SMI", new ArrayList());
            this.loader.scheduleLoad(mibImport.getName());
            this.currentMib.addImport(mibImport);
            arrayList.add(mibImport);
        }
        if (bl3) {
            mibImport = new MibImport(this.loader, fileLocation, "SNMPv2-TC", new ArrayList());
            this.loader.scheduleLoad(mibImport.getName());
            this.currentMib.addImport(mibImport);
            arrayList.add(mibImport);
        }
        mibImport = new MibImport(this.loader, fileLocation, "SNMPTridFix", new ArrayList());
        this.loader.scheduleLoad(mibImport.getName());
        this.currentMib.addImport(mibImport);
        arrayList.add(mibImport);
        MibContext mibContext = this.loader.getDefaultContext();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            mibImport = (MibImport)arrayList.get(i);
            mibContext = new CompoundContext(mibImport, mibContext);
        }
        this.baseContext = new CompoundContext(this.currentMib, mibContext);
        this.popContext();
        this.pushContext(this.baseContext);
    }

    protected Node exitModuleIdentifier(Production production) throws ParseException {
        production.addValue(this.getStringValue(this.getChildAt(production, 0), 0));
        return production;
    }

    protected Node exitModuleReference(Production production) throws ParseException {
        production.addValue(this.getStringValue(this.getChildAt(production, 0), 0));
        return production;
    }

    protected Node exitTagDefault(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        this.implicitTags = node.getId() != 1017;
        return null;
    }

    protected Node exitImportList(Production production) {
        this.verifyImports();
        return null;
    }

    protected Node exitSymbolsFromModule(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        ArrayList arrayList = node.getAllValues();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        node = this.getChildAt(production, 2);
        String string = this.getStringValue(node, 0);
        MibImport mibImport = new MibImport(this.loader, this.getLocation(node), string, arrayList);
        this.loader.scheduleLoad(string);
        this.currentMib.addImport(mibImport);
        production.addValue(mibImport);
        return production;
    }

    protected Node exitSymbolList(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSymbol(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitMacroDefinition(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        if (this.currentMib.getSymbol(string) != null) {
            System.out.println("MacroDefinition error : a symbol '" + string + "' already present in the MIB " + production.getStartLine() + "/" + production.getStartColumn());
            this.log.addWarning(this.getLocation(production), "a symbol '" + string + "' already present in the MIB ");
            return null;
        }
        MibMacroSymbol mibMacroSymbol = new MibMacroSymbol(this.getLocation(production), this.currentMib, string);
        mibMacroSymbol.setComment(MibAnalyzerUtil.getComments(production));
        return null;
    }

    protected Node exitMacroReference(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitTypeAssignment(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        if (this.currentMib.getSymbol(string) != null) {
            System.out.println("TypeAssignment error : a symbol '" + string + "' already present in the MIB " + production.getStartLine() + "/" + production.getStartColumn());
            this.log.addWarning(this.getLocation(production), "a symbol '" + string + "' already present in the MIB ");
            return null;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            this.log.addWarning(this.getLocation(production), "type identifier '" + string + "' doesn't " + "start with an uppercase character");
        }
        MibType mibType = (MibType)this.getValue(this.getChildAt(production, 2), 0);
        MibTypeSymbol mibTypeSymbol = new MibTypeSymbol(this.getLocation(production), this.currentMib, string, mibType);
        mibTypeSymbol.setComment(MibAnalyzerUtil.getComments(production));
        return null;
    }

    protected Node exitType(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitDefinedType(Production production) throws ParseException {
        MibContext mibContext = this.getContext();
        String string = null;
        Object object = null;
        FileLocation fileLocation = this.getLocation(production);
        block5: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2004: {
                    string = this.getStringValue(node, 0);
                    mibContext = this.currentMib.getImport(string);
                    if (mibContext != null) continue block5;
                    throw new ParseException(6, "referenced module not imported '" + string + "'", node.getStartLine(), node.getStartColumn());
                }
                case 1104: {
                    string = this.getStringValue(node, 0);
                    continue block5;
                }
                case 2045: {
                    object = this.getValue(node, 0);
                }
            }
        }
        object = object instanceof Constraint ? new TypeReference(fileLocation, mibContext, string, (Constraint)object) : (object instanceof ArrayList ? new TypeReference(fileLocation, mibContext, string, (ArrayList)object) : new TypeReference(fileLocation, mibContext, string));
        production.addValue(object);
        return production;
    }

    protected Node exitBuiltinType(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitNullType(Production production) {
        production.addValue(new NullType());
        return production;
    }

    protected Node exitBooleanType(Production production) {
        production.addValue(new BooleanType());
        return production;
    }

    protected Node exitRealType(Production production) {
        production.addValue(new RealType());
        return production;
    }

    protected Node exitIntegerType(Production production) {
        Object e;
        ArrayList arrayList = this.getChildValues(production);
        IntegerType integerType = arrayList.size() == 0 ? new IntegerType() : ((e = arrayList.get(0)) instanceof ArrayList ? new IntegerType((ArrayList)e) : new IntegerType((Constraint)e));
        production.addValue(integerType);
        return production;
    }

    protected Node exitObjectIdentifierType(Production production) {
        production.addValue(new ObjectIdentifierType());
        return production;
    }

    protected Node exitStringType(Production production) {
        ArrayList arrayList = this.getChildValues(production);
        StringType stringType = arrayList.size() == 0 ? new StringType() : new StringType((Constraint)arrayList.get(0));
        production.addValue(stringType);
        return production;
    }

    protected Node exitBitStringType(Production production) {
        Object e;
        ArrayList arrayList = this.getChildValues(production);
        BitSetType bitSetType = arrayList.size() == 0 ? new BitSetType() : ((e = arrayList.get(0)) instanceof ArrayList ? new BitSetType((ArrayList)e) : new BitSetType((Constraint)e));
        production.addValue(bitSetType);
        return production;
    }

    protected Node exitBitsType(Production production) {
        return this.exitBitStringType(production);
    }

    protected Node exitSequenceType(Production production) {
        ArrayList arrayList = this.getChildValues(production);
        production.addValue(new SequenceType(arrayList));
        return production;
    }

    protected Node exitSequenceOfType(Production production) throws ParseException {
        Constraint constraint = null;
        Node node = this.getChildAt(production, production.getChildCount() - 1);
        MibType mibType = (MibType)this.getValue(node, 0);
        if (production.getChildCount() == 4) {
            node = this.getChildAt(production, 1);
            constraint = (Constraint)this.getValue(node, 0);
        }
        production.addValue(new SequenceOfType(mibType, constraint));
        return production;
    }

    protected Node exitSetType(Production production) {
        this.log.addError(this.getLocation(production), "SET type currently unsupported");
        production.addValue(new NullType());
        return production;
    }

    protected Node exitSetOfType(Production production) {
        this.log.addError(this.getLocation(production), "SET OF type currently unsupported");
        production.addValue(new NullType());
        return production;
    }

    protected Node exitChoiceType(Production production) {
        production.addValue(new ChoiceType(this.getChildValues(production)));
        return production;
    }

    protected Node exitEnumeratedType(Production production) {
        this.log.addError(this.getLocation(production), "ENUMERATED type currently unsupported");
        production.addValue(new NullType());
        return production;
    }

    protected Node exitSelectionType(Production production) {
        this.log.addError(this.getLocation(production), "selection type currently unsupported");
        production.addValue(new NullType());
        return production;
    }

    protected Node exitTaggedType(Production production) throws ParseException {
        boolean bl = this.implicitTags;
        Node node = this.getChildAt(production, 0);
        MibTypeTag mibTypeTag = (MibTypeTag)this.getValue(node, 0);
        node = this.getChildAt(production, 1);
        if (node.getId() == 2040) {
            bl = (Boolean)this.getValue(node, 0);
        }
        node = this.getChildAt(production, production.getChildCount() - 1);
        MibType mibType = (MibType)this.getValue(node, 0);
        mibType.setTag(bl, mibTypeTag);
        production.addValue(mibType);
        return production;
    }

    protected Node exitTag(Production production) {
        int n;
        ArrayList arrayList = this.getChildValues(production);
        int n2 = 2;
        if (arrayList.size() == 1) {
            n = ((Number)arrayList.get(0)).intValue();
        } else {
            n2 = (Integer)arrayList.get(0);
            n = ((Number)arrayList.get(1)).intValue();
        }
        production.addValue(new MibTypeTag(n2, n));
        return production;
    }

    protected Node exitClass(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        int n = node.getId() == 1038 ? 0 : (node.getId() == 1039 ? 1 : (node.getId() == 1040 ? 3 : 2));
        production.addValue(new Integer(n));
        return production;
    }

    protected Node exitExplicitOrImplicitTag(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        if (node.getId() == 1017) {
            production.addValue(Boolean.FALSE);
        } else {
            production.addValue(Boolean.TRUE);
        }
        return production;
    }

    protected Node exitAnyType(Production production) {
        this.log.addError(this.getLocation(production), "ANY type currently unsupported");
        production.addValue(new NullType());
        return production;
    }

    protected Node exitElementTypeList(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitElementType(Production production) throws ParseException {
        String string = null;
        Node node = this.getChildAt(production, 0);
        if (node.getId() == 1104) {
            string = this.getStringValue(node, 0);
            node = this.getChildAt(production, 1);
        }
        if (node.getId() != 2019) {
            throw new ParseException(6, "referencing components is currently unsupported", node.getStartLine(), node.getStartColumn());
        }
        ElementType elementType = new ElementType(string, (MibType)this.getValue(node, 0));
        elementType.setComment(MibAnalyzerUtil.getComments(production));
        production.addValue(elementType);
        return production;
    }

    protected Node exitOptionalOrDefaultElement(Production production) {
        this.log.addError(this.getLocation(production), "optional and default elements are currently unsupported");
        return null;
    }

    protected Node exitValueOrConstraintList(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitNamedNumberList(Production production) {
        for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            if (node.getId() != 2047) continue;
            MibValueSymbol mibValueSymbol = (MibValueSymbol)node.getValue(0);
            mibValueSymbol.setComment(MibAnalyzerUtil.getComments(node));
        }
        production.addValue(this.getChildValues(production));
        return production;
    }

    protected Node exitNamedNumber(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        MibValue mibValue = (MibValue)this.getValue(this.getChildAt(production, 2), 0);
        MibValueSymbol mibValueSymbol = new MibValueSymbol(this.getLocation(production), null, string, null, mibValue);
        production.addValue(mibValueSymbol);
        return production;
    }

    protected Node exitNumber(Production production) throws ParseException {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitConstraintList(Production production) {
        Constraint constraint = null;
        ArrayList arrayList = this.getChildValues(production);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Constraint constraint2 = (Constraint)arrayList.get(i);
            constraint = constraint == null ? constraint2 : new CompoundConstraint(constraint2, constraint);
        }
        production.addValue(constraint);
        return production;
    }

    protected Node exitConstraint(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitValueConstraintList(Production production) {
        return this.exitConstraintList(production);
    }

    protected Node exitValueConstraint(Production production) throws ParseException {
        Object object;
        ArrayList arrayList = this.getChildValues(production);
        MibValue mibValue = null;
        MibValue mibValue2 = null;
        Boolean bl = null;
        Boolean bl2 = null;
        if (arrayList.size() == 0) {
            throw new ParseException(6, "no value specified in constraint", production.getStartLine(), production.getStartColumn());
        }
        if (arrayList.size() == 1) {
            mibValue = (MibValue)arrayList.get(0);
            object = new ValueConstraint(this.getLocation(production), mibValue);
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                object = arrayList.get(i);
                if (object instanceof Boolean && bl == null) {
                    bl = (Boolean)object;
                    continue;
                }
                if (object instanceof Boolean) {
                    bl2 = (Boolean)object;
                    continue;
                }
                if (bl == null) {
                    mibValue = (MibValue)object;
                    continue;
                }
                mibValue2 = (MibValue)object;
            }
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (bl2 == null) {
                bl2 = Boolean.FALSE;
            }
            object = new ValueRangeConstraint(this.getLocation(production), mibValue, bl, mibValue2, bl2);
        }
        production.addValue(object);
        return production;
    }

    protected Node exitValueRange(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        if (node.getId() == 1013) {
            production.addValue(Boolean.TRUE);
        } else {
            production.addValue(Boolean.FALSE);
        }
        node = this.getChildAt(production, production.getChildCount() - 1);
        production.addValue(node.getValue(0));
        node = this.getChildAt(production, production.getChildCount() - 2);
        if (node.getId() == 1013) {
            production.addValue(Boolean.TRUE);
        } else {
            production.addValue(Boolean.FALSE);
        }
        return production;
    }

    protected Node exitLowerEndPoint(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitUpperEndPoint(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSizeConstraint(Production production) throws ParseException {
        Constraint constraint = (Constraint)this.getValue(this.getChildAt(production, 1), 0);
        production.addValue(new SizeConstraint(this.getLocation(production), constraint));
        return production;
    }

    protected Node exitAlphabetConstraint(Production production) {
        this.log.addError(this.getLocation(production), "FROM constraints are currently unsupported");
        return null;
    }

    protected Node exitContainedTypeConstraint(Production production) {
        this.log.addError(this.getLocation(production), "INCLUDES constraints are currently unsupported");
        return null;
    }

    protected Node exitInnerTypeConstraint(Production production) {
        this.log.addError(this.getLocation(production), "WITH COMPONENT(S) constraints are currently unsupported");
        return null;
    }

    protected Node exitValueAssignment(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        if (this.currentMib.getSymbol(string) != null) {
            this.log.addWarning(this.getLocation(production), "a symbol '" + string + "' already present in the MIB at ln:" + production.getStartLine() + " col:" + production.getStartColumn());
            return null;
        }
        if (!Character.isLowerCase(string.charAt(0))) {
            this.log.addWarning(this.getLocation(production), "value identifier '" + string + "' doesn't " + "start with a lowercase character");
        }
        MibType mibType = (MibType)this.getValue(this.getChildAt(production, 1), 0);
        MibValue mibValue = (MibValue)this.getValue(this.getChildAt(production, 3), 0);
        MibValueSymbol mibValueSymbol = new MibValueSymbol(this.getLocation(production), this.currentMib, string, mibType, mibValue);
        mibValueSymbol.setComment(MibAnalyzerUtil.getComments(production));
        return null;
    }

    protected Node exitValue(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitDefinedValue(Production production) throws ParseException {
        String string;
        MibContext mibContext = this.getContext();
        Node node = this.getChildAt(production, 0);
        if (node.getId() == 2004) {
            string = this.getStringValue(node, 0);
            mibContext = this.currentMib.getImport(string);
            if (mibContext == null) {
                throw new ParseException(6, "referenced module not imported '" + string + "'", node.getStartLine(), node.getStartColumn());
            }
            node = this.getChildAt(production, 1);
        }
        string = this.getStringValue(node, 0);
        ValueReference valueReference = new ValueReference(this.getLocation(production), mibContext, string);
        production.addValue(valueReference);
        return production;
    }

    protected Node exitBuiltinValue(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitNullValue(Production production) {
        production.addValue(NullValue.NULL);
        return production;
    }

    protected Node exitBooleanValue(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        if (node.getId() == 1057) {
            production.addValue(BooleanValue.TRUE);
        } else {
            production.addValue(BooleanValue.FALSE);
        }
        return production;
    }

    protected Node exitSpecialRealValue(Production production) throws ParseException {
        Float f = this.getChildAt(production, 0).getId() == 1059 ? new Float(Float.POSITIVE_INFINITY) : new Float(Float.NEGATIVE_INFINITY);
        production.addValue(new NumberValue(f));
        return production;
    }

    protected Node exitNumberValue(Production production) throws ParseException {
        Number number;
        number = this.getChildAt(production, 0).getId() == 1012 ? (Number)((number = (Number)this.getValue(this.getChildAt(production, 1), 0)) instanceof Integer ? (Number)new Integer(-number.intValue()) : (Number)(number instanceof Long ? new Long(-number.longValue()) : ((BigInteger)number).negate())) : (Number)((Number)this.getValue(this.getChildAt(production, 0), 0));
        production.addValue(new NumberValue(number));
        return production;
    }

    protected Node exitBinaryValue(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        Number number = (Number)node.getValue(0);
        String string = (String)node.getValue(1);
        production.addValue(new BinaryNumberValue(number, string.length()));
        return production;
    }

    protected Node exitHexadecimalValue(Production production) throws ParseException {
        Node node = this.getChildAt(production, 0);
        Number number = (Number)node.getValue(0);
        String string = (String)node.getValue(1);
        production.addValue(new HexNumberValue(number, string.length()));
        return production;
    }

    protected Node exitStringValue(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        production.addValue(new StringValue(string));
        return production;
    }

    protected Node exitBitOrObjectIdentifierValue(Production production) throws ParseException {
        if (MibAnalyzerUtil.isBitValue(production)) {
            return this.exitBitValue(production);
        }
        return this.exitObjectIdentifierValue(production);
    }

    protected Node exitBitValue(Production production) throws ParseException {
        ArrayList arrayList = this.getChildValues(production);
        BitSet bitSet = new BitSet();
        ArrayList<ValueReference> arrayList2 = new ArrayList<ValueReference>();
        for (int i = 0; i < arrayList.size(); ++i) {
            NamedNumber namedNumber = (NamedNumber)arrayList.get(i);
            if (namedNumber.hasNumber()) {
                bitSet.set(namedNumber.getNumber().intValue());
                continue;
            }
            arrayList2.add(namedNumber.getReference());
        }
        production.addValue(new BitSetValue(bitSet, arrayList2));
        return production;
    }

    protected Node exitObjectIdentifierValue(Production production) throws ParseException {
        ArrayList arrayList = this.getChildValues(production);
        MibValue mibValue = null;
        if (arrayList.size() < 1) {
            throw new ParseException(6, "object identifier must contain at least one component", production.getStartLine(), production.getStartColumn());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NamedNumber namedNumber = (NamedNumber)arrayList.get(i);
            if (namedNumber.hasNumber()) {
                int n = namedNumber.getNumber().intValue();
                if (mibValue == null && n == 0) {
                    mibValue = new ValueReference(this.getLocation(production), this.getContext(), "ccitt");
                    continue;
                }
                if (mibValue == null && n == 1) {
                    mibValue = new ValueReference(this.getLocation(production), this.getContext(), "iso");
                    continue;
                }
                if (mibValue == null && n == 2) {
                    mibValue = new ValueReference(this.getLocation(production), this.getContext(), "joint-iso-ccitt");
                    continue;
                }
                if (mibValue instanceof ObjectIdentifierValue) {
                    try {
                        mibValue = new ObjectIdentifierValue(this.getLocation(production), (ObjectIdentifierValue)mibValue, namedNumber.getName(), n);
                    }
                    catch (MibException mibException) {
                        this.log.addError(mibException.getLocation(), mibException.getMessage());
                        mibValue = null;
                    }
                    continue;
                }
                mibValue = new ObjectIdentifierValue(this.getLocation(production), (ValueReference)mibValue, namedNumber.getName(), n);
                continue;
            }
            if (mibValue != null) {
                throw new ParseException(6, "object identifier component '" + namedNumber.getName() + "' has been previously defined, remove any " + "components to the left", production.getStartLine(), production.getStartColumn());
            }
            mibValue = namedNumber.getReference();
        }
        production.addValue(mibValue);
        return production;
    }

    protected Node exitNameValueList(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitNameValueComponent(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitNameOrNumber(Production production) throws ParseException {
        NamedNumber namedNumber;
        Object object = this.getValue(this.getChildAt(production, 0), 0);
        if (object instanceof Number) {
            namedNumber = new NamedNumber((Number)object);
        } else if (object instanceof String) {
            ValueReference valueReference = new ValueReference(this.getLocation(production), this.getContext(), (String)object);
            namedNumber = new NamedNumber((String)object, valueReference);
        } else {
            namedNumber = (NamedNumber)object;
        }
        production.addValue(namedNumber);
        return production;
    }

    protected Node exitNameAndNumber(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        Object object = this.getValue(this.getChildAt(production, 2), 0);
        NamedNumber namedNumber = object instanceof Number ? new NamedNumber(string, (Number)object) : new NamedNumber(string, (ValueReference)object);
        production.addValue(namedNumber);
        return production;
    }

    protected Node exitDefinedMacroType(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitDefinedMacroName(Production production) {
        production.addValue(((Token)production.getChildAt(0)).getImage());
        return production;
    }

    protected Node exitSnmpModuleIdentityMacroType(Production production) throws ParseException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.currentMib.setSmiVersion(2);
        String string = this.getStringValue(this.getChildAt(production, 1), 0);
        String string2 = this.getStringValue(this.getChildAt(production, 2), 0);
        String string3 = this.getStringValue(this.getChildAt(production, 3), 0);
        String string4 = this.getStringValue(this.getChildAt(production, 4), 0);
        for (int i = 5; i < production.getChildCount(); ++i) {
            arrayList.add(this.getValue(this.getChildAt(production, i), 0));
        }
        production.addValue(new SnmpModuleIdentity(string, string2, string3, string4, arrayList));
        return production;
    }

    protected Node exitSnmpObjectIdentityMacroType(Production production) throws ParseException {
        this.currentMib.setSmiVersion(2);
        SnmpStatus snmpStatus = (SnmpStatus)this.getValue(this.getChildAt(production, 1), 0);
        String string = this.getStringValue(this.getChildAt(production, 2), 0);
        String string2 = production.getChildCount() <= 3 ? null : this.getStringValue(this.getChildAt(production, 3), 0);
        production.addValue(new SnmpObjectIdentity(snmpStatus, string, string2));
        return production;
    }

    protected void childSnmpObjectTypeMacroType(Production production, Node node) throws ParseException {
        MibType mibType;
        if (node.getId() == 2102 && (mibType = (MibType)this.getValue(node, 0)) instanceof MibContext) {
            this.pushContextExtension((MibContext)((Object)mibType));
        }
        production.addChild(node);
    }

    protected Node exitSnmpObjectTypeMacroType(Production production) throws ParseException {
        MibType mibType = null;
        String string = null;
        SnmpAccess snmpAccess = null;
        SnmpStatus snmpStatus = null;
        String string2 = null;
        String string3 = null;
        Object object = null;
        MibValue mibValue = null;
        block10: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2102: {
                    mibType = (MibType)this.getValue(node, 0);
                    if (mibType instanceof MibContext) {
                        this.popContext();
                    }
                    mibType.setComment(MibAnalyzerUtil.getComments(node));
                    continue block10;
                }
                case 2103: {
                    string = this.getStringValue(node, 0);
                    continue block10;
                }
                case 2104: {
                    snmpAccess = (SnmpAccess)this.getValue(node, 0);
                    continue block10;
                }
                case 2100: {
                    snmpStatus = (SnmpStatus)this.getValue(node, 0);
                    continue block10;
                }
                case 2098: {
                    string2 = this.getStringValue(node, 0);
                    continue block10;
                }
                case 2101: {
                    string3 = this.getStringValue(node, 0);
                    continue block10;
                }
                case 2105: {
                    object = this.getValue(node, 0);
                    continue block10;
                }
                case 2109: {
                    mibValue = (MibValue)this.getValue(node, 0);
                }
            }
        }
        SnmpObjectType snmpObjectType = object instanceof ArrayList ? new SnmpObjectType(mibType, string, snmpAccess, snmpStatus, string2, string3, (ArrayList)object, mibValue) : new SnmpObjectType(mibType, string, snmpAccess, snmpStatus, string2, string3, (MibValue)object, mibValue);
        production.addValue(snmpObjectType);
        return production;
    }

    protected Node exitSnmpNotificationTypeMacroType(Production production) throws ParseException {
        ArrayList arrayList = new ArrayList();
        SnmpStatus snmpStatus = null;
        String string = null;
        String string2 = null;
        this.currentMib.setSmiVersion(2);
        block6: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2110: {
                    arrayList = (ArrayList)this.getValue(node, 0);
                    continue block6;
                }
                case 2100: {
                    snmpStatus = (SnmpStatus)this.getValue(node, 0);
                    continue block6;
                }
                case 2098: {
                    string = this.getStringValue(node, 0);
                    continue block6;
                }
                case 2101: {
                    string2 = this.getStringValue(node, 0);
                }
            }
        }
        production.addValue(new SnmpNotificationType(arrayList, snmpStatus, string, string2));
        return production;
    }

    protected Node exitSnmpTrapTypeMacroType(Production production) throws ParseException {
        MibValue mibValue = null;
        ArrayList arrayList = new ArrayList();
        String string = null;
        String string2 = null;
        block6: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2112: {
                    mibValue = (MibValue)this.getValue(node, 0);
                    continue block6;
                }
                case 2113: {
                    arrayList = node.getAllValues();
                    continue block6;
                }
                case 2098: {
                    string = this.getStringValue(node, 0);
                    continue block6;
                }
                case 2101: {
                    string2 = this.getStringValue(node, 0);
                }
            }
        }
        production.addValue(new SnmpTrapType(mibValue, arrayList, string, string2));
        return production;
    }

    protected Node exitSnmpTextualConventionMacroType(Production production) throws ParseException {
        String string = null;
        SnmpStatus snmpStatus = null;
        String string2 = null;
        String string3 = null;
        MibType mibType = null;
        this.currentMib.setSmiVersion(2);
        block7: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2114: {
                    string = this.getStringValue(node, 0);
                    continue block7;
                }
                case 2100: {
                    snmpStatus = (SnmpStatus)this.getValue(node, 0);
                    continue block7;
                }
                case 2098: {
                    string2 = this.getStringValue(node, 0);
                    continue block7;
                }
                case 2101: {
                    string3 = this.getStringValue(node, 0);
                    continue block7;
                }
                case 2102: {
                    mibType = (MibType)this.getValue(node, 0);
                    mibType.setComment(MibAnalyzerUtil.getComments(node));
                }
            }
        }
        production.addValue(new SnmpTextualConvention(string, snmpStatus, string2, string3, mibType));
        return production;
    }

    protected Node exitSnmpObjectGroupMacroType(Production production) throws ParseException {
        this.currentMib.setSmiVersion(2);
        ArrayList arrayList = (ArrayList)this.getValue(this.getChildAt(production, 1), 0);
        SnmpStatus snmpStatus = (SnmpStatus)this.getValue(this.getChildAt(production, 2), 0);
        String string = this.getStringValue(this.getChildAt(production, 3), 0);
        String string2 = production.getChildCount() <= 4 ? null : this.getStringValue(this.getChildAt(production, 4), 0);
        production.addValue(new SnmpObjectGroup(arrayList, snmpStatus, string, string2));
        return production;
    }

    protected Node exitSnmpNotificationGroupMacroType(Production production) throws ParseException {
        this.currentMib.setSmiVersion(2);
        ArrayList arrayList = this.getChildAt(production, 1).getAllValues();
        SnmpStatus snmpStatus = (SnmpStatus)this.getValue(this.getChildAt(production, 2), 0);
        String string = this.getStringValue(this.getChildAt(production, 3), 0);
        String string2 = production.getChildCount() <= 4 ? null : this.getStringValue(this.getChildAt(production, 4), 0);
        production.addValue(new SnmpNotificationGroup(arrayList, snmpStatus, string, string2));
        return production;
    }

    protected Node exitSnmpModuleComplianceMacroType(Production production) throws ParseException {
        SnmpStatus snmpStatus = null;
        String string = null;
        String string2 = null;
        ArrayList arrayList = new ArrayList();
        this.currentMib.setSmiVersion(2);
        block5: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2100: {
                    snmpStatus = (SnmpStatus)this.getValue(node, 0);
                    continue block5;
                }
                case 2098: {
                    string = this.getStringValue(node, 0);
                    continue block5;
                }
                case 2101: {
                    string2 = this.getStringValue(node, 0);
                    continue block5;
                }
            }
        }
        production.addValue(new SnmpModuleCompliance(snmpStatus, string, string2, arrayList));
        return production;
    }

    protected Node exitSnmpAgentCapabilitiesMacroType(Production production) throws ParseException {
        String string = null;
        SnmpStatus snmpStatus = null;
        String string2 = null;
        String string3 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.currentMib.setSmiVersion(2);
        block7: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2123: {
                    string = this.getStringValue(node, 0);
                    continue block7;
                }
                case 2100: {
                    snmpStatus = (SnmpStatus)this.getValue(node, 0);
                    continue block7;
                }
                case 2098: {
                    string2 = this.getStringValue(node, 0);
                    continue block7;
                }
                case 2101: {
                    string3 = this.getStringValue(node, 0);
                    continue block7;
                }
                case 2124: {
                    arrayList.add(this.getValue(node, 0));
                }
            }
        }
        production.addValue(new SnmpAgentCapabilities(string, snmpStatus, string2, string3, arrayList));
        return production;
    }

    protected Node exitSnmpUpdatePart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpOrganizationPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpContactPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpDescrPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpRevisionPart(Production production) throws ParseException {
        MibValue mibValue = (MibValue)this.getValue(this.getChildAt(production, 1), 0);
        String string = this.getStringValue(this.getChildAt(production, 3), 0);
        SnmpRevision snmpRevision = new SnmpRevision(mibValue, string);
        snmpRevision.setComment(MibAnalyzerUtil.getComments(production));
        production.addValue(snmpRevision);
        return production;
    }

    protected Node exitSnmpStatusPart(Production production) throws ParseException {
        Node node = this.getChildAt(production, 1);
        String string = this.getStringValue(node, 0);
        if (string.equals("mandatory")) {
            production.addValue(SnmpStatus.MANDATORY);
        } else if (string.equals("optional")) {
            production.addValue(SnmpStatus.OPTIONAL);
        } else if (string.equals("current")) {
            production.addValue(SnmpStatus.CURRENT);
        } else if (string.equals("deprecated")) {
            production.addValue(SnmpStatus.DEPRECATED);
        } else if (string.equals("obsolete")) {
            production.addValue(SnmpStatus.OBSOLETE);
        } else {
            production.addValue(SnmpStatus.CURRENT);
            throw new ParseException(6, "unrecognized status value: '" + string + "'", node.getStartLine(), node.getStartColumn());
        }
        return production;
    }

    protected Node exitSnmpReferPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpSyntaxPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpUnitsPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpAccessPart(Production production) throws ParseException {
        String string;
        Node node = this.getChildAt(production, 0);
        if (node.getId() != 1081) {
            this.currentMib.setSmiVersion(2);
        }
        if ((string = this.getStringValue(node = this.getChildAt(production, 1), 0)).equals("read-only")) {
            production.addValue(SnmpAccess.READ_ONLY);
        } else if (string.equals("read-write")) {
            production.addValue(SnmpAccess.READ_WRITE);
        } else if (string.equals("read-create")) {
            production.addValue(SnmpAccess.READ_CREATE);
        } else if (string.equals("write-only")) {
            production.addValue(SnmpAccess.WRITE_ONLY);
        } else if (string.equals("not-implemented")) {
            production.addValue(SnmpAccess.NOT_IMPLEMENTED);
        } else if (string.equals("not-accessible")) {
            production.addValue(SnmpAccess.NOT_ACCESSIBLE);
        } else if (string.equals("accessible-for-notify")) {
            production.addValue(SnmpAccess.ACCESSIBLE_FOR_NOTIFY);
        } else {
            production.addValue(SnmpAccess.READ_WRITE);
            throw new ParseException(6, "unrecognized access value: '" + string + "'", node.getStartLine(), node.getStartColumn());
        }
        return production;
    }

    protected Node exitSnmpIndexPart(Production production) throws ParseException {
        if (this.getChildAt(production, 0).getId() == 1084) {
            production.addValue(this.getChildValues(production));
        } else {
            production.addValues(this.getChildValues(production));
        }
        return production;
    }

    protected Node exitIndexValueList(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitIndexValue(Production production) {
        SnmpIndex snmpIndex;
        Object e = this.getChildValues(production).get(0);
        switch (production.getChildAt(0).getId()) {
            case 2066: {
                snmpIndex = new SnmpIndex(false, (MibValue)e, null);
                break;
            }
            case 1086: {
                snmpIndex = new SnmpIndex(true, (MibValue)e, null);
                break;
            }
            default: {
                snmpIndex = new SnmpIndex(false, null, (MibType)e);
            }
        }
        production.addValue(snmpIndex);
        return production;
    }

    protected Node exitIndexType(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpDefValPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpObjectsPart(Production production) {
        production.addValue(this.getChildValues(production));
        return production;
    }

    protected Node exitValueList(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpEnterprisePart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpVarPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpDisplayPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpNotificationsPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpModulePart(Production production) throws ParseException {
        String string = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string2 = null;
        block6: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 1093: {
                    string2 = MibAnalyzerUtil.getComments(node);
                    continue block6;
                }
                case 2117: {
                    string = this.getStringValue(node, 0);
                    this.popContext();
                    continue block6;
                }
                case 2118: {
                    arrayList = (ArrayList)this.getValue(node, 0);
                    continue block6;
                }
                case 2119: {
                    arrayList2.add(this.getValue(node, 0));
                }
            }
        }
        SnmpModule snmpModule = new SnmpModule(string, arrayList, arrayList2);
        snmpModule.setComment(string2);
        production.addValue(snmpModule);
        return production;
    }

    protected Node exitSnmpModuleImport(Production production) throws ParseException {
        String string = this.getStringValue(this.getChildAt(production, 0), 0);
        this.loader.scheduleLoad(string);
        MibImport mibImport = new MibImport(this.loader, this.getLocation(production), string, null);
        this.currentMib.addImport(mibImport);
        this.pushContextExtension(mibImport);
        production.addValue(string);
        return production;
    }

    protected Node exitSnmpMandatoryPart(Production production) {
        production.addValue(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpCompliancePart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitComplianceGroup(Production production) throws ParseException {
        MibValue mibValue = (MibValue)this.getValue(this.getChildAt(production, 1), 0);
        String string = this.getStringValue(this.getChildAt(production, 2), 0);
        SnmpCompliance snmpCompliance = new SnmpCompliance(true, mibValue, null, null, null, string);
        snmpCompliance.setComment(MibAnalyzerUtil.getComments(production));
        production.addValue(snmpCompliance);
        return production;
    }

    protected Node exitComplianceObject(Production production) throws ParseException {
        MibValue mibValue = null;
        MibType mibType = null;
        MibType mibType2 = null;
        SnmpAccess snmpAccess = null;
        String string = null;
        block7: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2066: {
                    mibValue = (MibValue)this.getValue(node, 0);
                    continue block7;
                }
                case 2102: {
                    mibType = (MibType)this.getValue(node, 0);
                    mibType.setComment(MibAnalyzerUtil.getComments(node));
                    continue block7;
                }
                case 2122: {
                    mibType2 = (MibType)this.getValue(node, 0);
                    mibType2.setComment(MibAnalyzerUtil.getComments(node));
                    continue block7;
                }
                case 2104: {
                    snmpAccess = (SnmpAccess)this.getValue(node, 0);
                    continue block7;
                }
                case 2098: {
                    string = this.getStringValue(node, 0);
                }
            }
        }
        SnmpCompliance snmpCompliance = new SnmpCompliance(false, mibValue, mibType, mibType2, snmpAccess, string);
        snmpCompliance.setComment(MibAnalyzerUtil.getComments(production));
        production.addValue(snmpCompliance);
        return production;
    }

    protected Node exitSnmpWriteSyntaxPart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpProductReleasePart(Production production) {
        production.addValues(this.getChildValues(production));
        return production;
    }

    protected Node exitSnmpModuleSupportPart(Production production) throws ParseException {
        String string = null;
        ArrayList arrayList = null;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        block5: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2117: {
                    string = this.getStringValue(node, 0);
                    this.popContext();
                    continue block5;
                }
                case 2111: {
                    arrayList = node.getAllValues();
                    continue block5;
                }
                case 2125: {
                    arrayList2.add(this.getValue(node, 0));
                }
            }
        }
        production.addValue(new SnmpModuleSupport(string, arrayList, arrayList2));
        return production;
    }

    protected void childSnmpVariationPart(Production production, Node node) throws ParseException {
        MibType mibType;
        if (node.getId() == 2066) {
            MibTypeContext mibTypeContext = new MibTypeContext(this.getValue(node, 0));
            this.pushContextExtension(mibTypeContext);
        } else if (node.getId() == 2102 && (mibType = (MibType)this.getValue(node, 0)) instanceof MibContext) {
            this.pushContextExtension((MibContext)((Object)mibType));
        }
        production.addChild(node);
    }

    protected Node exitSnmpVariationPart(Production production) throws ParseException {
        MibValue mibValue = null;
        MibType mibType = null;
        MibType mibType2 = null;
        SnmpAccess snmpAccess = null;
        ArrayList arrayList = new ArrayList();
        MibValue mibValue2 = null;
        String string = null;
        block9: for (int i = 0; i < production.getChildCount(); ++i) {
            Node node = production.getChildAt(i);
            switch (node.getId()) {
                case 2066: {
                    mibValue = (MibValue)this.getValue(node, 0);
                    this.popContext();
                    continue block9;
                }
                case 2102: {
                    mibType = (MibType)this.getValue(node, 0);
                    if (mibType instanceof MibContext) {
                        this.popContext();
                    }
                    mibType.setComment(MibAnalyzerUtil.getComments(node));
                    continue block9;
                }
                case 2122: {
                    mibType2 = (MibType)this.getValue(node, 0);
                    mibType2.setComment(MibAnalyzerUtil.getComments(node));
                    continue block9;
                }
                case 2104: {
                    snmpAccess = (SnmpAccess)this.getValue(node, 0);
                    continue block9;
                }
                case 2126: {
                    arrayList = (ArrayList)this.getValue(node, 0);
                    continue block9;
                }
                case 2109: {
                    mibValue2 = (MibValue)this.getValue(node, 0);
                    continue block9;
                }
                case 2098: {
                    string = this.getStringValue(node, 0);
                }
            }
        }
        production.addValue(new SnmpVariation(mibValue, mibType, mibType2, snmpAccess, arrayList, mibValue2, string));
        return production;
    }

    protected Node exitSnmpCreationPart(Production production) {
        production.addValue(this.getChildValues(production));
        return production;
    }

    private FileLocation getLocation(Node node) {
        return new FileLocation(this.file, node.getStartLine(), node.getStartColumn());
    }

    private MibContext getContext() {
        return (MibContext)this.contextStack.get(this.contextStack.size() - 1);
    }

    private void pushContext(MibContext mibContext) {
        this.contextStack.add(mibContext);
    }

    private void pushContextExtension(MibContext mibContext) {
        this.pushContext(new CompoundContext(mibContext, this.getContext()));
    }

    private void popContext() {
        this.contextStack.remove(this.contextStack.size() - 1);
    }
}

