/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.util;

import com.tridium.snmp.NullVarException;
import com.tridium.snmp.SnmpException;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpCounter;
import com.tridium.snmp.snmptypes.SnmpCounter64;
import com.tridium.snmp.snmptypes.SnmpGauge;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpIpAddress;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpTimeticks;
import com.tridium.snmp.snmptypes.SnmpUnsignedInt;
import com.tridium.snmp.snmptypes.SnmpVar;
import java.util.StringTokenizer;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.Array;

public class SnmpUtil
implements SnmpConst {
    public static final int INTEGER_TYPE = 0;
    public static final int STRING_TYPE = 1;
    public static final int COUNTER = 2;
    public static final int GAUGE = 3;
    public static final int TIMETICKS = 4;
    public static final int COUNTER_64 = 5;
    public static final int IP_ADDRESS = 6;
    public static final int OID = 7;

    public static long[] getLongArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = Long.parseLong(stringTokenizer.nextToken(), 10);
        }
        return lArray;
    }

    public static String longArrayToString(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < lArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(lArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(".");
            }
            byte by = byArray[i];
            int n = 0;
            boolean bl = false;
            if ((by & 0x80) != 0) {
                bl = true;
                by = (byte)(by & 0x7F);
            }
            n |= by;
            if (bl) {
                n |= 0x80;
            }
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    public static String[] getStringArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String ordToAbsolutePath(BOrd bOrd) {
        BIFile bIFile = (BIFile)bOrd.resolve().get();
        return BFileSystem.INSTANCE.pathToLocalFile(bIFile.getFilePath()).getAbsolutePath();
    }

    public static BOrd absolutePathToOrd(String string) {
        string = string.replace('\\', '/');
        return BOrd.make((String)("local:|file:/" + string));
    }

    public static BOrd absolutePathToDirOrd(String string) {
        if ((string = string.replace('\\', '/')).lastIndexOf(47) < 0) {
            return BFileSystem.INSTANCE.getOrdInHost();
        }
        string = string.substring(0, string.lastIndexOf(47));
        return BOrd.make((String)("local:|file:/" + string));
    }

    public static String rowIdFromOid(long[] lArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n + 1; i < lArray.length; ++i) {
            if (i > n + 1) {
                stringBuffer.append(".");
            }
            stringBuffer.append(lArray[i]);
        }
        return stringBuffer.toString();
    }

    public static Object[] getDecendantsByClass(BComponent bComponent, Class clazz) {
        Array array = new Array(clazz);
        SnmpUtil.getDecendantsByClass(array, bComponent, clazz);
        return array.trim();
    }

    private static void getDecendantsByClass(Array array, BComponent bComponent, Class clazz) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            BObject bObject = slotCursor.get();
            if (clazz.isInstance(bObject)) {
                array.add((Object)bObject);
            }
            if (!(bObject instanceof BComponent)) continue;
            SnmpUtil.getDecendantsByClass(array, (BComponent)bObject, clazz);
        }
    }

    public static BComponent getParent(BComponent bComponent, Type type) {
        BComplex bComplex = bComponent.getParent();
        while (!bComplex.getType().is(type)) {
            bComplex = bComplex.getParent();
        }
        return (BComponent)bComplex;
    }

    public static int getIndex(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return -1;
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    public static String replaceIndex(String string, int n) {
        return string.substring(0, string.lastIndexOf(46) + 1).concat(Integer.toString(n));
    }

    public static String replaceEnterprize(String string, int n) {
        long[] lArray = SnmpUtil.getLongArray(string);
        lArray[6] = n;
        return SnmpUtil.longArrayToString(lArray);
    }

    public static int findFreeIndex(int[] nArray, int n) {
        int n2 = 1;
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] != n2) continue;
                bl = true;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public static SnmpVar getSnmpVar(double d, BSnmpVariableTypeEnum bSnmpVariableTypeEnum) {
        switch (bSnmpVariableTypeEnum.getOrdinal()) {
            case 0: {
                return new SnmpInt((int)d);
            }
            case 1: {
                return new SnmpString(Double.toString(d));
            }
            case 3: {
                return new SnmpGauge((long)d);
            }
            case 4: {
                return new SnmpTimeticks((long)d);
            }
            case 2: {
                return new SnmpCounter((long)d);
            }
            case 5: {
                return new SnmpCounter64((long)d);
            }
        }
        return new SnmpNull();
    }

    public static SnmpVar getSnmpVar(boolean bl, BSnmpVariableTypeEnum bSnmpVariableTypeEnum, BFacets bFacets) {
        String string = bFacets.gets("trueText", "true");
        String string2 = bFacets.gets("falseText", "false");
        BEnumRange bEnumRange = (BEnumRange)bFacets.getFacet("range");
        int n = 1;
        int n2 = 0;
        if (bEnumRange != null && bEnumRange.isTag(string) && bEnumRange.isTag(string2)) {
            n = bEnumRange.tagToOrdinal(string);
            n2 = bEnumRange.tagToOrdinal(string2);
        }
        int n3 = bl ? n : n2;
        switch (bSnmpVariableTypeEnum.getOrdinal()) {
            case 0: {
                return new SnmpInt(n3);
            }
            case 1: {
                return new SnmpString(bl ? string : string2);
            }
            case 3: {
                return new SnmpGauge(n3);
            }
            case 2: {
                return new SnmpCounter(n3);
            }
            case 5: {
                return new SnmpCounter64(n3);
            }
        }
        return new SnmpNull();
    }

    public static SnmpVar getSnmpVar(String string, BSnmpVariableTypeEnum bSnmpVariableTypeEnum) {
        try {
            switch (bSnmpVariableTypeEnum.getOrdinal()) {
                case 0: {
                    return new SnmpInt(Integer.parseInt(string));
                }
                case 1: {
                    return new SnmpString(string);
                }
                case 3: {
                    return new SnmpGauge(Integer.parseInt(string));
                }
                case 4: {
                    return new SnmpTimeticks(Integer.parseInt(string));
                }
                case 2: {
                    return new SnmpCounter(Integer.parseInt(string));
                }
                case 5: {
                    return new SnmpCounter64(Long.parseLong(string));
                }
                case 6: {
                    return new SnmpIpAddress(string);
                }
                case 7: {
                    return new SnmpOID(string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SnmpNull();
    }

    public static SnmpVar getSnmpVar(BEnum bEnum, BSnmpVariableTypeEnum bSnmpVariableTypeEnum) {
        try {
            int n = bEnum.getOrdinal();
            switch (bSnmpVariableTypeEnum.getOrdinal()) {
                case 0: {
                    return new SnmpInt(n);
                }
                case 1: {
                    return new SnmpString(bEnum.getTag());
                }
                case 3: {
                    return new SnmpGauge(n);
                }
                case 4: {
                    return new SnmpTimeticks(n);
                }
                case 2: {
                    return new SnmpCounter(n);
                }
                case 5: {
                    return new SnmpCounter64(n);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SnmpNull();
    }

    public static boolean getBoolean(SnmpVar snmpVar, BFacets bFacets) {
        String string = bFacets.gets("trueText", "true");
        String string2 = bFacets.gets("falseText", "false");
        BEnumRange bEnumRange = (BEnumRange)bFacets.getFacet("range");
        int n = 0;
        switch (snmpVar.type) {
            case 2: {
                n = ((SnmpInt)snmpVar).intValue();
                break;
            }
            case 67: {
                n = (int)((SnmpTimeticks)snmpVar).longValue();
                break;
            }
            case 66: {
                n = (int)((SnmpGauge)snmpVar).longValue();
                break;
            }
            case 65: {
                n = (int)((SnmpCounter)snmpVar).longValue();
                break;
            }
            case 70: {
                n = (int)((SnmpCounter64)snmpVar).longValue();
                break;
            }
            case 4: {
                String string3 = ((SnmpString)snmpVar).toStringValue();
                if (string3.equalsIgnoreCase(string)) {
                    return true;
                }
                if (string3.equalsIgnoreCase(string2)) {
                    return false;
                }
                throw new SnmpException(SnmpPDU.translateErrorStatus(10));
            }
            case 5: {
                throw new NullVarException();
            }
            default: {
                throw new SnmpException(SnmpUtil.errorTypeToString(snmpVar.type));
            }
        }
        int n2 = 1;
        int n3 = 0;
        if (bEnumRange != null && bEnumRange.isTag(string) && bEnumRange.isTag(string2)) {
            n2 = bEnumRange.tagToOrdinal(string);
            n3 = bEnumRange.tagToOrdinal(string2);
        }
        if (n == n2) {
            return true;
        }
        if (n == n3) {
            return false;
        }
        throw new SnmpException(SnmpPDU.translateErrorStatus(10));
    }

    public static double getNumeric(SnmpVar snmpVar) {
        switch (snmpVar.type) {
            case 2: {
                return ((SnmpInt)snmpVar).intValue();
            }
            case 67: {
                return ((SnmpTimeticks)snmpVar).longValue();
            }
            case 66: {
                return ((SnmpGauge)snmpVar).longValue();
            }
            case 65: 
            case 70: {
                return ((SnmpUnsignedInt)snmpVar).longValue();
            }
            case 4: {
                return Double.parseDouble(((SnmpString)snmpVar).toNumericStringValue());
            }
            case 5: {
                throw new NullVarException();
            }
        }
        throw new SnmpException(SnmpUtil.errorTypeToString(snmpVar.type));
    }

    public static BEnum getEnum(SnmpVar snmpVar, BEnumRange bEnumRange) {
        int n;
        switch (snmpVar.type) {
            case 2: {
                n = ((SnmpInt)snmpVar).intValue();
                break;
            }
            case 67: {
                n = (int)((SnmpTimeticks)snmpVar).longValue();
                break;
            }
            case 66: {
                n = (int)((SnmpGauge)snmpVar).longValue();
                break;
            }
            case 65: 
            case 70: {
                n = (int)((SnmpUnsignedInt)snmpVar).longValue();
                break;
            }
            case 4: {
                return bEnumRange.get(((SnmpString)snmpVar).toStringValue());
            }
            case 5: {
                throw new NullVarException();
            }
            default: {
                throw new SnmpException(SnmpUtil.errorTypeToString(snmpVar.type));
            }
        }
        return bEnumRange.get(n);
    }

    public static String getString(SnmpVar snmpVar) {
        switch (snmpVar.type) {
            case 2: 
            case 4: 
            case 6: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: {
                return snmpVar.toStringValue();
            }
            case 5: {
                throw new NullVarException();
            }
        }
        throw new SnmpException(SnmpUtil.errorTypeToString(snmpVar.type));
    }

    private static String errorTypeToString(int n) {
        switch (n) {
            case 128: {
                return SnmpPDU.translateErrorStatus(128);
            }
            case 129: {
                return SnmpPDU.translateErrorStatus(129);
            }
            case 130: {
                return SnmpPDU.translateErrorStatus(130);
            }
        }
        return "Attempted to read an unsupported SNMP variable type";
    }
}

